/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.emf.data;

import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.emf.data.Design;
import com.idrsolutions.image.emf.data.FM;
import com.idrsolutions.image.emf.data.Space;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jpedal.utils.LogWriter;

public class ImageSpace
implements Space {
    private final Graphics2D g2;
    private int sc;
    private int ss = 0;
    private int fc;
    private int sw = 1;
    private int fontC = -16777216;
    private String fontName = "arial";
    private int fontSize = 12;
    private int fontWeight = 0;
    private float[][] ctm = FM.getIdentity();
    private float[][] fontTM = FM.getIdentity();
    private Design design;

    public ImageSpace(BufferedImage image) {
        this.g2 = image.createGraphics();
    }

    @Override
    public void sLine(int x, int y, int x2, int y2) {
    }

    @Override
    public void sPath(int[] cmds) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.sc, true));
        Shape shape2 = ImageSpace.getShape(cmds);
        this.g2.setStroke(new BasicStroke(this.sw));
        this.g2.draw(shape2);
    }

    private static Shape getShape(int[] cmds) {
        GeneralPath path = new GeneralPath();
        int i = 0;
        boolean hasMove = false;
        while (i < cmds.length) {
            switch (cmds[i]) {
                case 0: {
                    int x = cmds[i + 1];
                    int y = cmds[i + 2];
                    i += 3;
                    path.moveTo(x, y);
                    hasMove = true;
                    break;
                }
                case 1: {
                    int x = cmds[i + 1];
                    int y = cmds[i + 2];
                    if (!hasMove) {
                        path.moveTo(x, y);
                        hasMove = true;
                    }
                    path.lineTo(x, y);
                    i += 3;
                    break;
                }
                case 4: {
                    path.closePath();
                    ++i;
                    break;
                }
                case 2: {
                    int x = cmds[i + 1];
                    int y = cmds[i + 2];
                    int x2 = cmds[i + 3];
                    int y2 = cmds[i + 4];
                    int x3 = cmds[i + 5];
                    int y3 = cmds[i + 6];
                    if (!hasMove) {
                        path.moveTo(x, y);
                        hasMove = true;
                    }
                    path.curveTo(x, y, x2, y2, x3, y3);
                    i += 7;
                }
            }
        }
        return path;
    }

    @Override
    public void fPath(int[] cmds) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.fc, true));
        Shape shape2 = ImageSpace.getShape(cmds);
        this.g2.fill(shape2);
    }

    @Override
    public void sfPath(int[] cmds) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.fc, true));
        Shape shape2 = ImageSpace.getShape(cmds);
        this.g2.fill(shape2);
        this.g2.setColor(new Color(this.sc, true));
        this.g2.setStroke(new BasicStroke(this.sw));
        this.g2.draw(shape2);
    }

    @Override
    public void rect(int x, int y, int w, int h) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.fc, true));
        this.g2.fillRect(x, y, w, h);
        this.g2.setColor(new Color(this.sc, true));
        this.g2.drawRect(x, y, w, h);
    }

    @Override
    public void ellipse(int x, int y, int rx, int ry) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.fc, true));
        this.g2.fillOval(x, y, rx, ry);
        this.g2.setColor(new Color(this.sc, true));
        this.g2.setStroke(new BasicStroke(this.sw));
        this.g2.drawOval(x, y, rx, ry);
    }

    @Override
    public void image(int x, int y, BufferedImage image) {
    }

    @Override
    public void bmpImage(int x, int y, byte[] data) {
        try {
            this.g2.setTransform(FM.toAffine(this.ctm));
            BmpDecoder dec = new BmpDecoder();
            BufferedImage bmp = dec.read(data);
            this.g2.drawImage((Image)bmp, x, y, null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Error reading bmp image");
        }
    }

    @Override
    public void fill() {
    }

    @Override
    public void stroke() {
    }

    @Override
    public void setSW(int w) {
        this.sw = w;
    }

    @Override
    public void sStyle(int s) {
        this.ss = s;
    }

    @Override
    public void text(int x, int y, String str) {
        this.g2.setTransform(FM.toAffine(this.ctm));
        this.g2.setColor(new Color(this.fontC, true));
        int fw = 0;
        if (this.fontWeight == 1) {
            fw = 1;
        } else if (this.fontWeight == 2) {
            fw = 2;
        }
        Font font = new Font(this.fontName, fw, this.fontSize);
        this.g2.setFont(font);
        this.g2.drawString(str, x, y);
    }

    @Override
    public void clip(int x, int y, int x2, int y2) {
    }

    @Override
    public void font(String name, int size, int weight) {
        this.fontName = name;
        this.fontSize = size;
        this.fontWeight = weight;
    }

    @Override
    public void setFontC(int argb) {
        this.fontC = argb;
    }

    @Override
    public int getFontC() {
        return this.fontC;
    }

    @Override
    public void setSC(int argb) {
        this.sc = argb;
    }

    @Override
    public void setFC(int argb) {
        this.fc = argb;
    }

    @Override
    public int getSC() {
        return this.sc;
    }

    @Override
    public int getFC() {
        return this.fc;
    }

    @Override
    public void setMatrix(float[][] m) {
        this.ctm = m;
    }

    @Override
    public float[][] getMatrix() {
        return this.ctm;
    }

    @Override
    public void setFontMatrix(float[][] m) {
        this.fontTM = m;
    }

    @Override
    public float[][] getFontMatrix() {
        return this.fontTM;
    }

    @Override
    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontSize(int size) {
        this.fontSize = size;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void reset() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setDesign(Design design) {
        this.design = design;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }
}

