/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.utility.BitReader;
import com.idrsolutions.image.utility.BmpInfo;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.ToolARGB;
import com.idrsolutions.image.utility.ToolBinary;
import com.idrsolutions.image.utility.ToolGray;
import com.idrsolutions.image.utility.ToolGray16;
import com.idrsolutions.image.utility.ToolIndex;
import com.idrsolutions.image.utility.ToolRGB;
import com.idrsolutions.image.utility.ToolRGB555;
import com.idrsolutions.image.utility.ToolRGB565;
import com.idrsolutions.image.utility.Tooler;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

public class BmpDecoder
extends JDeliImage
implements Decoder {
    private static final int TYPE_BM = 19778;
    private static final int TYPE_BA = 16706;
    private static final int TYPE_CI = 18755;
    private static final int TYPE_CP = 20547;
    private static final int TYPE_IC = 17225;
    private static final int TYPE_PT = 21584;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    private static final int BI_JPEG = 4;
    private static final int BI_PNG = 5;
    private static final int BI_BI_ALPHABITFIELDS = 6;
    private static final int BI_CMYK = 11;
    private static final int BI_CMYKRLE8 = 12;
    private static final int BI_CMYKRLE4 = 13;

    @Override
    public BufferedImage read(byte[] bmpData) throws IOException {
        DataByteLittle reader = new DataByteLittle(bmpData);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        BufferedImage img = info.nPalColor == 0 ? BmpDecoder.getImageNormal(info, reader) : BmpDecoder.getImagePalette(info, reader);
        reader.close();
        return BmpDecoder.optimiseImage(img);
    }

    @Override
    public BufferedImage read(File bmpFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(bmpFile);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        BufferedImage img = info.nPalColor == 0 ? BmpDecoder.getImageNormal(info, reader) : BmpDecoder.getImagePalette(info, reader);
        reader.close();
        return BmpDecoder.optimiseImage(img);
    }

    @Override
    public Rectangle readDimension(File bmpFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(bmpFile);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        reader.close();
        return new Rectangle(info.width, info.height);
    }

    @Override
    public Rectangle readDimension(byte[] bmpData) throws IOException {
        DataByteLittle reader = new DataByteLittle(bmpData);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        return new Rectangle(info.width, info.height);
    }

    private static BmpInfo getBmpInfo(DataReader reader) throws IOException {
        BmpInfo info = new BmpInfo();
        info.type = reader.getU16();
        if (info.type == 19778 || info.type == 16706 || info.type == 18755 || info.type == 20547 || info.type == 17225 || info.type == 21584) {
            info.size = reader.getU32();
            reader.skip(4);
            info.offset = reader.getU32();
            info.headerSize = reader.getU32();
            info.width = reader.getU32();
            info.height = reader.getU32();
            if (info.width < 0) {
                info.hFlip = true;
                info.width = Math.abs(info.width);
            }
            if (info.height < 0) {
                info.vFlip = true;
                info.height = Math.abs(info.height);
            }
            info.nPlane = reader.getU16();
            info.bpp = reader.getU16();
            info.compress = reader.getU32();
            info.rawSize = reader.getU32();
            info.hRes = reader.getU32();
            info.vRes = reader.getU32();
            info.nPalColor = reader.getU32();
            info.nImpColor = reader.getU32();
            if (info.compress == 3) {
                info.maskR = reader.getU32();
                info.maskG = reader.getU32();
                info.maskB = reader.getU32();
                info.maskA = reader.getU32();
            }
        } else {
            throw new IOException("Invalid BMP File");
        }
        return info;
    }

    private static BufferedImage getImageNormal(BmpInfo info, DataReader reader) throws IOException {
        reader.moveTo(info.offset);
        return switch (info.compress) {
            case 0 -> BmpDecoder.getFromRGB(info, reader);
            case 3 -> BmpDecoder.getFromBITFIELDS(info, reader);
            case 1, 2, 4, 5, 6, 11, 12, 13 -> throw new IOException("Current compression mode not yet supported");
            default -> null;
        };
    }

    private static BufferedImage getFromRGB(BmpInfo info, DataReader reader) throws IOException {
        return switch (info.bpp) {
            case 1, 2, 4 -> BmpDecoder.handleUpto8Bit(info, reader);
            case 8 -> BmpDecoder.handle8Bit(info, reader);
            case 24 -> BmpDecoder.handle24Bit(info, reader);
            case 32 -> BmpDecoder.handle32Bit(info, reader);
            default -> null;
        };
    }

    private static BufferedImage handle32Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolARGB tool = new ToolARGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                int v = reader.getU32();
                int a = v >>> 24;
                int r = v >> 16 & 0xFF;
                int g = v >> 8 & 0xFF;
                int b = v & 0xFF;
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handle24Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolRGB tool = new ToolRGB(info.width, info.height);
        int iwx = (int)(Math.ceil((double)(info.width * 24) / 32.0) * 4.0) - info.width * 3;
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                int v = reader.getU24();
                int r = v >> 16;
                int g = v >> 8 & 0xFF;
                int b = v & 0xFF;
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, r << 16 | g << 8 | b);
            }
            if (iwx == 0) continue;
            for (int i = 0; i < iwx; ++i) {
                reader.getU8();
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handle8Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolGray tool = new ToolGray(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, reader.getU8());
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handleUpto8Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolBinary tool = new ToolBinary(info.width, info.height, info.bpp);
        int bitsPerLine = (info.width * info.bpp + 31) / 32 * 4;
        int dataLen = info.rawSize == 0 ? bitsPerLine * info.height : info.rawSize;
        byte[] small = new byte[dataLen];
        reader.read(small);
        int iwx = bitsPerLine * 8 - info.width * info.bpp;
        BitReader br = new BitReader(small);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, br.readBits(info.bpp));
            }
            if (iwx == 0) continue;
            br.readBits(iwx);
        }
        return tool.getBufferedImage();
    }

    private static int[] handleFlipped(int w, int h, boolean vFlipped, boolean hFlipped) {
        int heightStart = h - 1;
        int widthEnd = w;
        int heightEnd = 0;
        int widthStart = 0;
        if (vFlipped) {
            heightEnd = -heightStart;
            heightStart = 0;
        }
        if (hFlipped) {
            widthStart = -widthEnd;
            widthEnd = 0;
        }
        return new int[]{heightStart, heightEnd, widthStart, widthEnd};
    }

    private static BufferedImage getFromBITFIELDS(BmpInfo info, DataReader reader) throws IOException {
        int ncol;
        long[] mv;
        if (info.maskR == 63488) {
            mv = new long[]{info.maskR, info.maskG, info.maskB};
            ncol = 3;
        } else {
            mv = new long[]{info.maskA, info.maskR, info.maskG, info.maskB};
            ncol = 4;
        }
        long[] rs = new long[ncol];
        for (int i = 0; i < ncol; ++i) {
            long v = mv[i];
            if (v == 0L) continue;
            while ((v & 1L) == 0L) {
                v >>>= 1;
                int n = i;
                rs[n] = rs[n] + 1L;
            }
        }
        Tooler tool = null;
        switch (info.bpp) {
            case 16: {
                tool = BmpDecoder.handle16Bit(info, reader, rs);
                break;
            }
            case 24: {
                tool = BmpDecoder.handle24Bit(info, reader, rs);
                break;
            }
            case 32: {
                tool = BmpDecoder.handle32Bit(info, reader, rs);
                break;
            }
        }
        if (tool == null) {
            return null;
        }
        return tool.getBufferedImage();
    }

    private static Tooler handle32Bit(BmpInfo info, DataReader reader, long[] rs) throws IOException {
        ToolARGB tool = new ToolARGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                int v = reader.getU32();
                int r = (v & info.maskR) >>> (int)rs[1];
                int g = (v & info.maskG) >>> (int)rs[2];
                int b = (v & info.maskB) >>> (int)rs[3];
                int a = (v & info.maskA) >>> (int)rs[0];
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return tool;
    }

    private static Tooler handle24Bit(BmpInfo info, DataReader reader, long[] rs) throws IOException {
        ToolRGB tool = new ToolRGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                int v = reader.getU24();
                int r = (v & info.maskR) >>> (int)rs[1];
                int g = (v & info.maskG) >>> (int)rs[2];
                int b = (v & info.maskB) >>> (int)rs[3];
                int a = (v & info.maskA) >>> (int)rs[0];
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return tool;
    }

    private static Tooler handle16Bit(BmpInfo info, DataReader reader, long[] rs) throws IOException {
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        Tooler tool = info.maskR == 31744 ? new ToolRGB555(info.width, info.height) : (info.maskR == 63488 ? new ToolRGB565(info.width, info.height) : new ToolGray16(info.width, info.height));
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                int a;
                int b;
                int g;
                int r;
                int v = reader.getU16();
                if (info.maskR == 31744) {
                    r = (v & info.maskR) >>> (int)rs[1];
                    g = (v & info.maskG) >>> (int)rs[2];
                    b = (v & info.maskB) >>> (int)rs[3];
                    a = (v & info.maskA) >>> (int)rs[0];
                    tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, a << 16 | r << 10 | g << 5 | b);
                    continue;
                }
                if (info.maskR == 63488) {
                    r = (v & info.maskR) >>> (int)rs[0];
                    g = (v & info.maskG) >>> (int)rs[1];
                    b = (v & info.maskB) >>> (int)rs[2];
                    tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, r << 11 | g << 5 | b);
                    continue;
                }
                r = (v & info.maskR) >>> (int)rs[1];
                g = (v & info.maskG) >>> (int)rs[2];
                b = (v & info.maskB) >>> (int)rs[3];
                a = (v & info.maskA) >>> (int)rs[0];
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return tool;
    }

    private static BufferedImage getImagePalette(BmpInfo info, DataReader reader) throws IOException {
        int nCol = (int)Math.pow(2.0, info.bpp);
        byte[] rr = new byte[nCol];
        byte[] gg = new byte[nCol];
        byte[] bb = new byte[nCol];
        for (int i = 0; i < info.nPalColor; ++i) {
            bb[i] = (byte)reader.getU8();
            gg[i] = (byte)reader.getU8();
            rr[i] = (byte)reader.getU8();
            reader.getU8();
        }
        reader.moveTo(info.offset);
        int stripe = (info.width * info.bpp + 31) / 32 * 4;
        int buf8 = (info.width * info.bpp + 7) / 8;
        switch (info.bpp) {
            case 1: 
            case 2: 
            case 4: {
                IndexColorModel cm = new IndexColorModel(info.bpp, 1 << info.bpp, rr, gg, bb);
                BufferedImage img = new BufferedImage(info.width, info.height, 12, cm);
                byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                int dataLen = info.rawSize == 0 ? stripe * info.height : info.rawSize;
                byte[] small = new byte[dataLen];
                reader.read(small);
                int rawIdx = 0;
                for (int y = info.height - 1; y >= 0; --y) {
                    int imgIdx = y * buf8;
                    System.arraycopy(small, rawIdx, data, imgIdx, buf8);
                    rawIdx += stripe;
                }
                return img;
            }
        }
        ToolIndex tool = new ToolIndex(info.width, info.height, info.bpp, rr, gg, bb);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y = heightStart; y >= heightEnd; --y) {
            for (int x = widthStart; x < widthEnd; ++x) {
                tool.set(info.hFlip ? -x : x, info.vFlip ? -y : y, reader.getU8());
            }
        }
        return tool.getBufferedImage();
    }
}

