/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.BitMaskSet;
import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Entropy;
import com.idrsolutions.image.avif.dec.Intra;
import com.idrsolutions.image.avif.dec.Mem;
import com.idrsolutions.image.avif.dec.PostFilter;
import com.idrsolutions.image.avif.dec.Quant;
import com.idrsolutions.image.avif.dec.Reconstruct;
import com.idrsolutions.image.avif.dec.Scan;
import com.idrsolutions.image.avif.dec.Symbol;
import com.idrsolutions.image.avif.dec.Yuv;
import java.util.Arrays;
import java.util.Stack;
import org.jpedal.utils.LogWriter;

class Tile {
    final int number_;
    final int row_;
    final int column_;
    final byte[] data_;
    final int size_;
    final int row4x4_start_;
    final int row4x4_end_;
    final int column4x4_start_;
    final int column4x4_end_;
    final int superblock_rows_;
    final int superblock_columns_;
    boolean read_deltas_;
    final int[] subsampling_x_;
    final int[] subsampling_y_;
    final int[][][][] deblock_filter_levels_ = new int[8][4][8][2];
    int current_quantizer_index_;
    byte[][][][] coefficient_levels_;
    byte[][][][] dc_categories_;
    final D.Array2DView cdef_index_;
    final D.Array2DView cdef_skip_;
    final int[][] inter_transform_sizes_;
    final D.RefCountedBuffer current_frame_;
    final D.ObuSequenceHeader sequence_header_;
    final D.ObuFrameHeader frame_header_;
    final Entropy reader_;
    final Symbol symbol_decoder_context_;
    Symbol saved_symbol_decoder_context_;
    final D.SegmentationMap prev_segment_ids_;
    final PostFilter post_filter_;
    final D.BlockParametersHolder block_parameters_holder_;
    final Quant quantizer_;
    final int[][][][] quantizer_matrix_;
    final boolean split_parse_and_decode_;
    final int[] transform_types_ = new int[1024];
    boolean delta_lf_all_zero_;
    final boolean frame_parallel_;
    final boolean use_intra_prediction_buffer_;
    D.DynamicBufferBlockCdfContext top_context_ = new D.DynamicBufferBlockCdfContext();
    D.Array2DView[] buffer_ = new D.Array2DView[3];
    D.IntraPredictionBuffer[] intra_prediction_buffer_;
    final int[] residual_buffer_ = new int[4352];
    int residual_bufferPos_;
    D.ResidualBuffer[][] residual_buffer_threaded_;
    D.ResidualBufferPool residual_buffer_pool_;
    int residual_size_;
    int intra_block_copy_lag_;
    final int[] delta_lf_ = new int[4];
    int[] reference_frame_progress_cache_ = new int[8];
    D.TileScratchBufferPool tile_scratch_buffer_pool_ = new D.TileScratchBufferPool();
    D.RestorationUnitInfo[] reference_unit_info_ = new D.RestorationUnitInfo[3];
    D.BlockingCounterImpl pending_tiles_ = new D.BlockingCounterImpl(true);
    D.ThreadingParameters threading_ = new D.ThreadingParameters();
    D.BlockCdfContext left_context_ = new D.BlockCdfContext();
    D.RefCountedBuffer[] reference_frames_;
    D.TemporalMotionField motion_field_;
    boolean[] reference_frame_sign_bias_;
    int[][][] wedge_masks_;
    int[] reference_order_hint_;
    D.ThreadPool thread_pool_;
    D.GlobalMotion local_warp_params = null;
    D.PredictionParameters prediction_parameters_;
    D.Dsp dsp_;

    int SuperBlockRowIndex(int row4x4) {
        return row4x4 - this.row4x4_start_ >> (this.sequence_header_.use_128x128_superblock ? 5 : 4);
    }

    int SuperBlockColumnIndex(int column4x4) {
        return column4x4 - this.column4x4_start_ >> (this.sequence_header_.use_128x128_superblock ? 5 : 4);
    }

    int CdfContextIndex(int row_or_column4x4) {
        return row_or_column4x4 - (row_or_column4x4 & (this.sequence_header_.use_128x128_superblock ? -32 : -16));
    }

    int SuperBlockSize() {
        return this.sequence_header_.use_128x128_superblock ? 21 : 18;
    }

    int PlaneCount() {
        return this.sequence_header_.color_config.is_monochrome ? 1 : 3;
    }

    boolean IsRow4x4Inside(int row4x4) {
        return row4x4 >= this.row4x4_start_ && row4x4 < this.row4x4_end_;
    }

    boolean IsInside(int row4x4, int column4x4) {
        return this.IsRow4x4Inside(row4x4) && column4x4 >= this.column4x4_start_ && column4x4 < this.column4x4_end_;
    }

    boolean IsLeftInside(int column4x4) {
        return column4x4 > this.column4x4_start_;
    }

    boolean IsTopInside(int row4x4) {
        return row4x4 > this.row4x4_start_;
    }

    boolean IsTopLeftInside(int row4x4, int column4x4) {
        return row4x4 > this.row4x4_start_ && column4x4 > this.column4x4_start_;
    }

    boolean IsBottomRightInside(int row4x4, int column4x4) {
        return row4x4 < this.row4x4_end_ && column4x4 < this.column4x4_end_;
    }

    int BlockParametersStride() {
        return this.block_parameters_holder_.columns4x4();
    }

    boolean HasParameters(int row, int column) {
        return this.block_parameters_holder_.Find(row, column) != null;
    }

    D.BlockParameters Parameters(int row, int column) {
        return this.block_parameters_holder_.Find(row, column);
    }

    int number() {
        return this.number_;
    }

    int superblock_rows() {
        return this.superblock_rows_;
    }

    int superblock_columns() {
        return this.superblock_columns_;
    }

    int row4x4_start() {
        return this.row4x4_start_;
    }

    int column4x4_start() {
        return this.column4x4_start_;
    }

    int column4x4_end() {
        return this.column4x4_end_;
    }

    D.ObuFrameHeader frame_header() {
        return this.frame_header_;
    }

    D.BlockParameters BlockParametersAddress(int row4x4, int column4x4) {
        return this.block_parameters_holder_.Find(row4x4, column4x4);
    }

    D.BlockParameters findGivenBlockParameters(int pos) {
        for (D.BlockParameters bpx : this.block_parameters_holder_.block_parameters_) {
            if (bpx.pos != pos) continue;
            return bpx;
        }
        return null;
    }

    static Tile Create(int tile_number, byte[] data, int offset, int size, D.ObuSequenceHeader sequence_header, D.ObuFrameHeader frame_header, D.RefCountedBuffer current_frame, D.DecoderState state, D.FrameScratchBuffer frame_scratch_buffer, int[][][] wedge_masks, int[][][][] quantizer_matrix, Symbol saved_symbol_decoder_context, D.SegmentationMap prev_segment_ids, PostFilter post_filter, D.Dsp dsp, D.ThreadPool thread_pool, D.BlockingCounterImpl pending_tiles, boolean frame_parallel, boolean use_intra_prediction_buffer) {
        Tile tile = new Tile(tile_number, data, offset, size, sequence_header, frame_header, current_frame, state, frame_scratch_buffer, wedge_masks, quantizer_matrix, saved_symbol_decoder_context, prev_segment_ids, post_filter, dsp, thread_pool, pending_tiles, frame_parallel, use_intra_prediction_buffer);
        tile.Init();
        return tile;
    }

    Tile(int tile_number, byte[] data, int offset, int size, D.ObuSequenceHeader sequence_header, D.ObuFrameHeader frame_header, D.RefCountedBuffer current_frame, D.DecoderState state, D.FrameScratchBuffer frame_scratch_buffer, int[][][] wedge_masks, int[][][][] quantizer_matrix, Symbol saved_symbol_decoder_context, D.SegmentationMap prev_segment_ids, PostFilter post_filter, D.Dsp dsp, D.ThreadPool thread_pool, D.BlockingCounterImpl pending_tiles, boolean frame_parallel, boolean use_intra_prediction_buffer) {
        this.number_ = tile_number;
        this.row_ = this.number_ / frame_header.tile_info.tile_columns;
        this.column_ = this.number_ % frame_header.tile_info.tile_columns;
        this.data_ = data;
        this.size_ = size;
        this.read_deltas_ = false;
        this.subsampling_x_ = new int[]{0, sequence_header.color_config.subsampling_x, sequence_header.color_config.subsampling_x};
        this.subsampling_y_ = new int[]{0, sequence_header.color_config.subsampling_y, sequence_header.color_config.subsampling_y};
        this.current_quantizer_index_ = frame_header.quantizer.base_index;
        this.sequence_header_ = sequence_header;
        this.frame_header_ = frame_header;
        this.reference_frame_sign_bias_ = state.reference_frame_sign_bias;
        this.reference_frames_ = state.reference_frame;
        this.motion_field_ = frame_scratch_buffer.motion_field;
        this.reference_order_hint_ = state.reference_order_hint;
        this.wedge_masks_ = wedge_masks;
        this.quantizer_matrix_ = quantizer_matrix;
        this.reader_ = new Entropy(this.data_, offset, this.size_, this.frame_header_.enable_cdf_update);
        this.symbol_decoder_context_ = frame_scratch_buffer.symbol_decoder_context;
        this.saved_symbol_decoder_context_ = saved_symbol_decoder_context;
        this.prev_segment_ids_ = prev_segment_ids;
        this.dsp_ = dsp;
        this.post_filter_ = post_filter;
        this.block_parameters_holder_ = frame_scratch_buffer.block_parameters_holder;
        this.quantizer_ = new Quant(this.sequence_header_.color_config.bitdepth, this.frame_header_.quantizer);
        this.residual_size_ = 1;
        this.intra_block_copy_lag_ = this.frame_header_.allow_intrabc ? (this.sequence_header_.use_128x128_superblock ? 3 : 5) : 1;
        this.current_frame_ = current_frame;
        this.cdef_index_ = frame_scratch_buffer.cdef_index;
        this.cdef_skip_ = frame_scratch_buffer.cdef_skip;
        this.inter_transform_sizes_ = frame_scratch_buffer.inter_transform_sizes;
        this.thread_pool_ = thread_pool;
        this.residual_buffer_pool_ = frame_scratch_buffer.residual_buffer_pool;
        this.tile_scratch_buffer_pool_ = frame_scratch_buffer.tile_scratch_buffer_pool;
        this.pending_tiles_ = pending_tiles;
        this.frame_parallel_ = frame_parallel;
        this.use_intra_prediction_buffer_ = use_intra_prediction_buffer;
        this.intra_prediction_buffer_ = this.use_intra_prediction_buffer_ ? frame_scratch_buffer.intra_prediction_buffers.get()[this.row_] : null;
        this.row4x4_start_ = frame_header.tile_info.tile_row_start[this.row_];
        this.row4x4_end_ = frame_header.tile_info.tile_row_start[this.row_ + 1];
        this.column4x4_start_ = frame_header.tile_info.tile_column_start[this.column_];
        this.column4x4_end_ = frame_header.tile_info.tile_column_start[this.column_ + 1];
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        int block_width4x4_log2 = D.k4x4HeightLog2[this.SuperBlockSize()];
        this.superblock_rows_ = this.row4x4_end_ - this.row4x4_start_ + block_width4x4 - 1 >> block_width4x4_log2;
        this.superblock_columns_ = this.column4x4_end_ - this.column4x4_start_ + block_width4x4 - 1 >> block_width4x4_log2;
        boolean bl = this.split_parse_and_decode_ = this.thread_pool_ != null && this.superblock_columns_ > this.intra_block_copy_lag_ || frame_parallel;
        if (this.frame_parallel_) {
            Arrays.fill(this.reference_frame_progress_cache_, Integer.MIN_VALUE);
        }
        Arrays.fill(this.delta_lf_, 0);
        this.delta_lf_all_zero_ = true;
        Yuv buffer = this.post_filter_.frame_buffer();
        for (int plane = 0; plane < this.PlaneCount(); ++plane) {
            int max_tx_length;
            int n = max_tx_length = plane == 0 ? 64 : 32;
            if (this.buffer_[plane] == null) {
                this.buffer_[plane] = new D.Array2DView();
            }
            this.buffer_[plane].Reset(D.Align(buffer.height(plane), max_tx_length), buffer.stride(plane), this.post_filter_.GetUnfilteredBuffer(plane));
        }
    }

    boolean Init() {
        int maxVal = Math.max(this.frame_header_.columns4x4, this.frame_header_.rows4x4);
        maxVal = Math.max(maxVal, 256);
        this.coefficient_levels_ = new byte[2][3][maxVal][maxVal];
        this.dc_categories_ = new byte[2][3][maxVal][maxVal];
        if (this.split_parse_and_decode_) {
            this.residual_buffer_threaded_ = new D.ResidualBuffer[this.superblock_rows_][this.superblock_columns_];
            for (int i = 0; i < this.superblock_rows_; ++i) {
                for (int j = 0; j < this.superblock_columns_; ++j) {
                    this.residual_buffer_threaded_[i][j] = new D.ResidualBuffer();
                }
            }
        } else {
            this.prediction_parameters_ = new D.PredictionParameters();
        }
        if (this.frame_header_.use_ref_frame_mvs) {
            LogWriter.writeLog("Tile init error : not supported mvs");
        }
        this.ResetLoopRestorationParams();
        this.top_context_.Resize(this.superblock_columns_);
        return true;
    }

    static int GetSinglePredictionMode(int index, int y_mode) {
        if (y_mode < 18) {
            return y_mode;
        }
        int lookup_index = y_mode - 18;
        return D.kCompoundToSinglePredictionMode[lookup_index][index];
    }

    static int GetNumElements(int length, int start, int max) {
        return Math.min(length, max - start);
    }

    static void SetBlockValuesBoolean(int rows, int columns, boolean value, boolean[] dst, int dstPos, int stride) {
        switch (columns) {
            case 1: {
                D.MemSetBlockBoolean(rows, 1, value, dst, dstPos, stride);
                break;
            }
            case 2: {
                D.MemSetBlockBoolean(rows, 2, value, dst, dstPos, stride);
                break;
            }
            case 4: {
                D.MemSetBlockBoolean(rows, 4, value, dst, dstPos, stride);
                break;
            }
            case 8: {
                D.MemSetBlockBoolean(rows, 8, value, dst, dstPos, stride);
                break;
            }
            default: {
                D.MemSetBlockBoolean(rows, 16, value, dst, dstPos, stride);
            }
        }
    }

    static void SetBlockValues(int rows, int columns, int value, int[] dst, int dstPos, int stride) {
        switch (columns) {
            case 1: {
                D.MemSetBlock(rows, 1, value, dst, dstPos, stride);
                break;
            }
            case 2: {
                D.MemSetBlock(rows, 2, value, dst, dstPos, stride);
                break;
            }
            case 4: {
                D.MemSetBlock(rows, 4, value, dst, dstPos, stride);
                break;
            }
            case 8: {
                D.MemSetBlock(rows, 8, value, dst, dstPos, stride);
                break;
            }
            default: {
                D.MemSetBlock(rows, 16, value, dst, dstPos, stride);
            }
        }
    }

    static void SetTransformType(Block block, int x4, int y4, int w4, int h4, int tx_type, int[] transform_types) {
        int y_offset = y4 - block.row4x4;
        int x_offset = x4 - block.column4x4;
        int[] dst = transform_types;
        int dstPos = y_offset * 32 + x_offset;
        Tile.SetBlockValues(h4, w4, tx_type, dst, dstPos, 32);
    }

    void StoreMotionFieldMvs(int reference_frame_to_store, D.MotionVector mv_to_store, int stride, int rows, int columns, int reference_frame_row_start, D.MotionVector mv) {
        LogWriter.writeLog("set motion field mvs not implemented");
    }

    static void MoveCoefficientsForTxWidth64(int clamped_tx_height, int tx_width, int[] residual, int residualPos) {
        if (tx_width != 64) {
            return;
        }
        int rows = clamped_tx_height - 2;
        int[] src = residual;
        int srcPos = residualPos + 32 * rows;
        residualPos += 64 * rows;
        int x = rows >> 1;
        do {
            Mem.cpy(residual, residualPos, src, srcPos, 32);
            Mem.cpy(residual, residualPos + 64, src, srcPos + 32, 32);
            Mem.set(src, srcPos + 32, 0, 32);
            srcPos -= 64;
            residualPos -= 128;
        } while (--x != 0);
        Mem.cpy(residual, residualPos + 64, src, srcPos + 32, 32);
        Mem.set(src, srcPos + 32, 0, 32);
    }

    static void GetClampParameters(Block block, int[] min, int[] max) {
        int kMvBorder4x4 = 4;
        int row_border = 4 + block.height4x4;
        int column_border = 4 + block.width4x4;
        int macroblocks_to_top_edge = -block.row4x4;
        int macroblocks_to_bottom_edge = block.tile.frame_header().rows4x4 - block.height4x4 - block.row4x4;
        int macroblocks_to_left_edge = -block.column4x4;
        int macroblocks_to_right_edge = block.tile.frame_header().columns4x4 - block.width4x4 - block.column4x4;
        min[0] = (macroblocks_to_top_edge - row_border) * 32;
        min[1] = (macroblocks_to_left_edge - column_border) * 32;
        max[0] = (macroblocks_to_bottom_edge + row_border) * 32;
        max[1] = (macroblocks_to_right_edge + column_border) * 32;
    }

    static int GetCoeffBaseContextEob(int tx_size, int index) {
        if (index == 0) {
            return 0;
        }
        int adjusted_tx_size = D.kAdjustedTransformSize[tx_size];
        int tx_height = D.kTransformHeight[adjusted_tx_size];
        int tx_width_log2 = D.kTransformWidthLog2[adjusted_tx_size];
        if (index <= (tx_height << tx_width_log2) / 8) {
            return 1;
        }
        if (index <= (tx_height << tx_width_log2) / 4) {
            return 2;
        }
        return 3;
    }

    static int GetCoeffBaseRangeContextEob(int adjusted_tx_width_log2, int pos, int tx_class) {
        if (pos == 0) {
            return 0;
        }
        int tx_width = 1 << adjusted_tx_width_log2;
        int row = pos >> adjusted_tx_width_log2;
        int column = pos & tx_width - 1;
        return 14 >> ((tx_class == 0 & (row | column) < 2 ? 1 : 0) | tx_class & (column == 0 ? 1 : 0) | tx_class >> 1 & (row == 0 ? 1 : 0));
    }

    boolean ProcessSuperBlockRow(int row4x4, D.TileScratchBuffer scratch_buffer, int processing_mode, boolean save_symbol_decoder_context) {
        if (row4x4 < this.row4x4_start_ || row4x4 >= this.row4x4_end_) {
            return true;
        }
        if (scratch_buffer == null) {
            LogWriter.writeLog("Scratch buffer is null");
        }
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        for (int column4x4 = this.column4x4_start_; column4x4 < this.column4x4_end_; column4x4 += block_width4x4) {
            if (this.ProcessSuperBlock(row4x4, column4x4, scratch_buffer, processing_mode)) continue;
            LogWriter.writeLog("process superblock error");
            return false;
        }
        if (save_symbol_decoder_context && row4x4 + block_width4x4 >= this.row4x4_end_) {
            this.SaveSymbolDecoderContext();
        }
        if (processing_mode == 1 || processing_mode == 2) {
            this.PopulateIntraPredictionBuffer(row4x4);
        }
        return true;
    }

    void SaveSymbolDecoderContext() {
        if (this.frame_header_.enable_frame_end_update_cdf && this.number_ == this.frame_header_.tile_info.context_update_id) {
            this.saved_symbol_decoder_context_ = this.symbol_decoder_context_;
        }
    }

    boolean ParseAndDecode() {
        if (this.split_parse_and_decode_) {
            if (!this.ThreadedParseAndDecode()) {
                return false;
            }
            this.SaveSymbolDecoderContext();
            return true;
        }
        D.TileScratchBuffer scratch_buffer = this.tile_scratch_buffer_pool_.get();
        if (scratch_buffer == null) {
            LogWriter.writeLog("Parse And Decode Error : null scratch buffer");
            return false;
        }
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        for (int row4x4 = this.row4x4_start_; row4x4 < this.row4x4_end_; row4x4 += block_width4x4) {
            if (this.ProcessSuperBlockRow(row4x4, scratch_buffer, 2, true)) continue;
            this.pending_tiles_.Decrement(false);
            LogWriter.writeLog("Parse And Decode Error : process super block row");
            return false;
        }
        this.tile_scratch_buffer_pool_.release(scratch_buffer);
        this.pending_tiles_.Decrement(true);
        return true;
    }

    boolean Parse() {
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        D.TileScratchBuffer scratch_buffer = this.tile_scratch_buffer_pool_.get();
        if (scratch_buffer == null) {
            LogWriter.writeLog("Parse error: null scratch buffer");
            return false;
        }
        for (int row4x4 = this.row4x4_start_; row4x4 < this.row4x4_end_; row4x4 += block_width4x4) {
            if (this.ProcessSuperBlockRow(row4x4, scratch_buffer, 0, false)) continue;
            LogWriter.writeLog("Parse error: process super block");
            return false;
        }
        this.tile_scratch_buffer_pool_.release(scratch_buffer);
        this.SaveSymbolDecoderContext();
        return true;
    }

    boolean Decode(int[] superblock_row_progress, int[] superblock_row_progress_condvar) {
        int block_width4x4 = this.sequence_header_.use_128x128_superblock ? 32 : 16;
        int block_width4x4_log2 = this.sequence_header_.use_128x128_superblock ? 5 : 4;
        D.TileScratchBuffer scratch_buffer = this.tile_scratch_buffer_pool_.get();
        if (scratch_buffer == null) {
            LogWriter.writeLog("Tile Error: Scratch buffer is null");
            return false;
        }
        int row4x4 = this.row4x4_start_;
        int index = this.row4x4_start_ >> block_width4x4_log2;
        while (row4x4 < this.row4x4_end_) {
            boolean notify;
            if (!this.ProcessSuperBlockRow(row4x4, scratch_buffer, 1, false)) {
                LogWriter.writeLog("Tile Error: Process super block row");
                return false;
            }
            if (this.post_filter_.DoDeblock()) {
                this.post_filter_.ApplyDeblockFilter(0, row4x4, this.column4x4_start_ + 16, this.column4x4_end_, block_width4x4);
                if (row4x4 != this.row4x4_start_) {
                    this.post_filter_.ApplyDeblockFilter(1, row4x4, this.column4x4_start_ + 16, this.column4x4_end_ - 16, block_width4x4);
                }
            }
            int n = index;
            int n2 = superblock_row_progress[n] + 1;
            superblock_row_progress[n] = n2;
            boolean bl = notify = n2 == this.frame_header_.tile_info.tile_columns;
            if (notify) {
                // empty if block
            }
            row4x4 += block_width4x4;
            ++index;
        }
        return true;
    }

    boolean ThreadedParseAndDecode() {
        this.threading_.sb_state = new int[this.superblock_rows_][this.superblock_columns_];
        ++this.threading_.pending_jobs;
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        D.TileScratchBuffer scratch_buffer = this.tile_scratch_buffer_pool_.get();
        int row4x4 = this.row4x4_start_;
        int row_index = 0;
        while (row4x4 < this.row4x4_end_) {
            int column4x4 = this.column4x4_start_;
            int column_index = 0;
            while (column4x4 < this.column4x4_end_) {
                this.ProcessSuperBlock(row4x4, column4x4, scratch_buffer, 0);
                this.threading_.sb_state[row_index][column_index] = 1;
                if (this.CanDecode(row_index, column_index)) {
                    ++this.threading_.pending_jobs;
                    this.threading_.sb_state[row_index][column_index] = 2;
                    this.DecodeSuperBlock(row_index, column_index, block_width4x4);
                }
                column4x4 += block_width4x4;
                ++column_index;
            }
            row4x4 += block_width4x4;
            ++row_index;
        }
        return true;
    }

    boolean CanDecode(int row_index, int column_index) {
        if (row_index >= this.superblock_rows_ || column_index >= this.superblock_columns_ || this.threading_.sb_state[row_index][column_index] != 1) {
            return false;
        }
        if (row_index == 0 && column_index == 0) {
            return true;
        }
        if (row_index == 0) {
            return this.threading_.sb_state[0][column_index - 1] == 3;
        }
        int top_right_column_index = Math.min(column_index + this.intra_block_copy_lag_, this.superblock_columns_ - 1);
        return this.threading_.sb_state[row_index - 1][top_right_column_index] == 3 && (column_index == 0 || this.threading_.sb_state[row_index][column_index - 1] == 3);
    }

    void DecodeSuperBlock(int row_index, int column_index, int block_width4x4) {
        boolean ok;
        int row4x4 = this.row4x4_start_ + row_index * block_width4x4;
        int column4x4 = this.column4x4_start_ + column_index * block_width4x4;
        D.TileScratchBuffer scratch_buffer = this.tile_scratch_buffer_pool_.get();
        boolean bl = ok = scratch_buffer != null;
        if (ok) {
            ok = this.ProcessSuperBlock(row4x4, column4x4, scratch_buffer, 1);
            this.tile_scratch_buffer_pool_.release(scratch_buffer);
        }
        if (ok) {
            this.threading_.sb_state[row_index][column_index] = 3;
            int[] candidate_row_indices = new int[]{row_index + 1, row_index};
            int[] candidate_column_indices = new int[]{Math.max(0, column_index - this.intra_block_copy_lag_), column_index + 1};
            for (int i = 0; i < candidate_row_indices.length; ++i) {
                int candidate_row_index = candidate_row_indices[i];
                int candidate_column_index = candidate_column_indices[i];
                if (!this.CanDecode(candidate_row_index, candidate_column_index)) continue;
                ++this.threading_.pending_jobs;
                this.threading_.sb_state[candidate_row_index][candidate_column_index] = 2;
                this.DecodeSuperBlock(candidate_row_index, candidate_column_index, block_width4x4);
            }
        }
    }

    void PopulateIntraPredictionBuffer(int row4x4) {
        int block_width4x4 = D.kNum4x4BlocksWide[this.SuperBlockSize()];
        if (!this.use_intra_prediction_buffer_ || row4x4 + block_width4x4 >= this.row4x4_end_) {
            return;
        }
        int pixel_size = 1;
        for (int plane = 0; plane < this.PlaneCount(); ++plane) {
            int row_to_copy = ((row4x4 + block_width4x4) * 4 >> this.subsampling_y_[plane]) - 1;
            int pixels_to_copy = ((this.column4x4_end_ - this.column4x4_start_) * 4 >> this.subsampling_x_[plane]) * pixel_size;
            int column_start = this.column4x4_start_ * 4 >> this.subsampling_x_[plane];
            int[] startBuffer = this.buffer_[plane].data_;
            int startBufferPos = this.buffer_[plane].columns() * row_to_copy + column_start;
            int[] intraBuffer = this.intra_prediction_buffer_[plane].get();
            int intraBufferPos = column_start * pixel_size;
            Mem.cpy(intraBuffer, intraBufferPos, startBuffer, startBufferPos, pixels_to_copy);
        }
    }

    int GetTransformAllZeroContext(Block block, int plane, int tx_size, int x4, int y4, int w4, int h4) {
        int i;
        int max_x4x4 = this.frame_header_.columns4x4 >> this.subsampling_x_[plane];
        int max_y4x4 = this.frame_header_.rows4x4 >> this.subsampling_y_[plane];
        int tx_width = D.kTransformWidth[tx_size];
        int tx_height = D.kTransformHeight[tx_size];
        int plane_size = block.residual_size[plane];
        int block_width = D.kBlockWidthPixels[plane_size];
        int block_height = D.kBlockHeightPixels[plane_size];
        int top = 0;
        int left = 0;
        int num_top_elements = Tile.GetNumElements(w4, x4, max_x4x4);
        int num_left_elements = Tile.GetNumElements(h4, y4, max_y4x4);
        if (plane == 0) {
            int i2;
            if (block_width == tx_width && block_height == tx_height) {
                return 0;
            }
            byte[] coefficient_levels = this.coefficient_levels_[1][plane][x4];
            for (i2 = 0; i2 < num_top_elements; ++i2) {
                top = Math.max(top, coefficient_levels[i2] & 0xFF);
            }
            coefficient_levels = this.coefficient_levels_[0][plane][y4];
            for (i2 = 0; i2 < num_left_elements; ++i2) {
                left = Math.max(left, coefficient_levels[i2] & 0xFF);
            }
            return D.kAllZeroContextsByTopLeft[top][left];
        }
        byte[] coefficient_levels = this.coefficient_levels_[1][plane][x4];
        byte[] dc_categories = this.dc_categories_[1][plane][x4];
        for (i = 0; i < num_top_elements; ++i) {
            top |= coefficient_levels[i] & 0xFF;
            top |= dc_categories[i];
        }
        coefficient_levels = this.coefficient_levels_[0][plane][y4];
        dc_categories = this.dc_categories_[0][plane][y4];
        for (i = 0; i < num_left_elements; ++i) {
            left |= coefficient_levels[i] & 0xFF;
            left |= dc_categories[i];
        }
        return (top != 0 ? 1 : 0) + (left != 0 ? 1 : 0) + 7 + 3 * (block_width * block_height > tx_width * tx_height ? 1 : 0);
    }

    int GetTransformSet(int tx_size, boolean is_inter) {
        int tx_size_square_min = D.kTransformSizeSquareMin[tx_size];
        int tx_size_square_max = D.kTransformSizeSquareMax[tx_size];
        if (tx_size_square_max == 18) {
            return 0;
        }
        if (is_inter) {
            if (this.frame_header_.reduced_tx_set || tx_size_square_max == 14) {
                return 5;
            }
            if (tx_size_square_min == 9) {
                return 4;
            }
            return 3;
        }
        if (tx_size_square_max == 14) {
            return 0;
        }
        if (this.frame_header_.reduced_tx_set || tx_size_square_min == 9) {
            return 2;
        }
        return 1;
    }

    int ComputeTransformType(Block block, int plane, int tx_size, int block_x, int block_y) {
        int tx_type;
        D.BlockParameters bp = block.bp;
        int tx_size_square_max = D.kTransformSizeSquareMax[tx_size];
        if (this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id] || tx_size_square_max == 18) {
            return 0;
        }
        if (plane == 0) {
            return this.transform_types_[(block_y - block.row4x4) * 32 + (block_x - block.column4x4)];
        }
        int tx_set = this.GetTransformSet(tx_size, bp.is_inter);
        if (bp.is_inter) {
            int x4 = Math.max(block.column4x4, block_x << this.subsampling_x_[1]);
            int y4 = Math.max(block.row4x4, block_y << this.subsampling_y_[1]);
            tx_type = this.transform_types_[(y4 - block.row4x4) * 32 + (x4 - block.column4x4)];
        } else {
            tx_type = D.kModeToTransformType[bp.prediction_parameters.uv_mode];
        }
        return D.kTransformTypeInSetMask[tx_set].Contains(tx_type) ? tx_type : 0;
    }

    void ReadTransformType(Block block, int x4, int y4, int tx_size) {
        D.BlockParameters bp = block.bp;
        int tx_set = this.GetTransformSet(tx_size, bp.is_inter);
        int tx_type = 0;
        if (tx_set != 0 && this.frame_header_.segmentation.qindex[bp.prediction_parameters.segment_id] > 0) {
            int cdf_index = Symbol.TxTypeIndex(tx_set);
            int cdf_tx_size_index = D.TransformSizeToSquareTransformIndex(D.kTransformSizeSquareMin[tx_size]);
            if (bp.is_inter) {
                int[] cdf = this.symbol_decoder_context_.inter_tx_type_cdf[cdf_index][cdf_tx_size_index];
                switch (tx_set) {
                    case 3: {
                        tx_type = this.reader_.ReadSymbol(cdf, 16);
                        break;
                    }
                    case 4: {
                        tx_type = this.reader_.ReadSymbol(cdf, 12);
                        break;
                    }
                    default: {
                        tx_type = this.reader_.ReadSymbol(cdf) ? 1 : 0;
                        break;
                    }
                }
            } else {
                int intra_direction = block.bp.prediction_parameters.use_filter_intra ? D.kFilterIntraModeToIntraPredictor[block.bp.prediction_parameters.filter_intra_mode] : bp.y_mode;
                int[] cdf = this.symbol_decoder_context_.intra_tx_type_cdf[cdf_index][cdf_tx_size_index][intra_direction];
                tx_type = tx_set == 1 ? this.reader_.ReadSymbol(cdf, 7) : this.reader_.ReadSymbol(cdf, 5);
            }
            tx_type = D.kInverseTransformTypeBySet[tx_set - 1][tx_type];
        }
        Tile.SetTransformType(block, x4, y4, D.kTransformWidth4x4[tx_size], D.kTransformHeight4x4[tx_size], tx_type, this.transform_types_);
    }

    void ReadCoeffBase2D(int[] scan, int tx_size, int adjusted_tx_width_log2, int eob, int[][] coeff_base_cdf, int[][] coeff_base_range_cdf, int[] quantized_buffer, int qPos, int[] level_buffer) {
        int tx_width = 1 << adjusted_tx_width_log2;
        for (int i = eob - 2; i >= 1; --i) {
            int pos = scan[i] & 0xFFFF;
            int row = pos >> adjusted_tx_width_log2;
            int column = pos & tx_width - 1;
            int[] quantized = quantized_buffer;
            int[] levels = level_buffer;
            int neighbor_sum = 1 + levels[pos + 1] + levels[pos + tx_width] + levels[pos + tx_width + 1] + levels[pos + 2] + levels[pos + tx_width * 2];
            int context = (neighbor_sum > 7 ? 4 : neighbor_sum / 2) + D.kCoeffBaseContextOffset[tx_size][Math.min(row, 4)][Math.min(column, 4)];
            int level = this.reader_.ReadSymbol(coeff_base_cdf[context], 4);
            levels[pos] = level & 0xFF;
            if (level > 2) {
                int contextx = Math.min(6, (1 + quantized[qPos + pos + 1] + quantized[qPos + pos + tx_width] + quantized[qPos + pos + tx_width + 1]) / 2);
                level += this.ReadCoeffBaseRange(coeff_base_range_cdf[contextx += 14 >> ((row | column) < 2 ? 1 : 0)]);
            }
            quantized[qPos + pos] = level;
        }
        int[] quantized = quantized_buffer;
        int level = this.reader_.ReadSymbol(coeff_base_cdf[0], 4);
        level_buffer[0] = level & 0xFF;
        if (level > 2) {
            int context = Math.min(6, (1 + quantized[qPos + 1] + quantized[qPos + tx_width] + quantized[qPos + tx_width + 1]) / 2);
            level += this.ReadCoeffBaseRange(coeff_base_range_cdf[context]);
        }
        quantized[qPos] = level;
    }

    void ReadCoeffBaseHorizontal(int[] scan, int TransformSize, int adjusted_tx_width_log2, int eob, int[][] coeff_base_cdf, int[][] coeff_base_range_cdf, int[] quantized_buffer, int qPos, int[] level_buffer) {
        int tx_width = 1 << adjusted_tx_width_log2;
        int i = eob - 2;
        do {
            int pos = scan[i] & 0xFFFF;
            int column = pos & tx_width - 1;
            int[] quantized = quantized_buffer;
            int[] levels = level_buffer;
            int neighbor_sum = 1 + (levels[pos + 1] + levels[pos + tx_width] + levels[pos + 2] + levels[pos + 3] + (column + 4 < tx_width ? levels[pos + 4] : 0));
            int context = (neighbor_sum > 7 ? 4 : neighbor_sum / 2) + D.kCoeffBasePositionContextOffset[column];
            int level = this.reader_.ReadSymbol(coeff_base_cdf[context], 4);
            levels[pos] = level & 0xFF;
            if (level > 2) {
                int contextx = Math.min(6, (1 + quantized[qPos + pos + 1] + quantized[qPos + pos + tx_width] + quantized[qPos + pos + 2]) / 2);
                if (pos != 0) {
                    contextx += 14 >> (column == 0 ? 1 : 0);
                }
                level += this.ReadCoeffBaseRange(coeff_base_range_cdf[contextx]);
            }
            quantized[qPos + pos] = level;
        } while (--i >= 0);
    }

    void ReadCoeffBaseVertical(int[] scan, int TransformSize, int adjusted_tx_width_log2, int eob, int[][] coeff_base_cdf, int[][] coeff_base_range_cdf, int[] quantized_buffer, int qPos, int[] level_buffer) {
        int tx_width = 1 << adjusted_tx_width_log2;
        int i = eob - 2;
        do {
            int pos = scan[i] & 0xFFFF;
            int row = pos >> adjusted_tx_width_log2;
            int column = pos & tx_width - 1;
            int[] quantized = quantized_buffer;
            int[] levels = level_buffer;
            int neighbor_sum = 1 + ((column + 1 < tx_width ? levels[pos + 1] : 0) + levels[pos + tx_width] + levels[pos + tx_width * 2] + levels[pos + tx_width * 3] + levels[pos + tx_width * 4]);
            int context = (neighbor_sum > 7 ? 4 : neighbor_sum / 2) + D.kCoeffBasePositionContextOffset[row];
            int level = this.reader_.ReadSymbol(coeff_base_cdf[context], 4);
            levels[pos] = level & 0xFF;
            if (level > 2) {
                int quantized_column1 = column + 1 < tx_width ? quantized[qPos + pos + 1] : 0;
                int contextx = Math.min(6, (1 + quantized_column1 + quantized[qPos + pos + tx_width] + quantized[qPos + pos + tx_width * 2]) / 2);
                if (pos != 0) {
                    contextx += 14 >> (row == 0 ? 1 : 0);
                }
                level += this.ReadCoeffBaseRange(coeff_base_range_cdf[contextx]);
            }
            quantized[qPos + pos] = level;
        } while (--i >= 0);
    }

    static int accumulateByte(byte[] arr, int start, int end, int initial) {
        int res = 0;
        for (int i = start; i <= end; ++i) {
            res += arr[i];
        }
        return res + initial;
    }

    int GetDcSignContext(int x4, int y4, int w4, int h4, int plane) {
        int max_x4x4 = this.frame_header_.columns4x4 >> this.subsampling_x_[plane];
        byte[] dc_categories = this.dc_categories_[1][plane][x4];
        int dc_sign = Tile.accumulateByte(dc_categories, 0, Tile.GetNumElements(w4, x4, max_x4x4), 0);
        dc_categories = this.dc_categories_[0][plane][y4];
        int max_y4x4 = this.frame_header_.rows4x4 >> this.subsampling_y_[plane];
        dc_sign = Tile.accumulateByte(dc_categories, 0, Tile.GetNumElements(h4, y4, max_y4x4), dc_sign);
        return (dc_sign < 0 ? 1 : 0) + (dc_sign > 0 ? 1 : 0) * 2;
    }

    void SetEntropyContexts(int x4, int y4, int w4, int h4, int plane, int coefficient_level, int dc_category) {
        int max_x4x4 = this.frame_header_.columns4x4 >> this.subsampling_x_[plane];
        int num_top_elements = Tile.GetNumElements(w4, x4, max_x4x4);
        Mem.set(this.coefficient_levels_[1][plane][x4], (byte)coefficient_level, num_top_elements);
        Mem.set(this.dc_categories_[1][plane][x4], (byte)dc_category, num_top_elements);
        int max_y4x4 = this.frame_header_.rows4x4 >> this.subsampling_y_[plane];
        int num_left_elements = Tile.GetNumElements(h4, y4, max_y4x4);
        Mem.set(this.coefficient_levels_[0][plane][y4], (byte)coefficient_level, num_left_elements);
        Mem.set(this.dc_categories_[0][plane][y4], (byte)dc_category, num_left_elements);
    }

    boolean ReadSignAndApplyDequantization(int[] scan, int i, int q_value, int[] quantizer_matrix, int shift, int max_value, int[] dc_sign_cdf, int[] dc_category, int[] coefficient_level, int[] residual_buffer, int residual_bufferPos, boolean is_dc_coefficient) {
        int sign;
        int pos = is_dc_coefficient ? 0 : scan[i];
        int level = residual_buffer[residual_bufferPos + pos];
        if (level == 0) {
            return true;
        }
        int n = is_dc_coefficient ? (this.reader_.ReadSymbol(dc_sign_cdf) ? 1 : 0) : (sign = this.reader_.ReadBit());
        if (level > 14) {
            int length = 0;
            boolean golomb_length_bit = false;
            do {
                boolean bl = golomb_length_bit = this.reader_.ReadBit() != 0;
                if (++length <= 20) continue;
                LogWriter.writeLog("ReadSignAndApplyDequantization error: invalid golomb" + length);
                return false;
            } while (!golomb_length_bit);
            int x = 1;
            for (int ii = length - 2; ii >= 0; --ii) {
                x = x << 1 | this.reader_.ReadBit();
            }
            level += x - 1;
        }
        if (is_dc_coefficient) {
            dc_category[0] = sign != 0 ? -1 : 1;
        }
        coefficient_level[0] = coefficient_level[0] + (level &= 0xFFFFF);
        int q = q_value;
        if (quantizer_matrix != null) {
            q = D.RightShiftWithRounding(q * quantizer_matrix[pos], 5);
        }
        int dequantized_value = (int)((long)q * (long)level & 0xFFFFFFL);
        dequantized_value >>= shift;
        residual_buffer[residual_bufferPos + pos] = dequantized_value = Math.min(dequantized_value - sign, max_value) ^ -sign;
        return true;
    }

    int ReadCoeffBaseRange(int[] cdf) {
        int level = 0;
        for (int j = 0; j < 4; ++j) {
            int coeff_base_range = this.reader_.ReadSymbol(cdf, 4);
            level += coeff_base_range;
            if (coeff_base_range < 3) break;
        }
        return level;
    }

    int ReadTransformCoefficients(Block block, int plane, int start_x, int start_y, int tx_size, int[] tx_type) {
        int[] dc_sign_cdf;
        int level;
        int eob;
        int tx_size_context = D.kTransformSizeContext[tx_size];
        int x4 = start_x / 4;
        int y4 = start_y / 4;
        int w4 = D.kTransformWidth4x4[tx_size];
        int h4 = D.kTransformHeight4x4[tx_size];
        int context = this.GetTransformAllZeroContext(block, plane, tx_size, x4, y4, w4, h4);
        boolean all_zero = this.reader_.ReadSymbol(this.symbol_decoder_context_.all_zero_cdf[tx_size_context][context]);
        if (all_zero) {
            if (plane == 0) {
                Tile.SetTransformType(block, x4, y4, w4, h4, 0, this.transform_types_);
            }
            this.SetEntropyContexts(x4, y4, w4, h4, plane, 0, 0);
            tx_type[0] = 16;
            return 0;
        }
        int tx_width = D.kTransformWidth[tx_size];
        int tx_height = D.kTransformHeight[tx_size];
        int adjusted_tx_size = D.kAdjustedTransformSize[tx_size];
        int adjusted_tx_width_log2 = D.kTransformWidthLog2[adjusted_tx_size];
        int tx_padding = (1 << adjusted_tx_width_log2) * 4;
        int[] residual = block.residual;
        int residualPos = block.residualPos;
        Arrays.fill(residual, 0);
        int[] level_buffer = new int[1152];
        Mem.set(level_buffer, 0, D.kTransformWidth[adjusted_tx_size] * D.kTransformHeight[adjusted_tx_size] + tx_padding);
        int clamped_tx_height = Math.min(tx_height, 32);
        if (plane == 0) {
            this.ReadTransformType(block, x4, y4, tx_size);
        }
        D.BlockParameters bp = block.bp;
        tx_type[0] = this.ComputeTransformType(block, plane, tx_size, x4, y4);
        int eob_multi_size = D.kEobMultiSizeLookup[tx_size];
        int plane_type = D.GetPlaneType(plane);
        int tx_class = Reconstruct.GetTransformClass(tx_type[0]);
        context = tx_class != 0 ? 1 : 0;
        int eob_pt = 1;
        switch (eob_multi_size) {
            case 0: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_16_cdf[plane_type][context], 5);
                break;
            }
            case 1: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_32_cdf[plane_type][context], 6);
                break;
            }
            case 2: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_64_cdf[plane_type][context], 7);
                break;
            }
            case 3: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_128_cdf[plane_type][context], 8);
                break;
            }
            case 4: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_256_cdf[plane_type][context], 9);
                break;
            }
            case 5: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_512_cdf[plane_type], 10);
                break;
            }
            default: {
                eob_pt += this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_pt_1024_cdf[plane_type], 11);
            }
        }
        int n = eob = eob_pt < 2 ? eob_pt : (1 << eob_pt - 2) + 1;
        if (eob_pt >= 3) {
            context = eob_pt - 3;
            boolean eob_extra = this.reader_.ReadSymbol(this.symbol_decoder_context_.eob_extra_cdf[tx_size_context][plane_type][context]);
            if (eob_extra) {
                eob += 1 << eob_pt - 3;
            }
            for (int i = 1; i < eob_pt - 2; ++i) {
                if (this.reader_.ReadBit() == 0) continue;
                eob += 1 << eob_pt - i - 3;
            }
        }
        int[] scan = Scan.kScan[tx_class][tx_size];
        int clamped_tx_size_context = Math.min(tx_size_context, 3);
        int[][] coeff_base_range_cdf = this.symbol_decoder_context_.coeff_base_range_cdf[clamped_tx_size_context][plane_type];
        context = Tile.GetCoeffBaseContextEob(tx_size, eob - 1);
        int pos = scan[eob - 1] & 0xFFFF;
        level_buffer[pos] = level = 1 + this.reader_.ReadSymbol(this.symbol_decoder_context_.coeff_base_eob_cdf[tx_size_context][plane_type][context], 3);
        if (level > 2) {
            level += this.ReadCoeffBaseRange(coeff_base_range_cdf[Tile.GetCoeffBaseRangeContextEob(adjusted_tx_width_log2, pos, tx_class)]);
        }
        residual[residualPos + pos] = level;
        if (eob > 1) {
            switch (tx_class) {
                case 0: {
                    this.ReadCoeffBase2D(scan, tx_size, adjusted_tx_width_log2, eob, this.symbol_decoder_context_.coeff_base_cdf[tx_size_context][plane_type], coeff_base_range_cdf, residual, residualPos, level_buffer);
                    break;
                }
                case 1: {
                    this.ReadCoeffBaseHorizontal(scan, tx_size, adjusted_tx_width_log2, eob, this.symbol_decoder_context_.coeff_base_cdf[tx_size_context][plane_type], coeff_base_range_cdf, residual, residualPos, level_buffer);
                    break;
                }
                case 2: {
                    this.ReadCoeffBaseVertical(scan, tx_size, adjusted_tx_width_log2, eob, this.symbol_decoder_context_.coeff_base_cdf[tx_size_context][plane_type], coeff_base_range_cdf, residual, residualPos, level_buffer);
                }
            }
        }
        int max_value = (1 << 7 + this.sequence_header_.color_config.bitdepth) - 1;
        int current_quantizer_index = Quant.GetQIndex(this.frame_header_.segmentation, bp.prediction_parameters.segment_id, this.current_quantizer_index_);
        int dc_q_value = this.quantizer_.GetDcValue(plane, current_quantizer_index);
        int ac_q_value = this.quantizer_.GetAcValue(plane, current_quantizer_index);
        int shift = D.kQuantizationShift[tx_size];
        int[] quantizer_matrix = this.frame_header_.quantizer.use_matrix && tx_type[0] < 9 && !this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id] && this.frame_header_.quantizer.matrix_level[plane] < 15 ? this.quantizer_matrix_[this.frame_header_.quantizer.matrix_level[plane]][plane_type][adjusted_tx_size] : null;
        int[] coefficient_level = new int[]{0};
        int[] dc_category = new int[]{0};
        int[] nArray = dc_sign_cdf = residual[residualPos + 0] != 0 ? this.symbol_decoder_context_.dc_sign_cdf[plane_type][this.GetDcSignContext(x4, y4, w4, h4, plane)] : null;
        if (!this.ReadSignAndApplyDequantization(scan, 0, dc_q_value, quantizer_matrix, shift, max_value, dc_sign_cdf, dc_category, coefficient_level, residual, residualPos, true)) {
            LogWriter.writeLog("ReadTransformCoefficients : error1");
            return -1;
        }
        if (eob > 1) {
            int i = 1;
            do {
                if (this.ReadSignAndApplyDequantization(scan, i, ac_q_value, quantizer_matrix, shift, max_value, null, null, coefficient_level, residual, residualPos, false)) continue;
                LogWriter.writeLog("ReadTransformCoefficients : error2");
                return -1;
            } while (++i < eob);
            Tile.MoveCoefficientsForTxWidth64(clamped_tx_height, tx_width, residual, residualPos);
        }
        this.SetEntropyContexts(x4, y4, w4, h4, plane, Math.min(4, coefficient_level[0]), dc_category[0]);
        if (this.split_parse_and_decode_) {
            block.residualPos += tx_width * tx_height * this.residual_size_;
        }
        return eob;
    }

    boolean TransformBlock(Block block, int plane, int base_x, int base_y, int tx_size, int x, int y, int mode) {
        boolean do_decode;
        D.BlockParameters bp = block.bp;
        int subsampling_x = this.subsampling_x_[plane];
        int subsampling_y = this.subsampling_y_[plane];
        int start_x = base_x + x * 4;
        int start_y = base_y + y * 4;
        int max_x = this.frame_header_.columns4x4 * 4 >> subsampling_x;
        int max_y = this.frame_header_.rows4x4 * 4 >> subsampling_y;
        if (start_x >= max_x || start_y >= max_y) {
            return true;
        }
        int row = (start_y << subsampling_y) / 4;
        int column = (start_x << subsampling_x) / 4;
        int mask = this.sequence_header_.use_128x128_superblock ? 31 : 15;
        int sub_block_row4x4 = row & mask;
        int sub_block_column4x4 = column & mask;
        int step_x = D.kTransformWidth4x4[tx_size];
        int step_y = D.kTransformHeight4x4[tx_size];
        boolean bl = do_decode = mode == 1 || mode == 2;
        if (do_decode && !bp.is_inter) {
            if (bp.prediction_parameters.palette_mode_info.size[D.GetPlaneType(plane)] > 0) {
                this.PalettePrediction(block, plane, start_x, start_y, x, y, tx_size);
            } else {
                int modex = plane == 0 ? bp.y_mode : (bp.prediction_parameters.uv_mode == 13 ? 0 : bp.prediction_parameters.uv_mode);
                int tr_row4x4 = sub_block_row4x4 >> subsampling_y;
                int tr_column4x4 = (sub_block_column4x4 >> subsampling_x) + step_x + 1;
                int bl_row4x4 = (sub_block_row4x4 >> subsampling_y) + step_y + 1;
                int bl_column4x4 = sub_block_column4x4 >> subsampling_x;
                boolean has_left = x > 0 || block.left_available[plane];
                boolean has_top = y > 0 || block.top_available[plane];
                this.IntraPrediction(block, plane, start_x, start_y, has_left, has_top, block.scratch_buffer.block_decoded[plane][tr_row4x4 * 34 + tr_column4x4], block.scratch_buffer.block_decoded[plane][bl_row4x4 * 34 + bl_column4x4], modex, tx_size);
                if (plane != 0 && bp.prediction_parameters.uv_mode == 13) {
                    this.ChromaFromLumaPrediction(block, plane, start_x, start_y, tx_size);
                }
            }
            if (plane == 0) {
                block.bp.prediction_parameters.max_luma_width = start_x + step_x * 4;
                block.bp.prediction_parameters.max_luma_height = start_y + step_y * 4;
                block.scratch_buffer.cfl_luma_buffer_valid = false;
            }
        }
        if (!bp.skip) {
            int sb_row_index = this.SuperBlockRowIndex(block.row4x4);
            int sb_column_index = this.SuperBlockColumnIndex(block.column4x4);
            if (mode == 1) {
                D.QueueTransformParameters tx_params = this.residual_buffer_threaded_[sb_row_index][sb_column_index].transform_parameters_;
                this.ReconstructBlock(block, plane, start_x, start_y, tx_size, tx_params.Front().type, tx_params.Front().non_zero_coeff_count);
                tx_params.Pop();
            } else {
                int[] tx_type = new int[]{0};
                int non_zero_coeff_count = this.ReadTransformCoefficients(block, plane, start_x, start_y, tx_size, tx_type);
                if (non_zero_coeff_count < 0) {
                    return false;
                }
                if (mode == 2) {
                    this.ReconstructBlock(block, plane, start_x, start_y, tx_size, tx_type[0], non_zero_coeff_count);
                } else {
                    this.residual_buffer_threaded_[sb_row_index][sb_column_index].transform_parameters_.Push(new D.TransformParameters(tx_type[0], non_zero_coeff_count));
                }
            }
        }
        if (do_decode) {
            boolean[] block_decoded = block.scratch_buffer.block_decoded[plane];
            int block_decodedPos = ((sub_block_row4x4 >> subsampling_y) + 1) * 34 + ((sub_block_column4x4 >> subsampling_x) + 1);
            Tile.SetBlockValuesBoolean(step_y, step_x, true, block_decoded, block_decodedPos, 34);
        }
        return true;
    }

    boolean TransformTree(Block block, int start_x, int start_y, int plane_size, int mode) {
        LogWriter.writeLog("Transform Tree should not be called in intra decoding");
        Stack<D.TransformTreeNode> stack = new Stack<D.TransformTreeNode>();
        stack.push(new D.TransformTreeNode(start_x, start_y, plane_size));
        do {
            D.TransformTreeNode node = (D.TransformTreeNode)stack.pop();
            int row = node.y / 4;
            int column = node.x / 4;
            if (row >= this.frame_header_.rows4x4 || column >= this.frame_header_.columns4x4) continue;
            int inter_tx_size = this.inter_transform_sizes_[row][column];
            int width = D.kTransformWidth[node.tx_size];
            int height = D.kTransformHeight[node.tx_size];
            if (width <= D.kTransformWidth[inter_tx_size] && height <= D.kTransformHeight[inter_tx_size]) {
                if (this.TransformBlock(block, 0, node.x, node.y, node.tx_size, 0, 0, mode)) continue;
                LogWriter.writeLog("Transform Tree : error");
                return false;
            }
            int split_tx_size = D.kSplitTransformSize[node.tx_size];
            int half_width = width / 2;
            if (width > height) {
                stack.push(new D.TransformTreeNode(node.x + half_width, node.y, split_tx_size));
                stack.push(new D.TransformTreeNode(node.x, node.y, split_tx_size));
                continue;
            }
            int half_height = height / 2;
            if (width < height) {
                stack.push(new D.TransformTreeNode(node.x, node.y + half_height, split_tx_size));
                stack.push(new D.TransformTreeNode(node.x, node.y, split_tx_size));
                continue;
            }
            stack.push(new D.TransformTreeNode(node.x + half_width, node.y + half_height, split_tx_size));
            stack.push(new D.TransformTreeNode(node.x, node.y + half_height, split_tx_size));
            stack.push(new D.TransformTreeNode(node.x + half_width, node.y, split_tx_size));
            stack.push(new D.TransformTreeNode(node.x, node.y, split_tx_size));
        } while (!stack.isEmpty());
        return true;
    }

    void ReconstructBlock(Block block, int plane, int start_x, int start_y, int tx_size, int tx_type, int non_zero_coeff_count) {
        if (non_zero_coeff_count == 0) {
            return;
        }
        Reconstruct.reconsruct(tx_type, tx_size, this.frame_header_.segmentation.lossless[block.bp.prediction_parameters.segment_id], block.residual, block.residualPos, start_x, start_y, this.buffer_[plane], non_zero_coeff_count);
        if (this.split_parse_and_decode_) {
            block.residualPos += D.kTransformWidth[tx_size] * D.kTransformHeight[tx_size] * this.residual_size_;
        }
    }

    boolean Residual(Block block, int mode) {
        int width_chunks = Math.max(1, block.width >> 6);
        int height_chunks = Math.max(1, block.height >> 6);
        int size_chunk4x4 = width_chunks > 1 || height_chunks > 1 ? 18 : block.size;
        D.BlockParameters bp = block.bp;
        for (int chunk_y = 0; chunk_y < height_chunks; ++chunk_y) {
            for (int chunk_x = 0; chunk_x < width_chunks; ++chunk_x) {
                int num_planes = block.HasChroma() ? this.PlaneCount() : 1;
                int plane = 0;
                do {
                    int subsampling_x = this.subsampling_x_[plane];
                    int subsampling_y = this.subsampling_y_[plane];
                    int tx_size = plane == 0 ? this.inter_transform_sizes_[block.row4x4][block.column4x4] : bp.uv_transform_size;
                    int plane_size = D.kPlaneResidualSize[size_chunk4x4][subsampling_x][subsampling_y];
                    if (bp.is_inter && !this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id] && plane == 0) {
                        int column_chunk4x4 = block.column4x4 + chunk_x * 16;
                        int base_x = (column_chunk4x4 >> subsampling_x) * 4;
                        int row_chunk4x4 = block.row4x4 + chunk_y * 16;
                        int base_y = (row_chunk4x4 >> subsampling_y) * 4;
                        if (this.TransformTree(block, base_x, base_y, plane_size, mode)) continue;
                        LogWriter.writeLog("Residual : Error");
                        return false;
                    }
                    int base_x = (block.column4x4 >> subsampling_x) * 4;
                    int base_y = (block.row4x4 >> subsampling_y) * 4;
                    int step_x = D.kTransformWidth4x4[tx_size];
                    int step_y = D.kTransformHeight4x4[tx_size];
                    int num4x4_wide = D.kNum4x4BlocksWide[plane_size];
                    int num4x4_high = D.kNum4x4BlocksHigh[plane_size];
                    for (int y = 0; y < num4x4_high; y += step_y) {
                        for (int x = 0; x < num4x4_wide; x += step_x) {
                            if (this.TransformBlock(block, plane, base_x, base_y, tx_size, x + (chunk_x * 16 >> subsampling_x), y + (chunk_y * 16 >> subsampling_y), mode)) continue;
                            LogWriter.writeLog("Residual : Error2");
                            return false;
                        }
                    }
                } while (++plane < num_planes);
            }
        }
        return true;
    }

    boolean IsMvValid(Block block, boolean is_compound) {
        int active_64x64_block_column;
        int active_sb_row;
        int active_64x64_block;
        int src_64x64_block_column;
        int total_64x64_blocks_per_row;
        D.BlockParameters bp = block.bp;
        for (int i = 0; i < 1 + (is_compound ? 1 : 0); ++i) {
            for (int mv_component : bp.mv.mv[i].mv) {
                if (Math.abs(mv_component) < 16384) continue;
                return false;
            }
        }
        if (!block.bp.prediction_parameters.use_intra_block_copy) {
            return true;
        }
        if ((bp.mv.mv[0].mv32 & 0x70007) != 0) {
            return false;
        }
        int delta_row = bp.mv.mv[0].mv[0] >> 3;
        int delta_column = bp.mv.mv[0].mv[1] >> 3;
        int src_top_edge = block.row4x4 * 4 + delta_row;
        int src_left_edge = block.column4x4 * 4 + delta_column;
        int src_bottom_edge = src_top_edge + block.height;
        int src_right_edge = src_left_edge + block.width;
        if (block.HasChroma()) {
            if (block.width < 8 && this.subsampling_x_[1] != 0) {
                src_left_edge -= 4;
            }
            if (block.height < 8 && this.subsampling_y_[1] != 0) {
                src_top_edge -= 4;
            }
        }
        if (src_top_edge < this.row4x4_start_ * 4 || src_left_edge < this.column4x4_start_ * 4 || src_bottom_edge > this.row4x4_end_ * 4 || src_right_edge > this.column4x4_end_ * 4) {
            return false;
        }
        int sb_height_log2 = 6 + (this.sequence_header_.use_128x128_superblock ? 1 : 0);
        int src_sb_row = src_bottom_edge - 1 >> sb_height_log2;
        int src_64x64_block = src_sb_row * (total_64x64_blocks_per_row = (this.column4x4_end_ - this.column4x4_start_ - 1 >> 4) + 1) + (src_64x64_block_column = src_right_edge - 1 >> 6);
        if (src_64x64_block >= (active_64x64_block = (active_sb_row = block.row4x4 * 4 >> sb_height_log2) * total_64x64_blocks_per_row + (active_64x64_block_column = block.column4x4 * 4 >> 6)) - 4) {
            return false;
        }
        if (src_sb_row > active_sb_row) {
            return false;
        }
        int gradient = 5 + (this.sequence_header_.use_128x128_superblock ? 1 : 0);
        int wavefront_offset = gradient * (active_sb_row - src_sb_row);
        return src_64x64_block_column < active_64x64_block_column - 4 + wavefront_offset;
    }

    boolean AssignInterMv(Block block, boolean is_compound) {
        LogWriter.writeLog("AssignInterMv should not be called");
        int[] min = new int[2];
        int[] max = new int[2];
        Tile.GetClampParameters(block, min, max);
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = bp.prediction_parameters;
        bp.mv.mv64 = 0L;
        if (is_compound) {
            for (int i = 0; i < 2; ++i) {
                D.MotionVector predicted_mv;
                int mode = Tile.GetSinglePredictionMode(i, bp.y_mode);
                if (mode == 16) {
                    predicted_mv = prediction_parameters.global_mv[i];
                } else {
                    int ref_mv_index = mode == 14 || mode == 17 && prediction_parameters.ref_mv_count <= 1 ? 0 : prediction_parameters.ref_mv_index;
                    predicted_mv = prediction_parameters.reference_mv(ref_mv_index, i);
                    if (ref_mv_index < prediction_parameters.ref_mv_count) {
                        predicted_mv.mv[0] = D.Clip3(predicted_mv.mv[0], min[0], max[0]);
                        predicted_mv.mv[1] = D.Clip3(predicted_mv.mv[1], min[1], max[1]);
                    }
                }
                if (mode == 17) {
                    this.ReadMotionVector(block, i);
                    bp.mv.mv[i].mv[0] = bp.mv.mv[i].mv[0] + predicted_mv.mv[0];
                    bp.mv.mv[i].mv[1] = bp.mv.mv[i].mv[1] + predicted_mv.mv[1];
                    continue;
                }
                bp.mv.mv[i] = predicted_mv;
            }
        } else {
            D.MotionVector predicted_mv;
            int mode = Tile.GetSinglePredictionMode(0, bp.y_mode);
            if (mode == 16) {
                predicted_mv = prediction_parameters.global_mv[0];
            } else {
                int ref_mv_index = mode == 14 || mode == 17 && prediction_parameters.ref_mv_count <= 1 ? 0 : prediction_parameters.ref_mv_index;
                predicted_mv = prediction_parameters.reference_mv(ref_mv_index);
                if (ref_mv_index < prediction_parameters.ref_mv_count) {
                    predicted_mv.mv[0] = D.Clip3(predicted_mv.mv[0], min[0], max[0]);
                    predicted_mv.mv[1] = D.Clip3(predicted_mv.mv[1], min[1], max[1]);
                }
            }
            if (mode == 17) {
                this.ReadMotionVector(block, 0);
                bp.mv.mv[0].mv[0] = bp.mv.mv[0].mv[0] + predicted_mv.mv[0];
                bp.mv.mv[0].mv[1] = bp.mv.mv[0].mv[1] + predicted_mv.mv[1];
            } else {
                bp.mv.mv[0] = predicted_mv;
            }
        }
        return this.IsMvValid(block, is_compound);
    }

    boolean AssignIntraMv(Block block) {
        int[] min = new int[2];
        int[] max = new int[2];
        Tile.GetClampParameters(block, min, max);
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = bp.prediction_parameters;
        D.MotionVector ref_mv_0 = prediction_parameters.reference_mv(0);
        bp.mv.mv64 = 0L;
        this.ReadMotionVector(block, 0);
        if (ref_mv_0.mv32 == 0) {
            D.MotionVector ref_mv_1 = prediction_parameters.reference_mv(1);
            if (ref_mv_1.mv32 == 0) {
                int super_block_size4x4 = D.kNum4x4BlocksHigh[this.SuperBlockSize()];
                if (block.row4x4 - super_block_size4x4 < this.row4x4_start_) {
                    bp.mv.mv[0].mv[1] = bp.mv.mv[0].mv[1] - super_block_size4x4 * 32;
                    bp.mv.mv[0].mv[1] = bp.mv.mv[0].mv[1] - 2048;
                } else {
                    bp.mv.mv[0].mv[0] = bp.mv.mv[0].mv[0] - super_block_size4x4 * 32;
                }
            } else {
                bp.mv.mv[0].mv[0] = bp.mv.mv[0].mv[0] + D.Clip3(ref_mv_1.mv[0], min[0], max[0]);
                bp.mv.mv[0].mv[1] = bp.mv.mv[0].mv[1] + D.Clip3(ref_mv_1.mv[1], min[0], max[0]);
            }
        } else {
            bp.mv.mv[0].mv[0] = bp.mv.mv[0].mv[0] + D.Clip3(ref_mv_0.mv[0], min[0], max[0]);
            bp.mv.mv[0].mv[1] = bp.mv.mv[0].mv[1] + D.Clip3(ref_mv_0.mv[1], min[1], max[1]);
        }
        return this.IsMvValid(block, false);
    }

    void ResetEntropyContext(Block block) {
        int num_planes = block.HasChroma() ? this.PlaneCount() : 1;
        int plane = 0;
        do {
            int subsampling_x = this.subsampling_x_[plane];
            int start_x = block.column4x4 >> subsampling_x;
            int end_x = Math.min(block.column4x4 + block.width4x4 >> subsampling_x, this.frame_header_.columns4x4);
            Mem.set(this.coefficient_levels_[1][plane][start_x], (byte)0, end_x - start_x);
            Mem.set(this.dc_categories_[1][plane][start_x], (byte)0, end_x - start_x);
            int subsampling_y = this.subsampling_y_[plane];
            int start_y = block.row4x4 >> subsampling_y;
            int end_y = Math.min(block.row4x4 + block.height4x4 >> subsampling_y, this.frame_header_.rows4x4);
            Mem.set(this.coefficient_levels_[0][plane][start_y], (byte)0, end_y - start_y);
            Mem.set(this.dc_categories_[0][plane][start_y], (byte)0, end_y - start_y);
        } while (++plane < num_planes);
    }

    boolean ComputePrediction(Block block) {
        D.BlockParameters bp = block.bp;
        if (!bp.is_inter) {
            return true;
        }
        LogWriter.writeLog("compute prediction not needed in intra frame");
        int mask = (1 << 4 + (this.sequence_header_.use_128x128_superblock ? 1 : 0)) - 1;
        int sub_block_row4x4 = block.row4x4 & mask;
        int sub_block_column4x4 = block.column4x4 & mask;
        int plane_count = block.HasChroma() ? this.PlaneCount() : 1;
        boolean is_local_valid = false;
        int plane = 0;
        do {
            int prediction_height;
            int prediction_width;
            boolean some_use_intra;
            int subsampling_x = this.subsampling_x_[plane];
            int subsampling_y = this.subsampling_y_[plane];
            int plane_size = block.residual_size[plane];
            int block_width4x4 = D.kNum4x4BlocksWide[plane_size];
            int block_height4x4 = D.kNum4x4BlocksHigh[plane_size];
            int block_width = block_width4x4 * 4;
            int block_height = block_height4x4 * 4;
            int base_x = (block.column4x4 >> subsampling_x) * 4;
            int base_y = (block.row4x4 >> subsampling_y) * 4;
            if (bp.reference_frame[1] == 0) {
                int tr_row4x4 = sub_block_row4x4 >> subsampling_y;
                int tr_column4x4 = (sub_block_column4x4 >> subsampling_x) + block_width4x4 + 1;
                int bl_row4x4 = (sub_block_row4x4 >> subsampling_y) + block_height4x4;
                int bl_column4x4 = (sub_block_column4x4 >> subsampling_x) + 1;
                int tx_size = D.k4x4SizeToTransformSize[D.k4x4WidthLog2[plane_size]][D.k4x4HeightLog2[plane_size]];
                boolean has_left = block.left_available[plane];
                boolean has_top = block.top_available[plane];
                this.IntraPrediction(block, plane, base_x, base_y, has_left, has_top, block.scratch_buffer.block_decoded[plane][tr_row4x4 * 34 + tr_column4x4], block.scratch_buffer.block_decoded[plane][bl_row4x4 * 34 + bl_column4x4], D.kInterIntraToIntraMode[block.bp.prediction_parameters.inter_intra_mode], tx_size);
            }
            int candidate_row = block.row4x4;
            int candidate_column = block.column4x4;
            boolean bl = some_use_intra = bp.reference_frame[0] == 0;
            if (!some_use_intra && plane != 0) {
                candidate_row = candidate_row >> subsampling_y << subsampling_y;
                candidate_column = candidate_column >> subsampling_x << subsampling_x;
                if (candidate_row != block.row4x4) {
                    D.BlockParameters bp_top = this.block_parameters_holder_.Find(candidate_row, block.column4x4);
                    boolean bl2 = some_use_intra = bp_top.reference_frame[0] == 0;
                    if (!some_use_intra && candidate_column != block.column4x4) {
                        D.BlockParameters bp_top_left = this.block_parameters_holder_.Find(candidate_row, candidate_column);
                        boolean bl3 = some_use_intra = bp_top_left.reference_frame[0] == 0;
                    }
                }
                if (!some_use_intra && candidate_column != block.column4x4) {
                    D.BlockParameters bp_left = this.block_parameters_holder_.Find(block.row4x4, candidate_column);
                    boolean bl4 = some_use_intra = bp_left.reference_frame[0] == 0;
                }
            }
            if (some_use_intra) {
                candidate_row = block.row4x4;
                candidate_column = block.column4x4;
                prediction_width = block_width;
                prediction_height = block_height;
            } else {
                prediction_width = block.width >> subsampling_x;
                prediction_height = block.height >> subsampling_y;
            }
            int r = 0;
            int y = 0;
            do {
                int c = 0;
                int x = 0;
                do {
                    if (!this.InterPrediction(block, plane, base_x + x, base_y + y, prediction_width, prediction_height, candidate_row + r, candidate_column + c, is_local_valid, this.local_warp_params)) {
                        return false;
                    }
                    ++c;
                } while ((x += prediction_width) < block_width);
                ++r;
            } while ((y += prediction_height) < block_height);
        } while (++plane < plane_count);
        return true;
    }

    boolean InterPrediction(Block block, int plane, int x, int y, int prediction_width, int prediction_height, int candidate_row, int candidate_column, boolean is_local_valid, D.GlobalMotion local_warp_params) {
        LogWriter.writeLog("inter prediction not supported");
        return true;
    }

    void PopulateDeblockFilterLevel(Block block) {
        if (!this.post_filter_.DoDeblock()) {
            return;
        }
        D.BlockParameters bp = block.bp;
        int mode_id = D.kPredictionModeDeltasMask.Contains(bp.y_mode) ? 1 : 0;
        for (int i = 0; i < 4; ++i) {
            bp.deblock_filter_level[i] = this.delta_lf_all_zero_ ? this.post_filter_.GetZeroDeltaDeblockFilterLevel(bp.prediction_parameters.segment_id, i, bp.reference_frame[0], mode_id) : this.deblock_filter_levels_[bp.prediction_parameters.segment_id][i][bp.reference_frame[0]][mode_id];
        }
    }

    void PopulateCdefSkip(Block block) {
        if (!this.post_filter_.DoCdef() || block.bp.skip || this.frame_header_.cdef.bits > 0 && this.cdef_index_.get(block.row4x4 / 16, block.column4x4 / 16) == -1) {
            return;
        }
        int bw4 = Math.max(block.width4x4 / 2 + (block.column4x4 & 1), 1);
        int mask = block.width4x4 == 32 ? 255 : 255 >> 8 - bw4 << (block.column4x4 / 2 & 7);
        int hPos = block.row4x4 >> 1;
        int wPos = block.column4x4 >> 4;
        int stride = this.cdef_skip_.columns();
        int[] cdef_skip = this.cdef_skip_.data_;
        int cdef_skipPos = hPos * stride + wPos;
        int row = 0;
        do {
            int n = cdef_skipPos;
            cdef_skip[n] = cdef_skip[n] | mask;
            if (block.width4x4 == 32) {
                cdef_skip[cdef_skipPos + 1] = 255;
            }
            cdef_skipPos += stride;
        } while ((row += 2) < block.height4x4);
    }

    boolean ProcessBlock(int row4x4, int column4x4, int block_size, D.TileScratchBuffer scratch_buffer, int[] residual, int residualPos) {
        D.BlockParameters bp_ptr;
        if (row4x4 >= this.frame_header_.rows4x4 || column4x4 >= this.frame_header_.columns4x4) {
            return true;
        }
        if (this.split_parse_and_decode_) {
            int sb_row_index = this.SuperBlockRowIndex(row4x4);
            int sb_column_index = this.SuperBlockColumnIndex(column4x4);
            this.residual_buffer_threaded_[sb_row_index][sb_column_index].partition_tree_order().Push(new D.PartitionTreeNode(row4x4, column4x4, block_size));
        }
        D.BlockParameters bp = bp_ptr = this.block_parameters_holder_.Get(row4x4, column4x4, block_size);
        Block block = new Block(this, block_size, row4x4, column4x4, scratch_buffer, residual, residualPos);
        bp.size = block_size;
        D.PredictionParameters predictionParameters = bp.prediction_parameters = this.split_parse_and_decode_ ? new D.PredictionParameters() : this.prediction_parameters_;
        if (bp.prediction_parameters == null) {
            LogWriter.writeLog("Process Block Error");
            return false;
        }
        if (!this.DecodeModeInfo(block)) {
            LogWriter.writeLog("Process Block Error");
            return false;
        }
        this.PopulateDeblockFilterLevel(block);
        if (!this.ReadPaletteTokens(block)) {
            LogWriter.writeLog("Process Block Error2");
            return false;
        }
        this.DecodeTransformSize(block);
        int n = bp.uv_transform_size = this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id] ? 0 : D.kUVTransformSize[block.residual_size[1]];
        if (bp.skip) {
            this.ResetEntropyContext(block);
        }
        this.PopulateCdefSkip(block);
        if (this.split_parse_and_decode_) {
            if (!this.Residual(block, 0)) {
                LogWriter.writeLog("Process Block Error3");
                return false;
            }
        } else if (!this.ComputePrediction(block) || !this.Residual(block, 2)) {
            LogWriter.writeLog("Process Block Error4");
            return false;
        }
        if (this.frame_header_.segmentation.enabled && this.frame_header_.segmentation.update_map) {
            int x_limit = Math.min(this.frame_header_.columns4x4 - column4x4, block.width4x4);
            int y_limit = Math.min(this.frame_header_.rows4x4 - row4x4, block.height4x4);
            this.current_frame_.segmentation_map().FillBlock(row4x4, column4x4, x_limit, y_limit, bp.prediction_parameters.segment_id);
        }
        this.StoreMotionFieldMvsIntoCurrentFrame(block);
        if (!this.split_parse_and_decode_) {
            this.prediction_parameters_ = bp.prediction_parameters;
        }
        return true;
    }

    boolean DecodeBlock(int row4x4, int column4x4, int block_size, D.TileScratchBuffer scratch_buffer, int[] residual, int residualPos) {
        if (row4x4 >= this.frame_header_.rows4x4 || column4x4 >= this.frame_header_.columns4x4) {
            return true;
        }
        Block block = new Block(this, block_size, row4x4, column4x4, scratch_buffer, residual, residualPos);
        if (!this.ComputePrediction(block) || !this.Residual(block, 1)) {
            LogWriter.writeLog("Tile error: Decode Block");
            return false;
        }
        block.bp.prediction_parameters = null;
        return true;
    }

    boolean ProcessPartition(int row4x4_start, int column4x4_start, D.TileScratchBuffer scratch_buffer, int[] residual, int residualPos) {
        Stack<D.PartitionTreeNode> stack = new Stack<D.PartitionTreeNode>();
        stack.push(new D.PartitionTreeNode(row4x4_start, column4x4_start, this.SuperBlockSize()));
        block12: do {
            int[] partition;
            boolean has_columns;
            D.PartitionTreeNode node = (D.PartitionTreeNode)stack.pop();
            int row4x4 = node.row4x4;
            int column4x4 = node.column4x4;
            int block_size = node.block_size;
            if (row4x4 >= this.frame_header_.rows4x4 || column4x4 >= this.frame_header_.columns4x4) continue;
            int block_width4x4 = D.kNum4x4BlocksWide[block_size];
            int half_block4x4 = block_width4x4 >> 1;
            boolean has_rows = row4x4 + half_block4x4 < this.frame_header_.rows4x4;
            if (!this.ReadPartition(row4x4, column4x4, block_size, has_rows, has_columns = column4x4 + half_block4x4 < this.frame_header_.columns4x4, partition = new int[1])) {
                LogWriter.writeLog("partition error 1");
                return false;
            }
            int sub_size = D.kSubSize[partition[0]][block_size];
            if (sub_size == 23 || D.kPlaneResidualSize[sub_size][this.sequence_header_.color_config.subsampling_x][this.sequence_header_.color_config.subsampling_y] == 23) {
                LogWriter.writeLog("partition error 2");
                return false;
            }
            int quarter_block4x4 = half_block4x4 >> 1;
            int split_size = D.kSubSize[3][block_size];
            switch (partition[0]) {
                case 0: {
                    if (this.ProcessBlock(row4x4, column4x4, sub_size, scratch_buffer, residual, residualPos)) break;
                    LogWriter.writeLog("partition error 3");
                    return false;
                }
                case 3: {
                    stack.push(new D.PartitionTreeNode(row4x4 + half_block4x4, column4x4 + half_block4x4, sub_size));
                    stack.push(new D.PartitionTreeNode(row4x4 + half_block4x4, column4x4, sub_size));
                    stack.push(new D.PartitionTreeNode(row4x4, column4x4 + half_block4x4, sub_size));
                    stack.push(new D.PartitionTreeNode(row4x4, column4x4, sub_size));
                    break;
                }
                case 1: {
                    if (this.ProcessBlock(row4x4, column4x4, sub_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4, sub_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 4");
                    return false;
                }
                case 2: {
                    if (this.ProcessBlock(row4x4, column4x4, sub_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4, column4x4 + half_block4x4, sub_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 5");
                    return false;
                }
                case 4: {
                    if (this.ProcessBlock(row4x4, column4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4, column4x4 + half_block4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4, sub_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 6");
                    return false;
                }
                case 5: {
                    if (this.ProcessBlock(row4x4, column4x4, sub_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4 + half_block4x4, split_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 7");
                    return false;
                }
                case 6: {
                    if (this.ProcessBlock(row4x4, column4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4, column4x4 + half_block4x4, sub_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 8");
                    return false;
                }
                case 7: {
                    if (this.ProcessBlock(row4x4, column4x4, sub_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4, column4x4 + half_block4x4, split_size, scratch_buffer, residual, residualPos) && this.ProcessBlock(row4x4 + half_block4x4, column4x4 + half_block4x4, split_size, scratch_buffer, residual, residualPos)) continue block12;
                    LogWriter.writeLog("partition error 9");
                    return false;
                }
                case 8: {
                    int i;
                    for (i = 0; i < 4; ++i) {
                        if (this.ProcessBlock(row4x4 + i * quarter_block4x4, column4x4, sub_size, scratch_buffer, residual, residualPos)) continue;
                        LogWriter.writeLog("partition error 10");
                        return false;
                    }
                    continue block12;
                }
                case 9: {
                    int i;
                    for (i = 0; i < 4; ++i) {
                        if (this.ProcessBlock(row4x4, column4x4 + i * quarter_block4x4, sub_size, scratch_buffer, residual, residualPos)) continue;
                        LogWriter.writeLog("partition error 11");
                        return false;
                    }
                }
            }
        } while (!stack.isEmpty());
        return true;
    }

    private void ResetLoopRestorationParams() {
        for (int plane = 0; plane < 3; ++plane) {
            if (this.reference_unit_info_[plane] == null) {
                this.reference_unit_info_[plane] = new D.RestorationUnitInfo();
            }
            for (int i = 0; i <= 1; ++i) {
                this.reference_unit_info_[plane].sgr_proj_info.multiplier[i] = D.kSgrProjDefaultMultiplier[i];
                for (int j = 0; j < 3; ++j) {
                    this.reference_unit_info_[plane].wiener_info.filter[i][j] = D.kWienerDefaultFilter[j];
                }
            }
        }
    }

    void ResetCdef(int row4x4, int column4x4) {
        if (this.frame_header_.cdef.bits == 0) {
            return;
        }
        int row = row4x4 / 16;
        int column = column4x4 / 16;
        this.cdef_index_.set(row, column, -1);
        if (this.sequence_header_.use_128x128_superblock) {
            int cdef_size4x4 = D.kNum4x4BlocksWide[18];
            int border_row = (row4x4 + cdef_size4x4) / 16;
            int border_column = (column4x4 + cdef_size4x4) / 16;
            this.cdef_index_.set(row, border_column, -1);
            this.cdef_index_.set(border_row, column, -1);
            this.cdef_index_.set(border_row, border_column, -1);
        }
    }

    void ClearBlockDecoded(D.TileScratchBuffer scratch_buffer, int row4x4, int column4x4) {
        for (int i = 0; i < 3; ++i) {
            int len = 34;
            for (int j = 0; j < len; ++j) {
                scratch_buffer.block_decoded[i][j] = false;
            }
        }
        int sb_size4 = this.sequence_header_.use_128x128_superblock ? 32 : 16;
        for (int plane = 0; plane < this.PlaneCount(); ++plane) {
            int subsampling_x = this.subsampling_x_[plane];
            int subsampling_y = this.subsampling_y_[plane];
            int sb_width4 = this.column4x4_end_ - column4x4 >> subsampling_x;
            int sb_height4 = this.row4x4_end_ - row4x4 >> subsampling_y;
            int num_elements = Math.min((sb_size4 >> this.subsampling_x_[plane]) + 1, sb_width4) + 1;
            Mem.set(scratch_buffer.block_decoded[plane], true, num_elements);
            for (int y = -1; y < Math.min(sb_size4 >> subsampling_y, sb_height4); ++y) {
                scratch_buffer.block_decoded[plane][(y + 1) * 34 + 0] = true;
            }
        }
    }

    boolean ProcessSuperBlock(int row4x4, int column4x4, D.TileScratchBuffer scratch_buffer, int mode) {
        boolean decoding;
        boolean parsing = mode == 0 || mode == 2;
        boolean bl = decoding = mode == 1 || mode == 2;
        if (parsing) {
            this.read_deltas_ = this.frame_header_.delta_q.present;
            this.ResetCdef(row4x4, column4x4);
        }
        if (decoding) {
            this.ClearBlockDecoded(scratch_buffer, row4x4, column4x4);
        }
        int block_size = this.SuperBlockSize();
        if (parsing) {
            this.ReadLoopRestorationCoefficients(row4x4, column4x4, block_size);
        }
        if (parsing && decoding) {
            if (!this.ProcessPartition(row4x4, column4x4, scratch_buffer, this.residual_buffer_, this.residual_bufferPos_)) {
                LogWriter.writeLog("process block error 1");
                return false;
            }
            return true;
        }
        int sb_row_index = this.SuperBlockRowIndex(row4x4);
        int sb_column_index = this.SuperBlockColumnIndex(column4x4);
        if (parsing) {
            int residual_bufferPos;
            this.residual_buffer_threaded_[sb_row_index][sb_column_index] = this.residual_buffer_pool_.get();
            if (this.residual_buffer_threaded_[sb_row_index][sb_column_index] == null) {
                LogWriter.writeLog("process block error 2");
                return false;
            }
            int[] residual_buffer = this.residual_buffer_threaded_[sb_row_index][sb_column_index].buffer();
            if (!this.ProcessPartition(row4x4, column4x4, scratch_buffer, residual_buffer, residual_bufferPos = 0)) {
                LogWriter.writeLog("process block error 3");
                return false;
            }
        } else {
            if (!this.DecodeSuperBlock(sb_row_index, sb_column_index, scratch_buffer)) {
                LogWriter.writeLog("process block error 4");
                return false;
            }
            this.residual_buffer_threaded_[sb_row_index][sb_column_index] = null;
        }
        return true;
    }

    boolean DecodeSuperBlock(int sb_row_index, int sb_column_index, D.TileScratchBuffer scratch_buffer) {
        LogWriter.writeLog("Decodesuperblock with scratch buffer is called");
        int[] residual_buffer = this.residual_buffer_threaded_[sb_row_index][sb_column_index].buffer();
        int residual_bufferPos = 0;
        D.QueuePartitionTreeNode partition_tree_order = this.residual_buffer_threaded_[sb_row_index][sb_column_index].partition_tree_order();
        while (!partition_tree_order.Empty()) {
            D.PartitionTreeNode block = partition_tree_order.Front();
            if (!this.DecodeBlock(block.row4x4, block.column4x4, block.block_size, scratch_buffer, residual_buffer, residual_bufferPos)) {
                LogWriter.writeLog("Decode Superblock Error");
                return false;
            }
            partition_tree_order.Pop();
        }
        return true;
    }

    void ReadLoopRestorationCoefficients(int row4x4, int column4x4, int block_size) {
        if (this.frame_header_.allow_intrabc) {
            return;
        }
        D.LoopRestorationInfo restoration_info = this.post_filter_.restoration_info();
        boolean is_superres_scaled = this.frame_header_.width != this.frame_header_.upscaled_width;
        for (int plane = 0; plane < this.PlaneCount(); ++plane) {
            D.LoopRestorationUnitInfo unit_info = new D.LoopRestorationUnitInfo();
            if (!restoration_info.PopulateUnitInfoForSuperBlock(plane, block_size, is_superres_scaled, this.frame_header_.superres_scale_denominator, row4x4, column4x4, unit_info)) continue;
            for (int unit_row = unit_info.row_start; unit_row < unit_info.row_end; ++unit_row) {
                for (int unit_column = unit_info.column_start; unit_column < unit_info.column_end; ++unit_column) {
                    int unit_id = unit_row * restoration_info.num_horizontal_units(plane) + unit_column;
                    restoration_info.ReadUnitCoefficients(this.reader_, this.symbol_decoder_context_, plane, unit_id, this.reference_unit_info_);
                }
            }
        }
    }

    void StoreMotionFieldMvsIntoCurrentFrame(Block block) {
        if (this.frame_header_.refresh_frame_flags == 0 || D.IsIntraFrame(this.frame_header_.frame_type)) {
            return;
        }
        int row_start4x4 = block.row4x4 | 1;
        int row_limit4x4 = Math.min(block.row4x4 + block.height4x4, this.frame_header_.rows4x4);
        if (row_start4x4 >= row_limit4x4) {
            return;
        }
        int column_start4x4 = block.column4x4 | 1;
        int column_limit4x4 = Math.min(block.column4x4 + block.width4x4, this.frame_header_.columns4x4);
        if (column_start4x4 >= column_limit4x4) {
            return;
        }
        int kRefMvsLimit = 4095;
        D.BlockParameters bp = block.bp;
        D.ReferenceInfo reference_info = this.current_frame_.reference_info();
    }

    static boolean IsBackwardReference(int type) {
        return type >= 5 && type <= 7;
    }

    static boolean IsSameDirectionReferencePair(int type1, int type2) {
        return type1 >= 5 == type2 >= 5;
    }

    static int DecodeSegmentId(int diff, int reference, int max) {
        if (reference == 0) {
            return diff;
        }
        if (reference >= max - 1) {
            return max - diff - 1;
        }
        int value = (diff & 1) != 0 ? reference + (diff + 1 >> 1) : reference - (diff >> 1);
        int reference2 = reference << 1;
        if (reference2 < max) {
            return diff <= reference2 ? value : diff;
        }
        return diff <= max - reference - 1 << 1 ? value : max - (diff + 1);
    }

    static int GetRefMvIndexContext(int nearest_mv_count, int index) {
        if (index + 1 < nearest_mv_count) {
            return 0;
        }
        if (index + 1 == nearest_mv_count) {
            return 1;
        }
        return 2;
    }

    static boolean IsBlockDimensionLessThan64(int size) {
        return size <= 14 && size != 11;
    }

    static int GetUseCompoundReferenceContext(Block block) {
        if (block.top_available[0] && block.left_available[0]) {
            if (block.IsTopSingle() && block.IsLeftSingle()) {
                return (Tile.IsBackwardReference(block.TopReference(0)) ? 1 : 0) ^ (Tile.IsBackwardReference(block.LeftReference(0)) ? 1 : 0);
            }
            if (block.IsTopSingle()) {
                return 2 + (Tile.IsBackwardReference(block.TopReference(0)) || block.IsTopIntra() ? 1 : 0);
            }
            if (block.IsLeftSingle()) {
                return 2 + (Tile.IsBackwardReference(block.LeftReference(0)) || block.IsLeftIntra() ? 1 : 0);
            }
            return 4;
        }
        if (block.top_available[0]) {
            return block.IsTopSingle() ? (Tile.IsBackwardReference(block.TopReference(0)) ? 1 : 0) : 3;
        }
        if (block.left_available[0]) {
            return block.IsLeftSingle() ? (Tile.IsBackwardReference(block.LeftReference(0)) ? 1 : 0) : 3;
        }
        return 1;
    }

    int GetReferenceContext(Block block, int type0_start, int type0_end, int type1_start, int type1_end) {
        int type;
        int count0 = 0;
        int count1 = 0;
        for (type = type0_start; type <= type0_end; ++type) {
            count0 += block.CountReferences(type);
        }
        for (type = type1_start; type <= type1_end; ++type) {
            count1 += block.CountReferences(type);
        }
        return count0 < count1 ? 0 : (count0 == count1 ? 1 : 2);
    }

    boolean ReadSegmentId(Block block) {
        D.SegmentationMap map = this.current_frame_.segmentation_map();
        int top_left = -1;
        if (block.top_available[0] && block.left_available[0]) {
            top_left = map.segment_id(block.row4x4 - 1, block.column4x4 - 1);
        }
        int top = -1;
        if (block.top_available[0]) {
            top = map.segment_id(block.row4x4 - 1, block.column4x4);
        }
        int left = -1;
        if (block.left_available[0]) {
            left = map.segment_id(block.row4x4, block.column4x4 - 1);
        }
        int pred = top == -1 ? (left == -1 ? 0 : left) : (left == -1 ? top : (top_left == top ? top : left));
        D.BlockParameters bp = block.bp;
        if (bp.skip) {
            bp.prediction_parameters.segment_id = pred;
            return true;
        }
        int context = 0;
        if (top_left < 0) {
            context = 0;
        } else if (top_left == top && top_left == left) {
            context = 2;
        } else if (top_left == top || top_left == left || top == left) {
            context = 1;
        }
        int[] segment_id_cdf = this.symbol_decoder_context_.segment_id_cdf[context];
        int encoded_segment_id = this.reader_.ReadSymbol(segment_id_cdf, 8);
        bp.prediction_parameters.segment_id = Tile.DecodeSegmentId(encoded_segment_id, pred, this.frame_header_.segmentation.last_active_segment_id + 1);
        if (bp.prediction_parameters.segment_id < 0 || bp.prediction_parameters.segment_id > this.frame_header_.segmentation.last_active_segment_id) {
            LogWriter.writeLog("Read Segment id error: corrupted ids");
            return false;
        }
        return true;
    }

    boolean ReadIntraSegmentId(Block block) {
        D.BlockParameters bp = block.bp;
        if (!this.frame_header_.segmentation.enabled) {
            bp.prediction_parameters.segment_id = 0;
            return true;
        }
        return this.ReadSegmentId(block);
    }

    void ReadSkip(Block block) {
        D.BlockParameters bp = block.bp;
        if (this.frame_header_.segmentation.segment_id_pre_skip && this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 6)) {
            bp.skip = true;
            return;
        }
        int context = 0;
        if (block.top_available[0] && block.bp_top.skip) {
            ++context;
        }
        if (block.left_available[0] && block.bp_left.skip) {
            ++context;
        }
        int[] skip_cdf = this.symbol_decoder_context_.skip_cdf[context];
        bp.skip = this.reader_.ReadSymbol(skip_cdf);
    }

    boolean ReadSkipMode(Block block) {
        LogWriter.writeLog("reading skip mode is called");
        D.BlockParameters bp = block.bp;
        if (!this.frame_header_.skip_mode_present || this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 6) || this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 5) || this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 7) || D.IsBlockDimension4(block.size)) {
            return false;
        }
        int context = (block.left_available[0] ? (this.left_context_.skip_mode[block.left_context_index] ? 1 : 0) : 0) + (block.top_available[0] ? (block.top_context.skip_mode[block.top_context_index] ? 1 : 0) : 0);
        return this.reader_.ReadSymbol(this.symbol_decoder_context_.skip_mode_cdf[context]);
    }

    void ReadCdef(Block block) {
        D.BlockParameters bp = block.bp;
        if (bp.skip || this.frame_header_.coded_lossless || !this.sequence_header_.enable_cdef || this.frame_header_.allow_intrabc || this.frame_header_.cdef.bits == 0) {
            return;
        }
        int[] cdef_index = this.cdef_index_.data_;
        int cdef_indexPos = block.row4x4 / 16 * this.cdef_index_.columns() + block.column4x4 / 16;
        int stride = this.cdef_index_.columns();
        if (cdef_index[cdef_indexPos + 0] == -1) {
            cdef_index[cdef_indexPos + 0] = (byte)this.reader_.ReadLiteral(this.frame_header_.cdef.bits);
            if (block.size == 21) {
                cdef_index[cdef_indexPos + 1] = cdef_index[cdef_indexPos + 0];
                cdef_index[cdef_indexPos + stride] = cdef_index[cdef_indexPos + 0];
                cdef_index[cdef_indexPos + stride + 1] = cdef_index[cdef_indexPos + 0];
            } else if (block.width4x4 > 16) {
                cdef_index[cdef_indexPos + 1] = cdef_index[cdef_indexPos + 0];
            } else if (block.height4x4 > 16) {
                cdef_index[cdef_indexPos + stride] = cdef_index[cdef_indexPos + 0];
            }
        }
    }

    int ReadAndClipDelta(int[] cdf, int delta_small, int scale, int min_value, int max_value, int value) {
        int abs = this.reader_.ReadSymbol(cdf, 4);
        if (abs == delta_small) {
            int remaining_bit_count = (int)this.reader_.ReadLiteral(3) + 1;
            int abs_remaining_bits = (int)this.reader_.ReadLiteral(remaining_bit_count);
            abs = abs_remaining_bits + (1 << remaining_bit_count) + 1;
        }
        if (abs != 0) {
            boolean sign = this.reader_.ReadBit() != 0;
            int scaled_abs = abs << scale;
            int reduced_delta = sign ? -scaled_abs : scaled_abs;
            value += reduced_delta;
            value = D.Clip3(value, min_value, max_value);
        }
        return value;
    }

    void ReadQuantizerIndexDelta(Block block) {
        D.BlockParameters bp = block.bp;
        if (block.size == this.SuperBlockSize() && bp.skip) {
            return;
        }
        this.current_quantizer_index_ = this.ReadAndClipDelta(this.symbol_decoder_context_.delta_q_cdf, 3, this.frame_header_.delta_q.scale, 1, 255, this.current_quantizer_index_);
    }

    void ReadLoopFilterDelta(Block block) {
        D.BlockParameters bp = block.bp;
        if (!this.frame_header_.delta_lf.present || block.size == this.SuperBlockSize() && bp.skip) {
            return;
        }
        int frame_lf_count = 1;
        if (this.frame_header_.delta_lf.multi) {
            frame_lf_count = 4 - (this.PlaneCount() > 1 ? 0 : 2);
        }
        boolean recompute_deblock_filter_levels = false;
        for (int i = 0; i < frame_lf_count; ++i) {
            int[] delta_lf_abs_cdf = this.frame_header_.delta_lf.multi ? this.symbol_decoder_context_.delta_lf_multi_cdf[i] : this.symbol_decoder_context_.delta_lf_cdf;
            int old_delta_lf = this.delta_lf_[i];
            this.delta_lf_[i] = this.ReadAndClipDelta(delta_lf_abs_cdf, 3, this.frame_header_.delta_lf.scale, -63, 63, this.delta_lf_[i]);
            recompute_deblock_filter_levels = recompute_deblock_filter_levels || old_delta_lf != this.delta_lf_[i];
        }
        boolean bl = this.delta_lf_all_zero_ = (this.delta_lf_[0] | this.delta_lf_[1] | this.delta_lf_[2] | this.delta_lf_[3]) == 0;
        if (!this.delta_lf_all_zero_ && recompute_deblock_filter_levels) {
            this.post_filter_.ComputeDeblockFilterLevels(this.delta_lf_, this.deblock_filter_levels_);
        }
    }

    void ReadPredictionModeY(Block block, boolean intra_y_mode) {
        int[] cdf;
        if (intra_y_mode) {
            int top_mode = block.top_available[0] ? block.bp_top.y_mode : 0;
            int left_mode = block.left_available[0] ? block.bp_left.y_mode : 0;
            int top_context = D.kIntraYModeContext[top_mode];
            int left_context = D.kIntraYModeContext[left_mode];
            cdf = this.symbol_decoder_context_.intra_frame_y_mode_cdf[top_context][left_context];
        } else {
            cdf = this.symbol_decoder_context_.y_mode_cdf[D.kSizeGroup[block.size]];
        }
        block.bp.y_mode = this.reader_.ReadSymbol(cdf, 13);
    }

    void ReadIntraAngleInfo(Block block, int plane_type) {
        int mode;
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.angle_delta[plane_type] = 0;
        int n = mode = plane_type == 0 ? bp.y_mode : bp.prediction_parameters.uv_mode;
        if (D.IsBlockSmallerThan8x8(block.size) || !D.IsDirectionalMode(mode)) {
            return;
        }
        int[] cdf = this.symbol_decoder_context_.angle_delta_cdf[mode - 1];
        prediction_parameters.angle_delta[plane_type] = this.reader_.ReadSymbol(cdf, 7);
        int n2 = plane_type;
        prediction_parameters.angle_delta[n2] = prediction_parameters.angle_delta[n2] - 3;
    }

    void ReadCflAlpha(Block block) {
        int signs = this.reader_.ReadSymbol(this.symbol_decoder_context_.cfl_alpha_signs_cdf, 8);
        int[] cfl_lookup = D.kCflAlphaLookup[signs];
        int sign_u = cfl_lookup[0];
        int sign_v = cfl_lookup[1];
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.cfl_alpha_u = 0;
        if (sign_u != 0) {
            prediction_parameters.cfl_alpha_u = this.reader_.ReadSymbol(this.symbol_decoder_context_.cfl_alpha_cdf[cfl_lookup[2]], 16) + 1;
            if (sign_u == 1) {
                prediction_parameters.cfl_alpha_u *= -1;
            }
        }
        prediction_parameters.cfl_alpha_v = 0;
        if (sign_v != 0) {
            prediction_parameters.cfl_alpha_v = this.reader_.ReadSymbol(this.symbol_decoder_context_.cfl_alpha_cdf[cfl_lookup[3]], 16) + 1;
            if (sign_v == 1) {
                prediction_parameters.cfl_alpha_v *= -1;
            }
        }
    }

    void ReadPredictionModeUV(Block block) {
        D.BlockParameters bp = block.bp;
        boolean chroma_from_luma_allowed = this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id] ? block.residual_size[1] == 0 : Tile.IsBlockDimensionLessThan64(block.size);
        int[] cdf = this.symbol_decoder_context_.uv_mode_cdf[chroma_from_luma_allowed ? 1 : 0][bp.y_mode];
        bp.prediction_parameters.uv_mode = chroma_from_luma_allowed ? this.reader_.ReadSymbol(cdf, 14) : this.reader_.ReadSymbol(cdf, 13);
    }

    int ReadMotionVectorComponent(Block block, int component) {
        int fraction;
        int[] precision_cdf;
        int[] fraction_cdf;
        int value;
        LogWriter.writeLog("This method should not be called in intra prediction");
        int context = block.bp.prediction_parameters.use_intra_block_copy ? 1 : 0;
        boolean sign = this.reader_.ReadSymbol(this.symbol_decoder_context_.mv_sign_cdf[component][context]);
        int mv_class = this.reader_.ReadSymbol(this.symbol_decoder_context_.mv_class_cdf[component][context], 11);
        int magnitude = 1;
        if (mv_class == 0) {
            value = this.reader_.ReadSymbol(this.symbol_decoder_context_.mv_class0_bit_cdf[component][context]) ? 1 : 0;
            fraction_cdf = this.symbol_decoder_context_.mv_class0_fraction_cdf[component][context][value];
            precision_cdf = this.symbol_decoder_context_.mv_class0_high_precision_cdf[component][context];
        } else {
            value = 0;
            for (int i = 0; i < mv_class; ++i) {
                int bit = this.reader_.ReadSymbol(this.symbol_decoder_context_.mv_bit_cdf[component][context][i]) ? 1 : 0;
                value |= bit << i;
            }
            magnitude += 2 << mv_class + 2;
            fraction_cdf = this.symbol_decoder_context_.mv_fraction_cdf[component][context];
            precision_cdf = this.symbol_decoder_context_.mv_high_precision_cdf[component][context];
        }
        int n = fraction = this.frame_header_.force_integer_mv == 0 ? this.reader_.ReadSymbol(fraction_cdf, 4) : 3;
        int precision = this.frame_header_.allow_high_precision_mv ? (this.reader_.ReadSymbol(precision_cdf) ? 1 : 0) : 1;
        return sign ? -magnitude : (magnitude += value << 3 | fraction << 1 | precision);
    }

    void ReadMotionVector(Block block, int index) {
        LogWriter.writeLog("This method should not be called in intra prediction");
        D.BlockParameters bp = block.bp;
        int context = block.bp.prediction_parameters.use_intra_block_copy ? 1 : 0;
        int mv_joint = this.reader_.ReadSymbol(this.symbol_decoder_context_.mv_joint_cdf[context], 4);
        if (mv_joint == 2 || mv_joint == 3) {
            bp.mv.mv[index].mv[0] = this.ReadMotionVectorComponent(block, 0);
        }
        if (mv_joint == 1 || mv_joint == 3) {
            bp.mv.mv[index].mv[1] = this.ReadMotionVectorComponent(block, 1);
        }
    }

    void ReadFilterIntraModeInfo(Block block) {
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.use_filter_intra = false;
        if (!this.sequence_header_.enable_filter_intra || bp.y_mode != 0 || bp.prediction_parameters.palette_mode_info.size[0] != 0 || !Tile.IsBlockDimensionLessThan64(block.size)) {
            return;
        }
        prediction_parameters.use_filter_intra = this.reader_.ReadSymbol(this.symbol_decoder_context_.use_filter_intra_cdf[block.size]);
        if (prediction_parameters.use_filter_intra) {
            prediction_parameters.filter_intra_mode = this.reader_.ReadSymbol(this.symbol_decoder_context_.filter_intra_mode_cdf, 5);
        }
    }

    boolean DecodeIntraModeInfo(Block block) {
        D.BlockParameters bp = block.bp;
        bp.skip = false;
        if (this.frame_header_.segmentation.segment_id_pre_skip && !this.ReadIntraSegmentId(block)) {
            LogWriter.writeLog("Tile: Error in DecodeIntraModeInfo");
            return false;
        }
        this.SetCdfContextSkipMode(block, false);
        this.ReadSkip(block);
        if (!this.frame_header_.segmentation.segment_id_pre_skip && !this.ReadIntraSegmentId(block)) {
            LogWriter.writeLog("Tile: Error in DecodeIntraModeInfo2");
            return false;
        }
        this.ReadCdef(block);
        if (this.read_deltas_) {
            this.ReadQuantizerIndexDelta(block);
            this.ReadLoopFilterDelta(block);
            this.read_deltas_ = false;
        }
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.use_intra_block_copy = false;
        if (this.frame_header_.allow_intrabc) {
            prediction_parameters.use_intra_block_copy = this.reader_.ReadSymbol(this.symbol_decoder_context_.intra_block_copy_cdf);
        }
        if (prediction_parameters.use_intra_block_copy) {
            bp.is_inter = true;
            bp.reference_frame[0] = 0;
            bp.reference_frame[1] = -1;
            bp.y_mode = 0;
            bp.prediction_parameters.uv_mode = 0;
            this.SetCdfContextUVMode(block);
            prediction_parameters.motion_mode = 0;
            prediction_parameters.compound_prediction_type = 2;
            bp.prediction_parameters.palette_mode_info.size[0] = 0;
            bp.prediction_parameters.palette_mode_info.size[1] = 0;
            this.SetCdfContextPaletteSize(block);
            bp.interpolation_filter[0] = 3;
            bp.interpolation_filter[1] = 3;
            D.MvContexts dummy_mode_contexts = new D.MvContexts();
            this.FindMvStack(block, false, dummy_mode_contexts);
            return this.AssignIntraMv(block);
        }
        bp.is_inter = false;
        return this.ReadIntraBlockModeInfo(block, true);
    }

    private void FindMvStack(Block block, boolean b, D.MvContexts dummyModeContexts) {
        LogWriter.writeLog("Tile : Find MV Stack not implmented");
    }

    int ComputePredictedSegmentId(Block block) {
        if (this.prev_segment_ids_ == null) {
            return 0;
        }
        int x_limit = Math.min(this.frame_header_.columns4x4 - block.column4x4, block.width4x4);
        int y_limit = Math.min(this.frame_header_.rows4x4 - block.row4x4, block.height4x4);
        int id = 7;
        for (int y = 0; y < y_limit; ++y) {
            for (int x = 0; x < x_limit; ++x) {
                int prev_segment_id = this.prev_segment_ids_.segment_id(block.row4x4 + y, block.column4x4 + x);
                id = Math.min(id, prev_segment_id);
            }
        }
        return id;
    }

    void SetCdfContextUsePredictedSegmentId(Block block, boolean use_predicted_segment_id) {
        Mem.set(this.left_context_.use_predicted_segment_id, block.left_context_index, use_predicted_segment_id, block.height4x4);
        Mem.set(block.top_context.use_predicted_segment_id, block.top_context_index, use_predicted_segment_id, block.width4x4);
    }

    boolean ReadInterSegmentId(Block block, boolean pre_skip) {
        LogWriter.writeLog("This method should not be called in intra prediction");
        D.BlockParameters bp = block.bp;
        if (!this.frame_header_.segmentation.enabled) {
            bp.prediction_parameters.segment_id = 0;
            return true;
        }
        if (!this.frame_header_.segmentation.update_map) {
            bp.prediction_parameters.segment_id = this.ComputePredictedSegmentId(block);
            return true;
        }
        if (pre_skip) {
            if (!this.frame_header_.segmentation.segment_id_pre_skip) {
                bp.prediction_parameters.segment_id = 0;
                return true;
            }
        } else if (bp.skip) {
            this.SetCdfContextUsePredictedSegmentId(block, false);
            return this.ReadSegmentId(block);
        }
        if (this.frame_header_.segmentation.temporal_update) {
            int context = (block.left_available[0] ? (this.left_context_.use_predicted_segment_id[block.left_context_index] ? 1 : 0) : 0) + (block.top_available[0] ? (block.top_context.use_predicted_segment_id[block.top_context_index] ? 1 : 0) : 0);
            boolean use_predicted_segment_id = this.reader_.ReadSymbol(this.symbol_decoder_context_.use_predicted_segment_id_cdf[context]);
            this.SetCdfContextUsePredictedSegmentId(block, use_predicted_segment_id);
            if (use_predicted_segment_id) {
                bp.prediction_parameters.segment_id = this.ComputePredictedSegmentId(block);
                return true;
            }
        }
        return this.ReadSegmentId(block);
    }

    void ReadIsInter(Block block, boolean skip_mode) {
        LogWriter.writeLog("Read Is inter is called");
        D.BlockParameters bp = block.bp;
        if (skip_mode) {
            bp.is_inter = true;
            return;
        }
        LogWriter.writeLog("Tile: Read Is Inter not supported");
        bp.is_inter = false;
    }

    void SetCdfContextPaletteSize(Block block) {
        D.PaletteModeInfo palette_mode_info = block.bp.prediction_parameters.palette_mode_info;
        for (int plane_type = 0; plane_type <= 1; ++plane_type) {
            int i;
            Mem.set(this.left_context_.palette_size[plane_type], block.left_context_index, palette_mode_info.size[plane_type], block.height4x4);
            Mem.set(block.top_context.palette_size[plane_type], block.top_context_index, palette_mode_info.size[plane_type], block.width4x4);
            if (palette_mode_info.size[plane_type] == 0) continue;
            for (i = block.left_context_index; i < block.left_context_index + block.height4x4; ++i) {
                Mem.cpy(this.left_context_.palette_color[i][plane_type], palette_mode_info.color[plane_type], 8);
            }
            for (i = block.top_context_index; i < block.top_context_index + block.width4x4; ++i) {
                Mem.cpy(block.top_context.palette_color[i][plane_type], palette_mode_info.color[plane_type], 8);
            }
        }
    }

    void SetCdfContextUVMode(Block block) {
        if (this.subsampling_x_[1] == 0 || (block.column4x4 & 1) == 1 || block.width4x4 > 1) {
            Mem.set(this.left_context_.uv_mode, block.left_context_index, block.bp.prediction_parameters.uv_mode, block.height4x4);
        }
        if (this.subsampling_y_[1] == 0 || (block.row4x4 & 1) == 1 || block.height4x4 > 1) {
            Mem.set(block.top_context.uv_mode, block.top_context_index, block.bp.prediction_parameters.uv_mode, block.width4x4);
        }
    }

    boolean ReadIntraBlockModeInfo(Block block, boolean intra_y_mode) {
        D.BlockParameters bp = block.bp;
        bp.reference_frame[0] = 0;
        bp.reference_frame[1] = -1;
        this.ReadPredictionModeY(block, intra_y_mode);
        this.ReadIntraAngleInfo(block, 0);
        if (block.HasChroma()) {
            int smooth_column;
            int smooth_row;
            this.ReadPredictionModeUV(block);
            if (bp.prediction_parameters.uv_mode == 13) {
                this.ReadCflAlpha(block);
            }
            if (block.left_available[1]) {
                smooth_row = block.row4x4 + (~block.row4x4 & this.subsampling_y_[1]);
                smooth_column = block.column4x4 - 1 - (block.column4x4 & this.subsampling_x_[1]);
                D.BlockParameters bp_left = this.block_parameters_holder_.Find(smooth_row, smooth_column);
                boolean bl = bp.prediction_parameters.chroma_left_uses_smooth_prediction = bp_left.reference_frame[0] <= 0 && D.kPredictionModeSmoothMask.Contains(this.left_context_.uv_mode[this.CdfContextIndex(smooth_row)]);
            }
            if (block.top_available[1]) {
                smooth_row = block.row4x4 - 1 - (block.row4x4 & this.subsampling_y_[1]);
                smooth_column = block.column4x4 + (~block.column4x4 & this.subsampling_x_[1]);
                D.BlockParameters bp_top = this.block_parameters_holder_.Find(smooth_row, smooth_column);
                bp.prediction_parameters.chroma_top_uses_smooth_prediction = bp_top.reference_frame[0] <= 0 && D.kPredictionModeSmoothMask.Contains(this.top_context_.get()[this.SuperBlockColumnIndex((int)smooth_column)].uv_mode[this.CdfContextIndex(smooth_column)]);
            }
            this.SetCdfContextUVMode(block);
            this.ReadIntraAngleInfo(block, 1);
        }
        this.ReadPaletteModeInfo(block);
        this.SetCdfContextPaletteSize(block);
        this.ReadFilterIntraModeInfo(block);
        return true;
    }

    int ReadCompoundReferenceType(Block block) {
        int context;
        boolean left_uni_comp;
        boolean top_comp_inter = block.top_available[0] && !block.IsTopIntra() && !block.IsTopSingle();
        boolean left_comp_inter = block.left_available[0] && !block.IsLeftIntra() && !block.IsLeftSingle();
        boolean top_uni_comp = top_comp_inter && Tile.IsSameDirectionReferencePair(block.TopReference(0), block.TopReference(1));
        boolean bl = left_uni_comp = left_comp_inter && Tile.IsSameDirectionReferencePair(block.LeftReference(0), block.LeftReference(1));
        if (block.top_available[0] && !block.IsTopIntra() && block.left_available[0] && !block.IsLeftIntra()) {
            int same_direction;
            int n = same_direction = Tile.IsSameDirectionReferencePair(block.TopReference(0), block.LeftReference(0)) ? 1 : 0;
            context = !top_comp_inter && !left_comp_inter ? 1 + same_direction * 2 : (!top_comp_inter ? (left_uni_comp ? 3 + same_direction : 1) : (!left_comp_inter ? (top_uni_comp ? 3 + same_direction : 1) : (!top_uni_comp && !left_uni_comp ? 0 : (!top_uni_comp || !left_uni_comp ? 2 : 3 + (block.TopReference(0) == 5 == (block.LeftReference(0) == 5) ? 1 : 0)))));
        } else {
            context = block.top_available[0] && block.left_available[0] ? (top_comp_inter ? 1 + (top_uni_comp ? 1 : 0) * 2 : (left_comp_inter ? 1 + (left_uni_comp ? 1 : 0) * 2 : 2)) : (top_comp_inter ? (top_uni_comp ? 1 : 0) * 4 : (left_comp_inter ? (left_uni_comp ? 1 : 0) * 4 : 2));
        }
        return this.reader_.ReadSymbol(this.symbol_decoder_context_.compound_reference_type_cdf[context]) ? 1 : 0;
    }

    int[] GetReferenceCdf(Block block, int type, boolean is_single, boolean is_backward, int index) {
        int context = 0;
        if (type == 0 && index == 0 || is_single && index == 1) {
            context = this.GetReferenceContext(block, 1, 4, 5, 7);
        } else if (type == 0 && index == 1) {
            context = this.GetReferenceContext(block, 2, 2, 3, 4);
        } else if (type == 0 && index == 2 || type == 1 && index == 2 || is_single && index == 5) {
            context = this.GetReferenceContext(block, 3, 3, 4, 4);
        } else if (type == 1 && index == 0 || is_single && index == 3) {
            context = this.GetReferenceContext(block, 1, 2, 3, 4);
        } else if (type == 1 && index == 1 || is_single && index == 4) {
            context = this.GetReferenceContext(block, 1, 1, 2, 2);
        } else if (is_single && index == 2 || is_backward && index == 0) {
            context = this.GetReferenceContext(block, 5, 6, 7, 7);
        } else if (is_single && index == 6 || is_backward && index == 1) {
            context = this.GetReferenceContext(block, 5, 5, 6, 6);
        }
        if (is_single) {
            return this.symbol_decoder_context_.single_reference_cdf[context][index - 1];
        }
        if (is_backward) {
            return this.symbol_decoder_context_.compound_backward_reference_cdf[context][index];
        }
        return this.symbol_decoder_context_.compound_reference_cdf[type][context][index];
    }

    void ReadReferenceFrames(Block block, boolean skip_mode) {
        boolean use_compound_reference;
        D.BlockParameters bp = block.bp;
        if (skip_mode) {
            bp.reference_frame[0] = this.frame_header_.skip_mode_frame[0];
            bp.reference_frame[1] = this.frame_header_.skip_mode_frame[1];
            return;
        }
        if (this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 5)) {
            bp.reference_frame[0] = this.frame_header_.segmentation.feature_data[bp.prediction_parameters.segment_id][5];
            bp.reference_frame[1] = -1;
            return;
        }
        if (this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 6) || this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 7)) {
            bp.reference_frame[0] = 1;
            bp.reference_frame[1] = -1;
            return;
        }
        boolean bl = use_compound_reference = this.frame_header_.reference_mode_select && Math.min(block.width4x4, block.height4x4) >= 2 && this.reader_.ReadSymbol(this.symbol_decoder_context_.use_compound_reference_cdf[Tile.GetUseCompoundReferenceContext(block)]);
        if (use_compound_reference) {
            int reference_type = this.ReadCompoundReferenceType(block);
            if (reference_type == 0) {
                if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 0))) {
                    bp.reference_frame[0] = 5;
                    bp.reference_frame[1] = 7;
                    return;
                }
                if (!this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 1))) {
                    bp.reference_frame[0] = 1;
                    bp.reference_frame[1] = 2;
                    return;
                }
                if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 2))) {
                    bp.reference_frame[0] = 1;
                    bp.reference_frame[1] = 4;
                    return;
                }
                bp.reference_frame[0] = 1;
                bp.reference_frame[1] = 3;
                return;
            }
            if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 0))) {
                bp.reference_frame[0] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 2)) ? 4 : 3;
            } else {
                int n = bp.reference_frame[0] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, reference_type, false, false, 1)) ? 2 : 1;
            }
            bp.reference_frame[1] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, false, true, 0)) ? 7 : (this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, false, true, 1)) ? 6 : 5);
            return;
        }
        bp.reference_frame[1] = -1;
        if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 1))) {
            if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 2))) {
                bp.reference_frame[0] = 7;
                return;
            }
            bp.reference_frame[0] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 6)) ? 6 : 5;
            return;
        }
        if (this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 3))) {
            bp.reference_frame[0] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 5)) ? 4 : 3;
            return;
        }
        bp.reference_frame[0] = this.reader_.ReadSymbol(this.GetReferenceCdf(block, 2, true, false, 4)) ? 2 : 1;
    }

    void ReadInterPredictionModeY(Block block, D.MvContexts mode_contexts, boolean skip_mode) {
        LogWriter.writeLog("ReadInterPredictionModeY not to be called");
        D.BlockParameters bp = block.bp;
        if (skip_mode) {
            bp.y_mode = 18;
            return;
        }
        if (this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 6) || this.frame_header_.segmentation.FeatureActive(bp.prediction_parameters.segment_id, 7)) {
            bp.y_mode = 16;
            return;
        }
        if (bp.reference_frame[1] > 0) {
            int idx0 = mode_contexts.reference_mv >> 1;
            int idx1 = Math.min(mode_contexts.new_mv, 4);
            int context = D.kCompoundModeContextMap[idx0][idx1];
            int offset = this.reader_.ReadSymbol(this.symbol_decoder_context_.compound_prediction_mode_cdf[context], 8);
            bp.y_mode = 18 + offset;
            return;
        }
        if (!this.reader_.ReadSymbol(this.symbol_decoder_context_.new_mv_cdf[mode_contexts.new_mv])) {
            bp.y_mode = 17;
            return;
        }
        if (!this.reader_.ReadSymbol(this.symbol_decoder_context_.zero_mv_cdf[mode_contexts.zero_mv])) {
            bp.y_mode = 16;
            return;
        }
        bp.y_mode = this.reader_.ReadSymbol(this.symbol_decoder_context_.reference_mv_cdf[mode_contexts.reference_mv]) ? 15 : 14;
    }

    void ReadRefMvIndex(Block block) {
        int start;
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.ref_mv_index = 0;
        if (bp.y_mode != 17 && bp.y_mode != 25 && !D.kPredictionModeHasNearMvMask.Contains(bp.y_mode)) {
            return;
        }
        prediction_parameters.ref_mv_index = start = D.kPredictionModeHasNearMvMask.Contains(bp.y_mode) ? 1 : 0;
        for (int i = start; i < start + 2 && prediction_parameters.ref_mv_count > i + 1; ++i) {
            boolean ref_mv_index_bit = this.reader_.ReadSymbol(this.symbol_decoder_context_.ref_mv_index_cdf[Tile.GetRefMvIndexContext(prediction_parameters.nearest_mv_count, i)]);
            prediction_parameters.ref_mv_index = i + (ref_mv_index_bit ? 1 : 0);
            if (ref_mv_index_bit) continue;
            return;
        }
    }

    void ReadInterIntraMode(Block block, boolean is_compound, boolean skip_mode) {
        LogWriter.writeLog("ReadInterIntraMode not to be called");
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        prediction_parameters.inter_intra_mode = 4;
        prediction_parameters.is_wedge_inter_intra = false;
        if (skip_mode || !this.sequence_header_.enable_interintra_compound || is_compound || !D.kIsInterIntraModeAllowedMask.Contains(block.size)) {
            return;
        }
        if (!this.reader_.ReadSymbol(this.symbol_decoder_context_.is_inter_intra_cdf[D.kSizeGroup[block.size] - 1])) {
            prediction_parameters.inter_intra_mode = 4;
            return;
        }
        prediction_parameters.inter_intra_mode = this.reader_.ReadSymbol(this.symbol_decoder_context_.inter_intra_mode_cdf[D.kSizeGroup[block.size] - 1], 4);
        bp.reference_frame[1] = 0;
        prediction_parameters.angle_delta[0] = 0;
        prediction_parameters.angle_delta[1] = 0;
        prediction_parameters.use_filter_intra = false;
        prediction_parameters.is_wedge_inter_intra = this.reader_.ReadSymbol(this.symbol_decoder_context_.is_wedge_inter_intra_cdf[block.size]);
        if (!prediction_parameters.is_wedge_inter_intra) {
            return;
        }
        prediction_parameters.wedge_index = this.reader_.ReadSymbol(this.symbol_decoder_context_.wedge_index_cdf[block.size], 16);
        prediction_parameters.wedge_sign = 0;
    }

    void ReadMotionMode(Block block, boolean is_compound, boolean skip_mode) {
        LogWriter.writeLog("ReadMotionMode not to be called");
        D.BlockParameters bp = block.bp;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        int global_motion_type = this.frame_header_.global_motion[bp.reference_frame[0]].type;
        if (skip_mode || !this.frame_header_.is_motion_mode_switchable || D.IsBlockDimension4(block.size) || this.frame_header_.force_integer_mv == 0 && (bp.y_mode == 16 || bp.y_mode == 24) && global_motion_type > 1 || is_compound || bp.reference_frame[1] == 0 || !block.HasOverlappableCandidates()) {
            prediction_parameters.motion_mode = 0;
            return;
        }
        prediction_parameters.num_warp_samples = 0;
        int num_samples_scanned = 0;
        for (int i = 0; i < prediction_parameters.warp_estimate_candidates.length; ++i) {
            for (int j = 0; j < prediction_parameters.warp_estimate_candidates[0].length; ++j) {
                prediction_parameters.warp_estimate_candidates[i][j] = 0;
            }
        }
        this.FindWarpSamples(block, prediction_parameters.num_warp_samples, num_samples_scanned, prediction_parameters.warp_estimate_candidates);
        if (this.frame_header_.force_integer_mv != 0 || prediction_parameters.num_warp_samples == 0 || !this.frame_header_.allow_warped_motion || this.IsScaled(bp.reference_frame[0])) {
            prediction_parameters.motion_mode = this.reader_.ReadSymbol(this.symbol_decoder_context_.use_obmc_cdf[block.size]) ? 1 : 0;
            return;
        }
        prediction_parameters.motion_mode = this.reader_.ReadSymbol(this.symbol_decoder_context_.motion_mode_cdf[block.size], 3);
    }

    private boolean IsScaled(int type) {
        int index = this.frame_header_.reference_frame_index[type - 1];
        return this.reference_frames_[index].upscaled_width() != this.frame_header_.width || this.reference_frames_[index].frame_height() != this.frame_header_.height;
    }

    private void FindWarpSamples(Block block, int numWarpSamples, int numSamplesScanned, int[][] warpEstimateCandidates) {
        LogWriter.writeLog("Find Warp Samples not implemented");
    }

    int[] GetIsExplicitCompoundTypeCdf(Block block) {
        int context = 0;
        if (block.top_available[0]) {
            if (!block.IsTopSingle()) {
                context += block.top_context.is_explicit_compound_type[block.top_context_index] ? 1 : 0;
            } else if (block.TopReference(0) == 7) {
                context += 3;
            }
        }
        if (block.left_available[0]) {
            if (!block.IsLeftSingle()) {
                context += this.left_context_.is_explicit_compound_type[block.left_context_index] ? 1 : 0;
            } else if (block.LeftReference(0) == 7) {
                context += 3;
            }
        }
        return this.symbol_decoder_context_.is_explicit_compound_type_cdf[Math.min(context, 5)];
    }

    int[] GetIsCompoundTypeAverageCdf(Block block) {
        int backward;
        int context;
        D.BlockParameters bp = block.bp;
        D.ReferenceInfo reference_info = this.current_frame_.reference_info();
        int forward = Math.abs(reference_info.relative_distance_from[bp.reference_frame[0]]);
        int n = context = forward == (backward = Math.abs(reference_info.relative_distance_from[bp.reference_frame[1]])) ? 3 : 0;
        if (block.top_available[0]) {
            if (!block.IsTopSingle()) {
                context += block.top_context.is_compound_type_average[block.top_context_index] ? 1 : 0;
            } else if (block.TopReference(0) == 7) {
                ++context;
            }
        }
        if (block.left_available[0]) {
            if (!block.IsLeftSingle()) {
                context += this.left_context_.is_compound_type_average[block.left_context_index] ? 1 : 0;
            } else if (block.LeftReference(0) == 7) {
                ++context;
            }
        }
        return this.symbol_decoder_context_.is_compound_type_average_cdf[context];
    }

    void ReadCompoundType(Block block, boolean is_compound, boolean skip_mode, boolean[] is_explicit_compound_type, boolean[] is_compound_type_average) {
        is_explicit_compound_type[0] = false;
        is_compound_type_average[0] = true;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        if (skip_mode) {
            prediction_parameters.compound_prediction_type = 2;
            return;
        }
        if (is_compound) {
            if (this.sequence_header_.enable_masked_compound) {
                is_explicit_compound_type[0] = this.reader_.ReadSymbol(this.GetIsExplicitCompoundTypeCdf(block));
            }
            if (is_explicit_compound_type[0]) {
                prediction_parameters.compound_prediction_type = D.kIsWedgeCompoundModeAllowed.Contains(block.size) ? (this.reader_.ReadSymbol(this.symbol_decoder_context_.compound_type_cdf[block.size]) ? 1 : 0) : 1;
            } else if (this.sequence_header_.enable_jnt_comp) {
                is_compound_type_average[0] = this.reader_.ReadSymbol(this.GetIsCompoundTypeAverageCdf(block));
                prediction_parameters.compound_prediction_type = is_compound_type_average[0] ? 2 : 4;
            } else {
                prediction_parameters.compound_prediction_type = 2;
                return;
            }
            if (prediction_parameters.compound_prediction_type == 0) {
                prediction_parameters.wedge_index = this.reader_.ReadSymbol(this.symbol_decoder_context_.wedge_index_cdf[block.size], 16);
                prediction_parameters.wedge_sign = this.reader_.ReadBit();
            } else if (prediction_parameters.compound_prediction_type == 1) {
                prediction_parameters.mask_is_inverse = this.reader_.ReadBit() != 0;
            }
            return;
        }
        if (prediction_parameters.inter_intra_mode != 4) {
            prediction_parameters.compound_prediction_type = prediction_parameters.is_wedge_inter_intra ? 0 : 3;
            return;
        }
        prediction_parameters.compound_prediction_type = 2;
    }

    int[] GetInterpolationFilterCdf(Block block, int direction) {
        D.BlockParameters bp = block.bp;
        int context = direction * 8 + (bp.reference_frame[1] > 0 ? 1 : 0) * 4;
        int top_type = 3;
        if (block.top_available[0] && (block.bp_top.reference_frame[0] == bp.reference_frame[0] || block.bp_top.reference_frame[1] == bp.reference_frame[0])) {
            top_type = block.bp_top.interpolation_filter[direction];
        }
        int left_type = 3;
        if (block.left_available[0] && (block.bp_left.reference_frame[0] == bp.reference_frame[0] || block.bp_left.reference_frame[1] == bp.reference_frame[0])) {
            left_type = block.bp_left.interpolation_filter[direction];
        }
        context = left_type == top_type ? (context += left_type) : (left_type == 3 ? (context += top_type) : (top_type == 3 ? (context += left_type) : (context += 3)));
        return this.symbol_decoder_context_.interpolation_filter_cdf[context];
    }

    void ReadInterpolationFilter(Block block, boolean skip_mode) {
        D.BlockParameters bp = block.bp;
        if (this.frame_header_.interpolation_filter != 4) {
            for (int i = 0; i < bp.interpolation_filter.length; ++i) {
                bp.interpolation_filter[i] = this.frame_header_.interpolation_filter;
            }
            return;
        }
        boolean interpolation_filter_present = true;
        if (skip_mode || block.bp.prediction_parameters.motion_mode == 2) {
            interpolation_filter_present = false;
        } else if (!D.IsBlockDimension4(block.size) && bp.y_mode == 16) {
            interpolation_filter_present = this.frame_header_.global_motion[bp.reference_frame[0]].type == 1;
        } else if (!D.IsBlockDimension4(block.size) && bp.y_mode == 24) {
            interpolation_filter_present = this.frame_header_.global_motion[bp.reference_frame[0]].type == 1 || this.frame_header_.global_motion[bp.reference_frame[1]].type == 1;
        }
        for (int i = 0; i < (this.sequence_header_.enable_dual_filter ? 2 : 1); ++i) {
            bp.interpolation_filter[i] = interpolation_filter_present ? this.reader_.ReadSymbol(this.GetInterpolationFilterCdf(block, i), 3) : 0;
        }
        if (!this.sequence_header_.enable_dual_filter) {
            bp.interpolation_filter[1] = bp.interpolation_filter[0];
        }
    }

    void SetCdfContextCompoundType(Block block, boolean is_explicit_compound_type, boolean is_compound_type_average) {
        Mem.set(this.left_context_.is_explicit_compound_type, block.left_context_index, is_explicit_compound_type, block.height4x4);
        Mem.set(this.left_context_.is_compound_type_average, block.left_context_index, is_compound_type_average, block.height4x4);
        Mem.set(block.top_context.is_explicit_compound_type, block.top_context_index, is_explicit_compound_type, block.width4x4);
        Mem.set(block.top_context.is_compound_type_average, block.top_context_index, is_compound_type_average, block.width4x4);
    }

    boolean ReadInterBlockModeInfo(Block block, boolean skip_mode) {
        D.BlockParameters bp = block.bp;
        bp.prediction_parameters.palette_mode_info.size[0] = 0;
        bp.prediction_parameters.palette_mode_info.size[1] = 0;
        this.SetCdfContextPaletteSize(block);
        this.ReadReferenceFrames(block, skip_mode);
        boolean is_compound = bp.reference_frame[1] > 0;
        D.MvContexts mode_contexts = new D.MvContexts();
        this.FindMvStack(block, is_compound, mode_contexts);
        this.ReadInterPredictionModeY(block, mode_contexts, skip_mode);
        this.ReadRefMvIndex(block);
        if (!this.AssignInterMv(block, is_compound)) {
            return false;
        }
        this.ReadInterIntraMode(block, is_compound, skip_mode);
        this.ReadMotionMode(block, is_compound, skip_mode);
        boolean[] is_explicit_compound_type = new boolean[]{false};
        boolean[] is_compound_type_average = new boolean[]{false};
        this.ReadCompoundType(block, is_compound, skip_mode, is_explicit_compound_type, is_compound_type_average);
        this.SetCdfContextCompoundType(block, is_explicit_compound_type[0], is_compound_type_average[0]);
        this.ReadInterpolationFilter(block, skip_mode);
        return true;
    }

    void SetCdfContextSkipMode(Block block, boolean skip_mode) {
        Mem.set(this.left_context_.skip_mode, block.left_context_index, skip_mode, block.height4x4);
        Mem.set(block.top_context.skip_mode, block.top_context_index, skip_mode, block.width4x4);
    }

    boolean DecodeInterModeInfo(Block block) {
        D.BlockParameters bp = block.bp;
        block.bp.prediction_parameters.use_intra_block_copy = false;
        bp.skip = false;
        if (!this.ReadInterSegmentId(block, true)) {
            return false;
        }
        boolean skip_mode = this.ReadSkipMode(block);
        this.SetCdfContextSkipMode(block, skip_mode);
        if (skip_mode) {
            bp.skip = true;
        } else {
            this.ReadSkip(block);
        }
        if (!this.frame_header_.segmentation.segment_id_pre_skip && !this.ReadInterSegmentId(block, false)) {
            return false;
        }
        this.ReadCdef(block);
        if (this.read_deltas_) {
            this.ReadQuantizerIndexDelta(block);
            this.ReadLoopFilterDelta(block);
            this.read_deltas_ = false;
        }
        this.ReadIsInter(block, skip_mode);
        return bp.is_inter ? this.ReadInterBlockModeInfo(block, skip_mode) : this.ReadIntraBlockModeInfo(block, false);
    }

    boolean DecodeModeInfo(Block block) {
        return D.IsIntraFrame(this.frame_header_.frame_type) ? this.DecodeIntraModeInfo(block) : this.DecodeInterModeInfo(block);
    }

    static void merge(int[] f1, int f1Len, int[] f2, int f2Len, int[] dest) {
        int f1Pos = 0;
        int f2Pos = 0;
        int dPos = 0;
        while (f1Pos != f1Len) {
            if (f2Pos == f2Len) {
                int len = f1Len - f1Pos;
                System.arraycopy(f1, f1Pos, dest, dPos, len);
                return;
            }
            if (f2[f2Pos] < f1[f1Pos]) {
                dest[dPos] = f2[f2Pos];
                ++f2Pos;
            } else {
                dest[dPos] = f1[f1Pos];
                ++f1Pos;
            }
            ++dPos;
        }
        int len = f2Len - f2Pos;
        System.arraycopy(f2, f2Pos, dest, dPos, len);
    }

    int GetPaletteCache(Block block, int plane_type, int[] cache) {
        int left_size;
        int top_size = block.top_available[0] && block.row4x4 * 4 % 64 != 0 ? block.top_context.palette_size[plane_type][block.top_context_index] : 0;
        int n = left_size = block.left_available[0] ? this.left_context_.palette_size[plane_type][block.left_context_index] : 0;
        if (left_size == 0 && top_size == 0) {
            return 0;
        }
        int[] empty_palette = new int[]{0};
        int[] top = top_size > 0 ? block.top_context.palette_color[block.top_context_index][plane_type] : empty_palette;
        int[] left = left_size > 0 ? this.left_context_.palette_color[block.left_context_index][plane_type] : empty_palette;
        int[] tempCache = new int[top_size + left_size];
        Tile.merge(top, top_size, left, left_size, tempCache);
        int[] dists = Arrays.stream(tempCache).distinct().toArray();
        for (int i = 0; i < dists.length; ++i) {
            cache[i] = dists[i];
        }
        return dists.length;
    }

    void ReadPaletteColors(Block block, int plane) {
        block12: {
            int i;
            LogWriter.writeLog("reading palette colors");
            int plane_type = D.GetPlaneType(plane);
            int[] cache = new int[16];
            int n = this.GetPaletteCache(block, plane_type, cache);
            D.BlockParameters bp = block.bp;
            int palette_size = bp.prediction_parameters.palette_mode_info.size[plane_type];
            int[] palette_color = bp.prediction_parameters.palette_mode_info.color[plane];
            int bitdepth = this.sequence_header_.color_config.bitdepth;
            int index = 0;
            for (int i2 = 0; i2 < n && index < palette_size; ++i2) {
                if (this.reader_.ReadBit() == 0) continue;
                palette_color[index++] = cache[i2];
            }
            int merge_pivot = index;
            if (index < palette_size) {
                palette_color[index++] = (int)this.reader_.ReadLiteral(bitdepth);
            }
            int max_value = (1 << bitdepth) - 1;
            if (index < palette_size) {
                int bits = bitdepth - 3 + (int)this.reader_.ReadLiteral(2);
                do {
                    int delta = (int)(this.reader_.ReadLiteral(bits) + (long)(plane_type == 0 ? 1 : 0));
                    palette_color[index] = Math.min(palette_color[index - 1] + delta, max_value);
                    if (palette_color[index] + (plane_type == 0 ? 1 : 0) >= max_value) {
                        Mem.set(palette_color, index + 1, max_value, palette_size - index - 1);
                        break;
                    }
                    int range = (1 << bitdepth) - palette_color[index] - (plane_type == 0 ? 1 : 0);
                    bits = Math.min(bits, D.CeilLog2(range));
                } while (++index < palette_size);
            }
            int[] temp = new int[palette_size];
            for (i = 0; i < palette_size; ++i) {
                temp[i] = palette_color[i];
            }
            Arrays.sort(temp);
            for (i = 0; i < palette_size; ++i) {
                palette_color[i] = temp[i];
            }
            if (plane_type != 1) break block12;
            int[] palette_color_v = bp.prediction_parameters.palette_mode_info.color[2];
            if (this.reader_.ReadBit() != 0) {
                int bits = bitdepth - 4 + (int)this.reader_.ReadLiteral(2);
                palette_color_v[0] = (int)this.reader_.ReadLiteral(bitdepth);
                for (int i3 = 1; i3 < palette_size; ++i3) {
                    int delta = (int)this.reader_.ReadLiteral(bits);
                    if (delta != 0 && this.reader_.ReadBit() != 0) {
                        delta = -delta;
                    }
                    palette_color_v[i3] = palette_color_v[i3 - 1] + delta & max_value;
                }
            } else {
                for (int i4 = 0; i4 < palette_size; ++i4) {
                    palette_color_v[i4] = (int)this.reader_.ReadLiteral(bitdepth);
                }
            }
        }
    }

    void ReadPaletteModeInfo(Block block) {
        boolean has_palette_uv;
        int context;
        boolean has_palette_y;
        D.BlockParameters bp = block.bp;
        bp.prediction_parameters.palette_mode_info.size[0] = 0;
        bp.prediction_parameters.palette_mode_info.size[1] = 0;
        if (D.IsBlockSmallerThan8x8(block.size) || block.size > 18 || !this.frame_header_.allow_screen_content_tools) {
            return;
        }
        int block_size_context = D.k4x4WidthLog2[block.size] + D.k4x4HeightLog2[block.size] - 2;
        if (bp.y_mode == 0 && (has_palette_y = this.reader_.ReadSymbol(this.symbol_decoder_context_.has_palette_y_cdf[block_size_context][context = (block.top_available[0] && block.top_context.palette_size[0][block.top_context_index] > 0 ? 1 : 0) + (block.left_available[0] && this.left_context_.palette_size[0][block.left_context_index] > 0 ? 1 : 0)]))) {
            bp.prediction_parameters.palette_mode_info.size[0] = 2 + this.reader_.ReadSymbol(this.symbol_decoder_context_.palette_y_size_cdf[block_size_context], 7);
            this.ReadPaletteColors(block, 0);
        }
        if (block.HasChroma() && bp.prediction_parameters.uv_mode == 0 && (has_palette_uv = this.reader_.ReadSymbol(this.symbol_decoder_context_.has_palette_uv_cdf[context = bp.prediction_parameters.palette_mode_info.size[0] > 0 ? 1 : 0]))) {
            bp.prediction_parameters.palette_mode_info.size[1] = 2 + this.reader_.ReadSymbol(this.symbol_decoder_context_.palette_uv_size_cdf[block_size_context], 7);
            this.ReadPaletteColors(block, 1);
        }
    }

    void PopulatePaletteColorContexts(Block block, int plane_type, int i, int start, int end, int[][] color_order, int[] color_context) {
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        int column = start;
        int counter = 0;
        while (column >= end) {
            int index_mask;
            int left;
            int row = i - column;
            int top = row > 0 ? prediction_parameters.color_index_map[plane_type][row - 1][column] : 0;
            int n = left = column > 0 ? prediction_parameters.color_index_map[plane_type][row][column - 1] : 0;
            if (column <= 0) {
                color_context[counter] = 0;
                color_order[counter][0] = top;
                index_mask = 1 << top;
                index = 1;
            } else if (row <= 0) {
                color_context[counter] = 0;
                color_order[counter][0] = left;
                index_mask = 1 << left;
                index = 1;
            } else {
                int top_left = prediction_parameters.color_index_map[plane_type][row - 1][column - 1];
                index_mask = 1 << top | 1 << left | 1 << top_left;
                if (top == left && top == top_left) {
                    color_context[counter] = 4;
                    color_order[counter][0] = top;
                    index = 1;
                } else if (top == left) {
                    color_context[counter] = 3;
                    color_order[counter][0] = top;
                    color_order[counter][1] = top_left;
                    index = 2;
                } else if (top == top_left) {
                    color_context[counter] = 2;
                    color_order[counter][0] = top_left;
                    color_order[counter][1] = left;
                    index = 2;
                } else if (left == top_left) {
                    color_context[counter] = 2;
                    color_order[counter][0] = top_left;
                    color_order[counter][1] = top;
                    index = 2;
                } else {
                    color_context[counter] = 1;
                    color_order[counter][0] = Math.min(top, left);
                    color_order[counter][1] = Math.max(top, left);
                    color_order[counter][2] = top_left;
                    index = 3;
                }
            }
            for (int j = 0; j < 8; ++j) {
                if (BitMaskSet.MaskContainsValue(index_mask, j)) continue;
                color_order[counter][index++] = j;
            }
            --column;
            ++counter;
        }
    }

    boolean ReadPaletteTokens(Block block) {
        for (int i = 0; i < this.prediction_parameters_.color_index_map.length; ++i) {
            if (this.prediction_parameters_.color_index_map[i] != null) continue;
            this.prediction_parameters_.color_index_map[i] = new int[64][64];
        }
        D.PaletteModeInfo palette_mode_info = block.bp.prediction_parameters.palette_mode_info;
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        for (int plane_type = 0; plane_type < (block.HasChroma() ? 2 : 1); ++plane_type) {
            int i;
            int first_value;
            int palette_size = palette_mode_info.size[plane_type];
            if (palette_size == 0) continue;
            int block_height = block.height;
            int block_width = block.width;
            int screen_height = Math.min(block_height, (this.frame_header_.rows4x4 - block.row4x4) * 4);
            int screen_width = Math.min(block_width, (this.frame_header_.columns4x4 - block.column4x4) * 4);
            if (plane_type == 1) {
                block_width >>= this.sequence_header_.color_config.subsampling_x;
                screen_height >>= this.sequence_header_.color_config.subsampling_y;
                screen_width >>= this.sequence_header_.color_config.subsampling_x;
                if ((block_height >>= this.sequence_header_.color_config.subsampling_y) < 4) {
                    block_height += 2;
                    screen_height += 2;
                }
                if (block_width < 4) {
                    block_width += 2;
                    screen_width += 2;
                }
            }
            for (int h = 0; h < block_height; ++h) {
                for (int w = 0; w < block_width; ++w) {
                    prediction_parameters.color_index_map[plane_type][h][w] = 0;
                }
            }
            prediction_parameters.color_index_map[plane_type][0][0] = first_value = this.reader_.DecodeUniform(palette_size);
            for (i = 1; i < screen_height + screen_width - 1; ++i) {
                int start = Math.min(i, screen_width - 1);
                int end = Math.max(0, i - screen_height + 1);
                int[][] color_order = new int[64][8];
                int[] color_context = new int[64];
                this.PopulatePaletteColorContexts(block, plane_type, i, start, end, color_order, color_context);
                int j = start;
                int counter = 0;
                while (j >= end) {
                    int[] cdf = this.symbol_decoder_context_.palette_color_index_cdf[plane_type][palette_size - 2][color_context[counter]];
                    int color_order_index = this.reader_.ReadSymbol(cdf, palette_size);
                    prediction_parameters.color_index_map[plane_type][i - j][j] = color_order[counter][color_order_index];
                    --j;
                    ++counter;
                }
            }
            if (screen_width < block_width) {
                for (i = 0; i < screen_height; ++i) {
                    Mem.set(prediction_parameters.color_index_map[plane_type][i], screen_width, prediction_parameters.color_index_map[plane_type][i][screen_width - 1], block_width - screen_width);
                }
            }
            for (i = screen_height; i < block_height; ++i) {
                Mem.cpy(prediction_parameters.color_index_map[plane_type][i], prediction_parameters.color_index_map[plane_type][screen_height - 1], block_width);
            }
        }
        return true;
    }

    static int PartitionCdfGatherHorizontalAlike(int[] partition_cdf, int block_size) {
        int cdf = partition_cdf[0] - partition_cdf[1] + partition_cdf[2] - partition_cdf[6];
        if (block_size != 21) {
            cdf += partition_cdf[7] - partition_cdf[8];
        }
        return cdf &= 0xFFFF;
    }

    static int PartitionCdfGatherVerticalAlike(int[] partition_cdf, int block_size) {
        int cdf = partition_cdf[1] + partition_cdf[5] - partition_cdf[4];
        if (block_size != 21) {
            cdf += partition_cdf[8] - partition_cdf[7];
        }
        return cdf &= 0xFFFF;
    }

    int[] GetPartitionCdf(int row4x4, int column4x4, int block_size) {
        int block_size_log2 = D.k4x4WidthLog2[block_size];
        int top = 0;
        if (this.IsTopInside(row4x4)) {
            top = D.k4x4WidthLog2[this.block_parameters_holder_.Find((int)(row4x4 - 1), (int)column4x4).size] < block_size_log2 ? 1 : 0;
        }
        int left = 0;
        if (this.IsLeftInside(column4x4)) {
            left = D.k4x4HeightLog2[this.block_parameters_holder_.Find((int)row4x4, (int)(column4x4 - 1)).size] < block_size_log2 ? 1 : 0;
        }
        int context = left * 2 + top;
        return this.symbol_decoder_context_.partition_cdf[block_size_log2 - 1][context];
    }

    boolean ReadPartition(int row4x4, int column4x4, int block_size, boolean has_rows, boolean has_columns, int[] partition) {
        int cdf;
        int bsize_log2;
        if (D.IsBlockSmallerThan8x8(block_size)) {
            partition[0] = 0;
            return true;
        }
        if (!has_rows && !has_columns) {
            partition[0] = 3;
            return true;
        }
        int[] partition_cdf = this.GetPartitionCdf(row4x4, column4x4, block_size);
        if (partition_cdf == null) {
            return false;
        }
        partition[0] = has_rows && has_columns ? ((bsize_log2 = D.k4x4WidthLog2[block_size]) == 1 ? this.reader_.ReadSymbol(partition_cdf, 4) : (bsize_log2 == 5 ? this.reader_.ReadSymbol(partition_cdf, 8) : this.reader_.ReadSymbol(partition_cdf, 10))) : (has_columns ? (this.reader_.ReadSymbolWithoutCdfUpdate(cdf = Tile.PartitionCdfGatherVerticalAlike(partition_cdf, block_size)) ? 3 : 1) : (this.reader_.ReadSymbolWithoutCdfUpdate(cdf = Tile.PartitionCdfGatherHorizontalAlike(partition_cdf, block_size)) ? 3 : 2));
        return true;
    }

    static int GetSquareTransformSize(int pixels) {
        switch (pixels) {
            case 64: 
            case 128: {
                return 18;
            }
            case 32: {
                return 14;
            }
            case 16: {
                return 9;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    int GetTopTransformWidth(Block block, int row4x4, int column4x4, boolean ignore_skip) {
        if (row4x4 == block.row4x4) {
            if (!block.top_available[0]) {
                return 64;
            }
            D.BlockParameters bp_top = this.block_parameters_holder_.Find(row4x4 - 1, column4x4);
            if ((ignore_skip || bp_top.skip) && bp_top.is_inter) {
                return D.kBlockWidthPixels[bp_top.size];
            }
        }
        return D.kTransformWidth[this.inter_transform_sizes_[row4x4 - 1][column4x4]];
    }

    int GetLeftTransformHeight(Block block, int row4x4, int column4x4, boolean ignore_skip) {
        if (column4x4 == block.column4x4) {
            if (!block.left_available[0]) {
                return 64;
            }
            D.BlockParameters bp_left = this.block_parameters_holder_.Find(row4x4, column4x4 - 1);
            if ((ignore_skip || bp_left.skip) && bp_left.is_inter) {
                return D.kBlockHeightPixels[bp_left.size];
            }
        }
        return D.kTransformHeight[this.inter_transform_sizes_[row4x4][column4x4 - 1]];
    }

    int ReadFixedTransformSize(Block block) {
        boolean allow_select;
        D.BlockParameters bp = block.bp;
        if (this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id]) {
            return 0;
        }
        int max_rect_tx_size = D.kMaxTransformSizeRectangle[block.size];
        boolean bl = allow_select = !bp.skip || !bp.is_inter;
        if (block.size == 0 || !allow_select || this.frame_header_.tx_mode != 2) {
            return max_rect_tx_size;
        }
        int max_tx_width = D.kTransformWidth[max_rect_tx_size];
        int max_tx_height = D.kTransformHeight[max_rect_tx_size];
        int top_width = block.top_available[0] ? this.GetTopTransformWidth(block, block.row4x4, block.column4x4, true) : 0;
        int left_height = block.left_available[0] ? this.GetLeftTransformHeight(block, block.row4x4, block.column4x4, true) : 0;
        int context = (top_width >= max_tx_width ? 1 : 0) + (left_height >= max_tx_height ? 1 : 0);
        int cdf_index = D.kTxDepthCdfIndex[block.size];
        int[] cdf = this.symbol_decoder_context_.tx_depth_cdf[cdf_index][context];
        int tx_depth = cdf_index == 0 ? (this.reader_.ReadSymbol(cdf) ? 1 : 0) : this.reader_.ReadSymbol(cdf, 3);
        int tx_size = max_rect_tx_size;
        if (tx_depth == 0) {
            return tx_size;
        }
        tx_size = D.kSplitTransformSize[tx_size];
        if (tx_depth == 1) {
            return tx_size;
        }
        return D.kSplitTransformSize[tx_size];
    }

    void ReadVariableTransformTree(Block block, int row4x4, int column4x4, int tx_size) {
        System.out.println("ReadVariableTransformTree is called");
        int pixels = Math.max(block.width, block.height);
        int max_tx_size = Tile.GetSquareTransformSize(pixels);
        int context_delta = (4 - D.TransformSizeToSquareTransformIndex(max_tx_size)) * 6;
        Stack<D.TransformTreeNode> stack = new Stack<D.TransformTreeNode>();
        stack.push(new D.TransformTreeNode(column4x4, row4x4, tx_size, 0));
        do {
            int left;
            int top;
            int context;
            D.TransformTreeNode node = (D.TransformTreeNode)stack.pop();
            int tx_width4x4 = D.kTransformWidth4x4[node.tx_size];
            int tx_height4x4 = D.kTransformHeight4x4[node.tx_size];
            if (node.tx_size != 0 && node.depth != 2 && this.reader_.ReadSymbol(this.symbol_decoder_context_.tx_split_cdf[context = (max_tx_size > 4 && D.kTransformSizeSquareMax[node.tx_size] != max_tx_size ? 1 : 0) * 3 + context_delta + (top = this.GetTopTransformWidth(block, node.y, node.x, false) < D.kTransformWidth[node.tx_size] ? 1 : 0) + (left = this.GetLeftTransformHeight(block, node.y, node.x, false) < D.kTransformHeight[node.tx_size] ? 1 : 0)])) {
                int sub_tx_size = D.kSplitTransformSize[node.tx_size];
                int step_width4x4 = D.kTransformWidth4x4[sub_tx_size];
                int step_height4x4 = D.kTransformHeight4x4[sub_tx_size];
                for (int i = tx_height4x4 - step_height4x4; i >= 0; i -= step_height4x4) {
                    for (int j = tx_width4x4 - step_width4x4; j >= 0; j -= step_width4x4) {
                        if (node.y + i >= this.frame_header_.rows4x4 || node.x + j >= this.frame_header_.columns4x4) continue;
                        stack.push(new D.TransformTreeNode(node.x + j, node.y + i, sub_tx_size, node.depth + 1));
                    }
                }
            } else {
                for (int i = 0; i < tx_height4x4; ++i) {
                    Mem.set(this.inter_transform_sizes_[node.y + i], node.x, node.tx_size, tx_width4x4);
                }
            }
        } while (!stack.isEmpty());
    }

    void DecodeTransformSize(Block block) {
        D.BlockParameters bp = block.bp;
        if (this.frame_header_.tx_mode == 2 && block.size > 0 && bp.is_inter && !bp.skip && !this.frame_header_.segmentation.lossless[bp.prediction_parameters.segment_id]) {
            int max_tx_size = D.kMaxTransformSizeRectangle[block.size];
            int tx_width4x4 = D.kTransformWidth4x4[max_tx_size];
            int tx_height4x4 = D.kTransformHeight4x4[max_tx_size];
            for (int row = block.row4x4; row < block.row4x4 + block.height4x4; row += tx_height4x4) {
                for (int column = block.column4x4; column < block.column4x4 + block.width4x4; column += tx_width4x4) {
                    this.ReadVariableTransformTree(block, row, column, max_tx_size);
                }
            }
        } else {
            int transform_size = this.ReadFixedTransformSize(block);
            for (int row = block.row4x4; row < block.row4x4 + block.height4x4; ++row) {
                Mem.set(this.inter_transform_sizes_[row], block.column4x4, transform_size, block.width4x4);
            }
        }
    }

    static int GetDirectionalIntraPredictorDerivative(int angle) {
        if (angle < 3 || angle > 87) {
            LogWriter.writeLog("Tile: GetDirectionalIntraPredictorDerivative error ");
        }
        return D.kDirectionalIntraPredictorDerivative[angle / 2 - 1];
    }

    static int GetWedgeBlockSizeIndex(int block_size) {
        if (block_size < 4) {
            LogWriter.writeLog("Tile: GetWedgeBlockSizeIndex error ");
        }
        return block_size - 4 - (block_size >= 8 ? 1 : 0) - (block_size >= 12 ? 1 : 0);
    }

    static int GetInterIntraMaskLookupIndex(int dimension) {
        return D.FloorLog2(dimension) - 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int GetIntraEdgeFilterStrength(int width, int height, int filter_type, int delta) {
        int sum = width + height;
        delta = Math.abs(delta);
        if (filter_type == 0) {
            if (sum <= 8) {
                if (delta < 56) return 0;
                return 1;
            }
            if (sum <= 16) {
                if (delta < 40) return 0;
                return 1;
            }
            if (sum <= 24) {
                if (delta >= 32) {
                    return 3;
                }
                if (delta >= 16) {
                    return 2;
                }
                if (delta < 8) return 0;
                return 1;
            }
            if (sum > 32) return 3;
            if (delta >= 32) {
                return 3;
            }
            if (delta < 4) return 1;
            return 2;
        }
        if (sum <= 8) {
            if (delta >= 64) {
                return 2;
            }
            if (delta < 40) return 0;
            return 1;
        }
        if (sum <= 16) {
            if (delta >= 48) {
                return 2;
            }
            if (delta < 20) return 0;
            return 1;
        }
        if (sum > 24) return 3;
        if (delta < 4) return 0;
        return 3;
    }

    static boolean DoIntraEdgeUpsampling(int width, int height, int filter_type, int delta) {
        int sum = width + height;
        if ((delta = Math.abs(delta)) >= 40) {
            return false;
        }
        return filter_type == 1 ? sum <= 8 : sum <= 16;
    }

    void GetDistanceWeights(int[] distance, int[] weight) {
        int order;
        int n = order = distance[0] <= distance[1] ? 1 : 0;
        if (distance[0] == 0 || distance[1] == 0) {
            weight[0] = D.kQuantizedDistanceLookup[3][order];
            weight[1] = D.kQuantizedDistanceLookup[3][1 - order];
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                int weight_0 = D.kQuantizedDistanceWeight[i][order];
                int weight_1 = D.kQuantizedDistanceWeight[i][1 - order];
                if (order == 0 ? distance[0] * weight_0 < distance[1] * weight_1 : distance[0] * weight_0 > distance[1] * weight_1) break;
            }
            weight[0] = D.kQuantizedDistanceLookup[i][order];
            weight[1] = D.kQuantizedDistanceLookup[i][1 - order];
        }
    }

    private static int GetIntraPredictor(int mode, boolean has_left, boolean has_top) {
        if (mode == 0) {
            if (has_left && has_top) {
                return 3;
            }
            if (has_left) {
                return 2;
            }
            if (has_top) {
                return 1;
            }
            return 0;
        }
        switch (mode) {
            case 12: {
                return 6;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 9;
            }
        }
        return 10;
    }

    static int GetStartPoint(D.Array2DView[] buffer, int plane, int x, int y, int bitdepth) {
        return buffer[plane].get(y, x);
    }

    static int GetPixelPositionFromHighScale(int start, int step, int offset) {
        return start + step * offset >> 10;
    }

    void IntraPrediction(Block block, int plane, int x, int y, boolean has_left, boolean has_top, boolean has_top_right, boolean has_bottom_left, int mode, int tx_size) {
        int left_index;
        int plane_shift;
        int top_row_superblock_index;
        int current_superblock_index;
        int top_right_size;
        int left_size;
        int width = D.kTransformWidth[tx_size];
        int height = D.kTransformHeight[tx_size];
        int x_shift = this.subsampling_x_[plane];
        int y_shift = this.subsampling_y_[plane];
        int max_x = (this.frame_header_.columns4x4 * 4 >> x_shift) - 1;
        int max_y = (this.frame_header_.rows4x4 * 4 >> y_shift) - 1;
        int[] top_row_data = new int[160];
        int[] left_column_data = new int[160];
        int[] top_row = top_row_data;
        int top_rowPos = 16;
        int[] left_column = left_column_data;
        int left_columnPos = 16;
        int bitdepth = this.sequence_header_.color_config.bitdepth;
        int top_and_left_size = width + height;
        boolean is_directional_mode = D.IsDirectionalMode(mode);
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        boolean use_filter_intra = plane == 0 && prediction_parameters.use_filter_intra;
        int prediction_angle = is_directional_mode ? D.kPredictionModeToAngle[mode] + prediction_parameters.angle_delta[D.GetPlaneType(plane)] * 3 : 0;
        int top_size = is_directional_mode ? top_and_left_size : width;
        int n = left_size = is_directional_mode ? top_and_left_size : height;
        int n2 = is_directional_mode ? (has_top_right ? 2 : 1) * width : (top_right_size = width);
        int bottom_left_size = is_directional_mode ? (has_bottom_left ? 2 : 1) * height : height;
        D.Array2DView buffer = this.buffer_[plane];
        boolean needs_top = use_filter_intra || D.kNeedsLeftAndTop.Contains(mode) || is_directional_mode && prediction_angle < 180 || mode == 0 && has_top;
        boolean needs_left = use_filter_intra || D.kNeedsLeftAndTop.Contains(mode) || is_directional_mode && prediction_angle > 90 || mode == 0 && has_left;
        int[] bufferData = buffer.data_;
        int bufferStride = buffer.columns();
        int[] top_row_src = buffer.data_;
        int top_row_srcPos = (y - 1) * bufferStride;
        if ((needs_top || needs_left) && this.use_intra_prediction_buffer_ && (current_superblock_index = block.row4x4 >> (this.sequence_header_.use_128x128_superblock ? 5 : 4)) != (top_row_superblock_index = y - 1 >> (plane_shift = (this.sequence_header_.use_128x128_superblock ? 7 : 6) - this.subsampling_y_[plane]))) {
            top_row_src = this.intra_prediction_buffer_[plane].get();
            top_row_srcPos = 0;
        }
        if (needs_top) {
            if (has_top || has_left) {
                left_index = has_left ? x - 1 : x;
                top_row[top_rowPos - 1] = has_top ? top_row_src[top_row_srcPos + left_index] : bufferData[y * bufferStride + left_index];
            } else {
                top_row[top_rowPos - 1] = 1 << bitdepth - 1;
            }
            if (!has_top && has_left) {
                Mem.set(top_row, top_rowPos, bufferData[y * bufferStride + x - 1], top_size);
            } else if (!has_top && !has_left) {
                Mem.set(top_row, top_rowPos + (1 << bitdepth - 1) - 1, top_size);
            } else {
                int top_limit = Math.min(max_x - x + 1, top_right_size);
                Mem.cpy(top_row, top_rowPos, top_row_src, top_row_srcPos + x, top_limit);
                if (top_size - top_limit > 0) {
                    Mem.set(top_row, top_rowPos + top_limit, top_row_src[top_row_srcPos + top_limit + x - 1], top_size - top_limit);
                }
            }
        }
        if (needs_left) {
            if (has_top || has_left) {
                left_index = has_left ? x - 1 : x;
                left_column[left_columnPos - 1] = has_top ? top_row_src[top_row_srcPos + left_index] : bufferData[y * bufferStride + left_index];
            } else {
                left_column[left_columnPos - 1] = 1 << bitdepth - 1;
            }
            if (!has_left && has_top) {
                Mem.set(left_column, left_columnPos, top_row_src[top_row_srcPos + x], left_size);
            } else if (!has_left && !has_top) {
                Mem.set(left_column, left_columnPos, (1 << bitdepth - 1) + 1, left_size);
            } else {
                int left_limit = Math.min(max_y - y + 1, bottom_left_size);
                for (int i = 0; i < left_limit; ++i) {
                    left_column[left_columnPos + i] = bufferData[(y + i) * bufferStride + (x - 1)];
                }
                if (left_size - left_limit > 0) {
                    Mem.set(left_column, left_columnPos + left_limit, bufferData[(left_limit + y - 1) * bufferStride + (x - 1)], left_size - left_limit);
                }
            }
        }
        int[] dest = buffer.data_;
        int destPos = y * buffer.columns() + x;
        int dest_stride = buffer.columns();
        if (use_filter_intra) {
            Intra.FilterIntraPredictor(dest, destPos, dest_stride, top_row, top_rowPos, left_column, left_columnPos, prediction_parameters.filter_intra_mode, width, height);
        } else if (is_directional_mode) {
            this.DirectionalPrediction(block, plane, x, y, has_left, has_top, needs_left, needs_top, prediction_angle, width, height, max_x, max_y, tx_size, top_row, top_rowPos, left_column, left_columnPos);
        } else {
            int predictor = Tile.GetIntraPredictor(mode, has_left, has_top);
            Intra.doPrediction(tx_size, predictor, dest, destPos, dest_stride, top_row, top_rowPos, left_column, left_columnPos);
        }
    }

    static int GetIntraEdgeFilterType(Block block, int plane) {
        boolean left;
        boolean top;
        if (plane == 0) {
            top = block.top_available[0] && D.kPredictionModeSmoothMask.Contains(block.bp_top.y_mode);
            left = block.left_available[0] && D.kPredictionModeSmoothMask.Contains(block.bp_left.y_mode);
        } else {
            top = block.top_available[plane] && block.bp.prediction_parameters.chroma_top_uses_smooth_prediction;
            left = block.left_available[plane] && block.bp.prediction_parameters.chroma_left_uses_smooth_prediction;
        }
        return top || left ? 1 : 0;
    }

    void DirectionalPrediction(Block block, int plane, int x, int y, boolean has_left, boolean has_top, boolean needs_left, boolean needs_top, int prediction_angle, int width, int height, int max_x, int max_y, int tx_size, int[] top_row, int top_rowPos, int[] left_column, int left_colomnPos) {
        D.Array2DView buffer = this.buffer_[plane];
        int[] dest = buffer.data_;
        int destPos = y * buffer.columns() + x;
        int stride = buffer.columns();
        if (prediction_angle == 90) {
            Intra.doPrediction(tx_size, 4, dest, destPos, stride, top_row, top_rowPos, left_column, left_colomnPos);
            return;
        }
        if (prediction_angle == 180) {
            Intra.doPrediction(tx_size, 5, dest, destPos, stride, top_row, top_rowPos, left_column, left_colomnPos);
            return;
        }
        boolean upsampled_top = false;
        boolean upsampled_left = false;
        if (this.sequence_header_.enable_intra_edge_filter) {
            int num_pixels;
            int num_pixels2;
            int strength;
            int filter_type = Tile.GetIntraEdgeFilterType(block, plane);
            if (prediction_angle > 90 && prediction_angle < 180 && width + height >= 24) {
                int n = D.RightShiftWithRounding(left_column[left_colomnPos + 0] * 5 + top_row[top_rowPos - 1] * 6 + top_row[top_rowPos + 0] * 5, 4);
                top_row[top_rowPos - 1] = n;
                left_column[left_colomnPos - 1] = n;
            }
            if (has_top && needs_top && (strength = Tile.GetIntraEdgeFilterStrength(width, height, filter_type, prediction_angle - 90)) > 0) {
                num_pixels2 = Math.min(width, max_x - x + 1) + (prediction_angle < 90 ? height : 0) + 1;
                Intra.EdgeFilter(top_row, top_rowPos - 1, num_pixels2, strength);
            }
            if (has_left && needs_left && (strength = Tile.GetIntraEdgeFilterStrength(width, height, filter_type, prediction_angle - 180)) > 0) {
                num_pixels2 = Math.min(height, max_y - y + 1) + (prediction_angle > 180 ? width : 0) + 1;
                Intra.EdgeFilter(left_column, left_colomnPos - 1, num_pixels2, strength);
            }
            if ((upsampled_top = Tile.DoIntraEdgeUpsampling(width, height, filter_type, prediction_angle - 90)) && needs_top) {
                num_pixels = width + (prediction_angle < 90 ? height : 0);
                Intra.EdgeUpsampler(top_row, top_rowPos, num_pixels);
            }
            if ((upsampled_left = Tile.DoIntraEdgeUpsampling(width, height, filter_type, prediction_angle - 180)) && needs_left) {
                num_pixels = height + (prediction_angle > 180 ? width : 0);
                Intra.EdgeUpsampler(left_column, left_colomnPos, num_pixels);
            }
        }
        if (prediction_angle < 90) {
            dx = Tile.GetDirectionalIntraPredictorDerivative(prediction_angle);
            Intra.PredDirectionalZone1(dest, destPos, stride, top_row, top_rowPos, width, height, dx, upsampled_top);
        } else if (prediction_angle < 180) {
            dx = Tile.GetDirectionalIntraPredictorDerivative(180 - prediction_angle);
            int dy = Tile.GetDirectionalIntraPredictorDerivative(prediction_angle - 90);
            Intra.PredDirectionalZone2(dest, destPos, stride, top_row, top_rowPos, left_column, left_colomnPos, width, height, dx, dy, upsampled_top, upsampled_left);
        } else {
            int dy = Tile.GetDirectionalIntraPredictorDerivative(270 - prediction_angle);
            Intra.PredDirectionalZone3(dest, destPos, stride, left_column, left_colomnPos, width, height, dy, upsampled_left);
        }
    }

    void PalettePrediction(Block block, int plane, int start_x, int start_y, int x, int y, int tx_size) {
        int tx_width = D.kTransformWidth[tx_size];
        int tx_height = D.kTransformHeight[tx_size];
        int[] palette = block.bp.prediction_parameters.palette_mode_info.color[plane];
        int plane_type = D.GetPlaneType(plane);
        int x4 = x * 4;
        int y4 = y * 4;
        D.Array2DView buffer = this.buffer_[plane];
        for (int row = 0; row < tx_height; ++row) {
            for (int column = 0; column < tx_width; ++column) {
                int val = palette[block.bp.prediction_parameters.color_index_map[plane_type][y4 + row][x4 + column]];
                buffer.set(start_y + row, start_x + column, val);
            }
        }
    }

    void ChromaFromLumaPrediction(Block block, int plane, int start_x, int start_y, int tx_size) {
        int subsampling_x = this.subsampling_x_[plane];
        int subsampling_y = this.subsampling_y_[plane];
        D.PredictionParameters prediction_parameters = block.bp.prediction_parameters;
        D.Array2DView y_buffer = this.buffer_[0];
        if (!block.scratch_buffer.cfl_luma_buffer_valid) {
            int luma_x = start_x << subsampling_x;
            int luma_y = start_y << subsampling_y;
            int[] source = y_buffer.data_;
            int sourcePos = luma_y * y_buffer.columns() + luma_x;
            Intra.doCflSubsampler(tx_size, subsampling_x + subsampling_y, block.scratch_buffer.cfl_luma_buffer, prediction_parameters.max_luma_width - luma_x, prediction_parameters.max_luma_height - luma_y, source, sourcePos, y_buffer.columns());
            block.scratch_buffer.cfl_luma_buffer_valid = true;
        }
        D.Array2DView buffer = this.buffer_[plane];
        int[] dest = buffer.data_;
        int destPos = start_y * buffer.columns() + start_x;
        Intra.doCflIntraPredictor(tx_size, dest, destPos, buffer.columns(), block.scratch_buffer.cfl_luma_buffer, plane == 1 ? prediction_parameters.cfl_alpha_u : prediction_parameters.cfl_alpha_v);
    }

    static class Block {
        final Tile tile;
        final boolean has_chroma;
        final int size;
        boolean[] top_available = new boolean[3];
        boolean[] left_available = new boolean[3];
        final int[] residual_size = new int[3];
        final int row4x4;
        final int column4x4;
        final int width;
        final int height;
        final int width4x4;
        final int height4x4;
        D.BlockParameters bp_top;
        D.BlockParameters bp_left;
        D.BlockParameters bp;
        D.TileScratchBuffer scratch_buffer;
        final int[] residual;
        int residualPos;
        D.BlockCdfContext top_context;
        int top_context_index;
        int left_context_index;

        Block(Tile tile, int size, int row4x4, int column4x4, D.TileScratchBuffer scratch_buffer, int[] residual, int residualPos) {
            this.tile = tile;
            this.size = size;
            this.row4x4 = row4x4;
            this.column4x4 = column4x4;
            this.width = D.kBlockWidthPixels[size];
            this.height = D.kBlockHeightPixels[size];
            this.width4x4 = this.width >> 2;
            this.height4x4 = this.height >> 2;
            this.scratch_buffer = scratch_buffer;
            this.residual = residual;
            this.residualPos = residualPos;
            this.top_context = tile.top_context_.get()[tile.SuperBlockColumnIndex(column4x4)];
            this.top_context_index = tile.CdfContextIndex(column4x4);
            this.left_context_index = tile.CdfContextIndex(row4x4);
            this.residual_size[0] = D.kPlaneResidualSize[size][0][0];
            this.residual_size[1] = this.residual_size[2] = D.kPlaneResidualSize[size][tile.subsampling_x_[1]][tile.subsampling_y_[1]];
            this.has_chroma = (row4x4 & 1) == 0 && (tile.sequence_header_.color_config.subsampling_y & this.height4x4) == 1 ? false : ((column4x4 & 1) == 0 && (tile.sequence_header_.color_config.subsampling_x & this.width4x4) == 1 ? false : !tile.sequence_header_.color_config.is_monochrome);
            this.top_available[0] = tile.IsTopInside(row4x4);
            this.left_available[0] = tile.IsLeftInside(column4x4);
            if (this.has_chroma) {
                this.top_available[1] = this.top_available[2] = tile.IsTopInside(row4x4 - (tile.sequence_header_.color_config.subsampling_y & this.height4x4));
                this.left_available[1] = this.left_available[2] = tile.IsLeftInside(column4x4 - (tile.sequence_header_.color_config.subsampling_x & this.width4x4));
            }
            int stride = tile.BlockParametersStride();
            D.BlockParameters bps = tile.BlockParametersAddress(row4x4, column4x4);
            int bpsPos = row4x4 * tile.block_parameters_holder_.columns4x4() + column4x4;
            this.bp = bps;
            if (this.top_available[0]) {
                this.bp_top = tile.BlockParametersAddress(row4x4 - 1, column4x4);
            }
            if (this.left_available[0]) {
                this.bp_left = tile.BlockParametersAddress(row4x4, column4x4 - 1);
            }
        }

        boolean HasChroma() {
            return this.has_chroma;
        }

        int TopReference(int index) {
            return this.bp_top.reference_frame[index];
        }

        int LeftReference(int index) {
            return this.bp_left.reference_frame[index];
        }

        boolean IsTopIntra() {
            return this.TopReference(0) <= 0;
        }

        boolean IsLeftIntra() {
            return this.LeftReference(0) <= 0;
        }

        boolean IsTopSingle() {
            return this.TopReference(1) <= 0;
        }

        boolean IsLeftSingle() {
            return this.LeftReference(1) <= 0;
        }

        int CountReferences(int type) {
            int a = this.top_available[0] && this.bp_top.reference_frame[0] == type ? 1 : 0;
            int b = this.top_available[0] && this.bp_top.reference_frame[1] == type ? 1 : 0;
            int c = this.left_available[0] && this.bp_left.reference_frame[0] == type ? 1 : 0;
            int d = this.left_available[0] && this.bp_left.reference_frame[1] == type ? 1 : 0;
            return a + b + c + d;
        }

        public boolean HasOverlappableCandidates() {
            LogWriter.writeLog("Tile Error: has overlappable candidates not to be called");
            return false;
        }
    }
}

