/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Mem;
import com.idrsolutions.image.avif.dec.Sym1;
import com.idrsolutions.image.avif.dec.Sym2;
import com.idrsolutions.image.avif.dec.Sym3;

class Symbol {
    int[][][] partition_cdf = new int[5][4][11];
    int[][][][] palette_color_index_cdf = new int[2][7][5][9];
    final int[][] segment_id_cdf = new int[3][9];
    final int[][] use_predicted_segment_id_cdf = new int[3][3];
    final int[][] skip_cdf = new int[3][3];
    final int[][] skip_mode_cdf = new int[3][3];
    final int[] delta_q_cdf = new int[5];
    final int[] delta_lf_cdf = new int[5];
    final int[][] delta_lf_multi_cdf = new int[4][5];
    final int[] intra_block_copy_cdf = new int[3];
    final int[][][] intra_frame_y_mode_cdf = new int[5][5][14];
    final int[][] y_mode_cdf = new int[4][14];
    final int[][] angle_delta_cdf = new int[8][8];
    final int[][][] uv_mode_cdf = new int[2][13][15];
    final int[] cfl_alpha_signs_cdf = new int[9];
    final int[][] cfl_alpha_cdf = new int[6][17];
    final int[][] use_filter_intra_cdf = new int[22][3];
    final int[] filter_intra_mode_cdf = new int[6];
    final int[][][] tx_depth_cdf = new int[4][3][4];
    final int[][] tx_split_cdf = new int[21][3];
    final int[][][] all_zero_cdf = new int[5][13][3];
    final int[][][] inter_tx_type_cdf = new int[3][4][17];
    final int[][][][] intra_tx_type_cdf = new int[2][4][13][17];
    final int[][][] eob_pt_16_cdf = new int[2][2][6];
    final int[][][] eob_pt_32_cdf = new int[2][2][7];
    final int[][][] eob_pt_64_cdf = new int[2][2][8];
    final int[][][] eob_pt_128_cdf = new int[2][2][9];
    final int[][][] eob_pt_256_cdf = new int[2][2][10];
    final int[][] eob_pt_512_cdf = new int[2][11];
    final int[][] eob_pt_1024_cdf = new int[2][12];
    final int[][][][] eob_extra_cdf = new int[5][2][9][3];
    final int[][][][] coeff_base_eob_cdf = new int[5][2][4][4];
    final int[][][][] coeff_base_cdf = new int[5][2][42][5];
    final int[][][][] coeff_base_range_cdf = new int[5][2][21][5];
    final int[][][] dc_sign_cdf = new int[2][3][3];
    final int[] restoration_type_cdf = new int[4];
    final int[] use_wiener_cdf = new int[3];
    final int[] use_sgrproj_cdf = new int[3];
    final int[][][] has_palette_y_cdf = new int[7][3][3];
    final int[][] palette_y_size_cdf = new int[7][8];
    final int[][] has_palette_uv_cdf = new int[2][3];
    final int[][] palette_uv_size_cdf = new int[7][8];
    final int[][] is_inter_cdf = new int[4][3];
    final int[][] use_compound_reference_cdf = new int[5][3];
    final int[][] compound_reference_type_cdf = new int[5][3];
    final int[][][][] compound_reference_cdf = new int[2][3][3][3];
    final int[][][] compound_backward_reference_cdf = new int[3][2][3];
    final int[][][] single_reference_cdf = new int[3][6][3];
    final int[][] compound_prediction_mode_cdf = new int[8][9];
    final int[][] new_mv_cdf = new int[6][3];
    final int[][] zero_mv_cdf = new int[2][3];
    final int[][] reference_mv_cdf = new int[6][3];
    final int[][] ref_mv_index_cdf = new int[3][3];
    final int[][] is_inter_intra_cdf = new int[3][3];
    final int[][] inter_intra_mode_cdf = new int[3][5];
    final int[][] is_wedge_inter_intra_cdf = new int[23][3];
    final int[][] wedge_index_cdf = new int[22][17];
    final int[][] use_obmc_cdf = new int[22][3];
    final int[][] motion_mode_cdf = new int[22][4];
    final int[][] is_explicit_compound_type_cdf = new int[6][3];
    final int[][] is_compound_type_average_cdf = new int[6][3];
    final int[][] compound_type_cdf = new int[22][3];
    final int[][] interpolation_filter_cdf = new int[16][4];
    final int[][] mv_joint_cdf = new int[2][5];
    final int[][][] mv_sign_cdf = new int[2][2][3];
    final int[][][] mv_class_cdf = new int[2][2][12];
    final int[][][] mv_class0_bit_cdf = new int[2][2][3];
    final int[][][][] mv_class0_fraction_cdf = new int[2][2][2][5];
    final int[][][] mv_class0_high_precision_cdf = new int[2][2][3];
    final int[][][][] mv_bit_cdf = new int[2][2][10][3];
    final int[][][] mv_fraction_cdf = new int[2][2][5];
    final int[][][] mv_high_precision_cdf = new int[2][2][3];

    Symbol() {
    }

    void initialize(int base_quantizer_index) {
        Symbol.COPY(Sym1.kDefaultPartitionCdf, this.partition_cdf);
        Symbol.COPY(Sym1.kDefaultSkipCdf, this.skip_cdf);
        Symbol.COPY(Sym1.kDefaultSkipModeCdf, this.skip_mode_cdf);
        Symbol.COPY(Sym1.kDefaultSegmentIdCdf, this.segment_id_cdf);
        Symbol.COPY(Sym1.kDefaultUsePredictedSegmentIdCdf, this.use_predicted_segment_id_cdf);
        Symbol.COPY(Sym1.kDefaultDeltaQCdf, this.delta_q_cdf);
        Symbol.COPY(Sym1.kDefaultDeltaQCdf, this.delta_lf_cdf);
        for (int[] delta_lf_multi_cdf_entry : this.delta_lf_multi_cdf) {
            Symbol.COPY(Sym1.kDefaultDeltaQCdf, delta_lf_multi_cdf_entry);
        }
        Symbol.COPY(Sym1.kDefaultIntraBlockCopyCdf, this.intra_block_copy_cdf);
        Symbol.COPY(Sym1.kDefaultIntraFrameYModeCdf, this.intra_frame_y_mode_cdf);
        Symbol.COPY(Sym1.kDefaultYModeCdf, this.y_mode_cdf);
        Symbol.COPY(Sym1.kDefaultAngleDeltaCdf, this.angle_delta_cdf);
        Symbol.COPY(Sym1.kDefaultUVModeCdf, this.uv_mode_cdf);
        Symbol.COPY(Sym1.kDefaultCflAlphaSignsCdf, this.cfl_alpha_signs_cdf);
        Symbol.COPY(Sym1.kDefaultCflAlphaCdf, this.cfl_alpha_cdf);
        Symbol.COPY(Sym1.kDefaultUseFilterIntraCdf, this.use_filter_intra_cdf);
        Symbol.COPY(Sym1.kDefaultFilterIntraModeCdf, this.filter_intra_mode_cdf);
        Symbol.COPY(Sym1.kDefaultTxDepthCdf, this.tx_depth_cdf);
        Symbol.COPY(Sym1.kDefaultTxSplitCdf, this.tx_split_cdf);
        Symbol.COPY(Sym1.kDefaultInterTxTypeCdf, this.inter_tx_type_cdf);
        Symbol.COPY(Sym1.kDefaultIntraTxTypeCdf, this.intra_tx_type_cdf);
        Symbol.COPY(Sym1.kDefaultRestorationTypeCdf, this.restoration_type_cdf);
        Symbol.COPY(Sym1.kDefaultUseWienerCdf, this.use_wiener_cdf);
        Symbol.COPY(Sym1.kDefaultUseSgrProjCdf, this.use_sgrproj_cdf);
        Symbol.COPY(Sym1.kDefaultHasPaletteYCdf, this.has_palette_y_cdf);
        Symbol.COPY(Sym1.kDefaultPaletteYSizeCdf, this.palette_y_size_cdf);
        Symbol.COPY(Sym1.kDefaultHasPaletteUVCdf, this.has_palette_uv_cdf);
        Symbol.COPY(Sym1.kDefaultPaletteUVSizeCdf, this.palette_uv_size_cdf);
        Symbol.COPY(Sym1.kDefaultPaletteColorIndexCdf, this.palette_color_index_cdf);
        Symbol.COPY(Sym1.kDefaultIsInterCdf, this.is_inter_cdf);
        Symbol.COPY(Sym1.kDefaultUseCompoundReferenceCdf, this.use_compound_reference_cdf);
        Symbol.COPY(Sym1.kDefaultCompoundReferenceTypeCdf, this.compound_reference_type_cdf);
        Symbol.COPY(Sym1.kDefaultCompoundReferenceCdf, this.compound_reference_cdf);
        Symbol.COPY(Sym1.kDefaultCompoundBackwardReferenceCdf, this.compound_backward_reference_cdf);
        Symbol.COPY(Sym1.kDefaultSingleReferenceCdf, this.single_reference_cdf);
        Symbol.COPY(Sym1.kDefaultCompoundPredictionModeCdf, this.compound_prediction_mode_cdf);
        Symbol.COPY(Sym1.kDefaultNewMvCdf, this.new_mv_cdf);
        Symbol.COPY(Sym1.kDefaultZeroMvCdf, this.zero_mv_cdf);
        Symbol.COPY(Sym1.kDefaultReferenceMvCdf, this.reference_mv_cdf);
        Symbol.COPY(Sym1.kDefaultRefMvIndexCdf, this.ref_mv_index_cdf);
        Symbol.COPY(Sym1.kDefaultIsInterIntraCdf, this.is_inter_intra_cdf);
        Symbol.COPY(Sym1.kDefaultInterIntraModeCdf, this.inter_intra_mode_cdf);
        Symbol.COPY(Sym1.kDefaultIsWedgeInterIntraCdf, this.is_wedge_inter_intra_cdf);
        Symbol.COPY(Sym1.kDefaultWedgeIndexCdf, this.wedge_index_cdf);
        Symbol.COPY(Sym1.kDefaultUseObmcCdf, this.use_obmc_cdf);
        Symbol.COPY(Sym1.kDefaultMotionModeCdf, this.motion_mode_cdf);
        Symbol.COPY(Sym1.kDefaultIsExplicitCompoundTypeCdf, this.is_explicit_compound_type_cdf);
        Symbol.COPY(Sym1.kDefaultIsCompoundTypeAverageCdf, this.is_compound_type_average_cdf);
        Symbol.COPY(Sym1.kDefaultCompoundTypeCdf, this.compound_type_cdf);
        Symbol.COPY(Sym1.kDefaultInterpolationFilterCdf, this.interpolation_filter_cdf);
        for (int i = 0; i < 2; ++i) {
            Symbol.COPY(Sym1.kDefaultMvJointCdf, this.mv_joint_cdf[i]);
            for (int j = 0; j < 2; ++j) {
                Symbol.COPY(Sym1.kDefaultMvSignCdf, this.mv_sign_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvClassCdf, this.mv_class_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvClass0BitCdf, this.mv_class0_bit_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvClass0FractionCdf, this.mv_class0_fraction_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvClass0HighPrecisionCdf, this.mv_class0_high_precision_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvBitCdf, this.mv_bit_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvFractionCdf, this.mv_fraction_cdf[i][j]);
                Symbol.COPY(Sym1.kDefaultMvHighPrecisionCdf, this.mv_high_precision_cdf[i][j]);
            }
        }
        int quantizer_context = Symbol.GetQuantizerContext(base_quantizer_index);
        Symbol.COPY(Sym1.kDefaultAllZeroCdf[quantizer_context], this.all_zero_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt16Cdf[quantizer_context], this.eob_pt_16_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt32Cdf[quantizer_context], this.eob_pt_32_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt64Cdf[quantizer_context], this.eob_pt_64_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt128Cdf[quantizer_context], this.eob_pt_128_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt256Cdf[quantizer_context], this.eob_pt_256_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt512Cdf[quantizer_context], this.eob_pt_512_cdf);
        Symbol.COPY(Sym1.kDefaultEobPt1024Cdf[quantizer_context], this.eob_pt_1024_cdf);
        Symbol.COPY(Sym1.kDefaultEobExtraCdf[quantizer_context], this.eob_extra_cdf);
        Symbol.COPY(Sym1.kDefaultCoeffBaseEobCdf[quantizer_context], this.coeff_base_eob_cdf);
        Symbol.COPY(Sym2.kDefaultCoeffBaseCdf[quantizer_context], this.coeff_base_cdf);
        Symbol.COPY(Sym3.kDefaultCoeffBaseRangeCdf[quantizer_context], this.coeff_base_range_cdf);
        Symbol.COPY(Sym1.kDefaultDcSignCdf[quantizer_context], this.dc_sign_cdf);
    }

    static int TxTypeIndex(int tx_set) {
        switch (tx_set) {
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return -1;
    }

    static int GetQuantizerContext(int base_quantizer_index) {
        if (base_quantizer_index <= 20) {
            return 0;
        }
        if (base_quantizer_index <= 60) {
            return 1;
        }
        if (base_quantizer_index <= 120) {
            return 2;
        }
        return 3;
    }

    static int PartitionCdfSize(int block_size_log2) {
        switch (block_size_log2) {
            case 1: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        return 10;
    }

    static void COPY(int[] source, int[] destination) {
        Mem.cpy(destination, source, source.length);
    }

    static void COPY(int[][] source, int[][] destination) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < source[i].length; ++j) {
                destination[i][j] = source[i][j];
            }
        }
    }

    static void COPY(int[][][] source, int[][][] destination) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < source[i].length; ++j) {
                for (int k = 0; k < source[i][j].length; ++k) {
                    destination[i][j][k] = source[i][j][k];
                }
            }
        }
    }

    static void COPY(int[][][][] source, int[][][][] destination) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < source[i].length; ++j) {
                for (int k = 0; k < source[i][j].length; ++k) {
                    for (int l = 0; l < source[i][j][k].length; ++l) {
                        destination[i][j][k][l] = source[i][j][k][l];
                    }
                }
            }
        }
    }

    static void RESET(int[] source) {
        source[source.length - 1] = 0;
    }

    static void RESET(int[][] source) {
        for (int i = 0; i < source.length; ++i) {
            source[i][source[i].length - 1] = 0;
        }
    }

    static void RESET(int[][][] source) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < source[i].length; ++j) {
                source[i][j][source[i][j].length - 1] = 0;
            }
        }
    }

    static void RESET(int[][][][] source) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < source[i].length; ++j) {
                for (int k = 0; k < source[i][j].length; ++k) {
                    source[i][j][k][source[i][j][k].length - 1] = 0;
                }
            }
        }
    }

    static void ResetPartitionCounters(Symbol context) {
        int block_size_log2 = D.k4x4WidthLog2[4];
        for (int[][] d1 : context.partition_cdf) {
            int cdf_size = Symbol.PartitionCdfSize(block_size_log2++);
            for (int[] d2 : d1) {
                d2[cdf_size] = 0;
            }
        }
    }

    static void ResetPaletteColorIndexCounters(Symbol context) {
        for (int[][][] d1 : context.palette_color_index_cdf) {
            int cdf_size = 2;
            int[][][] nArray = d1;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[][] d2;
                for (int[] d3 : d2 = nArray[i]) {
                    d3[cdf_size] = 0;
                }
                ++cdf_size;
            }
        }
    }

    static void ResetTxTypeCounters(Symbol context) {
        int cdf_size;
        int set_index = 1;
        for (Object d1 : context.intra_tx_type_cdf) {
            cdf_size = D.kNumTransformTypesInSet[set_index++];
            int[][][] nArray = d1;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[][] d2;
                for (int[] d3 : d2 = nArray[i]) {
                    d3[cdf_size] = 0;
                }
            }
        }
        int[][][] nArray = context.inter_tx_type_cdf;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Object d1;
            d1 = nArray[i];
            cdf_size = D.kNumTransformTypesInSet[set_index++];
            for (int[][] d2 : d1) {
                d2[cdf_size] = (int[])false;
            }
        }
    }

    static void ResetTxDepthCounters(Symbol context) {
        int delta = 1;
        for (int[][] d1 : context.tx_depth_cdf) {
            int cdf_size = 3 - delta;
            delta = 0;
            for (int[] d2 : d1) {
                d2[cdf_size] = 0;
            }
        }
    }

    static void ResetUVModeCounters(Symbol context) {
        int cdf_size = 13;
        int[][][] nArray = context.uv_mode_cdf;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[][] d1;
            for (int[] d2 : d1 = nArray[i]) {
                d2[cdf_size] = 0;
            }
            ++cdf_size;
        }
    }

    void ResetIntraFrameYModeCdf() {
        Symbol.COPY(Sym1.kDefaultIntraFrameYModeCdf, this.intra_frame_y_mode_cdf);
    }

    void ResetCounters() {
        Symbol.ResetPartitionCounters(this);
        Symbol.RESET(this.segment_id_cdf);
        Symbol.RESET(this.use_predicted_segment_id_cdf);
        Symbol.RESET(this.skip_cdf);
        Symbol.RESET(this.skip_mode_cdf);
        Symbol.RESET(this.delta_q_cdf);
        Symbol.RESET(this.delta_lf_cdf);
        Symbol.RESET(this.delta_lf_multi_cdf);
        Symbol.RESET(this.intra_block_copy_cdf);
        Symbol.RESET(this.intra_frame_y_mode_cdf);
        Symbol.RESET(this.y_mode_cdf);
        Symbol.RESET(this.angle_delta_cdf);
        Symbol.ResetUVModeCounters(this);
        Symbol.RESET(this.cfl_alpha_signs_cdf);
        Symbol.RESET(this.cfl_alpha_cdf);
        Symbol.RESET(this.use_filter_intra_cdf);
        Symbol.RESET(this.filter_intra_mode_cdf);
        Symbol.ResetTxDepthCounters(this);
        Symbol.RESET(this.tx_split_cdf);
        Symbol.RESET(this.all_zero_cdf);
        Symbol.ResetTxTypeCounters(this);
        Symbol.RESET(this.eob_pt_16_cdf);
        Symbol.RESET(this.eob_pt_32_cdf);
        Symbol.RESET(this.eob_pt_64_cdf);
        Symbol.RESET(this.eob_pt_128_cdf);
        Symbol.RESET(this.eob_pt_256_cdf);
        Symbol.RESET(this.eob_pt_512_cdf);
        Symbol.RESET(this.eob_pt_1024_cdf);
        Symbol.RESET(this.eob_extra_cdf);
        Symbol.RESET(this.coeff_base_eob_cdf);
        Symbol.RESET(this.coeff_base_cdf);
        Symbol.RESET(this.coeff_base_range_cdf);
        Symbol.RESET(this.dc_sign_cdf);
        Symbol.RESET(this.restoration_type_cdf);
        Symbol.RESET(this.use_wiener_cdf);
        Symbol.RESET(this.use_sgrproj_cdf);
        Symbol.RESET(this.has_palette_y_cdf);
        Symbol.RESET(this.palette_y_size_cdf);
        Symbol.RESET(this.has_palette_uv_cdf);
        Symbol.RESET(this.palette_uv_size_cdf);
        Symbol.ResetPaletteColorIndexCounters(this);
        Symbol.RESET(this.is_inter_cdf);
        Symbol.RESET(this.use_compound_reference_cdf);
        Symbol.RESET(this.compound_reference_type_cdf);
        Symbol.RESET(this.compound_reference_cdf);
        Symbol.RESET(this.compound_backward_reference_cdf);
        Symbol.RESET(this.single_reference_cdf);
        Symbol.RESET(this.compound_prediction_mode_cdf);
        Symbol.RESET(this.new_mv_cdf);
        Symbol.RESET(this.zero_mv_cdf);
        Symbol.RESET(this.reference_mv_cdf);
        Symbol.RESET(this.ref_mv_index_cdf);
        Symbol.RESET(this.is_inter_intra_cdf);
        Symbol.RESET(this.inter_intra_mode_cdf);
        Symbol.RESET(this.is_wedge_inter_intra_cdf);
        Symbol.RESET(this.wedge_index_cdf);
        Symbol.RESET(this.use_obmc_cdf);
        Symbol.RESET(this.motion_mode_cdf);
        Symbol.RESET(this.is_explicit_compound_type_cdf);
        Symbol.RESET(this.is_compound_type_average_cdf);
        Symbol.RESET(this.compound_type_cdf);
        Symbol.RESET(this.interpolation_filter_cdf);
        Symbol.RESET(this.mv_joint_cdf);
        Symbol.RESET(this.mv_sign_cdf);
        Symbol.RESET(this.mv_class_cdf);
        Symbol.RESET(this.mv_class0_bit_cdf);
        Symbol.RESET(this.mv_class0_fraction_cdf);
        Symbol.RESET(this.mv_class0_high_precision_cdf);
        Symbol.RESET(this.mv_bit_cdf);
        Symbol.RESET(this.mv_fraction_cdf);
        Symbol.RESET(this.mv_high_precision_cdf);
    }
}

