/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.BitMaskSet;
import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Itx;
import org.jpedal.utils.LogWriter;

class Reconstruct {
    Reconstruct() {
    }

    static int GetTransformClass(int tx_type) {
        BitMaskSet kTransformClassVerticalMask = new BitMaskSet(10, 12, 14);
        if (kTransformClassVerticalMask.Contains(tx_type)) {
            return 2;
        }
        BitMaskSet kTransformClassHorizontalMask = new BitMaskSet(11, 13, 15);
        if (kTransformClassHorizontalMask.Contains(tx_type)) {
            return 1;
        }
        return 0;
    }

    static int GetNumRows(int tx_width, int tx_type, int tx_height, int non_zero_coeff_count) {
        int tx_class = Reconstruct.GetTransformClass(tx_type);
        switch (tx_class) {
            case 0: {
                if (tx_width == 4) {
                    if (non_zero_coeff_count <= 13) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 29) {
                        return 8;
                    }
                }
                if (tx_width == 8) {
                    if (non_zero_coeff_count <= 10) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 14 & tx_height > 8) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 43) {
                        return 8;
                    }
                    if (non_zero_coeff_count <= 107 & tx_height > 16) {
                        return 16;
                    }
                    if (non_zero_coeff_count <= 171 & tx_height > 16) {
                        return 24;
                    }
                }
                if (tx_width == 16) {
                    if (non_zero_coeff_count <= 10) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 14 & tx_height > 16) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 36) {
                        return 8;
                    }
                    if (non_zero_coeff_count <= 44 & tx_height > 16) {
                        return 8;
                    }
                    if (non_zero_coeff_count <= 151 & tx_height > 16) {
                        return 16;
                    }
                    if (non_zero_coeff_count <= 279 & tx_height > 16) {
                        return 24;
                    }
                }
                if (tx_width != 32) break;
                if (non_zero_coeff_count <= 10) {
                    return 4;
                }
                if (non_zero_coeff_count <= 36) {
                    return 8;
                }
                if (non_zero_coeff_count <= 136 & tx_height > 16) {
                    return 16;
                }
                if (!(non_zero_coeff_count <= 300 & tx_height > 16)) break;
                return 24;
            }
            case 1: {
                if (non_zero_coeff_count <= 4) {
                    return 4;
                }
                if (non_zero_coeff_count <= 8) {
                    return 8;
                }
                if (non_zero_coeff_count <= 16 & tx_height > 16) {
                    return 16;
                }
                if (!(non_zero_coeff_count <= 24 & tx_height > 16)) break;
                return 24;
            }
            default: {
                if (tx_width == 4) {
                    if (non_zero_coeff_count <= 16) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 32) {
                        return 8;
                    }
                }
                if (tx_width == 8) {
                    if (non_zero_coeff_count <= 32) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 64) {
                        return 8;
                    }
                    if (non_zero_coeff_count <= 128) {
                        return 16;
                    }
                    if (non_zero_coeff_count <= 192) {
                        return 24;
                    }
                }
                if (tx_width == 16) {
                    if (non_zero_coeff_count <= 64) {
                        return 4;
                    }
                    if (non_zero_coeff_count <= 128) {
                        return 8;
                    }
                    if (non_zero_coeff_count <= 256) {
                        return 16;
                    }
                    if (non_zero_coeff_count <= 384) {
                        return 24;
                    }
                }
                if (tx_width != 32) break;
                if (non_zero_coeff_count <= 128) {
                    return 4;
                }
                if (non_zero_coeff_count <= 256) {
                    return 8;
                }
                if (non_zero_coeff_count <= 512) {
                    return 16;
                }
                if (non_zero_coeff_count > 768) break;
                return 24;
            }
        }
        return tx_width >= 16 ? Math.min(tx_height, 32) : tx_height;
    }

    static int GetTransform1dSize(int size_log2) {
        return size_log2 - 2;
    }

    static void reconsruct(int tx_type, int tx_size, boolean lossless, int[] buffer, int bufferPos, int start_x, int start_y, D.Array2DView frame, int non_zero_coeff_count) {
        int tx_height;
        int tx_width_log2 = D.kTransformWidthLog2[tx_size];
        int tx_height_log2 = D.kTransformHeightLog2[tx_size];
        int n = tx_height = non_zero_coeff_count == 1 ? 1 : D.kTransformHeight[tx_size];
        if (tx_height > 4) {
            int rowSelect = tx_width_log2 - 2;
            switch (rowSelect) {
                case 0: {
                    tx_height = Reconstruct.GetNumRows(4, tx_type, tx_height, non_zero_coeff_count);
                    break;
                }
                case 1: {
                    tx_height = Reconstruct.GetNumRows(8, tx_type, tx_height, non_zero_coeff_count);
                    break;
                }
                case 2: {
                    tx_height = Reconstruct.GetNumRows(16, tx_type, tx_height, non_zero_coeff_count);
                    break;
                }
                case 3: {
                    tx_height = Reconstruct.GetNumRows(32, tx_type, tx_height, non_zero_coeff_count);
                    break;
                }
                case 4: {
                    tx_height = Reconstruct.GetNumRows(32, tx_type, tx_height, non_zero_coeff_count);
                    break;
                }
                default: {
                    LogWriter.writeLog("invalid numof rows found in reconstruct");
                }
            }
        }
        int row_transform_size = Reconstruct.GetTransform1dSize(tx_width_log2);
        int row_transform = lossless ? 3 : D.kRowTransform[tx_type];
        Itx.doTransform(row_transform, row_transform_size, 0, tx_type, tx_size, tx_height, buffer, bufferPos, start_x, start_y, frame);
        int column_transform_size = Reconstruct.GetTransform1dSize(tx_height_log2);
        int column_transform = lossless ? 3 : D.kColumnTransform[tx_type];
        Itx.doTransform(column_transform, column_transform_size, 1, tx_type, tx_size, tx_height, buffer, bufferPos, start_x, start_y, frame);
    }
}

