/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Mem;
import com.idrsolutions.image.avif.dec.QM;
import com.idrsolutions.image.avif.dec.QM2;
import com.idrsolutions.image.avif.dec.QM3;

class Quant {
    static final int[] kDcLookup = new int[]{4, 8, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 26, 27, 28, 29, 30, 31, 32, 32, 33, 34, 35, 36, 37, 38, 38, 39, 40, 41, 42, 43, 43, 44, 45, 46, 47, 48, 48, 49, 50, 51, 52, 53, 53, 54, 55, 56, 57, 57, 58, 59, 60, 61, 62, 62, 63, 64, 65, 66, 66, 67, 68, 69, 70, 70, 71, 72, 73, 74, 74, 75, 76, 77, 78, 78, 79, 80, 81, 81, 82, 83, 84, 85, 85, 87, 88, 90, 92, 93, 95, 96, 98, 99, 101, 102, 104, 105, 107, 108, 110, 111, 113, 114, 116, 117, 118, 120, 121, 123, 125, 127, 129, 131, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 154, 156, 158, 161, 164, 166, 169, 172, 174, 177, 180, 182, 185, 187, 190, 192, 195, 199, 202, 205, 208, 211, 214, 217, 220, 223, 226, 230, 233, 237, 240, 243, 247, 250, 253, 257, 261, 265, 269, 272, 276, 280, 284, 288, 292, 296, 300, 304, 309, 313, 317, 322, 326, 330, 335, 340, 344, 349, 354, 359, 364, 369, 374, 379, 384, 389, 395, 400, 406, 411, 417, 423, 429, 435, 441, 447, 454, 461, 467, 475, 482, 489, 497, 505, 513, 522, 530, 539, 549, 559, 569, 579, 590, 602, 614, 626, 640, 654, 668, 684, 700, 717, 736, 755, 775, 796, 819, 843, 869, 896, 925, 955, 988, 1022, 1058, 1098, 1139, 1184, 1232, 1282, 1336};
    static final int[] kAcLookup = new int[]{4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130, 132, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 155, 158, 161, 164, 167, 170, 173, 176, 179, 182, 185, 188, 191, 194, 197, 200, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255, 260, 265, 270, 275, 280, 285, 290, 295, 300, 305, 311, 317, 323, 329, 335, 341, 347, 353, 359, 366, 373, 380, 387, 394, 401, 408, 416, 424, 432, 440, 448, 456, 465, 474, 483, 492, 501, 510, 520, 530, 540, 550, 560, 571, 582, 593, 604, 615, 627, 639, 651, 663, 676, 689, 702, 715, 729, 743, 757, 771, 786, 801, 816, 832, 848, 864, 881, 898, 915, 933, 951, 969, 988, 1007, 1026, 1046, 1066, 1087, 1108, 1129, 1151, 1173, 1196, 1219, 1243, 1267, 1292, 1317, 1343, 1369, 1396, 1423, 1451, 1479, 1508, 1537, 1567, 1597, 1628, 1660, 1692, 1725, 1759, 1793, 1828};
    final int bitdepth_;
    final int[] dc_lookup_;
    final int[] ac_lookup_;
    final D.QuantizerParameters params_;

    static void Transpose(int[] dst, int[] src, int src_width, int src_height) {
        int dst_width = src_height;
        int dst_height = src_width;
        for (int y = 0; y < dst_height; ++y) {
            for (int x = 0; x < dst_width; ++x) {
                dst[y * dst_width + x] = src[x * src_width + y];
            }
        }
    }

    static void FillUpperTriangle(int[] dst, int[] src, int size) {
        int k = 0;
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x <= y; ++x) {
                int n = src[k++];
                dst[x * size + y] = n;
                dst[y * size + x] = n;
            }
        }
    }

    static int GetQIndex(D.Segmentation segmentation, int index, int base_qindex) {
        if (segmentation.FeatureActive(index, 0)) {
            int segment_qindex = base_qindex + segmentation.feature_data[index][0];
            return D.Clip3(segment_qindex, 0, 255);
        }
        return base_qindex;
    }

    static boolean initializeQuantizerMatrix(int[][][][] QuantizerMatrix) {
        for (int level = 0; level < 15; ++level) {
            for (int plane_type = 0; plane_type < 2; ++plane_type) {
                int[][] quantizer_matrix = QuantizerMatrix[level][plane_type];
                for (int tx_size = 0; tx_size < 19; ++tx_size) {
                    if (D.kTransformWidth[tx_size] == 64 || D.kTransformHeight[tx_size] == 64) continue;
                    int size = D.kTransformWidth[tx_size] * D.kTransformHeight[tx_size];
                    quantizer_matrix[tx_size] = new int[size];
                }
                Quant.FillUpperTriangle(quantizer_matrix[0], QM.kQuantizerMatrix4x4[level][plane_type], 4);
                Mem.cpy(quantizer_matrix[1], QM.kQuantizerMatrix4x8[level][plane_type], 32);
                Mem.cpy(quantizer_matrix[2], QM.kQuantizerMatrix4x16[level][plane_type], 64);
                Quant.Transpose(quantizer_matrix[3], QM.kQuantizerMatrix4x8[level][plane_type], 4, 8);
                Quant.FillUpperTriangle(quantizer_matrix[4], QM.kQuantizerMatrix8x8[level][plane_type], 8);
                Mem.cpy(quantizer_matrix[5], QM.kQuantizerMatrix8x16[level][plane_type], 128);
                Mem.cpy(quantizer_matrix[6], QM2.kQuantizerMatrix8x32[level][plane_type], 256);
                Quant.Transpose(quantizer_matrix[7], QM.kQuantizerMatrix4x16[level][plane_type], 4, 16);
                Quant.Transpose(quantizer_matrix[8], QM.kQuantizerMatrix8x16[level][plane_type], 8, 16);
                Mem.cpy(quantizer_matrix[10], QM3.kQuantizerMatrix16x32[level][plane_type], 512);
                Quant.Transpose(quantizer_matrix[12], QM2.kQuantizerMatrix8x32[level][plane_type], 8, 32);
                Quant.Transpose(quantizer_matrix[13], QM3.kQuantizerMatrix16x32[level][plane_type], 16, 32);
                Quant.FillUpperTriangle(quantizer_matrix[14], QM3.kQuantizerMatrix32x32[level][plane_type], 32);
                int[] dst16x16 = quantizer_matrix[9];
                int[] src32x32 = quantizer_matrix[14];
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        dst16x16[y * 16 + x] = src32x32[y * 2 * 32 + x * 2];
                    }
                }
            }
        }
        return true;
    }

    Quant(int bitdepth, D.QuantizerParameters params) {
        this.bitdepth_ = bitdepth;
        this.params_ = params;
        this.dc_lookup_ = kDcLookup;
        this.ac_lookup_ = kAcLookup;
    }

    int GetDcValue(int plane, int qindex) {
        return this.dc_lookup_[D.Clip3(qindex + this.params_.delta_dc[plane], 0, 255)];
    }

    int GetAcValue(int plane, int qindex) {
        return this.ac_lookup_[D.Clip3(qindex + this.params_.delta_ac[plane], 0, 255)];
    }
}

