/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.dec;

import com.idrsolutions.image.avif.dec.D;
import com.idrsolutions.image.avif.dec.Mem;
import org.jpedal.utils.LogWriter;

class Intra {
    private static final int kKernelTaps = 5;
    private static final int[][] kKernels = new int[][]{{0, 4, 8, 4, 0}, {0, 5, 6, 5, 0}, {2, 4, 4, 4, 2}};
    private static final int kMaxUpsampleSize = 16;
    private static final int kSmoothWeightScale = 8;
    private static final int bitdepth = 8;
    public static int[] kSmoothWeights = new int[]{255, 149, 85, 64, 255, 197, 146, 105, 73, 50, 37, 32, 255, 225, 196, 170, 145, 123, 102, 84, 68, 54, 43, 33, 26, 20, 17, 16, 255, 240, 225, 210, 196, 182, 169, 157, 145, 133, 122, 111, 101, 92, 83, 74, 66, 59, 52, 45, 39, 34, 29, 25, 21, 17, 14, 12, 10, 9, 8, 8, 255, 248, 240, 233, 225, 218, 210, 203, 196, 189, 182, 176, 169, 163, 156, 150, 144, 138, 133, 127, 121, 116, 111, 106, 101, 96, 91, 86, 82, 77, 73, 69, 65, 61, 57, 54, 50, 47, 44, 41, 38, 35, 32, 29, 27, 25, 22, 20, 18, 16, 15, 13, 12, 10, 9, 8, 7, 6, 6, 5, 5, 4, 4, 4};
    static final int[][] WH_TABLE = new int[][]{{4, 4}, {4, 8}, {4, 16}, {8, 4}, {8, 8}, {8, 16}, {8, 32}, {16, 4}, {16, 8}, {16, 16}, {16, 32}, {16, 64}, {32, 8}, {32, 16}, {32, 32}, {32, 64}, {64, 16}, {64, 32}, {64, 64}};
    static boolean debug = false;

    Intra() {
    }

    static void EdgeFilter(int[] buffer, int bufferPos, int size, int strength) {
        if (debug) {
            LogWriter.writeLog("Edge filter " + bufferPos + " " + size);
        }
        int[] edge = new int[129];
        Mem.cpy(edge, 0, buffer, bufferPos, size);
        int[] dst = buffer;
        int dstPos = bufferPos;
        int kernel_index = strength - 1;
        for (int i = 1; i < size; ++i) {
            int sum = 0;
            for (int j = 0; j < 5; ++j) {
                int k = D.Clip3(i + j - 2, 0, size - 1);
                sum += kKernels[kernel_index][j] * edge[k];
            }
            dst[dstPos + i] = D.RightShiftWithRounding(sum, 4);
        }
    }

    static void EdgeUpsampler(int[] buffer, int bufferPos, int size) {
        if (debug) {
            LogWriter.writeLog("Edge upsampler " + bufferPos + " " + size);
        }
        int[] pixel_buffer = buffer;
        int pixelPos = bufferPos;
        int[] temp = new int[19];
        temp[0] = temp[1] = pixel_buffer[bufferPos - 1];
        Mem.cpy(temp, 2, pixel_buffer, pixelPos, size);
        temp[size + 2] = pixel_buffer[pixelPos + size - 1];
        pixel_buffer[pixelPos - 2] = temp[0];
        for (int i = 0; i < size; ++i) {
            int sum = -temp[i] + 9 * temp[i + 1] + 9 * temp[i + 2] - temp[i + 3];
            pixel_buffer[pixelPos + 2 * i - 1] = D.Clip3(D.RightShiftWithRounding(sum, 4), 0, 255);
            pixel_buffer[pixelPos + 2 * i] = temp[i + 2];
        }
    }

    static void PredDcTop(int[] dst, int dstPos, int stride, int[] top, int topPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Dc top");
        }
        int sum = bw >> 1;
        for (int x = 0; x < bw; ++x) {
            sum += top[topPos + x];
        }
        int dc = sum >> D.FloorLog2(bw);
        for (int y = 0; y < bh; ++y) {
            Mem.set(dst, dstPos, dc, bw);
            dstPos += stride;
        }
    }

    static void PredDcLeft(int[] dst, int dstPos, int stride, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Dc left");
        }
        int sum = bh >> 1;
        for (int y = 0; y < bh; ++y) {
            sum += left[leftPos + y];
        }
        int dc = sum >> D.FloorLog2(bh);
        for (int y = 0; y < bh; ++y) {
            Mem.set(dst, dstPos, dc, bw);
            dstPos += stride;
        }
    }

    static void PredDc(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Dc");
        }
        int divisor = bw + bh;
        int sum = divisor >> 1;
        for (int x = 0; x < bw; ++x) {
            sum += top[topPos + x];
        }
        for (int y = 0; y < bh; ++y) {
            sum += left[leftPos + y];
        }
        int dc = sum / divisor;
        for (int y = 0; y < bh; ++y) {
            Mem.set(dst, dstPos, dc, bw);
            dstPos += stride;
        }
    }

    static void PredVertical(int[] dst, int dstPos, int stride, int[] top, int topPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Pred Vertical");
        }
        for (int y = 0; y < bh; ++y) {
            Mem.cpy(dst, dstPos, top, topPos, bw);
            dstPos += stride;
        }
    }

    static void PredHorizontal(int[] dst, int dstPos, int stride, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Pred Horizontal");
        }
        for (int y = 0; y < bh; ++y) {
            Mem.set(dst, dstPos, left[leftPos + y], bw);
            dstPos += stride;
        }
    }

    static void PredPaeth(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Pred Paeth");
        }
        int top_left = top[topPos - 1];
        int top_left_x2 = top_left + top_left;
        for (int y = 0; y < bh; ++y) {
            int left_pixel = left[leftPos + y];
            for (int x = 0; x < bw; ++x) {
                int left_dist = Math.abs(top[topPos + x] - top_left);
                int top_dist = Math.abs(left_pixel - top_left);
                int top_left_dist = Math.abs(top[topPos + x] + left_pixel - top_left_x2);
                dst[dstPos + x] = left_dist <= top_dist && left_dist <= top_left_dist ? left_pixel : (top_dist <= top_left_dist ? top[topPos + x] : top_left);
            }
            dstPos += stride;
        }
    }

    static void PredDcFill(int[] dst, int dstPos, int stride, int bw, int bh, int fill) {
        if (debug) {
            LogWriter.writeLog("Pred DC Fill");
        }
        for (int y = 0; y < bh; ++y) {
            Mem.set(dst, dstPos, fill, bw);
            dstPos += stride;
        }
    }

    static int[] getWH(int txsize) {
        return WH_TABLE[txsize];
    }

    static void doPrediction(int txsize, int predType, int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos) {
        int[] wh = Intra.getWH(txsize);
        int bw = wh[0];
        int bh = wh[1];
        switch (predType) {
            case 0: {
                Intra.PredDcFill(dst, dstPos, stride, bw, bh, 128);
                break;
            }
            case 1: {
                Intra.PredDcTop(dst, dstPos, stride, top, topPos, bw, bh);
                break;
            }
            case 2: {
                Intra.PredDcLeft(dst, dstPos, stride, left, leftPos, bw, bh);
                break;
            }
            case 3: {
                Intra.PredDc(dst, dstPos, stride, top, topPos, left, leftPos, bw, bh);
                break;
            }
            case 4: {
                Intra.PredVertical(dst, dstPos, stride, top, topPos, bw, bh);
                break;
            }
            case 5: {
                Intra.PredHorizontal(dst, dstPos, stride, left, leftPos, bw, bh);
                break;
            }
            case 6: {
                Intra.PredPaeth(dst, dstPos, stride, top, topPos, left, leftPos, bw, bh);
                break;
            }
            case 7: {
                Intra.Smooth(dst, dstPos, stride, top, topPos, left, leftPos, bw, bh);
                break;
            }
            case 8: {
                Intra.SmoothVertical(dst, dstPos, stride, top, topPos, left, leftPos, bw, bh);
                break;
            }
            case 9: {
                Intra.SmoothHorizontal(dst, dstPos, stride, top, topPos, left, leftPos, bw, bh);
                break;
            }
            default: {
                LogWriter.writeLog("Intra: unsupported prediction type " + predType);
            }
        }
    }

    static void doCflIntraPredictor(int txsize, int[] dst, int dstPos, int stride, int[][] luma, int alpha) {
        if (debug) {
            LogWriter.writeLog("Cfl Intra");
        }
        int[] wh = Intra.getWH(txsize);
        int bw = wh[0];
        int bh = wh[1];
        int bitdepth = 8;
        int dc = dst[dstPos];
        int max_value = (1 << bitdepth) - 1;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                dst[dstPos + x] = D.Clip3(dc + D.RightShiftWithRoundingSigned(alpha * luma[y][x], 6), 0, max_value);
            }
            dstPos += stride;
        }
    }

    static void CflSubsampler(int[][] luma, int max_luma_width, int max_luma_height, int[] src, int srcPos, int stride, int bw, int bh, int subsampling_x, int subsampling_y) {
        if (debug) {
            LogWriter.writeLog("Cfl Sampler");
        }
        int sum = 0;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                int luma_x = Math.min(x << subsampling_x, max_luma_width - (1 << subsampling_x));
                int luma_x_next = luma_x + stride;
                luma[y][x] = src[srcPos + luma_x] + (subsampling_x != 0 ? src[srcPos + luma_x + 1] : 0) + (subsampling_y != 0 ? src[srcPos + luma_x_next] + src[srcPos + luma_x_next + 1] : 0) << 3 - subsampling_x - subsampling_y;
                sum += luma[y][x];
            }
            if (y << subsampling_y >= max_luma_height - (1 << subsampling_y)) continue;
            srcPos += stride << subsampling_y;
        }
        int average = D.RightShiftWithRounding(sum, D.FloorLog2(bw) + D.FloorLog2(bh));
        for (int y = 0; y < bh; ++y) {
            int x = 0;
            while (x < bw) {
                int[] nArray = luma[y];
                int n = x++;
                nArray[n] = nArray[n] - average;
            }
        }
    }

    static void doCflSubsampler(int txsize, int sampleType, int[][] luma, int max_luma_width, int max_luma_height, int[] src, int srcPos, int stride) {
        int[] wh = Intra.getWH(txsize);
        int bw = wh[0];
        int bh = wh[1];
        switch (sampleType) {
            case 0: {
                Intra.CflSubsampler(luma, max_luma_width, max_luma_height, src, srcPos, stride, bw, bh, 0, 0);
                break;
            }
            case 1: {
                Intra.CflSubsampler(luma, max_luma_width, max_luma_height, src, srcPos, stride, bw, bh, 1, 0);
                break;
            }
            case 2: {
                Intra.CflSubsampler(luma, max_luma_width, max_luma_height, src, srcPos, stride, bw, bh, 1, 1);
            }
        }
    }

    static void PredDirectionalZone1(int[] dst, int dstPos, int stride, int[] top, int topPos, int width, int height, int xstep, boolean upsampled_top) {
        if (debug) {
            LogWriter.writeLog("PredDirectionalZone1");
        }
        if (xstep == 64) {
            int[] top_ptr = top;
            int top_ptrPos = topPos + 1;
            int y = 0;
            while (y < height) {
                Mem.cpy(dst, dstPos, top_ptr, top_ptrPos, width);
                ++y;
                dstPos += stride;
                ++top_ptrPos;
            }
            return;
        }
        int upsample_shift = upsampled_top ? 1 : 0;
        int max_base_x = width + height - 1 << upsample_shift;
        int scale_bits = 6 - upsample_shift;
        int base_step = 1 << upsample_shift;
        int top_x = xstep;
        int y = 0;
        do {
            int top_base_x;
            if ((top_base_x = top_x >> scale_bits) >= max_base_x) {
                for (int i = y; i < height; ++i) {
                    Mem.set(dst, dstPos, top[topPos + max_base_x], width);
                    dstPos += stride;
                }
                return;
            }
            int shift = (top_x << upsample_shift & 0x3F) >> 1;
            int x = 0;
            do {
                if (top_base_x >= max_base_x) {
                    Mem.set(dst, dstPos + x, top[topPos + max_base_x], width - x);
                    break;
                }
                int val = top[topPos + top_base_x] * (32 - shift) + top[topPos + top_base_x + 1] * shift;
                dst[dstPos + x] = D.RightShiftWithRounding(val, 5);
                top_base_x += base_step;
            } while (++x < width);
            dstPos += stride;
            top_x += xstep;
        } while (++y < height);
    }

    static void PredDirectionalZone2(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int width, int height, int xstep, int ystep, boolean upsampled_top, boolean upsampled_left) {
        if (debug) {
            LogWriter.writeLog("PredDirectionalZone2");
        }
        int upsample_top_shift = upsampled_top ? 1 : 0;
        int upsample_left_shift = upsampled_left ? 1 : 0;
        int scale_bits_x = 6 - upsample_top_shift;
        int scale_bits_y = 6 - upsample_left_shift;
        int min_base_x = -(1 << upsample_top_shift);
        int base_step_x = 1 << upsample_top_shift;
        int y = 0;
        int top_x = -xstep;
        do {
            int top_base_x = top_x >> scale_bits_x;
            int left_y = (y << 6) - ystep;
            int x = 0;
            do {
                int val;
                if (top_base_x >= min_base_x) {
                    int shift = (top_x * (1 << upsample_top_shift) & 0x3F) >> 1;
                    val = top[topPos + top_base_x] * (32 - shift) + top[topPos + top_base_x + 1] * shift;
                } else {
                    int left_base_y = left_y >> scale_bits_y;
                    int shift = (left_y * (1 << upsample_left_shift) & 0x3F) >> 1;
                    val = left[leftPos + left_base_y] * (32 - shift) + left[leftPos + left_base_y + 1] * shift;
                }
                dst[dstPos + x] = D.RightShiftWithRounding(val, 5);
                top_base_x += base_step_x;
                left_y -= ystep;
            } while (++x < width);
            top_x -= xstep;
            dstPos += stride;
        } while (++y < height);
    }

    static void PredDirectionalZone3(int[] dst, int dstPosGiven, int stride, int[] left, int leftPos, int width, int height, int ystep, boolean upsampled_left) {
        if (debug) {
            LogWriter.writeLog("PredDirectionalZone3");
        }
        int upsample_shift = upsampled_left ? 1 : 0;
        int scale_bits = 6 - upsample_shift;
        int base_step = 1 << upsample_shift;
        int left_y = ystep;
        int x = 0;
        do {
            int dstPos = dstPosGiven;
            int left_base_y = left_y >> scale_bits;
            int y = 0;
            do {
                int shift = (left_y << upsample_shift & 0x3F) >> 1;
                int val = left[leftPos + left_base_y] * (32 - shift) + left[leftPos + left_base_y + 1] * shift;
                dst[dstPos + x] = D.RightShiftWithRounding(val, 5);
                dstPos += stride;
                left_base_y += base_step;
            } while (++y < height);
            left_y += ystep;
        } while (++x < width);
    }

    static void FilterIntraPredictor(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int pred, int width, int height) {
        if (debug) {
            LogWriter.writeLog("FilterIntraPredictor");
        }
        int kMaxPixel = 255;
        int[][] buffer = new int[3][33];
        Mem.cpy(buffer[0], 0, top, topPos - 1, width + 1);
        int row0 = 0;
        int row2 = 2;
        int ystep = 1;
        int y = 0;
        do {
            buffer[1][0] = left[leftPos + y];
            buffer[row2][0] = left[leftPos + y + 1];
            int x = 1;
            do {
                int p0 = buffer[row0][x - 1];
                int p1 = buffer[row0][x + 0];
                int p2 = buffer[row0][x + 1];
                int p3 = buffer[row0][x + 2];
                int p4 = buffer[row0][x + 3];
                int p5 = buffer[1][x - 1];
                int p6 = buffer[row2][x - 1];
                for (int i = 0; i < 8; ++i) {
                    int xoffset = i & 3;
                    int yoffset = (i >> 2) * ystep;
                    int value = D.kFilterIntraTaps[pred][i][0] * p0 + D.kFilterIntraTaps[pred][i][1] * p1 + D.kFilterIntraTaps[pred][i][2] * p2 + D.kFilterIntraTaps[pred][i][3] * p3 + D.kFilterIntraTaps[pred][i][4] * p4 + D.kFilterIntraTaps[pred][i][5] * p5 + D.kFilterIntraTaps[pred][i][6] * p6;
                    buffer[1 + yoffset][x + xoffset] = D.Clip3(D.RightShiftWithRounding(value, 4), 0, kMaxPixel);
                }
            } while ((x += 4) < width);
            Mem.cpy(dst, dstPos, buffer[1], 1, width);
            Mem.cpy(dst, dstPos += stride, buffer[row2], 1, width);
            dstPos += stride;
            row0 ^= 2;
            row2 ^= 2;
            ystep = -ystep;
        } while ((y += 2) < height);
    }

    static void Smooth(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("Smooth");
        }
        int top_right = top[topPos + bw - 1];
        int bottom_left = left[leftPos + bh - 1];
        int[] weights_x = kSmoothWeights;
        int wxPos = bw - 4;
        int[] weights_y = kSmoothWeights;
        int wyPos = bh - 4;
        int scale_value = 256;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                long pred = weights_y[wyPos + y] * top[topPos + x];
                pred += (long)(weights_x[wxPos + x] * left[leftPos + y]);
                pred += (long)((scale_value - weights_y[wyPos + y] & 0xFF) * bottom_left);
                dst[dstPos + x] = D.RightShiftWithRounding(pred += (long)((scale_value - weights_x[wxPos + x] & 0xFF) * top_right), 9);
            }
            dstPos += stride;
        }
    }

    static void SmoothVertical(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("SmoothVertical");
        }
        int bottom_left = left[leftPos + bh - 1];
        int[] weights_y = kSmoothWeights;
        int wyPos = bh - 4;
        int scale_value = 256;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                long pred = weights_y[wyPos + y] * top[topPos + x];
                dst[dstPos + x] = D.RightShiftWithRounding(pred += (long)((scale_value - weights_y[wyPos + y] & 0xFF) * bottom_left), 8);
            }
            dstPos += stride;
        }
    }

    static void SmoothHorizontal(int[] dst, int dstPos, int stride, int[] top, int topPos, int[] left, int leftPos, int bw, int bh) {
        if (debug) {
            LogWriter.writeLog("SmoothHorizontal");
        }
        int top_right = top[topPos + bw - 1];
        int[] weights_x = kSmoothWeights;
        int wxPos = bw - 4;
        int scale_value = 256;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                long pred = weights_x[wxPos + x] * left[leftPos + y];
                dst[dstPos + x] = D.RightShiftWithRounding(pred += (long)((scale_value - weights_x[wxPos + x] & 0xFF) * top_right), 8);
            }
            dstPos += stride;
        }
    }
}

