/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.common;

import com.idrsolutions.image.avif.common.Mem;

class Intra {
    Intra() {
    }

    static void v_predictor(int[] dst, int dstPos, int stride, int bw, int bh, int[] above, int abovePos) {
        for (int r = 0; r < bh; ++r) {
            Mem.cpy(dst, dstPos, above, abovePos, bw);
            dstPos += stride;
        }
    }

    static void h_predictor(int[] dst, int dstPos, int stride, int bw, int bh, int[] left) {
        for (int r = 0; r < bh; ++r) {
            Mem.set(dst, dstPos, left[r], bw);
            dstPos += stride;
        }
    }

    static int abs_diff(int a, int b) {
        return a > b ? a - b : b - a;
    }

    static int paeth_predictor_single(int left, int top, int top_left) {
        int base = top + left - top_left;
        int p_left = Intra.abs_diff(base, left);
        int p_top = Intra.abs_diff(base, top);
        int p_top_left = Intra.abs_diff(base, top_left);
        return p_left <= p_top && p_left <= p_top_left ? left : (p_top <= p_top_left ? top : top_left);
    }

    static void paeth_predictor(int[] dst, int dstPos, int stride, int bw, int bh, int[] above, int abovePos, int[] left, int leftPos) {
        int ytop_left = above[abovePos - 1];
        for (int r = 0; r < bh; ++r) {
            for (int c = 0; c < bw; ++c) {
                dst[dstPos + c] = Intra.paeth_predictor_single(left[leftPos + r], above[abovePos + c], ytop_left);
            }
            dstPos += stride;
        }
    }

    static int divide_round(int value, int bits) {
        return value + (1 << bits - 1) >>> bits;
    }

    static void dc_128_predictor(int[] dst, int dstPos, int stride, int bw, int bh) {
        for (int r = 0; r < bh; ++r) {
            Mem.set(dst, dstPos, 128, bw);
            dstPos += stride;
        }
    }
}

