/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.common;

import org.jpedal.utils.LogWriter;

public class BitReader {
    long state;
    int bits_left;
    int error;
    int ptr;
    int ptr_start;
    int ptr_end;
    byte[] data = null;

    BitReader(byte[] data) {
        this.data = data;
        this.ptr = 0;
        this.ptr_start = 0;
        this.ptr_end = data.length;
        this.state = 0L;
        this.bits_left = 0;
        this.error = 0;
    }

    void refill(int n) {
        long ss = 0L;
        do {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
                if (ss != 0L) break;
                return;
            }
            ss = ss << 8 | (long)(this.data[this.ptr++] & 0xFF);
            this.bits_left += 8;
        } while (n > this.bits_left);
        this.state |= ss << 64 - this.bits_left;
    }

    int aom_rb_read_bit() {
        if (this.bits_left == 0) {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
            } else {
                long ss = this.data[this.ptr++] & 0xFF;
                this.bits_left = 7;
                this.state = ss << 57;
                return (int)(ss >>> 7);
            }
        }
        long ss = this.state;
        --this.bits_left;
        this.state = ss << 1;
        return (int)(ss >>> 63);
    }

    int aom_rb_read_literal(int n) {
        if (n > this.bits_left) {
            this.refill(n);
        }
        long ss = this.state;
        this.bits_left -= n;
        this.state = ss << n;
        return (int)(ss >>> (int)(64L - (long)n));
    }

    int aom_rb_read_unsigned_literal(int n) {
        return this.aom_rb_read_literal(n);
    }

    int aom_rb_read_inv_signed_literal(int bits) {
        int nbits = 8 - bits - 1;
        int value = this.aom_rb_read_literal(bits + 1) << nbits;
        LogWriter.writeLog("need testing bitreader");
        return value >> nbits;
    }

    int aom_rb_read_uvlc() {
        int num_zeros = 0;
        while (this.aom_rb_read_bit() == 0) {
            if (++num_zeros <= 31) continue;
            return 0;
        }
        if (num_zeros != 0) {
            return this.aom_rb_read_literal(num_zeros) + (1 << num_zeros) - 1;
        }
        return 0;
    }

    long get_uleb128() {
        int more;
        long val = 0L;
        int i = 0;
        do {
            int v = this.aom_rb_read_literal(8);
            more = v & 0x80;
            val |= (long)(v & 0x7F) << i;
        } while (more != 0 && (i += 7) < 56);
        return val;
    }

    private static int FloorLog2(int x) {
        int s = 0;
        while (x != 0) {
            x >>= 1;
            ++s;
        }
        return s - 1;
    }

    private int aom_rb_read_primitive_quniform(int max) {
        int l = BitReader.FloorLog2(max) + 1;
        int m = (1 << l) - max;
        int v = this.aom_rb_read_literal(l - 1);
        return v < m ? v : (v << 1) - m + this.aom_rb_read_bit();
    }

    private static int inv_recenter(int r, int v) {
        if (v > r << 1) {
            return v;
        }
        if ((v & 1) == 0) {
            return (v >> 1) + r;
        }
        return r - (v + 1 >> 1);
    }

    private int get_bits_subexp_u(int ref, int n) {
        int v = 0;
        int i = 0;
        while (true) {
            int b;
            int n2 = b = i != 0 ? 3 + i - 1 : 3;
            if (n < v + 3 * (1 << b)) {
                v += this.aom_rb_read_primitive_quniform(n - v + 1);
                break;
            }
            if (this.aom_rb_read_bit() == 0) {
                v += this.aom_rb_read_literal(b);
                break;
            }
            v += 1 << b;
            ++i;
        }
        return ref * 2 <= n ? BitReader.inv_recenter(ref, v) : n - BitReader.inv_recenter(n - ref, v);
    }

    int aom_rb_read_signed_primitive_refsubexpfin(int ref, int n) {
        return this.get_bits_subexp_u(ref + (1 << n), 2 << n) - (1 << n);
    }
}

