/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataByteLittle;

public final class ImageTypeFinder {
    private static final int HEVC = 943015475;
    private static final int HEIC = 943012147;
    private static final int HEIX = 943012168;
    private static final int AVIF = 826685750;
    private static final int RIFF = 572069398;
    private static final int WEBP = 655692320;

    private static boolean isAvif(byte[] data) {
        if (data[4] != 102 || data[5] != 116 || data[6] != 121 || data[7] != 112) {
            return false;
        }
        int brand = ImageTypeFinder.generateChecksum(data, 8);
        if (brand == 826685750) {
            return true;
        }
        brand = ImageTypeFinder.generateChecksum(data, 16);
        if (brand == 826685750) {
            return true;
        }
        brand = ImageTypeFinder.generateChecksum(data, 20);
        return brand == 826685750;
    }

    private static boolean isHeic(byte[] data) {
        if (data[4] != 102 || data[5] != 116 || data[6] != 121 || data[7] != 112) {
            return false;
        }
        int brand = ImageTypeFinder.generateChecksum(data, 8);
        if (brand == 943012147 || brand == 943012168 || brand == 943015475) {
            return true;
        }
        brand = ImageTypeFinder.generateChecksum(data, 16);
        if (brand == 943012147 || brand == 943012168 || brand == 943015475) {
            return true;
        }
        brand = ImageTypeFinder.generateChecksum(data, 20);
        return brand == 943012147 || brand == 943012168 || brand == 943015475;
    }

    private static ImageFormat getHevc(byte[] data) {
        int brand = ImageTypeFinder.generateChecksum(data, 8);
        if (brand == 943015475) {
            return ImageFormat.HEIC_MULTI_FRAME_IMAGE;
        }
        brand = ImageTypeFinder.generateChecksum(data, 20);
        if (brand == 943015475) {
            return ImageFormat.HEIC_MULTI_FRAME_IMAGE;
        }
        return ImageFormat.HEIC_IMAGE;
    }

    private ImageTypeFinder() {
    }

    private static boolean isPNG(byte[] data) {
        byte[] pngMark = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < pngMark.length; ++i) {
            if (data[i] == pngMark[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isTiff(byte[] data) {
        return data[0] == 73 && data[1] == 73 || data[0] == 77 && data[1] == 77;
    }

    private static boolean isJpeg(byte[] data) {
        return (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 216;
    }

    private static boolean isJpegXL(byte[] data) {
        if ((data[0] & 0xFF) == 255 && data[1] == 10) {
            return true;
        }
        byte[] CONTAINER_SIGNATURE = new byte[]{0, 0, 0, 12, 74, 88, 76, 32, 13, 10, -121, 10};
        for (int i = 0; i < CONTAINER_SIGNATURE.length; ++i) {
            if (data[i] == CONTAINER_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isJpeg2000(byte[] data) {
        if ((data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 79) {
            return true;
        }
        DataByteBig buff = new DataByteBig(data);
        int signLen = buff.getU32();
        int signType = buff.getU32();
        return signLen == 12 && signType == 1783636000;
    }

    private static boolean isGif(byte[] data) {
        return data[0] == 71 && data[1] == 73 && data[2] == 70 && data[3] == 56 && (data[4] == 55 || data[4] == 57) && data[5] == 97;
    }

    private static ImageFormat getAnimatedGif(byte[] data) {
        DataByteLittle dbl = new DataByteLittle(data);
        dbl.skip(6);
        int w = dbl.getU16();
        int h = dbl.getU16();
        int mcrp = dbl.getU8();
        if (mcrp >> 7 == 1) {
            int bp = 1 << (mcrp & 0xF) + 1;
            for (int i = 0; i < bp; ++i) {
                dbl.skip(3);
            }
        }
        int imageCount = 0;
        boolean canRead = true;
        while (canRead && dbl.getPosition() < dbl.getLength()) {
            int separator = dbl.getU8();
            switch (separator) {
                case 33: {
                    int size;
                    dbl.skip(1);
                    do {
                        size = dbl.getU8();
                        dbl.skip(size);
                    } while (size != 0);
                    break;
                }
                case 44: {
                    dbl.skip(8);
                    int mip = dbl.getU8();
                    boolean lctFlag = (mip & 0x80) != 0;
                    int lctSize = 2 << (mip & 7);
                    if (lctFlag) {
                        for (int i = 0; i < lctSize; ++i) {
                            dbl.skip(3);
                        }
                    }
                    int lzLen = dbl.getU8();
                    int MAXLEN = 4096;
                    int[] prefix = new int[4096];
                    byte[] block = new byte[256];
                    int clear = 1 << lzLen;
                    int eoi = clear + 1;
                    int avail = clear + 2;
                    int old = -1;
                    int cLen = lzLen + 1;
                    int cMask = (1 << cLen) - 1;
                    int i = 0;
                    int bi = 0;
                    int top = 0;
                    int count = 0;
                    int bits = 0;
                    int datum = 0;
                    while (i < w * h) {
                        if (top == 0) {
                            if (bits < cLen) {
                                if (count == 0) {
                                    int cc = 0;
                                    int blockSize = dbl.getU8();
                                    if (blockSize > 0) {
                                        cc = blockSize;
                                        dbl.moveTo(dbl.getPosition());
                                        for (int j = 0; j < cc; ++j) {
                                            block[j] = (byte)dbl.getU8();
                                        }
                                    }
                                    if ((count = cc) <= 0) break;
                                    bi = 0;
                                }
                                datum += (block[bi] & 0xFF) << bits;
                                bits += 8;
                                ++bi;
                                --count;
                                continue;
                            }
                            int code = datum & cMask;
                            datum >>= cLen;
                            bits -= cLen;
                            if (code > avail || code == eoi) break;
                            if (code == clear) {
                                cLen = lzLen + 1;
                                cMask = (1 << cLen) - 1;
                                avail = clear + 2;
                                old = -1;
                                continue;
                            }
                            if (old == -1) {
                                ++top;
                                old = code;
                                continue;
                            }
                            int cur = code;
                            if (code == avail) {
                                ++top;
                                code = old;
                            }
                            while (code > clear) {
                                ++top;
                                code = prefix[code];
                            }
                            if (avail >= 4096) break;
                            prefix[avail] = old;
                            ++top;
                            if ((++avail & cMask) == 0 && avail < 4096) {
                                ++cLen;
                                cMask += avail;
                            }
                            old = cur;
                        }
                        --top;
                        ++i;
                    }
                    ++imageCount;
                    break;
                }
                default: {
                    canRead = false;
                }
            }
            if (imageCount <= true) continue;
            return ImageFormat.ANIMATED_GIF;
        }
        return ImageFormat.GIF_IMAGE;
    }

    private static boolean isPsd(byte[] data) {
        DataByteBig buff = new DataByteBig(data);
        int signLen = buff.getU32();
        return signLen == 943870035;
    }

    private static boolean isWebp(byte[] data) {
        int r = ImageTypeFinder.generateChecksum(data, 0);
        int w = ImageTypeFinder.generateChecksum(data, 8);
        return r == 572069398 && w == 655692320;
    }

    private static boolean isBmp(byte[] data) {
        int TYPE_BM = 19778;
        int type = data[0] & 0xFF | (data[1] & 0xFF) << 8;
        return type == 19778;
    }

    private static boolean isDicom(byte[] data) {
        return data.length > 132 && data[128] == 68 && data[129] == 73 && data[130] == 67 && data[131] == 77;
    }

    private static boolean isSGI(byte[] data) {
        int sgi474 = data[0] << 8 | data[1] & 0xFF;
        byte format = data[2];
        return sgi474 == 474 && (format == 0 || format == 1);
    }

    private static boolean isWMF(byte[] data) {
        DataByteLittle reader = new DataByteLittle(data);
        int key = reader.getU32();
        return key == -1698247209;
    }

    private static boolean isEMF(byte[] data) {
        DataByteLittle reader = new DataByteLittle(data);
        int key = reader.getU32();
        return key == 1;
    }

    public static ImageFormat getImageType(byte[] test) {
        if (ImageTypeFinder.isAvif(test)) {
            return ImageFormat.AVIF_IMAGE;
        }
        if (ImageTypeFinder.isBmp(test)) {
            return ImageFormat.BMP_IMAGE;
        }
        if (ImageTypeFinder.isDicom(test)) {
            return ImageFormat.DICOM_IMAGE;
        }
        if (ImageTypeFinder.isEMF(test)) {
            return ImageFormat.EMF_IMAGE;
        }
        if (ImageTypeFinder.isGif(test)) {
            return ImageTypeFinder.getAnimatedGif(test);
        }
        if (ImageTypeFinder.isHeic(test)) {
            return ImageTypeFinder.getHevc(test);
        }
        if (ImageTypeFinder.isJpeg(test)) {
            return ImageFormat.JPEG_IMAGE;
        }
        if (ImageTypeFinder.isJpegXL(test)) {
            return ImageFormat.JPEGXL_IMAGE;
        }
        if (ImageTypeFinder.isJpeg2000(test)) {
            return ImageFormat.JPEG2000_IMAGE;
        }
        if (ImageTypeFinder.isPNG(test)) {
            return ImageFormat.PNG_IMAGE;
        }
        if (ImageTypeFinder.isPsd(test)) {
            return ImageFormat.PSD_IMAGE;
        }
        if (ImageTypeFinder.isTiff(test)) {
            return ImageFormat.TIFF_IMAGE;
        }
        if (ImageTypeFinder.isWebp(test)) {
            return ImageFormat.WEBP_IMAGE;
        }
        if (ImageTypeFinder.isSGI(test)) {
            return ImageFormat.SGI_IMAGE;
        }
        if (ImageTypeFinder.isWMF(test)) {
            return ImageFormat.WMF_IMAGE;
        }
        return ImageFormat.UNSUPPORTED_IMAGE;
    }

    private static int generateChecksum(byte[] raw, int keyStart) {
        int id = 0;
        int x = 0;
        for (int i2 = 3; i2 > -1; --i2) {
            int next = raw[keyStart + i2];
            id += (next -= 48) << x;
            x += 8;
        }
        return id;
    }
}

