/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageWriterSpi;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.imageio.ImageIOSupport;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;

public class JPEG2000ImageWriterSpi
extends JDeliImageWriterSpi {
    private static final String[] names = new String[]{"JPEG2000"};
    private static final String[] suffixes = new String[]{"jpx", "jp2"};
    private static final String[] MIMETypes = new String[]{"image/jpeg2000"};

    public JPEG2000ImageWriterSpi() {
        super(names, suffixes, MIMETypes);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageType) {
        int bands = imageType.getNumBands();
        return bands == 1 || bands == 2 || bands == 3 || bands == 4;
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG2000 Image Writer";
    }

    @Override
    public String[] getFormatNames() {
        if (this.isRegistered()) {
            return suffixes;
        }
        return new String[0];
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return super.createWriterInstance((Object)OutputFormat.JPEG2000);
    }

    @Override
    protected boolean isRegistered() {
        return ImageIOSupport.isregisteredWriter(OutputFormat.valueOf(names[0]));
    }
}

