/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageReaderSpi;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JPEG2000ImageReaderSpi
extends JDeliImageReaderSpi {
    private static final String[] names = new String[]{"JPEG2000"};
    private static final String[] suffixes = new String[]{"jpx", "jp2"};
    private static final String[] MIMETypes = new String[]{"image/jpeg2000"};

    public JPEG2000ImageReaderSpi() {
        super(names, suffixes, MIMETypes);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (this.isRegistered()) {
            ImageInputStream input = (ImageInputStream)source;
            byte[] b = new byte[140];
            input.read(b);
            return ImageTypeFinder.getImageType(b).equals((Object)ImageFormat.JPEG2000_IMAGE);
        }
        return false;
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG2000 JDeli Image Reader";
    }

    public static boolean isFormatSupported(String extension) {
        return "JPEG2000".equalsIgnoreCase(extension);
    }

    @Override
    public ImageReader createReaderInstance() throws IOException {
        return this.createReaderInstance("jpx");
    }
}

