/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliMetadata;
import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.metadata.Exif;
import com.idrsolutions.imageio.ImageIOSupport;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class JDeliImageReader
extends ImageReader {
    private ImageInputStream stream;
    private BufferedImage image;
    private final String format;
    private int currentImageIndex = -1;
    private int currentThumbnailIndex = -1;
    final JDeliMetadata metadata = new JDeliMetadata();
    private byte[] bytes;
    private BufferedImage tn;
    private final ImageReader delegate;

    public JDeliImageReader(ImageReaderSpi jdeliSpi, String format, ImageReader delegate) {
        super(jdeliSpi);
        this.format = format;
        this.delegate = delegate;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetaData) {
        if (File.class.equals(input.getClass())) {
            try {
                this.stream = new FileImageInputStream((File)input);
                if (this.delegate != null) {
                    this.delegate.setInput(new FileImageInputStream((File)input), seekForwardOnly, ignoreMetaData);
                }
            }
            catch (IOException e) {
                LogWriter.writeLog("Failed to create stream from file : " + e.getMessage());
            }
        } else if (URL.class.equals(input.getClass())) {
            try {
                this.stream = ImageIO.createImageInputStream(((URL)input).openStream());
                if (this.delegate != null) {
                    this.delegate.setInput(ImageIO.createImageInputStream(((URL)input).openStream()), seekForwardOnly, ignoreMetaData);
                }
            }
            catch (IOException e) {
                LogWriter.writeLog("Failed to create stream from url : " + e.getMessage());
            }
        } else {
            this.stream = (ImageInputStream)input;
            if (this.delegate != null) {
                this.delegate.setInput(input, seekForwardOnly, ignoreMetaData);
            }
        }
        this.getByteArray();
        this.seekForwardOnly = seekForwardOnly;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        if (!allowSearch) {
            return -1;
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getWidth(int imageIndex) throws IOException {
        int w = 0;
        if (this.delegate != null) return this.delegate.getWidth(imageIndex);
        this.getByteArray();
        try {
            Rectangle rectangle = JDeli.readDimension(this.bytes);
            if (rectangle == null) return w;
            return rectangle.width;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getHeight(int imageIndex) throws IOException {
        int h = 0;
        if (this.delegate != null) return this.delegate.getHeight(imageIndex);
        this.getByteArray();
        try {
            Rectangle rectangle = JDeli.readDimension(this.bytes);
            if (rectangle == null) return h;
            return rectangle.height;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(this.image);
        l.add(imageType);
        this.currentImageIndex = imageIndex;
        return l.iterator();
    }

    @Override
    public String getFormatName() {
        return this.format;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return this.delegate.getStreamMetadata();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.delegate.getImageMetadata(imageIndex);
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        if (this.currentImageIndex != imageIndex) {
            this.currentImageIndex = imageIndex;
        }
        try {
            if (this.bytes == null) {
                this.getByteArray();
            }
            if (this.format.equalsIgnoreCase(ImageIOSupport.InputFormat.HEIC.name())) {
                Exif exif = Exif.readExif(this.bytes);
                int size = exif.getIfdImages().size();
                return size != 0 ? size : 1;
            }
            if (this.format.equalsIgnoreCase(ImageIOSupport.InputFormat.JPEG.name())) {
                return 1;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return 0;
    }

    public void readMetadata() throws Exception {
        this.metadata.setMetadata(this.bytes);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        try {
            if (this.seekForwardOnly && this.currentImageIndex == 0) {
                ++this.minIndex;
            }
            if (this.currentImageIndex != imageIndex) {
                this.currentImageIndex = imageIndex;
                this.image = JDeli.read(this.bytes);
            } else if (this.image != null) {
                return this.image;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return this.image;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    private void getByteArray() {
        if (this.bytes == null) {
            try {
                int nRead;
                FastByteArrayOutputStream ba = new FastByteArrayOutputStream(8192);
                byte[] data = new byte[2048];
                while ((nRead = this.stream.read(data, 0, data.length)) != -1) {
                    ba.write(data, 0, nRead);
                }
                this.bytes = ba.toByteArray();
                this.stream.seek(0L);
            }
            catch (IOException ex) {
                LogWriter.writeLog("Failed to create output stream: " + ex.getMessage());
            }
        }
    }

    @Override
    public boolean hasThumbnails(int index) throws IOException {
        if (this.currentImageIndex != index) {
            this.currentImageIndex = index;
        }
        if (this.readerSupportsThumbnails()) {
            if (this.bytes == null) {
                this.getByteArray();
            }
            try {
                this.tn = JDeli.readEmbeddedThumbnail(this.bytes);
                return this.tn != null;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return false;
    }

    @Override
    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        if (!this.readerSupportsThumbnails()) {
            this.tn = this.delegate.readThumbnail(imageIndex, thumbnailIndex);
        } else {
            if (this.currentThumbnailIndex != thumbnailIndex || this.currentImageIndex != imageIndex) {
                this.currentThumbnailIndex = thumbnailIndex;
                this.currentImageIndex = imageIndex;
                this.tn = null;
            }
            if (this.tn == null) {
                if (this.bytes == null) {
                    this.getByteArray();
                }
                try {
                    this.tn = JDeli.readEmbeddedThumbnail(this.bytes);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        return this.tn;
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return this.format.equalsIgnoreCase("heic") || this.format.equalsIgnoreCase("heif") || this.format.equalsIgnoreCase("jpeg") || this.format.equalsIgnoreCase("jpg");
    }
}

