/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions;

import com.idrsolutions.JDeliImageReaderSpi;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class HEICImageReaderSpi
extends JDeliImageReaderSpi {
    private static final String[] names = new String[]{"HEIC", "HEIF"};
    private static final String[] suffixes = new String[]{"heic", "heif"};
    private static final String[] MIMETypes = new String[]{"image/heic"};

    public HEICImageReaderSpi() {
        super(names, suffixes, MIMETypes);
    }

    @Override
    public String getDescription(Locale locale) {
        return "HEIC JDeli Image Reader";
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (this.isRegistered()) {
            ImageInputStream input = (ImageInputStream)source;
            byte[] b = new byte[140];
            input.read(b);
            return ImageTypeFinder.getImageType(b).equals((Object)ImageFormat.HEIC_IMAGE);
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance() throws IOException {
        return this.createReaderInstance("heic");
    }
}

