/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.libloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.jalbum.libloader.Platform;

public class LibLoader {
    public static void loadLibrary(String libBaseName, Class baseClass) {
        String os;
        String string = Platform.isWindows() ? "win64" : (Platform.isLinux() ? "linux64" : (os = Platform.isMac() ? "macos64" : null));
        if (os == null) {
            throw new UnsupportedOperationException("Unsupported operating system.");
        }
        String prefix = Platform.isWindows() ? "" : (Platform.isLinux() ? "lib" : (Platform.isMac() ? "lib" : null));
        String libName = prefix + libBaseName;
        String extension = Platform.isWindows() ? ".dll" : (Platform.isLinux() ? ".so" : (Platform.isMac() ? ".dylib" : ""));
        String resourcePath = "/native/" + os + "/" + System.getProperty("os.arch") + "/" + libName + extension;
        InputStream inputStream = baseClass.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new RuntimeException("Native library not found: " + resourcePath);
        }
        try {
            File tempFile = File.createTempFile(libName, extension);
            tempFile.deleteOnExit();
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

