/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReader;
import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegUtilities;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.libloader.LibLoader;
import org.libjpegturbo.turbojpeg.TJLoader;

public class TurboJpegImageReaderSpi
extends ImageReaderSpi {
    static final String NATIVE_LIB_NAME = "turbojpeg";
    private static final Logger LOGGER;
    public static final Class[] SUPPORTED_CLASSES;
    public static final String[] names;
    private static final String[] suffixes;
    private static final String[] MIMETypes;
    private static final String readerClassName = "it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReader";
    private static final String[] writerSpiNames;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;
    private boolean registered = false;
    private static Method readerFormatNamesMethod;

    public TurboJpegImageReaderSpi() {
        super("jAlbum", "0.1", names, suffixes, MIMETypes, readerClassName, SUPPORTED_CLASSES, writerSpiNames, false, null, null, null, null, true, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.registered) {
            return;
        }
        this.registered = true;
        boolean turboJpegavailable = TurboJpegUtilities.isTurboJpegAvailable();
        if (turboJpegavailable) {
            this.dePrioritizeOtherSpis(registry, category);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deregistering " + this.getClass().getName());
            }
            registry.deregisterServiceProvider(this);
        }
    }

    private void dePrioritizeOtherSpis(ServiceRegistry registry, Class category) {
        if (registry == null) {
            return;
        }
        try {
            Iterator<ImageReaderSpi> iter = registry.getServiceProviders(ImageReaderSpi.class, new ContainsFilter(readerFormatNamesMethod, "JPEG"), true);
            while (iter.hasNext()) {
                ImageReaderSpi spi = iter.next();
                if (spi.getClass().equals(this.getClass())) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Deprioritizing " + String.valueOf(spi));
                }
                registry.setOrdering(category, this, spi);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void onDeregistration(ServiceRegistry registry, Class<?> category) {
        super.onDeregistration(registry, category);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getSimpleName() + " being deregistered");
        }
        this.registered = false;
    }

    @Override
    public String getDescription(Locale locale) {
        return "GeoSolutions TurboJPEG Reader";
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("canDecodeInput");
        }
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        int byte1 = iis.read();
        int byte2 = iis.read();
        if (byte1 != 255 || byte2 != 216) {
            iis.reset();
            return false;
        }
        block0: while (true) {
            byte1 = iis.read();
            byte2 = iis.read();
            if (byte1 != 255 || byte2 == 218) break;
            if (byte2 == 194) {
                iis.reset();
                return false;
            }
            if (byte2 >= 192 && byte2 <= 195) break;
            int length = iis.read() << 8;
            length += iis.read();
            length -= 2;
            while (true) {
                if (length <= 0) continue block0;
                length -= iis.skipBytes(length);
            }
            break;
        }
        iis.reset();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("canDecodeInput -> True");
        }
        return true;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new TurboJpegImageReader(this);
    }

    static {
        block2: {
            TJLoader.onLoad(() -> LibLoader.loadLibrary(NATIVE_LIB_NAME, TurboJpegImageReader.class));
            LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.turbojpeg");
            SUPPORTED_CLASSES = new Class[]{ImageInputStream.class, byte[].class};
            names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
            suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
            MIMETypes = new String[]{"image/jpeg"};
            writerSpiNames = new String[]{"it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriterSpi"};
            nativeImageMetadataFormatName = null;
            nativeImageMetadataFormatClassName = null;
            extraImageMetadataFormatNames = new String[]{null};
            extraImageMetadataFormatClassNames = new String[]{null};
            try {
                readerFormatNamesMethod = ImageReaderSpi.class.getMethod("getFormatNames", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
    }

    static class ContainsFilter
    implements ServiceRegistry.Filter {
        Method method;
        String name;

        public ContainsFilter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        @Override
        public boolean filter(Object elt) {
            try {
                return ContainsFilter.contains((String[])this.method.invoke(elt, new Object[0]), this.name);
            }
            catch (Exception e) {
                return false;
            }
        }

        private static boolean contains(String[] names, String name) {
            for (int i = 0; i < names.length; ++i) {
                if (!name.equalsIgnoreCase(names[i])) continue;
                return true;
            }
            return false;
        }
    }
}

