/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReadParam;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.util.Profiler;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

public class TurboJpegImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.turbojpeg");
    private int INITIAL_JPG_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_READ_BUFFER_SIZE = 4096;
    private static ColorSpace sRGB = ColorSpace.getInstance(1000);
    private int width = -1;
    private int height = -1;
    private byte[] data = null;
    private ImageInputStream iis = null;
    private static int EXTERNAL_FLAGS = -1;
    private int flags = 0;
    private int subsamp;
    private ImageReader delegate;
    TJDecompressor decompressor;
    private static final List<ImageTypeSpecifier> FIXEDIMGETYPES = Collections.unmodifiableList(Arrays.asList(ImageTypeSpecifier.createFromBufferedImageType(1), ImageTypeSpecifier.createFromBufferedImageType(2), ImageTypeSpecifier.createFromBufferedImageType(5), ImageTypeSpecifier.createFromBufferedImageType(6), ImageTypeSpecifier.createFromBufferedImageType(10)));

    private void assertDecompressorLoaded() {
        if (this.decompressor == null) {
            try {
                this.decompressor = new TJDecompressor();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize native decompressor", e);
            }
        }
    }

    public TurboJpegImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getNumImages(allowSearch);
        }
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getWidth(imageIndex);
        }
        this.checkIndex(imageIndex);
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getHeight(imageIndex);
        }
        this.checkIndex(imageIndex);
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getImageTypes(imageIndex);
        }
        this.checkIndex(imageIndex);
        return FIXEDIMGETYPES.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getStreamMetadata();
        }
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getImageMetadata(imageIndex);
        }
        return null;
    }

    private static int allowedDenominators(int number) {
        if (number <= 2) {
            return number;
        }
        if (number > 8) {
            return 8;
        }
        int result = 2;
        while (result * 2 <= number) {
            result *= 2;
        }
        return result;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        if (this.delegate != null) {
            return this.delegate.getDefaultReadParam();
        }
        return new TurboJpegImageReadParam();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (this.delegate != null) {
            return this.delegate.read(imageIndex, param);
        }
        this.assertDecompressorLoaded();
        this.checkIndex(imageIndex);
        if (this.data == null) {
            throw new IllegalArgumentException("Missing data array");
        }
        try {
            BufferedImage bi;
            block13: {
                this.decompressor.setSourceImage(this.data, this.data.length);
                int width = this.decompressor.getWidth();
                int height = this.decompressor.getHeight();
                TJScalingFactor xScalingFactor = new TJScalingFactor(1, TurboJpegImageReader.allowedDenominators(param.getSourceXSubsampling()));
                this.decompressor.setScalingFactor(xScalingFactor);
                if (param.getSourceRegion() != null) {
                    this.decompressor.setCroppingRegion(param.getSourceRegion());
                }
                bi = this.decompressor.decompress8(5);
                try {
                    byte[] profileBytes = this.decompressor.getICCProfile();
                    if (profileBytes == null) break block13;
                    ICC_Profile profile = ICC_Profile.getInstance(profileBytes);
                    ICC_ColorSpace colorSpace = new ICC_ColorSpace(profile);
                    ComponentColorModel colorModel = new ComponentColorModel(colorSpace, bi.getColorModel().getComponentSize(), bi.getColorModel().hasAlpha(), bi.getColorModel().isAlphaPremultiplied(), bi.getColorModel().getTransparency(), bi.getColorModel().getTransferType());
                    WritableRaster raster = bi.getRaster();
                    bi = new BufferedImage(colorModel, raster, false, null);
                    if (!(param instanceof TurboJpegImageReadParam) || !((TurboJpegImageReadParam)param).isApplyColorProfile() || colorSpace.equals(sRGB)) break block13;
                    ColorConvertOp colorConvert = new ColorConvertOp(colorSpace, sRGB, null);
                    try (Profiler.Sample _s3 = Profiler.profile((String)"Apply color profile");){
                        BufferedImage convertedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 5);
                        bi = colorConvert.filter(bi, convertedImage);
                    }
                }
                catch (TJException tJException) {
                    // empty catch block
                }
            }
            return bi;
        }
        catch (Exception e) {
            throw new IOException("Exception while decompressing:", e);
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (Thread.currentThread().getStackTrace()[2].getClassName().toLowerCase().contains("tiff")) {
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("JPEG");
            ImageReader reader = it.next();
            if (reader instanceof TurboJpegImageReader) {
                reader = it.next();
            }
            this.delegate = reader;
            this.delegate.setInput(input, seekForwardOnly, ignoreMetadata);
            return;
        }
        this.assertDecompressorLoaded();
        this.reset();
        this.ignoreMetadata = ignoreMetadata;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting input");
        }
        if (input instanceof ImageInputStream) {
            this.iis = (ImageInputStream)input;
        }
        try {
            if (input instanceof byte[]) {
                this.data = (byte[])input;
            } else {
                if (this.iis == null) {
                    throw new NullPointerException("The provided input is null!");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(this.INITIAL_JPG_BUFFER_SIZE);
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = this.iis.read(buffer))) {
                    baos.write(buffer, 0, n);
                }
                this.data = baos.toByteArray();
            }
            this.flags = EXTERNAL_FLAGS > 0 ? EXTERNAL_FLAGS : this.flags;
            this.decompressor.setSourceImage(this.data, this.data.length);
            this.width = this.decompressor.getWidth();
            this.height = this.decompressor.getHeight();
            this.subsamp = this.decompressor.get(4);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating jpegturbo decompressor: " + ex.getMessage(), ex);
        }
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.data = null;
        this.delegate = null;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("ImageIndex out of bound: " + imageIndex);
        }
    }

    @Override
    public void dispose() {
        try {
            this.reset();
        }
        finally {
            block9: {
                if (this.decompressor != null) {
                    try {
                        this.decompressor.close();
                        this.decompressor = null;
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block9;
                        LOGGER.fine("Exception occurred while closing the decompressor: " + ex.getLocalizedMessage());
                    }
                }
            }
        }
    }

    protected static String toString(ImageReadParam param) {
        StringBuilder sb = new StringBuilder();
        if (param == null) {
            sb.append("ImageReadParam is null");
        } else {
            BufferedImage bi;
            sb.append(param.getClass().getSimpleName()).append('[');
            sb.append(" srcXsub:").append(param.getSourceXSubsampling());
            sb.append(" srcYsub:").append(param.getSourceYSubsampling());
            sb.append(" subXoff:").append(param.getSubsamplingXOffset());
            sb.append(" subYoff:").append(param.getSubsamplingYOffset());
            sb.append(" srcRegion:").append(param.getSourceRegion());
            sb.append(" destOff:").append(param.getDestinationOffset());
            ImageTypeSpecifier its = param.getDestinationType();
            if (its != null) {
                sb.append(" its:").append(its.getSampleModel());
                if (its.getSampleModel() != null) {
                    sb.append(" its.sm.datatype:").append(its.getSampleModel().getDataType());
                    sb.append(" its.sm.numbands:").append(its.getSampleModel().getNumBands());
                }
            }
            if ((bi = param.getDestination()) != null) {
                sb.append(" bi.sm:").append(bi.getSampleModel());
                if (bi.getSampleModel() != null) {
                    sb.append(" bi.sm.datatype:").append(bi.getSampleModel().getDataType());
                    sb.append(" bi.sm.numbands:").append(bi.getSampleModel().getNumBands());
                }
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

