/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.com.google.ical.iter.Generator;
import biweekly.util.com.google.ical.iter.InstanceGenerators;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.iter.SingleValueGenerator;
import biweekly.util.com.google.ical.iter.ThrottledGenerator;
import biweekly.util.com.google.ical.util.DTBuilder;
import biweekly.util.com.google.ical.util.Predicate;
import biweekly.util.com.google.ical.util.TimeUtils;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.DateValueImpl;
import biweekly.util.com.google.ical.values.TimeValue;
import java.util.TimeZone;

final class RRuleIteratorImpl
implements RecurrenceIterator {
    private final Predicate<? super DateValue> condition;
    private final Generator instanceGenerator;
    private final ThrottledGenerator yearGenerator;
    private final Generator monthGenerator;
    private DateValue pendingUtc;
    private DTBuilder builder;
    private boolean done;
    private final DateValue dtStart;
    private final boolean canShortcutAdvance;
    private final TimeZone tzid;
    private static final DateValue MIN_DATE = new DateValueImpl(Integer.MIN_VALUE, 1, 1);
    private DateValue lastUtc_ = RRuleIteratorImpl.MIN_DATE;

    /*
     * Unable to fully structure code
     */
    RRuleIteratorImpl(DateValue dtStart, TimeZone tzid, Predicate<? super DateValue> condition, Generator instanceGenerator, ThrottledGenerator yearGenerator, Generator monthGenerator, Generator dayGenerator, Generator hourGenerator, Generator minuteGenerator, Generator secondGenerator, boolean canShortcutAdvance) {
        super();
        this.condition = condition;
        this.instanceGenerator = instanceGenerator;
        this.yearGenerator = yearGenerator;
        this.monthGenerator = monthGenerator;
        this.dtStart = dtStart;
        this.tzid = tzid;
        this.canShortcutAdvance = canShortcutAdvance;
        initWorkLimit = 1000;
        this.builder = new DTBuilder(dtStart);
        try {
            if (InstanceGenerators.skipSubDayGenerators(hourGenerator, minuteGenerator, secondGenerator)) {
                toInitialize = new Generator[]{yearGenerator, monthGenerator};
                this.builder.hour = ((SingleValueGenerator)hourGenerator).getValue();
                this.builder.minute = ((SingleValueGenerator)minuteGenerator).getValue();
                this.builder.second = ((SingleValueGenerator)secondGenerator).getValue();
            } else {
                toInitialize = new Generator[]{yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator};
            }
            i = 0;
            while (i != toInitialize.length) {
                block11: {
                    if (!toInitialize[i].generate(this.builder)) break block11;
                    ++i;
                    ** GOTO lbl-1000
                }
                if (--i < 0) {
                    this.done = true;
                } else lbl-1000:
                // 2 sources

                {
                    if (--initWorkLimit != 0) continue;
                    this.done = true;
                }
                break;
            }
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            this.done = true;
        }
        while (!this.done) {
            this.pendingUtc = this.generateInstance();
            if (this.pendingUtc == null) {
                this.done = true;
                break;
            }
            if (this.pendingUtc.compareTo(TimeUtils.toUtc(dtStart, tzid)) >= 0) {
                if (condition.apply(this.pendingUtc)) break;
                this.done = true;
                this.pendingUtc = null;
                break;
            }
            if (--initWorkLimit != 0) continue;
            this.done = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.pendingUtc == null) {
            this.fetchNext();
        }
        return this.pendingUtc != null;
    }

    @Override
    public DateValue next() {
        if (this.pendingUtc == null) {
            this.fetchNext();
        }
        DateValue next = this.pendingUtc;
        this.pendingUtc = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue dateUtc) {
        if (this.pendingUtc != null && dateUtc.compareTo(this.pendingUtc) <= 0) {
            return;
        }
        DateValue dateLocal = TimeUtils.fromUtc(dateUtc, this.tzid);
        if (dateLocal.compareTo(this.builder.toDate()) <= 0) {
            return;
        }
        this.pendingUtc = null;
        try {
            if (this.canShortcutAdvance) {
                if (this.builder.year < dateLocal.year()) {
                    do {
                        if (this.yearGenerator.generate(this.builder)) continue;
                        this.done = true;
                        return;
                    } while (this.builder.year < dateLocal.year());
                    while (!this.monthGenerator.generate(this.builder)) {
                        if (this.yearGenerator.generate(this.builder)) continue;
                        this.done = true;
                        return;
                    }
                }
                while (this.builder.year == dateLocal.year() && this.builder.month < dateLocal.month()) {
                    while (!this.monthGenerator.generate(this.builder)) {
                        if (this.yearGenerator.generate(this.builder)) continue;
                        this.done = true;
                        return;
                    }
                }
            }
            while (!this.done) {
                DateValue dUtc = this.generateInstance();
                if (dUtc == null) {
                    this.done = true;
                    return;
                }
                if (!this.condition.apply(dUtc)) {
                    this.done = true;
                    return;
                }
                if (dUtc.compareTo(dateUtc) < 0) continue;
                this.pendingUtc = dUtc;
                break;
            }
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            this.done = true;
        }
    }

    private void fetchNext() {
        if (this.pendingUtc != null || this.done) {
            return;
        }
        DateValue dUtc = this.generateInstance();
        if (dUtc == null || !this.condition.apply(dUtc)) {
            this.done = true;
            return;
        }
        this.pendingUtc = dUtc;
        this.yearGenerator.workDone();
    }

    private DateValue generateInstance() {
        try {
            DateValue dUtc;
            do {
                if (this.instanceGenerator.generate(this.builder)) continue;
                return null;
            } while ((dUtc = this.dtStart instanceof TimeValue ? TimeUtils.toUtc(this.builder.toDateTime(), this.tzid) : this.builder.toDate()).compareTo(this.lastUtc_) <= 0);
            return dUtc;
        }
        catch (Generator.IteratorShortCircuitingException ex) {
            return null;
        }
    }
}

