/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ICalDateFormat {
    DATE_BASIC("yyyyMMdd"),
    DATE_EXTENDED("yyyy-MM-dd"),
    DATE_TIME_BASIC("yyyyMMdd'T'HHmmssZ"),
    DATE_TIME_BASIC_WITHOUT_TZ("yyyyMMdd'T'HHmmss"),
    DATE_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ssZ"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            SimpleDateFormat df = new SimpleDateFormat(this.formatStr){
                private static final long serialVersionUID = -297452842012115768L;

                @Override
                public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                    StringBuffer sb = super.format(date, toAppendTo, fieldPosition);
                    sb.insert(sb.length() - 2, ':');
                    return sb;
                }
            };
            if (timezone != null) {
                df.setTimeZone(timezone);
            }
            return df;
        }
    }
    ,
    DATE_TIME_EXTENDED_WITHOUT_TZ("yyyy-MM-dd'T'HH:mm:ss"),
    UTC_TIME_BASIC("yyyyMMdd'T'HHmmss'Z'"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            timezone = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(timezone);
        }
    }
    ,
    UTC_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ss'Z'"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            timezone = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(timezone);
        }
    };

    protected final String formatStr;

    private ICalDateFormat(String formatStr) {
        this.formatStr = formatStr;
    }

    public DateFormat getDateFormat() {
        return this.getDateFormat(null);
    }

    public DateFormat getDateFormat(TimeZone timezone) {
        SimpleDateFormat df = new SimpleDateFormat(this.formatStr);
        if (timezone != null) {
            df.setTimeZone(timezone);
        }
        return df;
    }

    public String format(Date date) {
        return this.format(date, null);
    }

    public String format(Date date, TimeZone timezone) {
        DateFormat df = this.getDateFormat(timezone);
        return df.format(date);
    }

    public static Date parse(String dateStr) {
        return ICalDateFormat.parse(dateStr, null);
    }

    public static Date parse(String dateStr, TimeZone timezone) {
        TimestampPattern p = new TimestampPattern(dateStr);
        if (!p.matches()) {
            throw ICalDateFormat.parseException(dateStr);
        }
        if (p.hasOffset()) {
            timezone = TimeZone.getTimeZone("UTC");
        } else if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        Calendar c = Calendar.getInstance(timezone);
        c.clear();
        c.set(1, p.year());
        c.set(2, p.month() - 1);
        c.set(5, p.date());
        if (p.hasTime()) {
            c.set(11, p.hour());
            c.set(12, p.minute());
            c.set(13, p.second());
            c.set(14, p.millisecond());
            if (p.hasOffset()) {
                c.set(15, p.offsetMillis());
            }
        }
        return c.getTime();
    }

    public static boolean dateHasTime(String dateStr) {
        return dateStr.contains("T");
    }

    public static boolean dateHasTimezone(String dateStr) {
        return ICalDateFormat.isUTC(dateStr) || dateStr.matches(".*?[-+]\\d\\d:?\\d\\d");
    }

    public static boolean isUTC(String dateStr) {
        return dateStr.endsWith("Z");
    }

    public static TimeZone parseTimeZoneId(String timezoneId) {
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        return "GMT".equals(timezone.getID()) && !"GMT".equalsIgnoreCase(timezoneId) ? null : timezone;
    }

    private static IllegalArgumentException parseException(String dateStr) {
        return new IllegalArgumentException("Date string \"" + dateStr + "\" is not in a valid ISO-8601 format.");
    }

    private static class TimestampPattern {
        private static final Pattern regex = Pattern.compile("^(\\d{4})-?(\\d{2})-?(\\d{2})(T(\\d{2}):?(\\d{2}):?(\\d{2})(\\.\\d+)?(Z|([-+])((\\d{2})|((\\d{2}):?(\\d{2}))))?)?$");
        private final Matcher m;
        private final boolean matches;

        public TimestampPattern(String str) {
            this.m = regex.matcher(str);
            this.matches = this.m.find();
        }

        public boolean matches() {
            return this.matches;
        }

        public int year() {
            return this.parseInt(1);
        }

        public int month() {
            return this.parseInt(2);
        }

        public int date() {
            return this.parseInt(3);
        }

        public boolean hasTime() {
            return this.m.group(5) != null;
        }

        public int hour() {
            return this.parseInt(5);
        }

        public int minute() {
            return this.parseInt(6);
        }

        public int second() {
            return this.parseInt(7);
        }

        public int millisecond() {
            if (this.m.group(8) == null) {
                return 0;
            }
            double ms = Double.parseDouble(this.m.group(8)) * 1000.0;
            return (int)Math.round(ms);
        }

        public boolean hasOffset() {
            return this.m.group(9) != null;
        }

        public int offsetMillis() {
            int offsetMinute;
            int offsetHour;
            int positive;
            if (this.m.group(9).equals("Z")) {
                return 0;
            }
            int n = positive = this.m.group(10).equals("+") ? 1 : -1;
            if (this.m.group(12) != null) {
                offsetHour = this.parseInt(12);
                offsetMinute = 0;
            } else {
                offsetHour = this.parseInt(14);
                offsetMinute = this.parseInt(15);
            }
            return (offsetHour * 60 * 60 * 1000 + offsetMinute * 60 * 1000) * positive;
        }

        private int parseInt(int group) {
            return Integer.parseInt(this.m.group(group));
        }
    }
}

