/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.IntegerProperty;
import biweekly.property.ValuedProperty;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public abstract class IntegerPropertyScribe<T extends IntegerProperty>
extends ICalPropertyScribe<T> {
    public IntegerPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.INTEGER);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Integer value = (Integer)((ValuedProperty)property).getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        String valueStr = null;
        Integer value = (Integer)((ValuedProperty)property).getValue();
        if (value != null) {
            valueStr = value.toString();
        }
        element.append(this.dataType(property, null), valueStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.parse(value);
        }
        throw IntegerPropertyScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        return JCalValue.single(((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asSingle());
    }

    private T parse(String value) {
        if (value == null || value.length() == 0) {
            return this.newInstance(null);
        }
        try {
            Integer intValue = Integer.valueOf(value);
            return this.newInstance(intValue);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(24, new Object[0]);
        }
    }

    protected abstract T newInstance(Integer var1);
}

