/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.Observance;
import biweekly.component.VTimezone;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.ICalDateFormat;
import biweekly.util.ListMultimap;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class ICalPropertyScribe<T extends ICalProperty> {
    private static final Set<ICalVersion> allVersions = Collections.unmodifiableSet(EnumSet.allOf(ICalVersion.class));
    protected final Class<T> clazz;
    protected final String propertyName;
    private final ICalDataType defaultDataType;
    protected final QName qname;

    public ICalPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, null);
    }

    public ICalPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType) {
        this(clazz, propertyName, defaultDataType, new QName("urn:ietf:params:xml:ns:icalendar-2.0", propertyName.toLowerCase()));
    }

    public ICalPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType, QName qname) {
        this.clazz = clazz;
        this.propertyName = propertyName;
        this.defaultDataType = defaultDataType;
        this.qname = qname;
    }

    public Set<ICalVersion> getSupportedVersions() {
        return allVersions;
    }

    public Class<T> getPropertyClass() {
        return this.clazz;
    }

    public String getPropertyName(ICalVersion version) {
        return this.propertyName;
    }

    public QName getQName() {
        return this.qname;
    }

    public final ICalParameters prepareParameters(T property, WriteContext context) {
        return this._prepareParameters(property, context);
    }

    public final ICalDataType defaultDataType(ICalVersion version) {
        return this._defaultDataType(version);
    }

    public final ICalDataType dataType(T property, ICalVersion version) {
        return this._dataType(property, version);
    }

    public final String writeText(T property, WriteContext context) {
        return this._writeText(property, context);
    }

    public final void writeXml(T property, Element element, WriteContext context) {
        XCalElement xcalElement = new XCalElement(element);
        this._writeXml(property, xcalElement, context);
    }

    public final JCalValue writeJson(T property, WriteContext context) {
        return this._writeJson(property, context);
    }

    public final T parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        T property = this._parseText(value, dataType, parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseXml(Element element, ICalParameters parameters, ParseContext context) {
        T property = this._parseXml(new XCalElement(element), parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        T property = this._parseJson(value, dataType, parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    protected ICalParameters _prepareParameters(T property, WriteContext context) {
        return ((ICalProperty)property).getParameters();
    }

    protected ICalDataType _defaultDataType(ICalVersion version) {
        return this.defaultDataType;
    }

    protected ICalDataType _dataType(T property, ICalVersion version) {
        return this.defaultDataType(version);
    }

    protected abstract String _writeText(T var1, WriteContext var2);

    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        String value = this.writeText(property, context);
        ICalDataType dataType = this.dataType(property, ICalVersion.V2_0);
        element.append(dataType, value);
    }

    protected JCalValue _writeJson(T property, WriteContext context) {
        String value = this.writeText(property, context);
        return JCalValue.single(value);
    }

    protected abstract T _parseText(String var1, ICalDataType var2, ICalParameters var3, ParseContext var4);

    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        XCalElement.XCalValue firstValue = element.firstValue();
        ICalDataType dataType = firstValue.getDataType();
        String value = VObjectPropertyValues.escape((String)firstValue.getValue());
        return this._parseText(value, dataType, parameters, context);
    }

    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = ICalPropertyScribe.jcalValueToString(value);
        return this._parseText(valueStr, dataType, parameters, context);
    }

    private static String jcalValueToString(JCalValue value) {
        ListMultimap<String, String> object;
        List<List<String>> structured;
        List<String> multi;
        List<JsonValue> values = value.getValues();
        if (values.size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return VObjectPropertyValues.writeList(multi);
        }
        if (!values.isEmpty() && values.get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return VObjectPropertyValues.writeStructured(structured, (boolean)true);
        }
        if (values.get(0).getObject() != null && !(object = value.asObject()).isEmpty()) {
            return VObjectPropertyValues.writeMultimap(object.getMap());
        }
        return VObjectPropertyValues.escape((String)value.asSingle());
    }

    protected static boolean isInObservance(WriteContext context) {
        return context.getParent() instanceof Observance;
    }

    protected static DateParser date(String value) {
        return new DateParser(value);
    }

    protected static DateWriter date(Date date) {
        return ICalPropertyScribe.date(date == null ? null : new ICalDate(date));
    }

    protected static DateWriter date(ICalDate date) {
        return new DateWriter(date);
    }

    protected static DateWriter date(Date date, ICalProperty property, WriteContext context) {
        return ICalPropertyScribe.date(date == null ? null : new ICalDate(date), property, context);
    }

    protected static DateWriter date(ICalDate date, ICalProperty property, WriteContext context) {
        TimeZone tz;
        boolean floating;
        TimezoneAssignment globalTz = context.getGlobalTimezone();
        if (globalTz == null) {
            TimezoneInfo tzinfo = context.getTimezoneInfo();
            floating = tzinfo.isFloating(property);
            TimezoneAssignment assignment = tzinfo.getTimezoneToWriteIn(property);
            tz = assignment == null ? null : assignment.getTimeZone();
        } else {
            floating = false;
            tz = globalTz.getTimeZone();
        }
        context.addDate(date, floating, tz);
        return ICalPropertyScribe.date(date).tz(floating, tz);
    }

    protected static ICalParameters handleTzidParameter(ICalProperty property, boolean hasTime, WriteContext context) {
        TimezoneAssignment tz;
        ICalParameters parameters = property.getParameters();
        if (!hasTime) {
            return parameters;
        }
        if (context.getVersion() == ICalVersion.V1_0) {
            return parameters;
        }
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean floating = tzinfo.isFloating(property);
        if (floating) {
            return parameters;
        }
        TimezoneAssignment globalTz = context.getGlobalTimezone();
        if (globalTz == null) {
            tz = tzinfo.getTimezoneToWriteIn(property);
            if (tz == null) {
                return parameters;
            }
        } else {
            tz = globalTz;
        }
        String tzid = null;
        VTimezone component = tz.getComponent();
        String globalId = tz.getGlobalId();
        if (component != null) {
            tzid = ValuedProperty.getValue(component.getTimezoneId());
        } else if (globalId != null) {
            tzid = '/' + globalId;
        }
        if (tzid == null) {
            tzid = tz.getTimeZone().getID();
        }
        parameters = new ICalParameters(parameters);
        parameters.setTimezoneId(tzid);
        return parameters;
    }

    protected static CannotParseException missingXmlElements(ICalDataType ... dataTypes) {
        String[] elements = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            ICalDataType dataType = dataTypes[i];
            elements[i] = dataType == null ? "unknown" : dataType.getName().toLowerCase();
        }
        return ICalPropertyScribe.missingXmlElements(elements);
    }

    protected static CannotParseException missingXmlElements(String ... elements) {
        return new CannotParseException(23, Arrays.toString(elements));
    }

    protected static class DateParser {
        private String value;
        private Boolean hasTime;

        public DateParser(String value) {
            this.value = value;
        }

        public DateParser hasTime(Boolean hasTime) {
            this.hasTime = hasTime;
            return this;
        }

        public ICalDate parse() {
            DateTimeComponents components = DateTimeComponents.parse(this.value, this.hasTime);
            Date date = components.toDate();
            boolean hasTime = components.hasTime();
            return new ICalDate(date, components, hasTime);
        }
    }

    protected static class DateWriter {
        private ICalDate date;
        private TimeZone timezone;
        private boolean observance = false;
        private boolean extended = false;
        private boolean utc = false;

        public DateWriter(ICalDate date) {
            this.date = date;
        }

        public DateWriter observance(boolean observance) {
            this.observance = observance;
            return this;
        }

        public DateWriter utc(boolean utc) {
            this.utc = utc;
            return this;
        }

        public DateWriter tz(boolean floating, TimeZone timezone) {
            if (floating) {
                timezone = TimeZone.getDefault();
            }
            this.timezone = timezone;
            return this;
        }

        public DateWriter extended(boolean extended) {
            this.extended = extended;
            return this;
        }

        public String write() {
            ICalDateFormat format;
            if (this.date == null) {
                return "";
            }
            if (this.observance) {
                DateTimeComponents components = this.date.getRawComponents();
                if (components == null) {
                    ICalDateFormat format2 = this.extended ? ICalDateFormat.DATE_TIME_EXTENDED_WITHOUT_TZ : ICalDateFormat.DATE_TIME_BASIC_WITHOUT_TZ;
                    return format2.format(this.date);
                }
                return components.toString(true, this.extended);
            }
            if (this.utc) {
                ICalDateFormat format3 = this.extended ? ICalDateFormat.UTC_TIME_EXTENDED : ICalDateFormat.UTC_TIME_BASIC;
                return format3.format(this.date);
            }
            TimeZone timezone = this.timezone;
            if (this.date.hasTime()) {
                format = timezone == null ? (this.extended ? ICalDateFormat.UTC_TIME_EXTENDED : ICalDateFormat.UTC_TIME_BASIC) : (this.extended ? ICalDateFormat.DATE_TIME_EXTENDED_WITHOUT_TZ : ICalDateFormat.DATE_TIME_BASIC_WITHOUT_TZ);
            } else {
                format = this.extended ? ICalDateFormat.DATE_EXTENDED : ICalDateFormat.DATE_BASIC;
                timezone = null;
            }
            return format.format(this.date, timezone);
        }
    }

    public static class Result<T> {
        private final T property;
        private final List<ValidationWarning> warnings;

        public Result(T property, List<ValidationWarning> warnings) {
            this.property = property;
            this.warnings = warnings;
        }

        public List<ValidationWarning> getWarnings() {
            return this.warnings;
        }

        public T getProperty() {
            return this.property;
        }
    }
}

