/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.chain;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.ParseWarning;
import biweekly.io.StreamReader;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.ICalProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

abstract class ChainingParser<T extends ChainingParser<?>> {
    final String string;
    final InputStream in;
    final Reader reader;
    final File file;
    ScribeIndex index;
    List<List<ParseWarning>> warnings;
    final T this_ = this;

    ChainingParser(String string) {
        this(string, null, null, null);
    }

    ChainingParser(InputStream in) {
        this(null, in, null, null);
    }

    ChainingParser(Reader reader) {
        this(null, null, reader, null);
    }

    ChainingParser(File file) {
        this(null, null, null, file);
    }

    ChainingParser() {
        this(null, null, null, null);
    }

    private ChainingParser(String string, InputStream in, Reader reader, File file) {
        this.string = string;
        this.in = in;
        this.reader = reader;
        this.file = file;
    }

    public T register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        if (this.index == null) {
            this.index = new ScribeIndex();
        }
        this.index.register(scribe);
        return this.this_;
    }

    public T register(ICalComponentScribe<? extends ICalComponent> scribe) {
        if (this.index == null) {
            this.index = new ScribeIndex();
        }
        this.index.register(scribe);
        return this.this_;
    }

    public T warnings(List<List<ParseWarning>> warnings) {
        this.warnings = warnings;
        return this.this_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICalendar first() throws IOException {
        StreamReader reader = this.constructReader();
        if (this.index != null) {
            reader.setScribeIndex(this.index);
        }
        try {
            ICalendar ical = reader.readNext();
            if (this.warnings != null) {
                this.warnings.add(reader.getWarnings());
            }
            ICalendar iCalendar = ical;
            return iCalendar;
        }
        finally {
            if (this.closeWhenDone()) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICalendar> all() throws IOException {
        StreamReader reader = this.constructReader();
        if (this.index != null) {
            reader.setScribeIndex(this.index);
        }
        try {
            ICalendar ical;
            ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
            while ((ical = reader.readNext()) != null) {
                if (this.warnings != null) {
                    this.warnings.add(reader.getWarnings());
                }
                icals.add(ical);
            }
            ArrayList<ICalendar> arrayList = icals;
            return arrayList;
        }
        finally {
            if (this.closeWhenDone()) {
                reader.close();
            }
        }
    }

    abstract StreamReader constructReader() throws IOException;

    private boolean closeWhenDone() {
        return this.in == null && this.reader == null;
    }
}

