/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.component.VTimezone;
import biweekly.io.TimezoneAssignment;
import biweekly.property.ICalProperty;
import biweekly.property.ValuedProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimezoneInfo {
    private final Collection<TimezoneAssignment> assignments = new HashSet<TimezoneAssignment>(){

        @Override
        public boolean remove(Object assignment) {
            Collection values = TimezoneInfo.this.propertyTimezones.values();
            while (values.remove(assignment)) {
            }
            return super.remove(assignment);
        }
    };
    private final Map<ICalProperty, TimezoneAssignment> propertyTimezones = new IdentityHashMap<ICalProperty, TimezoneAssignment>();
    private final List<ICalProperty> floatingProperties = new ArrayList<ICalProperty>();
    private TimezoneAssignment defaultTimezone;
    private boolean globalFloatingTime = false;

    public Collection<TimezoneAssignment> getTimezones() {
        return this.assignments;
    }

    public TimezoneAssignment getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public void setDefaultTimezone(TimezoneAssignment timezone) {
        if (timezone == null) {
            if (this.defaultTimezone != null && !this.propertyTimezones.values().contains(this.defaultTimezone)) {
                this.assignments.remove(this.defaultTimezone);
            }
        } else {
            this.assignments.add(timezone);
        }
        this.defaultTimezone = timezone;
    }

    public void setTimezone(ICalProperty property, TimezoneAssignment timezone) {
        if (timezone == null) {
            TimezoneAssignment existing = this.propertyTimezones.remove(property);
            if (existing != null && existing != this.defaultTimezone && !this.propertyTimezones.values().contains(existing)) {
                this.assignments.remove(existing);
            }
            return;
        }
        this.assignments.add(timezone);
        this.propertyTimezones.put(property, timezone);
    }

    public TimezoneAssignment getTimezone(ICalProperty property) {
        return this.propertyTimezones.get(property);
    }

    public TimezoneAssignment getTimezoneToWriteIn(ICalProperty property) {
        TimezoneAssignment assignment = this.getTimezone(property);
        return assignment == null ? this.defaultTimezone : assignment;
    }

    public TimezoneAssignment getTimezoneById(String tzid) {
        for (TimezoneAssignment assignment : this.assignments) {
            String componentId;
            VTimezone component = assignment.getComponent();
            if (component == null || !tzid.equals(componentId = ValuedProperty.getValue(component.getTimezoneId()))) continue;
            return assignment;
        }
        return null;
    }

    public boolean isGlobalFloatingTime() {
        return this.globalFloatingTime;
    }

    public void setGlobalFloatingTime(boolean enable) {
        this.globalFloatingTime = enable;
    }

    public boolean isFloating(ICalProperty property) {
        if (TimezoneInfo.containsIdentity(this.floatingProperties, property)) {
            return true;
        }
        if (this.propertyTimezones.containsKey(property)) {
            return false;
        }
        return this.globalFloatingTime;
    }

    public void setFloating(ICalProperty property, boolean enable) {
        if (enable) {
            this.floatingProperties.add(property);
        } else {
            TimezoneInfo.removeIdentity(this.floatingProperties, property);
        }
    }

    public Collection<VTimezone> getComponents() {
        ArrayList<VTimezone> components = new ArrayList<VTimezone>(this.assignments.size());
        for (TimezoneAssignment assignment : this.assignments) {
            VTimezone component = assignment.getComponent();
            if (component == null) continue;
            components.add(component);
        }
        return Collections.unmodifiableList(components);
    }

    private static <T> void removeIdentity(List<T> list, T object) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            if (object != it.next()) continue;
            it.remove();
        }
    }

    private static <T> boolean containsIdentity(List<T> list, T object) {
        for (T item : list) {
            if (item != object) continue;
            return true;
        }
        return false;
    }
}

