/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mpg;

import de.sciss.jump3r.mp3.VBRTag;
import de.sciss.jump3r.mp3.VBRTagData;
import de.sciss.jump3r.mpg.Common;
import de.sciss.jump3r.mpg.DCT64;
import de.sciss.jump3r.mpg.Decode;
import de.sciss.jump3r.mpg.Frame;
import de.sciss.jump3r.mpg.Layer1;
import de.sciss.jump3r.mpg.Layer2;
import de.sciss.jump3r.mpg.Layer3;
import de.sciss.jump3r.mpg.MPGLib;
import de.sciss.jump3r.mpg.TabInit;

public class Interface {
    private VBRTag vbr;
    private Common common;
    protected Decode decode = new Decode();
    private Layer1 layer1 = new Layer1();
    private Layer2 layer2 = new Layer2();
    private Layer3 layer3 = new Layer3();
    private DCT64 dct = new DCT64();
    private TabInit tab = new TabInit();
    public static final int XING_HEADER_SIZE = 194;

    public void setModules(VBRTag v, Common c) {
        this.vbr = v;
        this.common = c;
        this.layer1.setModules(this.common, this.decode);
        this.layer2.setModules(this.common);
        this.layer3.setModules(this.common);
        this.decode.setModules(this.tab, this.dct);
        this.dct.setModules(this.tab);
    }

    MPGLib.mpstr_tag InitMP3() {
        MPGLib.mpstr_tag mp = new MPGLib.mpstr_tag();
        mp.framesize = 0;
        mp.num_frames = 0;
        mp.enc_delay = -1;
        mp.enc_padding = -1;
        mp.vbr_header = false;
        mp.header_parsed = false;
        mp.side_parsed = false;
        mp.data_parsed = false;
        mp.free_format = false;
        mp.old_free_format = false;
        mp.ssize = 0;
        mp.dsize = 0;
        mp.fsizeold = -1;
        mp.bsize = 0;
        mp.tail = null;
        mp.head = null;
        mp.fr.single = -1;
        mp.bsnum = 0;
        mp.wordpointer = mp.bsspace[mp.bsnum];
        mp.wordpointerPos = 512;
        mp.bitindex = 0;
        mp.synth_bo = 1;
        mp.sync_bitstream = 1;
        this.tab.make_decode_tables(32767L);
        this.layer3.init_layer3(32);
        this.layer2.init_layer2();
        return mp;
    }

    void ExitMP3(MPGLib.mpstr_tag mp) {
        MPGLib.buf b = mp.tail;
        while (b != null) {
            MPGLib.buf bn;
            b.pnt = null;
            b = bn = b.next;
        }
    }

    MPGLib.buf addbuf(MPGLib.mpstr_tag mp, byte[] buf2, int bufPos, int size) {
        MPGLib.buf nbuf = new MPGLib.buf();
        nbuf.pnt = new byte[size];
        nbuf.size = size;
        System.arraycopy(buf2, bufPos, nbuf.pnt, 0, size);
        nbuf.next = null;
        nbuf.prev = mp.head;
        nbuf.pos = 0;
        if (null == mp.tail) {
            mp.tail = nbuf;
        } else {
            mp.head.next = nbuf;
        }
        mp.head = nbuf;
        mp.bsize += size;
        return nbuf;
    }

    void remove_buf(MPGLib.mpstr_tag mp) {
        MPGLib.buf buf2 = mp.tail;
        mp.tail = buf2.next;
        if (mp.tail != null) {
            mp.tail.prev = null;
        } else {
            mp.head = null;
            mp.tail = null;
        }
        buf2.pnt = null;
        buf2 = null;
    }

    int read_buf_byte(MPGLib.mpstr_tag mp) {
        int pos = mp.tail.pos;
        while (pos >= mp.tail.size) {
            this.remove_buf(mp);
            if (null == mp.tail) {
                throw new RuntimeException("hip: Fatal error! tried to read past mp buffer");
            }
            pos = mp.tail.pos;
        }
        int b = mp.tail.pnt[pos] & 0xFF;
        --mp.bsize;
        ++mp.tail.pos;
        return b;
    }

    void read_head(MPGLib.mpstr_tag mp) {
        long head = this.read_buf_byte(mp);
        head <<= 8;
        head |= (long)this.read_buf_byte(mp);
        head <<= 8;
        head |= (long)this.read_buf_byte(mp);
        head <<= 8;
        mp.header = head |= (long)this.read_buf_byte(mp);
    }

    void copy_mp(MPGLib.mpstr_tag mp, int size, byte[] ptr, int ptrPos) {
        int len = 0;
        while (len < size && mp.tail != null) {
            int blen = mp.tail.size - mp.tail.pos;
            int nlen = size - len <= blen ? size - len : blen;
            System.arraycopy(mp.tail.pnt, mp.tail.pos, ptr, ptrPos + len, nlen);
            len += nlen;
            mp.tail.pos += nlen;
            mp.bsize -= nlen;
            if (mp.tail.pos != mp.tail.size) continue;
            this.remove_buf(mp);
        }
    }

    int check_vbr_header(MPGLib.mpstr_tag mp, int bytes) {
        int i;
        MPGLib.buf buf2 = mp.tail;
        byte[] xing = new byte[194];
        int pos = buf2.pos;
        for (i = 0; i < bytes; ++i) {
            while (pos >= buf2.size) {
                buf2 = buf2.next;
                if (null == buf2) {
                    return -1;
                }
                pos = buf2.pos;
            }
            ++pos;
        }
        for (i = 0; i < 194; ++i) {
            while (pos >= buf2.size) {
                buf2 = buf2.next;
                if (null == buf2) {
                    return -1;
                }
                pos = buf2.pos;
            }
            xing[i] = buf2.pnt[pos];
            ++pos;
        }
        VBRTagData pTagData = this.vbr.getVbrTag(xing);
        boolean bl = mp.vbr_header = pTagData != null;
        if (mp.vbr_header) {
            mp.num_frames = pTagData.frames;
            mp.enc_delay = pTagData.encDelay;
            mp.enc_padding = pTagData.encPadding;
            if (pTagData.headersize < 1) {
                return 1;
            }
            return pTagData.headersize;
        }
        return 0;
    }

    int sync_buffer(MPGLib.mpstr_tag mp, boolean free_match) {
        int[] b = new int[]{0, 0, 0, 0};
        MPGLib.buf buf2 = mp.tail;
        if (null == buf2) {
            return -1;
        }
        int pos = buf2.pos;
        for (int i = 0; i < mp.bsize; ++i) {
            b[0] = b[1];
            b[1] = b[2];
            b[2] = b[3];
            while (pos >= buf2.size) {
                buf2 = buf2.next;
                pos = buf2.pos;
            }
            b[3] = buf2.pnt[pos] & 0xFF;
            ++pos;
            if (i < 3) continue;
            Frame fr = mp.fr;
            long head = b[0];
            head <<= 8;
            head |= (long)b[1];
            head <<= 8;
            head |= (long)b[2];
            head <<= 8;
            boolean h = this.common.head_check(head |= (long)b[3], fr.lay);
            if (h && free_match) {
                boolean mpeg25;
                int lsf;
                if ((head & 0x100000L) != 0L) {
                    lsf = (head & 0x80000L) != 0L ? 0 : 1;
                    mpeg25 = false;
                } else {
                    lsf = 1;
                    mpeg25 = true;
                }
                int mode = (int)(head >> 6 & 3L);
                int stereo = mode == 3 ? 1 : 2;
                int sampling_frequency = mpeg25 ? (int)(6L + (head >> 10 & 3L)) : (int)((head >> 10 & 3L) + (long)(lsf * 3));
                boolean bl = h = stereo == fr.stereo && lsf == fr.lsf && mpeg25 == fr.mpeg25 && sampling_frequency == fr.sampling_frequency;
            }
            if (!h) continue;
            return i - 3;
        }
        return -1;
    }

    MPGLib.mpstr_tag decode_reset() {
        return this.InitMP3();
    }

    int audiodata_precedesframes(MPGLib.mpstr_tag mp) {
        if (mp.fr.lay == 3) {
            return this.layer3.layer3_audiodata_precedesframes(mp);
        }
        return 0;
    }

    <T> int decodeMP3_clipchoice(MPGLib.mpstr_tag mp, byte[] in, int inPos, int isize, T[] out, MPGLib.ProcessedBytes done, ISynth synth, Decode.Factory<T> tFactory) {
        int size;
        int bytes;
        if (in != null && isize != 0 && this.addbuf(mp, in, inPos, isize) == null) {
            return -1;
        }
        if (!mp.header_parsed) {
            if (mp.fsizeold == -1 || mp.sync_bitstream != 0) {
                mp.sync_bitstream = 0;
                bytes = this.sync_buffer(mp, false);
                if (mp.bsize < bytes + 194) {
                    return 1;
                }
                int vbrbytes = this.check_vbr_header(mp, bytes);
                if (mp.vbr_header) {
                    if (bytes + vbrbytes > mp.bsize) {
                        return 1;
                    }
                    for (int i = 0; i < vbrbytes + bytes; ++i) {
                        this.read_buf_byte(mp);
                    }
                    return 1;
                }
            } else {
                bytes = this.sync_buffer(mp, true);
            }
            if (bytes < 0) {
                return 1;
            }
            if (bytes > 0) {
                System.err.printf("hip: bitstream problem, resyncing skipping %d bytes...\n", bytes);
                mp.old_free_format = false;
                mp.sync_bitstream = 1;
                size = mp.wordpointerPos - 512;
                if (size > 2880) {
                    System.err.printf("hip: wordpointer trashed.  size=%i (%i)  bytes=%i \n", size, 2880, bytes);
                    size = 0;
                    mp.wordpointer = mp.bsspace[mp.bsnum];
                    mp.wordpointerPos = 512;
                }
                for (int i = size + bytes - 2880; i > 0; --i) {
                    --bytes;
                    this.read_buf_byte(mp);
                }
                this.copy_mp(mp, bytes, mp.wordpointer, mp.wordpointerPos);
                mp.fsizeold += bytes;
            }
            this.read_head(mp);
            this.common.decode_header(mp.fr, mp.header);
            mp.header_parsed = true;
            mp.framesize = mp.fr.framesize;
            boolean bl = mp.free_format = mp.framesize == 0;
            if (mp.fr.lsf != 0) {
                mp.ssize = mp.fr.stereo == 1 ? 9 : 17;
            } else {
                int n = mp.ssize = mp.fr.stereo == 1 ? 17 : 32;
            }
            if (mp.fr.error_protection) {
                mp.ssize += 2;
            }
            mp.bsnum = 1 - mp.bsnum;
            mp.wordpointer = mp.bsspace[mp.bsnum];
            mp.wordpointerPos = 512;
            mp.bitindex = 0;
            if (mp.fsizeold == -1) {
                return 1;
            }
        }
        if (!mp.side_parsed) {
            if (mp.fr.lay == 3) {
                int bits;
                if (mp.bsize < mp.ssize) {
                    return 1;
                }
                this.copy_mp(mp, mp.ssize, mp.wordpointer, mp.wordpointerPos);
                if (mp.fr.error_protection) {
                    this.common.getbits(mp, 16);
                }
                if ((bits = this.layer3.do_layer3_sideinfo(mp)) < 0) {
                    bits = 0;
                }
                mp.dsize = (bits + 7) / 8;
            } else {
                if (mp.fr.framesize > mp.bsize) {
                    return 1;
                }
                mp.dsize = mp.fr.framesize;
                mp.ssize = 0;
            }
            mp.side_parsed = true;
        }
        int iret = 1;
        if (!mp.data_parsed) {
            if (mp.dsize > mp.bsize) {
                return 1;
            }
            this.copy_mp(mp, mp.dsize, mp.wordpointer, mp.wordpointerPos);
            done.pb = 0;
            switch (mp.fr.lay) {
                case 1: {
                    if (mp.fr.error_protection) {
                        this.common.getbits(mp, 16);
                    }
                    this.layer1.do_layer1(mp, out, done, tFactory);
                    break;
                }
                case 2: {
                    if (mp.fr.error_protection) {
                        this.common.getbits(mp, 16);
                    }
                    this.layer2.do_layer2(mp, out, done, synth, tFactory);
                    break;
                }
                case 3: {
                    this.layer3.do_layer3(mp, out, done, synth, tFactory);
                    break;
                }
                default: {
                    System.err.printf("hip: invalid layer %d\n", mp.fr.lay);
                }
            }
            mp.wordpointer = mp.bsspace[mp.bsnum];
            mp.wordpointerPos = 512 + mp.ssize + mp.dsize;
            mp.data_parsed = true;
            iret = 0;
        }
        if (mp.free_format) {
            if (mp.old_free_format) {
                mp.framesize = mp.fsizeold_nopadding + mp.fr.padding;
            } else {
                bytes = this.sync_buffer(mp, true);
                if (bytes < 0) {
                    return iret;
                }
                mp.framesize = bytes + mp.ssize + mp.dsize;
                mp.fsizeold_nopadding = mp.framesize - mp.fr.padding;
            }
        }
        if ((bytes = mp.framesize - (mp.ssize + mp.dsize)) > mp.bsize) {
            return iret;
        }
        if (bytes > 0) {
            this.copy_mp(mp, bytes, mp.wordpointer, mp.wordpointerPos);
            mp.wordpointerPos += bytes;
            size = mp.wordpointerPos - 512;
            if (size > 2880) {
                System.err.printf("hip: fatal error.  MAXFRAMESIZE not large enough.\n", new Object[0]);
            }
        }
        mp.fsizeold = mp.framesize;
        mp.old_free_format = mp.free_format;
        mp.framesize = 0;
        mp.header_parsed = false;
        mp.side_parsed = false;
        mp.data_parsed = false;
        return iret;
    }

    <T> int decodeMP3(MPGLib.mpstr_tag mp, byte[] in, int bufferPos, int isize, T[] out, int osize, MPGLib.ProcessedBytes done, Decode.Factory<T> tFactory) {
        if (osize < 2304) {
            System.err.printf("hip: Insufficient memory for decoding buffer %d\n", osize);
            return -1;
        }
        ISynth synth = new ISynth(){

            public <X> int synth_1to1_mono_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, X[] out, MPGLib.ProcessedBytes p, Decode.Factory<X> tFactory) {
                return Interface.this.decode.synth_1to1_mono(mp, in, inPos, out, p, tFactory);
            }

            public <X> int synth_1to1_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, int i, X[] out, MPGLib.ProcessedBytes p, Decode.Factory<X> tFactory) {
                return Interface.this.decode.synth_1to1(mp, in, inPos, i, out, p, tFactory);
            }
        };
        return this.decodeMP3_clipchoice(mp, in, bufferPos, isize, out, done, synth, tFactory);
    }

    <T> int decodeMP3_unclipped(MPGLib.mpstr_tag mp, byte[] in, int bufferPos, int isize, T[] out, int osize, MPGLib.ProcessedBytes done, Decode.Factory<T> tFactory) {
        if (osize < 2304) {
            System.err.printf("hip: out space too small for unclipped mode\n", new Object[0]);
            return -1;
        }
        ISynth synth = new ISynth(){

            public <X> int synth_1to1_mono_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, X[] out, MPGLib.ProcessedBytes p, Decode.Factory<X> tFactory) {
                return Interface.this.decode.synth_1to1_mono_unclipped(mp, in, inPos, out, p, tFactory);
            }

            public <X> int synth_1to1_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, int i, X[] out, MPGLib.ProcessedBytes p, Decode.Factory<X> tFactory) {
                return Interface.this.decode.synth_1to1_unclipped(mp, in, inPos, i, out, p, tFactory);
            }
        };
        return this.decodeMP3_clipchoice(mp, in, bufferPos, isize, out, done, synth, tFactory);
    }

    static interface ISynth {
        public <T> int synth_1to1_mono_ptr(MPGLib.mpstr_tag var1, float[] var2, int var3, T[] var4, MPGLib.ProcessedBytes var5, Decode.Factory<T> var6);

        public <T> int synth_1to1_ptr(MPGLib.mpstr_tag var1, float[] var2, int var3, int var4, T[] var5, MPGLib.ProcessedBytes var6, Decode.Factory<T> var7);
    }
}

