/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mpg;

import de.sciss.jump3r.mpg.DCT64;
import de.sciss.jump3r.mpg.MPGLib;
import de.sciss.jump3r.mpg.TabInit;

public class Decode {
    private TabInit tab;
    private DCT64 dct64;
    private static final int step = 2;

    public void setModules(TabInit t, DCT64 d) {
        this.tab = t;
        this.dct64 = d;
    }

    private <T> int WRITE_SAMPLE_CLIPPED(int samples, float sum, int clip, T[] out, Factory<T> tFactory) {
        if ((double)sum > 32767.0) {
            out[samples] = tFactory.create(32767.0f);
            ++clip;
        } else if ((double)sum < -32768.0) {
            out[samples] = tFactory.create(-32768.0f);
            ++clip;
        } else {
            out[samples] = tFactory.create((int)(sum > 0.0f ? (double)sum + 0.5 : (double)sum - 0.5));
        }
        return clip;
    }

    private <T> void WRITE_SAMPLE_UNCLIPPED(int samples, float sum, int clip, T[] out, Factory<T> tFactory) {
        out[samples] = tFactory.create(sum);
    }

    <T> int synth_1to1_mono(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, T[] out, MPGLib.ProcessedBytes pnt, Factory<T> tFactory) {
        Object[] samples_tmp = new Object[64];
        int tmp1 = 0;
        MPGLib.ProcessedBytes pnt1 = new MPGLib.ProcessedBytes();
        int ret = this.synth_1to1(mp, bandPtr, bandPos, 0, samples_tmp, pnt1, tFactory);
        int outPos = pnt.pb;
        for (int i = 0; i < 32; ++i) {
            out[outPos++] = samples_tmp[tmp1];
            tmp1 += 2;
        }
        pnt.pb += 32;
        return ret;
    }

    <T> int synth_1to1_mono_unclipped(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, T[] out, MPGLib.ProcessedBytes pnt, Factory<T> tFactory) {
        Object[] samples_tmp = new Object[64];
        int tmp1 = 0;
        MPGLib.ProcessedBytes pnt1 = new MPGLib.ProcessedBytes();
        int ret = this.synth_1to1_unclipped(mp, bandPtr, bandPos, 0, samples_tmp, pnt1, tFactory);
        int outPos = pnt.pb;
        for (int i = 0; i < 32; ++i) {
            out[outPos++] = samples_tmp[tmp1];
            tmp1 += 2;
        }
        pnt.pb += 32;
        return ret;
    }

    <T> int synth_1to1(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, int channel, T[] out, MPGLib.ProcessedBytes pnt, Factory<T> tFactory) {
        float sum;
        int bo1;
        int b0Pos;
        float[] b0;
        float[][] buf2;
        int samples = pnt.pb;
        int clip = 0;
        int bo = mp.synth_bo;
        if (0 == channel) {
            --bo;
            bo &= 0xF;
            buf2 = mp.synth_buffs[0];
        } else {
            ++samples;
            buf2 = mp.synth_buffs[1];
        }
        if ((bo & 1) != 0) {
            b0 = buf2[0];
            b0Pos = 0;
            bo1 = bo;
            this.dct64.dct64(buf2[1], bo + 1 & 0xF, buf2[0], bo, bandPtr, bandPos);
        } else {
            b0 = buf2[1];
            b0Pos = 0;
            bo1 = bo + 1;
            this.dct64.dct64(buf2[0], bo, buf2[1], bo + 1, bandPtr, bandPos);
        }
        mp.synth_bo = bo;
        int window = 16 - bo1;
        int j = 16;
        while (j != 0) {
            sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + 1] * b0[b0Pos + 1];
            sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + 3] * b0[b0Pos + 3];
            sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + 5] * b0[b0Pos + 5];
            sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + 7] * b0[b0Pos + 7];
            sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + 9] * b0[b0Pos + 9];
            sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + 11] * b0[b0Pos + 11];
            sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + 13] * b0[b0Pos + 13];
            sum += this.tab.decwin[window + 14] * b0[b0Pos + 14];
            clip = this.WRITE_SAMPLE_CLIPPED(samples, sum -= this.tab.decwin[window + 15] * b0[b0Pos + 15], clip, out, tFactory);
            --j;
            b0Pos += 16;
            window += 32;
            samples += 2;
        }
        sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
        sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
        sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
        sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
        sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
        sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
        sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
        clip = this.WRITE_SAMPLE_CLIPPED(samples, sum += this.tab.decwin[window + 14] * b0[b0Pos + 14], clip, out, tFactory);
        b0Pos -= 16;
        window -= 32;
        samples += 2;
        window += bo1 << 1;
        j = 15;
        while (j != 0) {
            sum = -this.tab.decwin[window + -1] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + -2] * b0[b0Pos + 1];
            sum -= this.tab.decwin[window + -3] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + -4] * b0[b0Pos + 3];
            sum -= this.tab.decwin[window + -5] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + -6] * b0[b0Pos + 5];
            sum -= this.tab.decwin[window + -7] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + -8] * b0[b0Pos + 7];
            sum -= this.tab.decwin[window + -9] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + -10] * b0[b0Pos + 9];
            sum -= this.tab.decwin[window + -11] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + -12] * b0[b0Pos + 11];
            sum -= this.tab.decwin[window + -13] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + -14] * b0[b0Pos + 13];
            sum -= this.tab.decwin[window + -15] * b0[b0Pos + 14];
            clip = this.WRITE_SAMPLE_CLIPPED(samples, sum -= this.tab.decwin[window + 0] * b0[b0Pos + 15], clip, out, tFactory);
            --j;
            b0Pos -= 16;
            window -= 32;
            samples += 2;
        }
        pnt.pb += 64;
        return clip;
    }

    <T> int synth_1to1_unclipped(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, int channel, T[] out, MPGLib.ProcessedBytes pnt, Factory<T> tFactory) {
        float sum;
        int bo1;
        int b0Pos;
        float[] b0;
        float[][] buf2;
        int samples = pnt.pb;
        int clip = 0;
        int bo = mp.synth_bo;
        if (0 == channel) {
            --bo;
            bo &= 0xF;
            buf2 = mp.synth_buffs[0];
        } else {
            ++samples;
            buf2 = mp.synth_buffs[1];
        }
        if ((bo & 1) != 0) {
            b0 = buf2[0];
            b0Pos = 0;
            bo1 = bo;
            this.dct64.dct64(buf2[1], bo + 1 & 0xF, buf2[0], bo, bandPtr, bandPos);
        } else {
            b0 = buf2[1];
            b0Pos = 0;
            bo1 = bo + 1;
            this.dct64.dct64(buf2[0], bo, buf2[1], bo + 1, bandPtr, bandPos);
        }
        mp.synth_bo = bo;
        int window = 16 - bo1;
        int j = 16;
        while (j != 0) {
            sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + 1] * b0[b0Pos + 1];
            sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + 3] * b0[b0Pos + 3];
            sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + 5] * b0[b0Pos + 5];
            sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + 7] * b0[b0Pos + 7];
            sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + 9] * b0[b0Pos + 9];
            sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + 11] * b0[b0Pos + 11];
            sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + 13] * b0[b0Pos + 13];
            sum += this.tab.decwin[window + 14] * b0[b0Pos + 14];
            this.WRITE_SAMPLE_UNCLIPPED(samples, sum -= this.tab.decwin[window + 15] * b0[b0Pos + 15], clip, out, tFactory);
            --j;
            b0Pos += 16;
            window += 32;
            samples += 2;
        }
        sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
        sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
        sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
        sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
        sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
        sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
        sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
        this.WRITE_SAMPLE_UNCLIPPED(samples, sum += this.tab.decwin[window + 14] * b0[b0Pos + 14], clip, out, tFactory);
        b0Pos -= 16;
        window -= 32;
        samples += 2;
        window += bo1 << 1;
        j = 15;
        while (j != 0) {
            sum = -this.tab.decwin[window + -1] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + -2] * b0[b0Pos + 1];
            sum -= this.tab.decwin[window + -3] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + -4] * b0[b0Pos + 3];
            sum -= this.tab.decwin[window + -5] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + -6] * b0[b0Pos + 5];
            sum -= this.tab.decwin[window + -7] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + -8] * b0[b0Pos + 7];
            sum -= this.tab.decwin[window + -9] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + -10] * b0[b0Pos + 9];
            sum -= this.tab.decwin[window + -11] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + -12] * b0[b0Pos + 11];
            sum -= this.tab.decwin[window + -13] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + -14] * b0[b0Pos + 13];
            sum -= this.tab.decwin[window + -15] * b0[b0Pos + 14];
            this.WRITE_SAMPLE_UNCLIPPED(samples, sum -= this.tab.decwin[window + 0] * b0[b0Pos + 15], clip, out, tFactory);
            --j;
            b0Pos -= 16;
            window -= 32;
            samples += 2;
        }
        pnt.pb += 64;
        return clip;
    }

    static interface Factory<T> {
        public T create(float var1);
    }
}

