/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.LameInternalFlags;

public class FFT {
    private static float[] window = new float[1024];
    private static float[] window_s = new float[128];
    private static final float[] costab = new float[]{0.9238795f, 0.38268343f, 0.9951847f, 0.09801714f, 0.9996988f, 0.024541229f, 0.99998116f, 0.0061358847f};
    private static final byte[] rv_tbl = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2};

    private void fht(float[] fz, int fzPos, int n) {
        int tri = 0;
        int fn = fzPos + (n <<= 1);
        int k4 = 4;
        do {
            int kx = k4 >> 1;
            int k1 = k4;
            int k2 = k4 << 1;
            int k3 = k2 + k1;
            k4 = k2 << 1;
            int fi = fzPos;
            int gi = fi + kx;
            do {
                float f1 = fz[fi + 0] - fz[fi + k1];
                float f0 = fz[fi + 0] + fz[fi + k1];
                float f3 = fz[fi + k2] - fz[fi + k3];
                float f2 = fz[fi + k2] + fz[fi + k3];
                fz[fi + k2] = f0 - f2;
                fz[fi + 0] = f0 + f2;
                fz[fi + k3] = f1 - f3;
                fz[fi + k1] = f1 + f3;
                f1 = fz[gi + 0] - fz[gi + k1];
                f0 = fz[gi + 0] + fz[gi + k1];
                f3 = 1.4142135f * fz[gi + k3];
                f2 = 1.4142135f * fz[gi + k2];
                fz[gi + k2] = f0 - f2;
                fz[gi + 0] = f0 + f2;
                fz[gi + k3] = f1 - f3;
                fz[gi + k1] = f1 + f3;
                gi += k4;
            } while ((fi += k4) < fn);
            float c1 = costab[tri + 0];
            float s1 = costab[tri + 1];
            for (int i = 1; i < kx; ++i) {
                float c2 = 1.0f - 2.0f * s1 * s1;
                float s2 = 2.0f * s1 * c1;
                fi = fzPos + i;
                gi = fzPos + k1 - i;
                do {
                    float b = s2 * fz[fi + k1] - c2 * fz[gi + k1];
                    float a = c2 * fz[fi + k1] + s2 * fz[gi + k1];
                    float f1 = fz[fi + 0] - a;
                    float f0 = fz[fi + 0] + a;
                    float g1 = fz[gi + 0] - b;
                    float g0 = fz[gi + 0] + b;
                    b = s2 * fz[fi + k3] - c2 * fz[gi + k3];
                    a = c2 * fz[fi + k3] + s2 * fz[gi + k3];
                    float f3 = fz[fi + k2] - a;
                    float f2 = fz[fi + k2] + a;
                    float g3 = fz[gi + k2] - b;
                    float g2 = fz[gi + k2] + b;
                    b = s1 * f2 - c1 * g3;
                    a = c1 * f2 + s1 * g3;
                    fz[fi + k2] = f0 - a;
                    fz[fi + 0] = f0 + a;
                    fz[gi + k3] = g1 - b;
                    fz[gi + k1] = g1 + b;
                    b = c1 * g2 - s1 * f3;
                    a = s1 * g2 + c1 * f3;
                    fz[gi + k2] = g0 - a;
                    fz[gi + 0] = g0 + a;
                    fz[fi + k3] = f1 - b;
                    fz[fi + k1] = f1 + b;
                    gi += k4;
                } while ((fi += k4) < fn);
                c2 = c1;
                c1 = c2 * costab[tri + 0] - s1 * costab[tri + 1];
                s1 = c2 * costab[tri + 1] + s1 * costab[tri + 0];
            }
            tri += 2;
        } while (k4 < n);
    }

    public final void fft_short(LameInternalFlags gfc, float[][] x_real, int chn, float[][] buffer, int bufPos) {
        for (int b = 0; b < 3; ++b) {
            int x = 128;
            short k = (short)(192 * (b + 1));
            int j = 31;
            do {
                int i = rv_tbl[j << 2] & 0xFF;
                float f0 = window_s[i] * buffer[chn][bufPos + i + k];
                float w = window_s[127 - i] * buffer[chn][bufPos + i + k + 128];
                float f1 = f0 - w;
                f0 += w;
                float f2 = window_s[i + 64] * buffer[chn][bufPos + i + k + 64];
                w = window_s[63 - i] * buffer[chn][bufPos + i + k + 192];
                float f3 = f2 - w;
                x_real[b][(x -= 4) + 0] = f0 + (f2 += w);
                x_real[b][x + 2] = f0 - f2;
                x_real[b][x + 1] = f1 + f3;
                x_real[b][x + 3] = f1 - f3;
                f0 = window_s[i + 1] * buffer[chn][bufPos + i + k + 1];
                w = window_s[126 - i] * buffer[chn][bufPos + i + k + 129];
                f1 = f0 - w;
                f0 += w;
                f2 = window_s[i + 65] * buffer[chn][bufPos + i + k + 65];
                w = window_s[62 - i] * buffer[chn][bufPos + i + k + 193];
                f3 = f2 - w;
                x_real[b][x + 128 + 0] = f0 + (f2 += w);
                x_real[b][x + 128 + 2] = f0 - f2;
                x_real[b][x + 128 + 1] = f1 + f3;
                x_real[b][x + 128 + 3] = f1 - f3;
            } while (--j >= 0);
            this.fht(x_real[b], x, 128);
        }
    }

    public final void fft_long(LameInternalFlags gfc, float[] y, int chn, float[][] buffer, int bufPos) {
        int jj = 127;
        int x = 512;
        do {
            int i = rv_tbl[jj] & 0xFF;
            float f0 = window[i] * buffer[chn][bufPos + i];
            float w = window[i + 512] * buffer[chn][bufPos + i + 512];
            float f1 = f0 - w;
            f0 += w;
            float f2 = window[i + 256] * buffer[chn][bufPos + i + 256];
            w = window[i + 768] * buffer[chn][bufPos + i + 768];
            float f3 = f2 - w;
            y[(x -= 4) + 0] = f0 + (f2 += w);
            y[x + 2] = f0 - f2;
            y[x + 1] = f1 + f3;
            y[x + 3] = f1 - f3;
            f0 = window[i + 1] * buffer[chn][bufPos + i + 1];
            w = window[i + 513] * buffer[chn][bufPos + i + 513];
            f1 = f0 - w;
            f0 += w;
            f2 = window[i + 257] * buffer[chn][bufPos + i + 257];
            w = window[i + 769] * buffer[chn][bufPos + i + 769];
            f3 = f2 - w;
            y[x + 512 + 0] = f0 + (f2 += w);
            y[x + 512 + 2] = f0 - f2;
            y[x + 512 + 1] = f1 + f3;
            y[x + 512 + 3] = f1 - f3;
        } while (--jj >= 0);
        this.fht(y, x, 512);
    }

    public final void init_fft(LameInternalFlags gfc) {
        int i;
        for (i = 0; i < 1024; ++i) {
            FFT.window[i] = (float)(0.42 - 0.5 * Math.cos(Math.PI * 2 * ((double)i + 0.5) / 1024.0) + 0.08 * Math.cos(Math.PI * 4 * ((double)i + 0.5) / 1024.0));
        }
        for (i = 0; i < 128; ++i) {
            FFT.window_s[i] = (float)(0.5 * (1.0 - Math.cos(Math.PI * 2 * ((double)i + 0.5) / 256.0)));
        }
    }
}

