/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.lowlevel;

import de.sciss.jump3r.mp3.BRHist;
import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.GainAnalysis;
import de.sciss.jump3r.mp3.GetAudio;
import de.sciss.jump3r.mp3.ID3Tag;
import de.sciss.jump3r.mp3.Lame;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.MPEGMode;
import de.sciss.jump3r.mp3.Parse;
import de.sciss.jump3r.mp3.Presets;
import de.sciss.jump3r.mp3.Quantize;
import de.sciss.jump3r.mp3.QuantizePVT;
import de.sciss.jump3r.mp3.Reservoir;
import de.sciss.jump3r.mp3.Takehiro;
import de.sciss.jump3r.mp3.Util;
import de.sciss.jump3r.mp3.VBRTag;
import de.sciss.jump3r.mp3.VbrMode;
import de.sciss.jump3r.mp3.Version;
import de.sciss.jump3r.mpg.Common;
import de.sciss.jump3r.mpg.Interface;
import de.sciss.jump3r.mpg.MPGLib;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

public class LameEncoder {
    public static final AudioFormat.Encoding MPEG1L3 = new AudioFormat.Encoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L3 = new AudioFormat.Encoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = new AudioFormat.Encoding("MPEG2DOT5L3");
    public static final String P_VBR = "vbr";
    public static final String P_CHMODE = "chmode";
    public static final String P_BITRATE = "bitrate";
    public static final String P_QUALITY = "quality";
    public static final int MPEG_VERSION_2 = 0;
    public static final int MPEG_VERSION_1 = 1;
    public static final int MPEG_VERSION_2DOT5 = 2;
    public static final int QUALITY_LOWEST = 9;
    public static final int QUALITY_LOW = 7;
    public static final int QUALITY_MIDDLE = 5;
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_HIGHEST = 1;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int CHANNEL_MODE_AUTO = -1;
    public static final int BITRATE_AUTO = -1;
    private static final int DEFAULT_PCM_BUFFER_SIZE = 32768;
    private static int DEFAULT_QUALITY = 5;
    private static int DEFAULT_BITRATE = -1;
    private static int DEFAULT_CHANNEL_MODE = -1;
    private static boolean DEFAULT_VBR = false;
    private AudioFormat.Encoding sourceEncoding;
    private ByteOrder sourceByteOrder;
    private int sourceChannels;
    private int sourceSampleRate;
    private int sourceSampleSizeInBits;
    private boolean sourceIsBigEndian;
    private int quality = DEFAULT_QUALITY;
    private int bitRate = DEFAULT_BITRATE;
    private boolean vbrMode = DEFAULT_VBR;
    private int chMode = DEFAULT_CHANNEL_MODE;
    private int effQuality;
    private int effBitRate;
    private int effVbr;
    private int effChMode;
    private int effSampleRate;
    private int effEncoding;
    private LameGlobalFlags gfp;
    private AudioFormat sourceFormat;
    private AudioFormat targetFormat;
    GetAudio gaud;
    ID3Tag id3;
    Lame lame;
    GainAnalysis ga;
    BitStream bs;
    Presets p;
    QuantizePVT qupvt;
    Quantize qu;
    VBRTag vbr;
    Version ver;
    Util util;
    Reservoir rv;
    Takehiro tak;
    Parse parse;
    BRHist hist;
    MPGLib mpg;
    Interface intf;
    Common common;

    public LameEncoder() {
    }

    public LameEncoder(AudioFormat sourceFormat) {
        this.readParams(sourceFormat, null);
        this.setFormat(sourceFormat, null);
    }

    public LameEncoder(AudioFormat sourceFormat, AudioFormat targetFormat) {
        this.readParams(sourceFormat, targetFormat.properties());
        this.setFormat(sourceFormat, targetFormat);
    }

    public LameEncoder(AudioFormat sourceFormat, int bitRate, int channelMode, int quality, boolean VBR) {
        this.bitRate = bitRate;
        this.chMode = channelMode;
        this.quality = quality;
        this.vbrMode = VBR;
        this.setFormat(sourceFormat, null);
    }

    private void readParams(AudioFormat sourceFormat, Map<String, Object> props) {
        if (props != null) {
            this.readProps(props);
        }
    }

    public void setSourceFormat(AudioFormat sourceFormat) {
        this.setFormat(sourceFormat, null);
    }

    public void setTargetFormat(AudioFormat targetFormat) {
        this.setFormat(null, targetFormat);
    }

    public void setFormat(AudioFormat sourceFormat, AudioFormat targetFormat) {
        int result;
        this.sourceFormat = sourceFormat;
        if (sourceFormat != null) {
            this.sourceEncoding = sourceFormat.getEncoding();
            this.sourceSampleSizeInBits = sourceFormat.getSampleSizeInBits();
            this.sourceByteOrder = sourceFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            this.sourceChannels = sourceFormat.getChannels();
            this.sourceSampleRate = Math.round(sourceFormat.getSampleRate());
            this.sourceIsBigEndian = sourceFormat.isBigEndian();
            if (sourceFormat.getSampleRate() < 32000.0f && this.bitRate > 160) {
                this.bitRate = 160;
            }
        }
        int targetSampleRate = -1;
        this.targetFormat = targetFormat;
        if (targetFormat != null) {
            targetSampleRate = Math.round(targetFormat.getSampleRate());
        }
        if ((result = this.nInitParams(this.sourceChannels, this.sourceSampleRate, targetSampleRate, this.bitRate, this.chMode, this.quality, this.vbrMode, this.sourceIsBigEndian)) < 0) {
            throw new IllegalArgumentException("parameters not supported by LAME (returned " + result + ")");
        }
    }

    private int nInitParams(int channels, int inSampleRate, int outSampleRate, int bitrate, int mode, int quality, boolean VBR, boolean bigEndian) {
        this.lame = new Lame();
        this.gaud = new GetAudio();
        this.ga = new GainAnalysis();
        this.bs = new BitStream();
        this.p = new Presets();
        this.qupvt = new QuantizePVT();
        this.qu = new Quantize();
        this.vbr = new VBRTag();
        this.ver = new Version();
        this.id3 = new ID3Tag();
        this.rv = new Reservoir();
        this.tak = new Takehiro();
        this.parse = new Parse();
        this.hist = new BRHist();
        this.mpg = new MPGLib();
        this.intf = new Interface();
        this.common = new Common();
        this.lame.setModules(this.ga, this.bs, this.p, this.qupvt, this.qu, this.vbr, this.ver, this.id3, this.mpg);
        this.bs.setModules(this.ga, this.mpg, this.ver, this.vbr);
        this.id3.setModules(this.bs, this.ver);
        this.p.setModules(this.lame);
        this.qu.setModules(this.bs, this.rv, this.qupvt, this.tak);
        this.qupvt.setModules(this.tak, this.rv, this.lame.enc.psy);
        this.rv.setModules(this.bs);
        this.tak.setModules(this.qupvt);
        this.vbr.setModules(this.lame, this.bs, this.ver);
        this.gaud.setModules(this.parse, this.mpg);
        this.parse.setModules(this.ver, this.id3, this.p);
        this.mpg.setModules(this.intf, this.common);
        this.intf.setModules(this.vbr, this.common);
        this.gfp = this.lame.lame_init();
        this.gfp.num_channels = channels;
        this.gfp.in_samplerate = inSampleRate;
        if (outSampleRate >= 0) {
            this.gfp.out_samplerate = outSampleRate;
        }
        if (mode != -1) {
            this.gfp.mode = MPEGMode.values()[mode];
        }
        if (VBR) {
            this.gfp.VBR = VbrMode.vbr_default;
            this.gfp.VBR_q = quality;
        } else if (bitrate != -1) {
            this.gfp.brate = bitrate;
        }
        this.gfp.quality = quality;
        this.id3.id3tag_init(this.gfp);
        this.gfp.write_id3tag_automatic = false;
        this.gfp.findReplayGain = true;
        int rc = this.lame.lame_init_params(this.gfp);
        this.effSampleRate = this.gfp.out_samplerate;
        this.effBitRate = this.gfp.brate;
        this.effChMode = this.gfp.mode.ordinal();
        this.effVbr = this.gfp.VBR.ordinal();
        this.effQuality = VBR ? this.gfp.VBR_q : this.gfp.quality;
        return rc;
    }

    public String getEncoderVersion() {
        return this.ver.getLameVersion();
    }

    public int getPCMBufferSize() {
        return 32768;
    }

    public int getMP3BufferSize() {
        return this.getPCMBufferSize() / 2 + 1024;
    }

    public int getInputBufferSize() {
        return this.getPCMBufferSize();
    }

    public int getOutputBufferSize() {
        return this.getMP3BufferSize();
    }

    private int doEncodeBuffer(byte[] pcm, int offset, int length, byte[] encoded) {
        int i;
        int bytes_per_sample = this.sourceSampleSizeInBits >> 3;
        int samples_read = length / bytes_per_sample;
        int[] sample_buffer = new int[samples_read];
        int sample_index = samples_read;
        if (!this.sourceEncoding.toString().equals("PCM_FLOAT")) {
            if (this.sourceByteOrder == ByteOrder.LITTLE_ENDIAN) {
                if (bytes_per_sample == 1) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample == 2) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 16 | (pcm[offset + i + 1] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample == 3) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 8 | (pcm[offset + i + 1] & 0xFF) << 16 | (pcm[offset + i + 2] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample == 4) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = pcm[offset + i] & 0xFF | (pcm[offset + i + 1] & 0xFF) << 8 | (pcm[offset + i + 2] & 0xFF) << 16 | (pcm[offset + i + 3] & 0xFF) << 24;
                    }
                }
            } else {
                if (bytes_per_sample == 1) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF ^ 0x80) << 24 | 0x7F0000;
                    }
                }
                if (bytes_per_sample == 2) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 24 | (pcm[offset + i + 1] & 0xFF) << 16;
                    }
                }
                if (bytes_per_sample == 3) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 24 | (pcm[offset + i + 1] & 0xFF) << 16 | (pcm[offset + i + 2] & 0xFF) << 8;
                    }
                }
                if (bytes_per_sample == 4) {
                    i = samples_read * bytes_per_sample;
                    while ((i -= bytes_per_sample) >= 0) {
                        sample_buffer[--sample_index] = (pcm[offset + i] & 0xFF) << 24 | (pcm[offset + i + 1] & 0xFF) << 16 | (pcm[offset + i + 2] & 0xFF) << 8 | pcm[offset + i + 3] & 0xFF;
                    }
                }
            }
        } else if (bytes_per_sample == 4) {
            i = samples_read * bytes_per_sample;
            while ((i -= bytes_per_sample) >= 0) {
                byte[] sample = new byte[]{pcm[offset + i], pcm[offset + i + 1], pcm[offset + i + 2], pcm[offset + i + 3]};
                float amlitude = this.convertByteArrayToFloat(sample, 0, this.sourceByteOrder);
                if ((double)Math.abs(amlitude) >= 1.0) continue;
                int sampleInt = Math.round(2.1474836E9f * amlitude);
                sample_buffer[--sample_index] = sampleInt;
            }
        }
        int p = samples_read;
        int[][] buffer = new int[2][samples_read /= this.gfp.num_channels];
        if (this.gfp.num_channels == 2) {
            int i2 = samples_read;
            while (--i2 >= 0) {
                buffer[1][i2] = sample_buffer[--p];
                buffer[0][i2] = sample_buffer[--p];
            }
        } else if (this.gfp.num_channels == 1) {
            Arrays.fill(buffer[1], 0, samples_read, 0);
            int i3 = samples_read;
            while (--i3 >= 0) {
                int n = sample_buffer[--p];
                buffer[1][i3] = n;
                buffer[0][i3] = n;
            }
        }
        int res = this.lame.lame_encode_buffer_int(this.gfp, buffer[0], buffer[1], samples_read, encoded, 0, encoded.length);
        return res;
    }

    public int encodeBuffer(byte[] pcm, int offset, int length, byte[] encoded) throws ArrayIndexOutOfBoundsException {
        if (length < 0 || offset + length > pcm.length) {
            throw new IllegalArgumentException("inconsistent parameters");
        }
        int result = this.doEncodeBuffer(pcm, offset, length, encoded);
        if (result < 0) {
            if (result == -1) {
                throw new ArrayIndexOutOfBoundsException("Encode buffer too small");
            }
            throw new RuntimeException("crucial error in encodeBuffer.");
        }
        return result;
    }

    public int encodeFinish(byte[] encoded) {
        return this.lame.lame_encode_flush(this.gfp, encoded, 0, encoded.length);
    }

    public void close() {
        this.lame.lame_close(this.gfp);
    }

    private void readProps(Map<String, Object> props) {
        Object q = props.get(P_QUALITY);
        if (q instanceof String) {
            this.quality = this.string2quality(((String)q).toLowerCase(), this.quality);
        } else if (q instanceof Integer) {
            this.quality = (Integer)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of quality property: " + q);
        }
        q = props.get(P_BITRATE);
        if (q instanceof String) {
            this.bitRate = Integer.parseInt((String)q);
        } else if (q instanceof Integer) {
            this.bitRate = (Integer)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of bitrate property: " + q);
        }
        q = props.get(P_CHMODE);
        if (q instanceof String) {
            this.chMode = this.string2chmode(((String)q).toLowerCase(), this.chMode);
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of chmode property: " + q);
        }
        q = props.get(P_VBR);
        if (q instanceof String) {
            this.vbrMode = LameEncoder.string2bool((String)q);
        } else if (q instanceof Boolean) {
            this.vbrMode = (Boolean)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of vbr property: " + q);
        }
    }

    public AudioFormat getEffectiveFormat() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUALITY, this.getEffectiveQuality());
        map.put(P_BITRATE, this.getEffectiveBitRate());
        map.put(P_CHMODE, this.chmode2string(this.getEffectiveChannelMode()));
        map.put(P_VBR, this.getEffectiveVBR());
        map.put("encoder.name", "LAME");
        map.put("encoder.version", this.getEncoderVersion());
        int channels = 2;
        if (this.chMode == 3) {
            channels = 1;
        }
        return new AudioFormat(this.getEffectiveEncoding(), this.getEffectiveSampleRate(), -1, channels, -1, -1.0f, false, map);
    }

    public int getEffectiveQuality() {
        if (this.effQuality >= 9) {
            return 9;
        }
        if (this.effQuality >= 7) {
            return 7;
        }
        if (this.effQuality >= 5) {
            return 5;
        }
        if (this.effQuality >= 2) {
            return 2;
        }
        return 1;
    }

    public int getEffectiveBitRate() {
        return this.effBitRate;
    }

    public int getEffectiveChannelMode() {
        return this.effChMode;
    }

    public boolean getEffectiveVBR() {
        return this.effVbr != 0;
    }

    public int getEffectiveSampleRate() {
        return this.effSampleRate;
    }

    public AudioFormat.Encoding getEffectiveEncoding() {
        if (this.effEncoding == 0) {
            if (this.getEffectiveSampleRate() < 16000) {
                return MPEG2DOT5L3;
            }
            return MPEG2L3;
        }
        if (this.effEncoding == 2) {
            return MPEG2DOT5L3;
        }
        return MPEG1L3;
    }

    private int string2quality(String quality, int def) {
        if (quality.equals("lowest")) {
            return 9;
        }
        if (quality.equals("low")) {
            return 7;
        }
        if (quality.equals("middle")) {
            return 5;
        }
        if (quality.equals("high")) {
            return 2;
        }
        if (quality.equals("highest")) {
            return 1;
        }
        return def;
    }

    private String chmode2string(int chmode) {
        if (chmode == 0) {
            return "stereo";
        }
        if (chmode == 1) {
            return "jointstereo";
        }
        if (chmode == 2) {
            return "dual";
        }
        if (chmode == 3) {
            return "mono";
        }
        if (chmode == -1) {
            return "auto";
        }
        return "auto";
    }

    private int string2chmode(String chmode, int def) {
        if (chmode.equals("stereo")) {
            return 0;
        }
        if (chmode.equals("jointstereo")) {
            return 1;
        }
        if (chmode.equals("dual")) {
            return 2;
        }
        if (chmode.equals("mono")) {
            return 3;
        }
        if (chmode.equals("auto")) {
            return -1;
        }
        return def;
    }

    private static boolean string2bool(String val) {
        if (val.length() > 0) {
            if (val.charAt(0) == 'f' || val.charAt(0) == 'n' || val.equals("off")) {
                return false;
            }
            if (val.charAt(0) == 't' || val.charAt(0) == 'y' || val.equals("on")) {
                return true;
            }
        }
        throw new IllegalArgumentException("wrong string for boolean property: " + val);
    }

    public final float convertByteArrayToFloat(byte[] bytes, int offset, ByteOrder byteOrder) {
        byte byte0 = bytes[offset + 0];
        byte byte1 = bytes[offset + 1];
        byte byte2 = bytes[offset + 2];
        byte byte3 = bytes[offset + 3];
        int bits = byteOrder == ByteOrder.BIG_ENDIAN ? (0xFF & byte0) << 24 | (0xFF & byte1) << 16 | (0xFF & byte2) << 8 | (0xFF & byte3) << 0 : (0xFF & byte3) << 24 | (0xFF & byte2) << 16 | (0xFF & byte1) << 8 | (0xFF & byte0) << 0;
        float result = Float.intBitsToFloat(bits);
        return result;
    }

    public AudioFormat getSourceFormat() {
        return this.sourceFormat;
    }

    public AudioFormat getTargetFormat() {
        return this.targetFormat;
    }
}

