/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.lowlevel;

import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.Enc;
import de.sciss.jump3r.mp3.GainAnalysis;
import de.sciss.jump3r.mp3.GetAudio;
import de.sciss.jump3r.mp3.ID3Tag;
import de.sciss.jump3r.mp3.Lame;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.Parse;
import de.sciss.jump3r.mp3.Presets;
import de.sciss.jump3r.mp3.Quantize;
import de.sciss.jump3r.mp3.QuantizePVT;
import de.sciss.jump3r.mp3.Reservoir;
import de.sciss.jump3r.mp3.Takehiro;
import de.sciss.jump3r.mp3.VBRTag;
import de.sciss.jump3r.mp3.Version;
import de.sciss.jump3r.mpg.Common;
import de.sciss.jump3r.mpg.Interface;
import de.sciss.jump3r.mpg.MPGLib;
import java.nio.ByteBuffer;

public class LameDecoder {
    private GetAudio gaud;
    private ID3Tag id3;
    private Lame lame;
    private GainAnalysis ga;
    private BitStream bs;
    private Presets p;
    private QuantizePVT qupvt;
    private Quantize qu;
    private VBRTag vbr;
    private Version ver;
    private Reservoir rv;
    private Takehiro tak;
    private Parse parse;
    private MPGLib mpg;
    private Interface intf;
    private Common common;
    private int wavsize;
    private short[][] buffer = new short[2][1152];
    private LameGlobalFlags gfp;

    public LameDecoder(String mp3File) {
        this.lame = new Lame();
        this.gaud = new GetAudio();
        this.ga = new GainAnalysis();
        this.bs = new BitStream();
        this.p = new Presets();
        this.qupvt = new QuantizePVT();
        this.qu = new Quantize();
        this.vbr = new VBRTag();
        this.ver = new Version();
        this.id3 = new ID3Tag();
        this.rv = new Reservoir();
        this.tak = new Takehiro();
        this.parse = new Parse();
        this.mpg = new MPGLib();
        this.intf = new Interface();
        this.common = new Common();
        this.lame.setModules(this.ga, this.bs, this.p, this.qupvt, this.qu, this.vbr, this.ver, this.id3, this.mpg);
        this.bs.setModules(this.ga, this.mpg, this.ver, this.vbr);
        this.id3.setModules(this.bs, this.ver);
        this.p.setModules(this.lame);
        this.qu.setModules(this.bs, this.rv, this.qupvt, this.tak);
        this.qupvt.setModules(this.tak, this.rv, this.lame.enc.psy);
        this.rv.setModules(this.bs);
        this.tak.setModules(this.qupvt);
        this.vbr.setModules(this.lame, this.bs, this.ver);
        this.gaud.setModules(this.parse, this.mpg);
        this.parse.setModules(this.ver, this.id3, this.p);
        this.mpg.setModules(this.intf, this.common);
        this.intf.setModules(this.vbr, this.common);
        this.gfp = this.lame.lame_init();
        this.gfp.write_id3tag_automatic = false;
        this.lame.lame_init_params(this.gfp);
        this.parse.input_format = GetAudio.sound_file_format.sf_mp3;
        StringBuilder inPath = new StringBuilder(mp3File);
        Enc enc = new Enc();
        this.gaud.init_infile(this.gfp, inPath.toString(), enc);
        int skip_start = 0;
        int skip_end = 0;
        if (this.parse.silent < 10) {
            System.out.printf("\rinput:  %s%s(%g kHz, %d channel%s, ", inPath, inPath.length() > 26 ? "\n\t" : "  ", (double)this.gfp.in_samplerate / 1000.0, this.gfp.num_channels, this.gfp.num_channels != 1 ? "s" : "");
        }
        if (enc.enc_delay > -1 || enc.enc_padding > -1) {
            if (enc.enc_delay > -1) {
                skip_start = enc.enc_delay + 528 + 1;
            }
            if (enc.enc_padding > -1) {
                skip_end = enc.enc_padding - 529;
            }
        } else {
            skip_start = this.gfp.encoder_delay + 528 + 1;
        }
        System.out.printf("MPEG-%d%s Layer %s", 2 - this.gfp.version, this.gfp.out_samplerate < 16000 ? ".5" : "", "III");
        System.out.printf(")\noutput: (16 bit, Microsoft WAVE)\n", new Object[0]);
        if (skip_start > 0) {
            System.out.printf("skipping initial %d samples (encoder+decoder delay)\n", skip_start);
        }
        if (skip_end > 0) {
            System.out.printf("skipping final %d samples (encoder padding-decoder delay)\n", skip_end);
        }
        this.wavsize = -(skip_start + skip_end);
        this.parse.mp3input_data.totalframes = this.parse.mp3input_data.nsamp / this.parse.mp3input_data.framesize;
        assert (this.gfp.num_channels >= 1 && this.gfp.num_channels <= 2);
    }

    public void decode(ByteBuffer sampleBuffer, boolean playOriginal) {
        int iread = this.gaud.get_audio16(this.gfp, this.buffer);
        if (iread >= 0) {
            this.parse.mp3input_data.framenum += iread / this.parse.mp3input_data.framesize;
            this.wavsize += iread;
            for (int i = 0; i < iread; ++i) {
                if (playOriginal) {
                    sampleBuffer.array()[i * 2] = (byte)(this.buffer[0][i] & 0xFF);
                    sampleBuffer.array()[i * 2 + 1] = (byte)((this.buffer[0][i] & 0xFFFF) >> 8 & 0xFF);
                }
                if (this.gfp.num_channels != 2) continue;
            }
        }
    }

    public void close() {
        this.lame.lame_close(this.gfp);
    }
}

