/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jcamerainfo;

import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.CameraMetadataPrinter;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.FileFilters;

public class JCameraInfoPanel
extends JPanel
implements EditListener {
    private AlbumObject ao;
    private FileFilters.BasicImageInfo ii;
    private JTextArea content = new JTextArea();
    private DecimalFormat twoDec = new DecimalFormat("0.##");
    private ImageInfoFormatter formatter = new ImageInfoFormatter();
    private PluginContext context;
    private boolean showing = false;

    public JCameraInfoPanel(PluginContext context) {
        this.context = context;
        this.init();
    }

    private static ExifSubIFDDirectory getMainSubIFDDirectory(Metadata meta) {
        for (ExifSubIFDDirectory dir : meta.getDirectoriesOfType(ExifSubIFDDirectory.class)) {
            if (dir.containsTag(254)) continue;
            return dir;
        }
        return null;
    }

    private static Dimension getImageDim(Metadata meta) throws MetadataException {
        for (ExifSubIFDDirectory dir : meta.getDirectoriesOfType(ExifSubIFDDirectory.class)) {
            if (dir.containsTag(40962)) {
                return new Dimension(dir.getInt(40962), dir.getInt(40963));
            }
            if (!dir.containsTag(256)) continue;
            return new Dimension(dir.getInt(256), dir.getInt(257));
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.ao == null) {
            return "";
        }
        CameraMetadataPrinter printer = new CameraMetadataPrinter();
        return printer.printMetadata(this.ao, "\n");
    }

    public void setAlbumObject(AlbumObject ao) {
        this.ao = ao;
        if (ao != null) {
            try {
                this.ii = ao.getImageInfo();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
        if (ao == null || ao.isFolder() && this.showing) {
            this.context.getEditPanel().removeCustomTab((JComponent)this);
            this.showing = false;
            return;
        }
        if (!ao.isFolder() && !this.showing) {
            this.context.getEditPanel().addCustomTab(Msg.get((String)"edit.camera"), (JComponent)this);
            this.showing = true;
        }
        this.content.setText(this.toString());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.content.setOpaque(false);
        this.content.setFont(new JTextField().getFont());
        this.content.setForeground(JAlbumColor.textSublimeText);
        this.setBackground(JAlbumColor.text);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.content.setFont(this.content.getFont().deriveFont(11.0f));
        this.content.setEditable(false);
        this.content.setToolTipText("<html>File name<br>Original date<br>(Pixel size) - Disk size<br>Camera make - model<br>Lens type (if available)<br>Focal length (35mm eq)<br>Exp mode (ISO eq) - Exp bias<br>Exp time - Aperture<br>White balance mode (Temp)</html>");
        this.add((Component)this.content, "Center");
        this.validate();
    }
}

