/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.Book;
import com.inet.jorthodictionaries.BookGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BookGenerator_pl_Engish
extends BookGenerator {
    BookGenerator_pl_Engish(Book book) {
        super(book);
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        if (wikiText.indexOf("==Polish==") < 0) {
            return false;
        }
        this.conjugationAiUje(wikiText);
        this.conjugationApAm_Asz(wikiText);
        this.conjugationAiAm_Asz(wikiText);
        this.conjugationAi(wikiText);
        this.declensionNoun(wikiText);
        this.declensionNounCja(wikiText);
        this.declensionNounF(wikiText);
        this.declensionNounIa(wikiText);
        this.declensionAdjI(wikiText);
        this.declensionAdjKi(wikiText);
        this.declensionAdjY(wikiText);
        this.declensionAdjIa(wikiText);
        this.declensionAdj(wikiText);
        return true;
    }

    private void conjugationAiUje(String wikiText) {
        String[] suffixe = new String[]{"owa\u0107", "uj\u0119", "ujemy", "ujesz", "ujecie", "uje", "uj\u0105", "owa\u0142em", "owa\u0142am", "owali\u015bmy", "owa\u0142y\u015bmy", "owa\u0142e\u015b", "owa\u0142a\u015b", "owali\u015bcie", "owa\u0142y\u015bcie", "owa\u0142", "owa\u0142a", "owa\u0142o", "owali", "owa\u0142y", "owa\u0142bym", "owa\u0142abym", "owaliby\u015bmy", "owa\u0142yby\u015bmy", "owa\u0142by\u015b", "owa\u0142aby\u015b", "owaliby\u015bcie", "owa\u0142yby\u015bcie", "owa\u0142by", "owa\u0142aby", "owa\u0142oby", "owaliby", "owa\u0142yby", "uj", "ujcie", "uj\u0105cy", "uj\u0105ca", "uj\u0105ce", "uj\u0105cy", "uj\u0105c", "owano", "owanie"};
        this.templateWithRoots(wikiText, "pl-conj-ai-uj\u0119", new String[][]{suffixe});
    }

    private void conjugationApAm_Asz(String wikiText) {
        String[] suffixe = new String[]{"\u0107", "m", "my", "sz", "cie", "", "j\u0105", "\u0142em", "\u0142am", "li\u015bmy", "\u0142y\u015bmy", "\u0142e\u015b", "\u0142a\u015b", "li\u015bcie", "\u0142y\u015bcie", "\u0142", "\u0142a", "\u0142o", "li", "\u0142y", "\u0142bym", "\u0142abym", "liby\u015bmy", "\u0142yby\u015bmy", "\u0142by\u015b", "\u0142aby\u015b", "liby\u015bcie", "\u0142yby\u015bcie", "\u0142by", "\u0142aby", "\u0142oby", "liby", "\u0142yby", "jmy", "j", "jcie"};
        this.templateWithRoots(wikiText, "pl-conj-ap-am,asz", new String[][]{suffixe});
    }

    private void conjugationAiAm_Asz(String wikiText) {
        String[] suffixe = new String[]{"\u0107", "m", "my", "sz", "cie", "", "j\u0105", "\u0142em", "\u0142am", "li\u015bmy", "\u0142y\u015bmy", "\u0142e\u015b", "\u0142a\u015b", "li\u015bcie", "\u0142y\u015bcie", "\u0142", "\u0142a", "\u0142o", "li", "\u0142y", "b\u0119d\u0119", "\u0142", "\u0142a", "li", "\u0142y", "\u0142", "\u0142a", "li", "\u0142y", "\u0142", "\u0142a", "\u0142o", "li", "\u0142y", "\u0142bym", "\u0142abym", "liby\u015bmy", "\u0142yby\u015bmy", "\u0142by\u015b", "\u0142aby\u015b", "liby\u015bcie", "\u0142yby\u015bcie", "\u0142by", "\u0142aby", "\u0142oby", "liby", "\u0142yby", "my", "j", "jcie", "j\u0105", "j\u0105cy", "j\u0105ca", "j\u0105ce", "j\u0105cy", "j\u0105ce", "j\u0105c", "no", "nie"};
        this.templateWithRoots(wikiText, "pl-conj-ai-am,asz", new String[][]{suffixe});
    }

    private void conjugationAi(String wikiText) {
        String[] suffixeRoot1 = new String[]{""};
        String[] suffixeRoot2 = new String[]{""};
        String[] suffixeRoot3 = new String[]{"my", "sz", "cie", ""};
        String[] suffixeRoot4 = new String[]{"", "cy", "ca", "ce", "c"};
        String[] suffixeRoot5 = new String[]{"\u0142em", "\u0142e\u015b", "\u0142", "\u0142bym", "\u0142by\u015b", "\u0142by"};
        String[] suffixeRoot6 = new String[]{"\u0142am", "\u0142y\u015bmy", "\u0142a\u015b", "\u0142y\u015bcie", "\u0142a", "\u0142o", "\u0142y", "\u0142abym", "\u0142yby\u015bmy", "\u0142aby\u015b", "\u0142yby\u015bcie", "\u0142aby", "\u0142oby", "\u0142yby"};
        String[] suffixeRoot7 = new String[]{"li\u015bmy", "li\u015bcie", "li", "liby\u015bmy", "liby\u015bcie", "liby"};
        String[] suffixeRoot8 = new String[]{"my", "", "cie"};
        this.templateWithRoots(wikiText, "pl-conj-ai", suffixeRoot1, suffixeRoot2, suffixeRoot3, suffixeRoot4, suffixeRoot5, suffixeRoot6, suffixeRoot7, suffixeRoot8);
    }

    private void declensionNoun(String wikiText) {
        this.templateWithWordList(wikiText, "pl-decl-noun");
    }

    private void declensionNounCja(String wikiText) {
        String[] suffixe = new String[]{"ja", "je", "ji", "ji", "yj", "ji", "jom", "j\u0119", "je", "j\u0105", "jami", "ji", "jach", "jo", "je"};
        this.templateWithRoots(wikiText, "pl-decl-noun-cja", new String[][]{suffixe});
    }

    private void declensionNounF(String wikiText) {
        String[] suffixe = new String[]{"ba", "ca", "cha", "cza", "dza", "d\u017ca", "fa", "ga", "ka", "la", "\u0142a", "ma", "pa", "ra", "sa", "sza", "wa", "za", "\u017ca"};
        this.templateWithRoots(wikiText, "pl-decl-noun-f", new String[][]{suffixe});
    }

    private void declensionNounIa(String wikiText) {
        String[] suffixe = new String[]{"ia", "ie", "ii", "iom", "i\u0119", "ie", "i\u0105", "iami", "iach", "io", "ie"};
        this.templateWithRoots(wikiText, "pl-decl-noun-ia", new String[][]{suffixe});
    }

    private void declensionAdjI(String wikiText) {
        String[] suffixeRoot1 = new String[]{"i", "ie", "a", "ie", "iego", "ie", "ich", "iemu", "im", "iego", "i", "ie", "\u0105", "ich", "ie", "im", "imi", "ie", "ich"};
        String[] suffixeRoot2 = new String[]{""};
        this.templateWithRoots(wikiText, "pl-decl-adj-i", suffixeRoot1, suffixeRoot2);
    }

    private void declensionAdjKi(String wikiText) {
        String[] suffixe = new String[]{"ki", "kie", "ka", "cy", "kie", "kiego", "kiej", "kich", "kiemu", "kim", "kiego", "ki", "kie", "k\u0105", "kich", "kie", "kim", "kimi", "kiej", "kich"};
        this.templateWithRoots(wikiText, "pl-decl-adj-ki", new String[][]{suffixe});
    }

    private void declensionAdjY(String wikiText) {
        String[] suffixeRoot1 = new String[]{"y", "e", "a", "e", "ego", "ej", "ych", "emu", "ym", "ego", "y", "e", "\u0105", "ych", "e", "ym", "ymi", "ej", "ych"};
        String[] suffixeRoot2 = new String[]{""};
        this.templateWithRoots(wikiText, "pl-decl-adj-y", suffixeRoot1, suffixeRoot2);
    }

    private void declensionAdjIa(String wikiText) {
        String[] suffixeRoot1 = new String[]{"i", "ie", "ia", "ie", "iego", "iej", "ich", "iemu", "im", "iego", "i", "ie", "i\u0105", "ich", "ie", "im", "imi", "iej", "ich"};
        String[] suffixeRoot2 = new String[]{""};
        this.templateWithRoots(wikiText, "pl-decl-adj-y", suffixeRoot1, suffixeRoot2);
    }

    private void declensionAdj(String wikiText) {
        this.templateWithWordList(wikiText, "pl-decl-adj");
    }

    private void templateWithRoots(String wikiText, String templateId, String[] ... suffixes) {
        int idx = this.findTemplate(wikiText, templateId);
        if (idx < 0) {
            return;
        }
        int end = wikiText.indexOf(125, idx);
        if (end < 0) {
            return;
        }
        String wordRootsStr = wikiText.substring(idx, end);
        String[] wordRoots = wordRootsStr.split("\\|");
        for (int w = 0; w < wordRoots.length; ++w) {
            String wordRoot = wordRoots[w];
            if (!this.isValidWord(wordRoot = wordRoot.trim()) || suffixes.length <= w) continue;
            String[] suffixe = suffixes[w];
            for (int i = 0; i < suffixe.length; ++i) {
                this.addWord(wordRoot + suffixe[i]);
            }
        }
    }

    private void templateWithWordList(String wikiText, String templateId) {
        int idx = this.findTemplate(wikiText, templateId);
        if (idx < 0) {
            return;
        }
        int endIdx = wikiText.indexOf(125, idx);
        if (endIdx < 0) {
            return;
        }
        String wordStr = wikiText.substring(idx, endIdx);
        String[] words = wordStr.split("\\|");
        for (int w = 0; w < words.length; ++w) {
            String word = words[w];
            if (!this.isValidWord(word = word.trim())) continue;
            this.addWord(word);
        }
    }

    private int findTemplate(String wikiText, String tempalateName) {
        Pattern pattern = Pattern.compile("\\{\\{\\s*" + tempalateName + "\\s*\\|");
        Matcher matcher = pattern.matcher(wikiText);
        if (matcher.find()) {
            return matcher.end();
        }
        return -1;
    }
}

