/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookUtils;
import java.util.Properties;
import java.util.StringTokenizer;

public class BookGenerator_es
extends BookGenerator {
    @Override
    boolean isValidLanguage(String word, String wikiText) {
        if (wikiText.indexOf("{{ES}}") < 0 && wikiText.indexOf("{{ES|") < 0) {
            return false;
        }
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.-\u00f3n", null, new String[]{"\u00f3n", "ona", "ones", "onas"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.agudo-cons", null, new String[]{"\u00f3n", "ona", "ones", "onas"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.ad-lib", null, new String[]{""}, new String[]{""}, new String[]{""}, new String[]{""});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.no-g\u00e9nero", new String[]{"s"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.reg", null, new String[]{"o", "os", "a", "as"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.adj.reg-cons", new String[]{"es", "a", "as"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.sust.-\u00f3n", null, new String[]{"\u00f3n", "ones"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.sust.agudo-cons", null, new String[]{"\u00f3n", "ones"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.sust.reg", new String[]{"s"});
        this.findRuleAndAddWords(word, wikiText, "inflect.es.sust.reg-cons", new String[]{"es"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.ar", null, new String[]{"ar", "ado", "ando", "o", "as", "\u00e1s", "a", "amos", "\u00e1is", "an", "aba", "abas", "\u00e1bamos", "abais", "aban", "\u00e9", "aste", "\u00f3", "asteis", "aron", "ar\u00e9", "ar\u00e1s", "ar\u00e1", "aremos", "ar\u00e9is", "ar\u00e1n", "ar\u00eda", "ar\u00edas", "ar\u00edamos", "ar\u00edais", "ar\u00edan", "e", "es", "\u00e9s", "emos", "\u00e9is", "en", "ara", "aras", "\u00e1ramos", "arais", "aran", "ase", "ases", "\u00e1semos", "aseis", "asen", "are", "ares", "\u00e1remos", "areis", "aren", "\u00e1", "emos", "ad"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.2.ar", null, new String[]{"ar", "ado", "ando", "\u00e1s", "amos", "\u00e1is", "aba", "abas", "\u00e1bamos", "abais", "aban", "\u00e9", "aste", "\u00f3", "asteis", "aron", "ar\u00e9", "ar\u00e1s", "ar\u00e1", "aremos", "ar\u00e9is", "ar\u00e1n", "ar\u00eda", "ar\u00edas", "ar\u00edamos", "ar\u00edais", "ar\u00edan", "\u00e9s", "emos", "\u00e9is", "ara", "aras", "\u00e1ramos", "arais", "aran", "ase", "ases", "\u00e1semos", "aseis", "asen", "are", "ares", "\u00e1remos", "areis", "aren", "\u00e1", "emos", "ad"}, new String[]{"o", "as", "a", "an", "e", "es", "en"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.car", null, new String[]{"car", "cado", "cando", "co", "cas", "c\u00e1s", "ca", "camos", "c\u00e1is", "can", "caba", "cabas", "c\u00e1bamos", "cabais", "caban", "qu\u00e9", "caste", "c\u00f3", "casteis", "caron", "car\u00e9", "car\u00e1s", "car\u00e1", "caremos", "car\u00e9is", "car\u00e1n", "car\u00eda", "car\u00edas", "car\u00edamos", "car\u00edais", "car\u00edan", "que", "ques", "qu\u00e9s", "quemos", "qu\u00e9is", "quen", "cara", "caras", "c\u00e1ramos", "carais", "caran", "case", "acses", "c\u00e1semos", "caseis", "casen", "care", "cares", "c\u00e1remos", "careis", "caren", "c\u00e1", "quemos", "cad"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.cuar", null, new String[]{"cuar", "cuado", "cuando", "cuo", "c\u00fao", "cuas", "c\u00faas", "cua", "c\u00faa", "cuamos", "cu\u00e1is", "cuan", "c\u00faan", "cuaba", "cuabas", "cu\u00e1bamos", "cuabais", "cuaban", "cu\u00e9", "cuaste", "cu\u00f3", "cuasteis", "cuaron", "cuar\u00e9", "cuar\u00e1s", "cuar\u00e1", "cuaremos", "cuar\u00e9is", "cuar\u00e1n", "cuar\u00eda", "cuar\u00edas", "cuar\u00edamos", "cuar\u00edais", "cuar\u00edan", "cue", "c\u00fae", "cues", "c\u00faes", "cuemos", "cu\u00e9is", "cuen", "c\u00faen", "cuara", "cuaras", "cu\u00e1ramos", "cuarais", "cuaran", "cuase", "cuases", "cu\u00e1semos", "cuaseis", "cuasen", "cuare", "cuares", "cu\u00e1remos", "cuareis", "cuaren", "cua", "c\u00faa", "cuemos", "cuad"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.gar", null, new String[]{"gar", "gado", "gando", "go", "gas", "g\u00e1s", "ga", "gamos", "g\u00e1is", "gan", "gaba", "gabas", "g\u00e1bamos", "gabais", "gaban", "gu\u00e9", "gaste", "g\u00f3", "gasteis", "garon", "gar\u00e9", "gar\u00e1s", "gar\u00e1", "garemos", "gar\u00e9is", "gar\u00e1n", "gar\u00eda", "gar\u00edas", "gar\u00edamos", "gar\u00edais", "gar\u00edan", "gue", "gues", "gu\u00e9s", "guemos", "gu\u00e9is", "guen", "gara", "garas", "g\u00e1ramos", "garais", "garan", "gase", "gases", "g\u00e1semos", "gaseis", "gasen", "gare", "gares", "g\u00e1remos", "gareis", "garen", "g\u00e1", "guemos", "gad"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.-ie-ue-.ar", null, new String[]{"ar", "ado", "ando", "\u00e1s", "amos", "\u00e1is", "aba", "abas", "\u00e1bamos", "abais", "aban", "\u00e9", "aste", "\u00f3", "asteis", "aron", "ar\u00e9", "ar\u00e1s", "ar\u00e1", "aremos", "ar\u00e9is", "ar\u00e1n", "ar\u00eda", "ar\u00edas", "ar\u00edamos", "ar\u00edais", "ar\u00edan", "\u00e9s", "emos", "\u00e9is", "ara", "aras", "\u00e1ramos", "arais", "aran", "ase", "ases", "\u00e1semos", "aseis", "asen", "are", "ares", "\u00e1remos", "areis", "aren", "\u00e1", "emos", "ad"}, new String[]{"o", "as", "a", "an", "e", "es", "en"});
        this.findRuleAndAddWords(word, wikiText, "es.v.conj.zar", null, new String[]{"zar", "zado", "zando", "zo", "zas", "z\u00e1s", "za", "zamos", "z\u00e1is", "zan", "zaba", "zabas", "z\u00e1bamos", "zabais", "zaban", "c\u00e9", "zaste", "z\u00f3", "zasteis", "zaron", "zar\u00e9", "zar\u00e1s", "zar\u00e1", "azremos", "zar\u00e9is", "zar\u00e1n", "zar\u00eda", "zar\u00edas", "zar\u00edamos", "zar\u00edais", "zar\u00edan", "ce", "ces", "c\u00e9s", "cemos", "c\u00e9is", "cen", "zara", "zaras", "z\u00e1ramos", "zarais", "zaran", "zase", "zases", "z\u00e1semos", "zaseis", "zasen", "zare", "zares", "z\u00e1remos", "zareis", "zaren", "z\u00e1", "cemos", "zad"});
        this.es_v_conj_er(wikiText);
        this.es_v_conj_ie_ue_er(wikiText);
        this.es_v_conj_cer(wikiText);
        this.es_v_conj_zc_cer(wikiText);
        this.es_v_conj_eer(wikiText);
        this.es_v_conj_ger(wikiText);
        this.es_v_conj_caer(wikiText);
        this.es_v_conj_hacer(wikiText);
        this.es_v_conj_poner(wikiText);
        this.es_v_conj_tener(wikiText);
        this.es_v_conj_traer(wikiText);
        this.es_v_conj_ir(wikiText);
        this.es_v_conj_cir(wikiText);
        this.es_v_conj_zc_cir(wikiText);
        this.es_v_conj_decir(wikiText);
        this.es_v_conj_gir(wikiText);
        this.es_v_conj_ie_i_ue_ir(wikiText);
        this.es_v_conj_nir(wikiText);
        this.es_v_conj_seguir(wikiText);
        this.es_v_conj_uir(wikiText);
        return true;
    }

    private void es_v_conj_ie_ue_er(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.-ie-ue-.er", 0);
        if (props != null) {
            String nexo = props.getProperty("nexo", "");
            String w2 = props.getProperty("2", "{{{2}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.setProperty("i.p.1s", w2 + nexo + "o");
            props.setProperty("i.p.2s", w2 + nexo + "es");
            props.setProperty("i.p.3s", w2 + nexo + "e");
            props.setProperty("i.p.3p", w2 + nexo + "en");
            props.setProperty("s.p.1s", w2 + nexo + "a");
            props.setProperty("s.p.2s", w2 + nexo + "as");
            props.setProperty("s.p.3s", w2 + nexo + "a");
            props.setProperty("s.p.3p", w2 + nexo + "an");
            props.setProperty("im.2s", pronominal ? props.getProperty("3", "{{{3}}}") + nexo + "ete" : w2 + nexo + "e");
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_er(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.er", 0);
        if (props != null) {
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_cer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.cer", 0);
        if (props != null) {
            props.put("nexo", "c");
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_zc_cer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.zc.cer", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            String w2 = props.getProperty("2", "");
            props.put("irregular", "x");
            if (props.getProperty("nexo", "").length() == 0) {
                props.put("nexo", "c");
            }
            props.put("i.p.1s", w1 + "zco");
            props.put("s.p.1s", w1 + "zca");
            props.put("s.p.2s", w1 + "zcas");
            props.put("s.p.2s2", w1 + "zc\u00e1s");
            props.put("s.p.3s", w1 + "zca");
            props.put("s.p.1p", w1 + "zcamos");
            props.put("s.p.2p", w1 + "zc\u00e1is");
            props.put("s.p.3p", w1 + "zcan");
            if (w2.length() > 0) {
                props.put("im.3s", w2 + "zcase");
                props.put("im.1p", w1 + "zc\u00e1monos");
                props.put("im.3p", w2 + "zcanse");
            } else {
                props.put("im.3s", w1 + "zcase");
                props.put("im.1p", w1 + "zcamos");
                props.put("im.3p", w1 + "zcan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_eer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.eer", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            props.put("irregular", "x");
            props.put("i.pp.1s", w1 + "\u00ed");
            props.put("i.pp.2s", w1 + "\u00edste");
            props.put("i.pp.3s", w1 + "y\u00f3");
            props.put("i.pp.1p", w1 + "jimos");
            props.put("i.pp.2p", w1 + "\u00edsteis");
            props.put("i.pp.3p", w1 + "yeron");
            props.put("s.pi.1s", w1 + "yera");
            props.put("s.pi.2s", w1 + "yeras");
            props.put("s.pi.3s", w1 + "yera");
            props.put("s.pi.1p", w1 + "y\u00e9ramos");
            props.put("s.pi.2p", w1 + "yerais");
            props.put("s.pi.3p", w1 + "yeran");
            props.put("s.pi2.1s", w1 + "yese");
            props.put("s.pi2.2s", w1 + "yeses");
            props.put("s.pi2.3s", w1 + "yese");
            props.put("s.pi2.1p", w1 + "y\u00e9semos");
            props.put("s.pi2.2p", w1 + "yeseis");
            props.put("s.pi2.3p", w1 + "yesen");
            props.put("s.f.1s", w1 + "yere");
            props.put("s.f.2s", w1 + "yeres");
            props.put("s.f.3s", w1 + "yere");
            props.put("s.f.1p", w1 + "y\u00e9remos");
            props.put("s.f.2p", w1 + "yereis");
            props.put("s.f.3p", w1 + "yeren");
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_ger(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.ger", 0);
        if (props != null) {
            props.put("nexo", "g");
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_caer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.caer", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("i.p.1s", w1 + "caigo");
            props.put("i.pp.3s", w1 + "cay\u00f3");
            props.put("i.pp.3p", w1 + "cayeron");
            props.put("s.p.1s", w1 + "caiga");
            props.put("s.p.2s", w1 + "caigas");
            props.put("s.p.2s2", w1 + "caig\u00e1s");
            props.put("s.p.3s", w1 + "caiga");
            props.put("s.p.1p", w1 + "caigamos");
            props.put("s.p.2p", w1 + "caig\u00e1is");
            props.put("s.p.3p", w1 + "caigan");
            props.put("s.pi.1s", w1 + "cayera");
            props.put("s.pi.2s", w1 + "cayeras");
            props.put("s.pi.3s", w1 + "cayera");
            props.put("s.pi.1p", w1 + "cay\u00e9ramos");
            props.put("s.pi.2p", w1 + "cayerais");
            props.put("s.pi.3p", w1 + "cayeran");
            props.put("s.pi2.1s", w1 + "cayese");
            props.put("s.pi2.2s", w1 + "cayeses");
            props.put("s.pi2.3s", w1 + "cayese");
            props.put("s.pi2.1p", w1 + "cay\u00e9semos");
            props.put("s.pi2.2p", w1 + "cayeseis");
            props.put("s.pi2.3p", w1 + "cayesen");
            props.put("s.f.1s", w1 + "cayere");
            props.put("s.f.2s", w1 + "cayeres");
            props.put("s.f.3s", w1 + "cayere");
            props.put("s.f.1p", w1 + "cay\u00e9remos");
            props.put("s.f.2p", w1 + "cayereis");
            props.put("s.f.3p", w1 + "cayeren");
            if (pronominal) {
                props.put("im.3s", w1 + "c\u00e1igase");
                props.put("im.1p", w1 + "caig\u00e1monos");
                props.put("im.3p", w1 + "c\u00e1iganse");
            } else {
                props.put("im.3s", w1 + "caiga");
                props.put("im.1p", w1 + "caigamos");
                props.put("im.3p", w1 + "caigan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_hacer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.hacer", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("1", w1 + "ac");
            props.put("2", w1 + "\u00e1c");
            props.put("i.p.1s", w1 + "ago");
            props.put("i.pp.1s", w1 + "ice");
            props.put("i.pp.2s", w1 + "iciste");
            props.put("i.pp.3s", w1 + "izo");
            props.put("i.pp.1p", w1 + "icimos");
            props.put("i.pp.2p", w1 + "icisteis");
            props.put("i.pp.3p", w1 + "icieron");
            props.put("i.f.1s", w1 + "ar\u00e9");
            props.put("i.f.2s", w1 + "ar\u00e1s");
            props.put("i.f.3s", w1 + "ar\u00e1");
            props.put("i.f.1p", w1 + "aremos");
            props.put("i.f.2p", w1 + "ar\u00e9is");
            props.put("i.f.3p", w1 + "ar\u00e1n");
            props.put("i.c.1s", w1 + "ar\u00eda");
            props.put("i.c.2s", w1 + "ar\u00edas");
            props.put("i.c.3s", w1 + "ar\u00eda");
            props.put("i.c.1p", w1 + "ar\u00edamos");
            props.put("i.c.2p", w1 + "ar\u00edais");
            props.put("i.c.3p", w1 + "ar\u00edan");
            props.put("s.p.1s", w1 + "aga");
            props.put("s.p.2s", w1 + "agas");
            props.put("s.p.2s2", w1 + "ag\u00e1s");
            props.put("s.p.3s", w1 + "aga");
            props.put("s.p.1p", w1 + "agamos");
            props.put("s.p.2p", w1 + "ag\u00e1is");
            props.put("s.p.3p", w1 + "agan");
            props.put("s.pi.1s", w1 + "iciera");
            props.put("s.pi.2s", w1 + "icieras");
            props.put("s.pi.3s", w1 + "iciera");
            props.put("s.pi.1p", w1 + "ici\u00e9ramos");
            props.put("s.pi.2p", w1 + "icierais");
            props.put("s.pi.3p", w1 + "icieran");
            props.put("s.pi2.1s", w1 + "iciese");
            props.put("s.pi2.2s", w1 + "icieses");
            props.put("s.pi2.3s", w1 + "iciese");
            props.put("s.pi2.1p", w1 + "ici\u00e9semos");
            props.put("s.pi2.2p", w1 + "icieseis");
            props.put("s.pi2.3p", w1 + "iciesen");
            props.put("s.f.1s", w1 + "iciere");
            props.put("s.f.2s", w1 + "icieres");
            props.put("s.f.3s", w1 + "iciere");
            props.put("s.f.1p", w1 + "ici\u00e9remos");
            props.put("s.f.2p", w1 + "iciereis");
            props.put("s.f.3p", w1 + "icieren");
            if (pronominal) {
                props.put("im.2s", w1 + "azte");
                props.put("im.3s", w1 + "\u00e1gase");
                props.put("im.1p", w1 + "ag\u00e1monos");
                props.put("im.3p", w1 + "\u00e1ganse");
            } else {
                props.put("im.2s", w1 + "az");
                props.put("im.3s", w1 + "aga");
                props.put("im.1p", w1 + "agamos");
                props.put("im.3p", w1 + "agan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_poner(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.poner", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("1", w1 + "pon");
            props.put("2", w1 + "p\u00f3n");
            props.put("i.p.1s", w1 + "pongo");
            props.put("i.pp.1s", w1 + "puse");
            props.put("i.pp.2s", w1 + "pusiste");
            props.put("i.pp.3s", w1 + "puso");
            props.put("i.pp.1p", w1 + "pusimos");
            props.put("i.pp.2p", w1 + "pusisteis");
            props.put("i.pp.3p", w1 + "pusieron");
            props.put("i.f.1s", w1 + "pondr\u00e9");
            props.put("i.f.2s", w1 + "pondr\u00e1s");
            props.put("i.f.3s", w1 + "pondr\u00e1");
            props.put("i.f.1p", w1 + "pondremos");
            props.put("i.f.2p", w1 + "pondr\u00e9is");
            props.put("i.f.3p", w1 + "pondr\u00e1n");
            props.put("i.c.1s", w1 + "pondr\u00eda");
            props.put("i.c.2s", w1 + "pondr\u00edas");
            props.put("i.c.3s", w1 + "pondr\u00eda");
            props.put("i.c.1p", w1 + "pondr\u00edamos");
            props.put("i.c.2p", w1 + "pondr\u00edais");
            props.put("i.c.3p", w1 + "pondr\u00edan");
            props.put("s.p.1s", w1 + "ponga");
            props.put("s.p.2s", w1 + "pongas");
            props.put("s.p.2s2", w1 + "pong\u00e1s");
            props.put("s.p.3s", w1 + "ponga");
            props.put("s.p.1p", w1 + "pongamos");
            props.put("s.p.2p", w1 + "pong\u00e1is");
            props.put("s.p.3p", w1 + "pongan");
            props.put("s.pi.1s", w1 + "pusiera");
            props.put("s.pi.2s", w1 + "pusieras");
            props.put("s.pi.3s", w1 + "pusiera");
            props.put("s.pi.1p", w1 + "pusi\u00e9ramos");
            props.put("s.pi.2p", w1 + "pusierais");
            props.put("s.pi.3p", w1 + "pusieran");
            props.put("s.pi2.1s", w1 + "pusiese");
            props.put("s.pi2.2s", w1 + "pusieses");
            props.put("s.pi2.3s", w1 + "pusiese");
            props.put("s.pi2.1p", w1 + "pusi\u00e9semos");
            props.put("s.pi2.2p", w1 + "pusieseis");
            props.put("s.pi2.3p", w1 + "pusiesen");
            props.put("s.f.1s", w1 + "pusiere");
            props.put("s.f.2s", w1 + "pusieres");
            props.put("s.f.3s", w1 + "pusiere");
            props.put("s.f.1p", w1 + "pusi\u00e9remos");
            props.put("s.f.2p", w1 + "pusiereis");
            props.put("s.f.3p", w1 + "pusieren");
            if (pronominal) {
                props.put("im.2s", w1 + "ponte");
                this.addWord(w1 + "p\u00f3nete");
                props.put("im.3s", w1 + "p\u00f3ngase");
                props.put("im.1p", w1 + "pong\u00e1monos");
                props.put("im.3p", w1 + "p\u00f3nganse");
            } else {
                props.put("im.2s", w1 + "p\u00f3n");
                this.addWord(w1 + "pone");
                props.put("im.3s", w1 + "ponga");
                props.put("im.1p", w1 + "pongamos");
                props.put("im.3p", w1 + "pongan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_tener(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.tener", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("1", w1 + "ten");
            props.put("2", w1 + "t\u00e9n");
            props.put("i.p.1s", w1 + "tengo");
            props.put("i.p.2s", w1 + "tienes");
            props.put("i.p.3s", w1 + "tiene");
            props.put("i.p.3p", w1 + "tienen");
            props.put("i.pp.1s", w1 + "tuve");
            props.put("i.pp.2s", w1 + "tuviste");
            props.put("i.pp.3s", w1 + "tuvo");
            props.put("i.pp.1p", w1 + "tuvimos");
            props.put("i.pp.2p", w1 + "tuvisteis");
            props.put("i.pp.3p", w1 + "tuvieron");
            props.put("i.f.1s", w1 + "tendr\u00e9");
            props.put("i.f.2s", w1 + "tendr\u00e1s");
            props.put("i.f.3s", w1 + "tendr\u00e1");
            props.put("i.f.1p", w1 + "tendremos");
            props.put("i.f.2p", w1 + "tendr\u00e9is");
            props.put("i.f.3p", w1 + "tendr\u00e1n");
            props.put("i.c.1s", w1 + "tendr\u00eda");
            props.put("i.c.2s", w1 + "tendr\u00edas");
            props.put("i.c.3s", w1 + "tendr\u00eda");
            props.put("i.c.1p", w1 + "tendr\u00edamos");
            props.put("i.c.2p", w1 + "tendr\u00edais");
            props.put("i.c.3p", w1 + "tendr\u00edan");
            props.put("s.p.1s", w1 + "tenga");
            props.put("s.p.2s", w1 + "tengas");
            props.put("s.p.2s2", w1 + "teng\u00e1s");
            props.put("s.p.3s", w1 + "tenga");
            props.put("s.p.1p", w1 + "tengamos");
            props.put("s.p.2p", w1 + "teng\u00e1is");
            props.put("s.p.3p", w1 + "tengan");
            props.put("s.pi.1s", w1 + "tuviera");
            props.put("s.pi.2s", w1 + "tuvieras");
            props.put("s.pi.3s", w1 + "tuviera");
            props.put("s.pi.1p", w1 + "tuvi\u00e9ramos");
            props.put("s.pi.2p", w1 + "tuvierais");
            props.put("s.pi.3p", w1 + "tuvieran");
            props.put("s.pi2.1s", w1 + "tuviese");
            props.put("s.pi2.2s", w1 + "tuvieses");
            props.put("s.pi2.3s", w1 + "tuviese");
            props.put("s.pi2.1p", w1 + "tuvi\u00e9semos");
            props.put("s.pi2.2p", w1 + "tuvieseis");
            props.put("s.pi2.3p", w1 + "tuviesen");
            props.put("s.f.1s", w1 + "tuviere");
            props.put("s.f.2s", w1 + "tuvieres");
            props.put("s.f.3s", w1 + "tuviere");
            props.put("s.f.1p", w1 + "tuvi\u00e9remos");
            props.put("s.f.2p", w1 + "tuviereis");
            props.put("s.f.3p", w1 + "tuvieren");
            if (pronominal) {
                props.put("im.2s=", w1 + "t\u00e9nte");
                props.put("im.3s", w1 + "t\u00e9ngase");
                props.put("im.1p", w1 + "teng\u00e1monos");
                props.put("im.3p", w1 + "t\u00e9nganse");
            } else {
                props.put("im.2s=", w1 + "t\u00e9n");
                props.put("im.3s", w1 + "tenga");
                props.put("im.1p", w1 + "tengamos");
                props.put("im.3p", w1 + "tengan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_traer(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.traer", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("1", w1 + "tra");
            props.put("2", w1 + "tr\u00e1");
            props.put("i.p.1s", w1 + "traigo");
            props.put("i.pp.1s", w1 + "traje");
            props.put("i.pp.2s", w1 + "trajiste");
            props.put("i.pp.3s", w1 + "trajo");
            props.put("i.pp.1p", w1 + "trajimos");
            props.put("i.pp.2p", w1 + "trajisteis");
            props.put("i.pp.3p", w1 + "trajeron");
            props.put("s.p.1s", w1 + "traiga");
            props.put("s.p.2s", w1 + "traigas");
            props.put("s.p.2s2", w1 + "traig\u00e1s");
            props.put("s.p.3s", w1 + "traiga");
            props.put("s.p.1p", w1 + "traigamos");
            props.put("s.p.2p", w1 + "traig\u00e1is");
            props.put("s.p.3p", w1 + "traigan");
            props.put("s.pi.1s", w1 + "trajera");
            props.put("s.pi.2s", w1 + "trajeras");
            props.put("s.pi.3s", w1 + "trajera");
            props.put("s.pi.1p", w1 + "traj\u00e9ramos");
            props.put("s.pi.2p", w1 + "trajerais");
            props.put("s.pi.3p", w1 + "trajeran");
            props.put("s.pi2.1s", w1 + "trajese");
            props.put("s.pi2.2s", w1 + "trajeses");
            props.put("s.pi2.3s", w1 + "trajese");
            props.put("s.pi2.1p", w1 + "traj\u00e9semos");
            props.put("s.pi2.2p", w1 + "trajeseis");
            props.put("s.pi2.3p", w1 + "trajesen");
            props.put("s.f.1s", w1 + "trajere");
            props.put("s.f.2s", w1 + "trajeres");
            props.put("s.f.3s", w1 + "trajere");
            props.put("s.f.1p", w1 + "traj\u00e9remos");
            props.put("s.f.2p", w1 + "trajereis");
            props.put("s.f.3p", w1 + "trajeren");
            if (pronominal) {
                props.put("im.3s", w1 + "tr\u00e1igase");
                props.put("im.1p", w1 + "traig\u00e1monos");
                props.put("im.3p", w1 + "tr\u00e1iganse");
            } else {
                props.put("im.3s", w1 + "traiga");
                props.put("im.1p", w1 + "traigamos");
                props.put("im.3p", w1 + "traigan");
            }
            this.es_v_conj_er(props);
        }
    }

    private void es_v_conj_er(Properties props) {
        String w1 = props.getProperty("1", "{{{1}}}");
        String nexo = props.getProperty("nexo", "");
        String part = props.getProperty("part");
        String part2 = props.getProperty("part2");
        boolean impersonal = props.getProperty("impersonal", "").length() > 0;
        boolean impersonalPlural = "plural".equalsIgnoreCase(props.getProperty("impersonal", ""));
        boolean pronominal = props.getProperty("pronominal", "").length() > 0;
        this.addWord(w1 + nexo + "er" + (pronominal ? "se" : ""));
        this.addWord(w1 + nexo + "ido");
        this.addWord(w1 + nexo + (pronominal ? "i\u00e9ndose" : "iendo"));
        if (part != null) {
            this.addWord(part);
        }
        if (part2 != null) {
            this.addWord(part2);
        }
        if (!impersonal) {
            this.addWord(props.getProperty("i.p.1s", w1 + nexo + "o"));
            this.addWord(props.getProperty("i.p.2s", w1 + nexo + "es"));
            this.addWord(props.getProperty("i.p.2s2", w1 + nexo + "\u00e9s"));
        }
        this.addWord(props.getProperty("i.p.3s", w1 + nexo + "e"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.p.1p", w1 + nexo + "emos"));
            this.addWord(props.getProperty("i.p.2p", w1 + nexo + "\u00e9is"));
        }
        this.addWord(props.getProperty("i.p.3p", w1 + nexo + "en"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pi.1s", w1 + nexo + "\u00eda"));
            this.addWord(props.getProperty("i.pi.2s", w1 + nexo + "\u00edas"));
        }
        this.addWord(props.getProperty("i.pi.3s", w1 + nexo + "\u00eda"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pi.1p", w1 + nexo + "\u00edamos"));
            this.addWord(props.getProperty("i.pi.2p", w1 + nexo + "\u00edais"));
        }
        this.addWord(props.getProperty("i.pi.3p", w1 + nexo + "\u00edan"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pp.1s", w1 + nexo + "\u00ed"));
            this.addWord(props.getProperty("i.pp.2s", w1 + nexo + "iste"));
        }
        this.addWord(props.getProperty("i.pp.3s", w1 + nexo + "i\u00f3"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pp.1p", w1 + nexo + "imos"));
            this.addWord(props.getProperty("i.pp.2p", w1 + nexo + "isteis"));
        }
        this.addWord(props.getProperty("i.pp.3p", w1 + nexo + "ieron"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.f.1s", w1 + nexo + "er\u00e9"));
            this.addWord(props.getProperty("i.f.2s", w1 + nexo + "er\u00e1s"));
        }
        this.addWord(props.getProperty("i.f.3s", w1 + nexo + "er\u00e1"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.f.1p", w1 + nexo + "eremos"));
            this.addWord(props.getProperty("i.f.2p", w1 + nexo + "er\u00e9is"));
        }
        this.addWord(props.getProperty("i.f.3p", w1 + nexo + "er\u00e1n"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.c.1s", w1 + nexo + "er\u00eda"));
            this.addWord(props.getProperty("i.c.2s", w1 + nexo + "er\u00edas"));
        }
        this.addWord(props.getProperty("i.c.3s", w1 + nexo + "er\u00eda"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.c.1p", w1 + nexo + "er\u00edamos"));
            this.addWord(props.getProperty("i.c.2p", w1 + nexo + "er\u00edais"));
        }
        this.addWord(props.getProperty("i.c.3p", w1 + nexo + "er\u00edan"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.p.1s", w1 + nexo + "a"));
            this.addWord(props.getProperty("s.p.2s", w1 + nexo + "as"));
            this.addWord(props.getProperty("s.p.2s2", w1 + nexo + "\u00e1s"));
        }
        this.addWord(props.getProperty("s.p.3s", w1 + nexo + "a"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.p.1p", w1 + nexo + "amos"));
            this.addWord(props.getProperty("s.p.2p", w1 + nexo + "\u00e1is"));
        }
        this.addWord(props.getProperty("s.p.3p", w1 + nexo + "an"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi.1s", w1 + nexo + "iera"));
            this.addWord(props.getProperty("s.pi.2s", w1 + nexo + "ieras"));
        }
        this.addWord(props.getProperty("s.pi.3s", w1 + nexo + "iera"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi.1p", w1 + nexo + "i\u00e9ramos"));
            this.addWord(props.getProperty("s.pi.2p", w1 + nexo + "ierais"));
        }
        this.addWord(props.getProperty("s.pi.3p", w1 + nexo + "ieran"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi2.1s", w1 + nexo + "iese"));
            this.addWord(props.getProperty("s.pi2.2s", w1 + nexo + "ieses"));
        }
        this.addWord(props.getProperty("s.pi2.3s", w1 + nexo + "iese"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi2.1p", w1 + nexo + "i\u00e9semos"));
            this.addWord(props.getProperty("s.pi2.2p", w1 + nexo + "ieseis"));
        }
        this.addWord(props.getProperty("s.pi2.3p", w1 + nexo + "iesen"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.f.1s", w1 + nexo + "iere"));
            this.addWord(props.getProperty("s.f.2s", w1 + nexo + "ieres"));
        }
        this.addWord(props.getProperty("s.f.3s", w1 + nexo + "iere"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.f.1p", w1 + nexo + "i\u00e9remos"));
            this.addWord(props.getProperty("s.f.2p", w1 + nexo + "iereis"));
        }
        this.addWord(props.getProperty("s.f.3p", w1 + nexo + "ieren"));
        if (!impersonalPlural) {
            this.addWord(props.getProperty("im.2s", w1 + nexo + "e"));
            this.addWord(props.getProperty("im.2s2", w1 + nexo + "\u00e9"));
            this.addWord(props.getProperty("im.2p", w1 + nexo + "ed"));
        }
    }

    private void es_v_conj_ir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.ir", 0);
        if (props != null) {
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_cir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.cir", 0);
        if (props != null) {
            props.put("nexo", "c");
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_zc_cir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.zc.cir", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            String w2 = props.getProperty("2", "");
            props.put("irregular", "x");
            props.put("nexo", "c");
            props.put("i.p.1s", w1 + "zco");
            props.put("s.p.1s", w1 + "zca");
            props.put("s.p.2s", w1 + "zcas");
            props.put("s.p.2s2", w1 + "zc\u00e1s");
            props.put("s.p.3s", w1 + "zca");
            props.put("s.p.1p", w1 + "zcamos");
            props.put("s.p.2p", w1 + "zc\u00e1is");
            props.put("s.p.3p", w1 + "zcan");
            if (w2.length() > 0) {
                props.put("im.3s", w2 + "zcase");
                props.put("im.1p", w1 + "zc\u00e1monos");
                props.put("im.3p", w2 + "zcanse");
            } else {
                props.put("im.3s", w1 + "zca");
                props.put("im.1p", w1 + "zcamos");
                props.put("im.3p", w1 + "zcan");
            }
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_decir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.decir", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            String w2 = props.getProperty("2", "");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "si");
            props.put("1", w1 + "dec");
            if (pronominal) {
                props.put("2", w1 + "d\u00edg");
            }
            props.put("i.p.1s", w1 + "digo");
            props.put("i.p.2s", w1 + "dices");
            props.put("i.p.3s", w1 + "dice");
            props.put("i.p.3p", w1 + "dicen");
            props.put("i.pp.1s", w1 + "dije");
            props.put("i.pp.2s", w1 + "dijiste");
            props.put("i.pp.3s", w1 + "dijo");
            props.put("i.pp.1p", w1 + "dijimos");
            props.put("i.pp.2p", w1 + "dijisteis");
            props.put("i.pp.3p", w1 + "dijeron");
            props.put("i.f.1s", w1 + "dir\u00e9");
            props.put("i.f.2s", w1 + "dir\u00e1s");
            props.put("i.f.3s", w1 + "dir\u00e1");
            props.put("i.f.1p", w1 + "diremos");
            props.put("i.f.2p", w1 + "dir\u00e9is");
            props.put("i.f.3p", w1 + "dir\u00e1n");
            props.put("i.c.1s", w1 + "dir\u00eda");
            props.put("i.c.2s", w1 + "dir\u00edas");
            props.put("i.c.3s", w1 + "dir\u00eda");
            props.put("i.c.1p", w1 + "dir\u00edamos");
            props.put("i.c.2p", w1 + "dir\u00edais");
            props.put("i.c.3p", w1 + "dir\u00edan");
            props.put("s.p.1s", w1 + "diga");
            props.put("s.p.2s", w1 + "digas");
            props.put("s.p.2s2", w1 + "dig\u00e1s");
            props.put("s.p.3s", w1 + "diga");
            props.put("s.p.1p", w1 + "digamos");
            props.put("s.p.2p", w1 + "dig\u00e1is");
            props.put("s.p.3p", w1 + "digan");
            props.put("s.pi.1s", w1 + "dijera");
            props.put("s.pi.2s", w1 + "dijeras");
            props.put("s.pi.3s", w1 + "dijera");
            props.put("s.pi.1p", w1 + "dij\u00e9ramos");
            props.put("s.pi.2p", w1 + "dijerais");
            props.put("s.pi.3p", w1 + "dijeran");
            props.put("s.pi2.1s", w1 + "dijese");
            props.put("s.pi2.2s", w1 + "dijeses");
            props.put("s.pi2.3s", w1 + "dijese");
            props.put("s.pi2.1p", w1 + "dij\u00e9semos");
            props.put("s.pi2.2p", w1 + "dijeseis");
            props.put("s.pi2.3p", w1 + "dijesen");
            props.put("s.f.1s", w1 + "dijere");
            props.put("s.f.2s", w1 + "dijeres");
            props.put("s.f.3s", w1 + "dijere");
            props.put("s.f.1p", w1 + "dij\u00e9remos");
            props.put("s.f.2p", w1 + "dijereis");
            props.put("s.f.3p", w1 + "dijeren");
            props.put("im.2s", w1 + "di");
            props.put("im.1p", w1 + "digamos");
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_gir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.gir", 0);
        if (props != null) {
            props.put("nexo", "g");
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_ie_i_ue_ir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.-ie-i-ue-u-.ir", 0);
        if (props != null) {
            this.es_v_conj_ie_i_ue_ir(props);
        }
    }

    private void es_v_conj_ie_i_ue_ir(Properties props) {
        String w2 = props.getProperty("2", "{{{2}}}");
        String w3 = props.getProperty("3", "{{{3}}}");
        String w4 = props.getProperty("4", "{{{4}}}");
        String nexo = props.getProperty("nexo", "");
        boolean pronominal = props.getProperty("pronominal", "").length() > 0;
        props.put("irregular", "x");
        props.put("i.p.1s", w2 + nexo + "o");
        props.put("i.p.2s", w2 + nexo + "es");
        props.put("i.p.3s", w2 + nexo + "e");
        props.put("i.p.3p", w2 + nexo + "en");
        props.put("i.pp.3s", w3 + nexo + "i\u00f3");
        props.put("i.pp.3p", w3 + nexo + "ieron");
        props.put("s.p.1s", w2 + nexo + "a");
        props.put("s.p.2s", w2 + nexo + "as");
        props.put("s.p.2s2", w3 + nexo + "\u00e1s");
        props.put("s.p.3s", w2 + nexo + "a");
        props.put("s.p.1p", w3 + nexo + "amos");
        props.put("s.p.2p", w3 + nexo + "\u00e1is");
        props.put("s.p.3p", w2 + nexo + "an");
        props.put("s.pi.1s", w3 + nexo + "iera");
        props.put("s.pi.2s", w3 + nexo + "ieras");
        props.put("s.pi.3s", w3 + nexo + "iera");
        props.put("s.pi.1p", w3 + nexo + "i\u00e9ramos");
        props.put("s.pi.2p", w3 + nexo + "ierais");
        props.put("s.pi.3p", w3 + nexo + "ieran");
        props.put("s.pi2.1s", w3 + nexo + "iese");
        props.put("s.pi2.2s", w3 + nexo + "ieses");
        props.put("s.pi2.3s", w3 + nexo + "iese");
        props.put("s.pi2.1p", w3 + nexo + "i\u00e9semos");
        props.put("s.pi2.2p", w3 + nexo + "ieseis");
        props.put("s.pi2.3p", w3 + nexo + "iesen");
        props.put("s.f.1s", w3 + nexo + "iere");
        props.put("s.f.2s", w3 + nexo + "ieres");
        props.put("s.f.3s", w3 + nexo + "iere");
        props.put("s.f.1p", w3 + nexo + "i\u00e9remos");
        props.put("s.f.2p", w3 + nexo + "iereis");
        props.put("s.f.3p", w3 + nexo + "ieren");
        if (pronominal) {
            props.put("im.2s", w4 + nexo + "ete]]|[[{{{2}}}{{{nexo|}}}e");
            props.put("im.3s", w4 + nexo + "ase]]|[[{{{3}}}{{mutacion.es.nexo.ei|{{{nexo|}}}}}a");
            props.put("im.1p", w3 + nexo + "\u00e1monos]]|[[{{{2}}}{{mutacion.es.nexo.ei|{{{nexo|}}}}}amos");
            props.put("im.3p", w4 + nexo + "anse]]|[[{{{3}}}{{mutacion.es.nexo.ei|{{{nexo|}}}}}an");
        } else {
            props.put("im.2s", w2 + nexo + "e");
            props.put("im.3s", w3 + nexo + "a");
            props.put("im.1p", w2 + nexo + "amos");
            props.put("im.3p", w3 + nexo + "an");
        }
        this.es_v_conj_ir(props);
    }

    private void es_v_conj_nir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.\u00f1ir", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            props.put("irregular", "x");
            props.put("i.pp.3s", w1 + "\u00f3");
            props.put("i.pp.3p", w1 + "eron");
            props.put("s.pi.1s", w1 + "era");
            props.put("s.pi.2s", w1 + "eras");
            props.put("s.pi.3s", w1 + "era");
            props.put("s.pi.1p", w1 + "\u00e9ramos");
            props.put("s.pi.2p", w1 + "erais");
            props.put("s.pi.3p", w1 + "eran");
            props.put("s.pi2.1s", w1 + "ese");
            props.put("s.pi2.2s", w1 + "eses");
            props.put("s.pi2.3s", w1 + "ese");
            props.put("s.pi2.1p", w1 + "\u00e9semos");
            props.put("s.pi2.2p", w1 + "eseis");
            props.put("s.pi2.3p", w1 + "esen");
            props.put("s.f.1s", w1 + "ere");
            props.put("s.f.2s", w1 + "eres");
            props.put("s.f.3s", w1 + "ere");
            props.put("s.f.1p", w1 + "\u00e9remos");
            props.put("s.f.2p", w1 + "ereis");
            props.put("s.f.3p", w1 + "eren");
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_seguir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.seguir", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            props.put("1", w1 + "se");
            props.put("2", w1 + "si");
            props.put("3", w1 + "si");
            props.put("4", w1 + "s\u00ed");
            props.put("nexo", w1 + "gu");
            this.es_v_conj_ie_i_ue_ir(props);
        }
    }

    private void es_v_conj_uir(String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "es.v.conj.uir", 0);
        if (props != null) {
            String w1 = props.getProperty("1", "{{{1}}}");
            String w2 = props.getProperty("2", "{{{2}}}");
            boolean pronominal = props.getProperty("pronominal", "").length() > 0;
            props.put("irregular", "x");
            props.put("i.p.1s", w1 + "yoo");
            props.put("i.p.2s", w1 + "yeses");
            props.put("i.p.2s2", w1 + "\u00eds");
            props.put("i.p.3s", w1 + "yee");
            props.put("i.p.2p", w1 + "\u00eds");
            props.put("i.p.3p", w1 + "yen");
            props.put("i.pp.1s", w1 + "\u00ed");
            props.put("i.pp.3s", w1 + "y\u00f3");
            props.put("i.pp.3p", w1 + "yeron");
            props.put("s.p.1s", w1 + "ya");
            props.put("s.p.2s", w1 + "yas");
            props.put("s.p.2s2", w1 + "y\u00e1s");
            props.put("s.p.3s", w1 + "ya");
            props.put("s.p.1p", w1 + "yamos");
            props.put("s.p.2p", w1 + "y\u00e1is");
            props.put("s.p.3p", w1 + "yan");
            props.put("s.pi.1s", w1 + "yera");
            props.put("s.pi.2s", w1 + "yeras");
            props.put("s.pi.3s", w1 + "yera");
            props.put("s.pi.1p", w1 + "y\u00e9ramos");
            props.put("s.pi.2p", w1 + "yerais");
            props.put("s.pi.3p", w1 + "yeran");
            props.put("s.pi2.1s", w1 + "yese");
            props.put("s.pi2.2s", w1 + "yeses");
            props.put("s.pi2.3s", w1 + "yese");
            props.put("s.pi2.1p", w1 + "y\u00e9semos");
            props.put("s.pi2.2p", w1 + "yeseis");
            props.put("s.pi2.3p", w1 + "yesen");
            props.put("s.f.1s", w1 + "yere");
            props.put("s.f.2s", w1 + "yeres");
            props.put("s.f.3s", w1 + "yere");
            props.put("s.f.1p", w1 + "y\u00e9remos");
            props.put("s.f.2p", w1 + "yereis");
            props.put("s.f.3p", w1 + "yeren");
            if (pronominal) {
                props.put("im.2s", w2 + "yete");
                props.put("im.2s2", w1 + "ite");
                props.put("im.3s", w2 + "yase");
                props.put("im.1p", w1 + "y\u00e1monos");
                props.put("im.3p", w2 + "yanse");
            } else {
                props.put("im.2s", w1 + "ye");
                props.put("im.2s2", w1 + "\u00ed");
                props.put("im.3s", w1 + "ya");
                props.put("im.1p", w1 + "yamos");
                props.put("im.3p", w2 + "yan");
            }
            this.es_v_conj_ir(props);
        }
    }

    private void es_v_conj_ir(Properties props) {
        String w1 = props.getProperty("1", "{{{1}}}");
        String nexo = props.getProperty("nexo", "");
        String part = props.getProperty("part");
        String part2 = props.getProperty("part2");
        boolean impersonal = props.getProperty("impersonal", "").length() > 0;
        boolean impersonalPlural = "plural".equalsIgnoreCase(props.getProperty("impersonal", ""));
        boolean pronominal = props.getProperty("pronominal", "").length() > 0;
        this.addWord(w1 + nexo + "ir" + (pronominal ? "se" : ""));
        this.addWord(w1 + nexo + "ito");
        this.addWord(w1 + nexo + (pronominal ? "i\u00e9ndose" : "iendo"));
        if (part != null) {
            this.addWord(part);
        }
        if (part2 != null) {
            this.addWord(part2);
        }
        if (!impersonal) {
            this.addWord(props.getProperty("i.p.1s", w1 + nexo + "o"));
            this.addWord(props.getProperty("i.p.2s", w1 + nexo + "es"));
            this.addWord(props.getProperty("i.p.2s2", w1 + nexo + "\u00eds"));
        }
        this.addWord(props.getProperty("i.p.3s", w1 + nexo + "e"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.p.1p", w1 + nexo + "imos"));
            this.addWord(props.getProperty("i.p.2p", w1 + nexo + "\u00eds"));
        }
        this.addWord(props.getProperty("i.p.3p", w1 + nexo + "en"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pi.1s", w1 + nexo + "\u00eda"));
            this.addWord(props.getProperty("i.pi.2s", w1 + nexo + "\u00edas"));
        }
        this.addWord(props.getProperty("i.pi.3s", w1 + nexo + "\u00eda"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pi.1p", w1 + nexo + "\u00edamos"));
            this.addWord(props.getProperty("i.pi.2p", w1 + nexo + "\u00edais"));
        }
        this.addWord(props.getProperty("i.pi.3p", w1 + nexo + "\u00edan"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pp.1s", w1 + nexo + "\u00ed"));
            this.addWord(props.getProperty("i.pp.2s", w1 + nexo + "iste"));
        }
        this.addWord(props.getProperty("i.pp.3s", w1 + nexo + "i\u00f3"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.pp.1p", w1 + nexo + "imos"));
            this.addWord(props.getProperty("i.pp.2p", w1 + nexo + "isteis"));
        }
        this.addWord(props.getProperty("i.pp.3p", w1 + nexo + "ieron"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.f.1s", w1 + nexo + "ir\u00e9"));
            this.addWord(props.getProperty("i.f.2s", w1 + nexo + "ir\u00e1s"));
        }
        this.addWord(props.getProperty("i.f.3s", w1 + nexo + "ir\u00e1"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.f.1p", w1 + nexo + "iremos"));
            this.addWord(props.getProperty("i.f.2p", w1 + nexo + "ir\u00e9is"));
        }
        this.addWord(props.getProperty("i.f.3p", w1 + nexo + "ir\u00e1n"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.c.1s", w1 + nexo + "ir\u00eda"));
            this.addWord(props.getProperty("i.c.2s", w1 + nexo + "ir\u00edas"));
        }
        this.addWord(props.getProperty("i.c.3s", w1 + nexo + "ir\u00eda"));
        if (!impersonal) {
            this.addWord(props.getProperty("i.c.1p", w1 + nexo + "ir\u00edamos"));
            this.addWord(props.getProperty("i.c.2p", w1 + nexo + "ir\u00edais"));
        }
        this.addWord(props.getProperty("i.c.3p", w1 + nexo + "ir\u00edan"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.p.1s", w1 + nexo + "a"));
            this.addWord(props.getProperty("s.p.2s", w1 + nexo + "as"));
            this.addWord(props.getProperty("s.p.2s2", w1 + nexo + "\u00e1s"));
        }
        this.addWord(props.getProperty("s.p.3s", w1 + nexo + "a"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.p.1p", w1 + nexo + "amos"));
            this.addWord(props.getProperty("s.p.2p", w1 + nexo + "\u00e1is"));
        }
        this.addWord(props.getProperty("s.p.3p", w1 + nexo + "an"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi.1s", w1 + nexo + "iera"));
            this.addWord(props.getProperty("s.pi.2s", w1 + nexo + "ieras"));
        }
        this.addWord(props.getProperty("s.pi.3s", w1 + nexo + "iera"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi.1p", w1 + nexo + "i\u00e9ramos"));
            this.addWord(props.getProperty("s.pi.2p", w1 + nexo + "ierais"));
        }
        this.addWord(props.getProperty("s.pi.3p", w1 + nexo + "ieran"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi2.1s", w1 + nexo + "iese"));
            this.addWord(props.getProperty("s.pi2.2s", w1 + nexo + "ieses"));
        }
        this.addWord(props.getProperty("s.pi2.3s", w1 + nexo + "iese"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.pi2.1p", w1 + nexo + "i\u00e9semos"));
            this.addWord(props.getProperty("s.pi2.2p", w1 + nexo + "ieseis"));
        }
        this.addWord(props.getProperty("s.pi2.3p", w1 + nexo + "iesen"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.f.1s", w1 + nexo + "iere"));
            this.addWord(props.getProperty("s.f.2s", w1 + nexo + "ieres"));
        }
        this.addWord(props.getProperty("s.f.3s", w1 + nexo + "iere"));
        if (!impersonal) {
            this.addWord(props.getProperty("s.f.1p", w1 + nexo + "i\u00e9remos"));
            this.addWord(props.getProperty("s.f.2p", w1 + nexo + "iereis"));
        }
        this.addWord(props.getProperty("s.f.3p", w1 + nexo + "ieren"));
        if (!impersonalPlural) {
            this.addWord(props.getProperty("im.2s", w1 + nexo + "e"));
            this.addWord(props.getProperty("im.2s2", w1 + nexo + "\u00ed"));
            this.addWord(props.getProperty("im.2p", w1 + nexo + "id"));
        }
    }

    private void findRuleAndAddWords(String word, String wikiText, String rule, String[] endingName) {
        this.findRuleAndAddWords(word, wikiText, rule, endingName, null);
    }

    private void findRuleAndAddWords(String word, String wikiText, String rule, String[] endingName, String[] ending1) {
        this.findRuleAndAddWords(word, wikiText, rule, endingName, ending1, null);
    }

    private void findRuleAndAddWords(String word, String wikiText, String rule, String[] endingName, String[] ending1, String[] ending2) {
        this.findRuleAndAddWords(word, wikiText, rule, endingName, ending1, ending2, null, null);
    }

    private void findRuleAndAddWords(String word, String wikiText, String rule, String[] endingName, String[] ending1, String[] ending2, String[] ending3, String[] ending4) {
        int idx2;
        String params;
        StringTokenizer tok;
        int idx = wikiText.indexOf("{{" + rule + "}}");
        if (idx < 0 && (idx = wikiText.indexOf("{{" + rule + "|")) < 0) {
            return;
        }
        if (endingName != null) {
            for (String ending : endingName) {
                this.addWord(word + ending);
            }
        }
        if (ending1 == null) {
            return;
        }
        if ((tok = new StringTokenizer(params = wikiText.substring(idx += rule.length() + 3, idx2 = wikiText.indexOf("}}", idx)), "|")).hasMoreElements()) {
            String first = tok.nextToken().trim();
            if (ending1 != null) {
                for (String ending : ending1) {
                    this.addWord(first + ending);
                }
            }
            if (tok.hasMoreElements()) {
                String second = tok.nextToken().trim();
                if (ending2 != null) {
                    for (String ending : ending2) {
                        this.addWord(second + ending);
                    }
                }
                if (tok.hasMoreElements()) {
                    String third = tok.nextToken().trim();
                    if (ending3 != null) {
                        for (String ending : ending3) {
                            this.addWord(third + ending);
                        }
                    }
                    if (tok.hasMoreElements()) {
                        String four = tok.nextToken().trim();
                        if (ending4 != null) {
                            for (String ending : ending4) {
                                this.addWord(four + ending);
                            }
                        }
                    }
                }
            }
        }
    }
}

