/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.Book;
import com.inet.jorthodictionaries.Parser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class BookGenerator {
    private final Book book;

    public static void main(String[] args) throws Exception {
        String dirName;
        String languagesList = args.length > 0 ? args[0] : "en";
        String string = dirName = args.length > 1 ? args[1].replace('\\', '/') : "";
        if (dirName.length() > 0 && !dirName.endsWith("/")) {
            dirName = dirName + '/';
        }
        String[] languages = languagesList.split(",");
        for (int i = 0; i < languages.length; ++i) {
            String language = languages[i];
            String filename = dirName + language + "wiktionary-latest-pages-articles.xml";
            File file = new File(filename);
            BookGenerator generator = (BookGenerator)Class.forName(BookGenerator.class.getName() + "_" + language).newInstance();
            generator.start(file);
            generator.save(language);
            generator.createPackage(language);
        }
    }

    BookGenerator() {
        this(new Book());
    }

    BookGenerator(Book book) {
        this.book = book;
    }

    void start(File file) throws Exception {
        FileInputStream stream = new FileInputStream(file);
        System.out.println("=== Start Parsing XML stream ===");
        new Parser(this, stream);
        ((InputStream)stream).close();
    }

    final void save(String language) throws Exception {
        File dictFile = new File("dictionary_" + language + ".ortho");
        OutputStream dict = new FileOutputStream(dictFile);
        dict = new BufferedOutputStream(dict);
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        dict = new DeflaterOutputStream(dict, deflater);
        dict = new BufferedOutputStream(dict);
        PrintStream dictPs = new PrintStream(dict, false, "UTF8");
        OutputStream txt = new FileOutputStream("IncludedWords.txt");
        txt = new BufferedOutputStream(txt);
        PrintStream ps = new PrintStream(txt, false, "UTF8");
        Object[] words = this.book.getWords();
        Arrays.sort(words);
        for (int i = 0; i < words.length; ++i) {
            ps.print((String)words[i] + '\n');
            dictPs.print((String)words[i] + '\n');
        }
        ps.close();
        dictPs.close();
        this.saveStatistics(dictFile);
    }

    private final void saveStatistics(File dictFile) throws Exception {
        String statistics = "";
        statistics = statistics + "Total Wiktionary Title count: " + this.book.getTitleCount() + "\r\n";
        statistics = statistics + "Language Title count: " + this.book.getLanguageTitleCount() + "\r\n";
        statistics = statistics + "Word count in dictionary: " + this.book.getWordCount() + "\r\n";
        statistics = statistics + "Char count in dictionary: " + this.book.getCharCount() + "\r\n";
        statistics = statistics + "Dictionary size on disk (bytes): " + dictFile.length() + "\r\n";
        Class<?> clazz = Class.forName("com.inet.jortho.DictionaryFactory");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        constructor.setAccessible(true);
        Object factory = constructor.newInstance(new Object[0]);
        Method loadWordList = clazz.getDeclaredMethod("loadWordList", URL.class);
        loadWordList.setAccessible(true);
        loadWordList.invoke(factory, dictFile.toURL());
        Method create = clazz.getDeclaredMethod("create", new Class[0]);
        create.setAccessible(true);
        Object dictionary = create.invoke(factory, new Object[0]);
        Method getDataSize = dictionary.getClass().getDeclaredMethod("getDataSize", new Class[0]);
        getDataSize.setAccessible(true);
        Integer size = (Integer)getDataSize.invoke(dictionary, new Object[0]);
        statistics = statistics + "Dictionary size in memory (bytes): " + size + "\r\n";
        System.out.println(statistics);
        FileOutputStream out = new FileOutputStream("statistics.txt");
        out.write(statistics.getBytes());
        out.close();
    }

    private final void createPackage(String language) throws Exception {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream("dictionary_" + language + "_" + new SimpleDateFormat("yyyy_MM").format(new Date()) + ".zip"));
        out.setLevel(9);
        this.addFileToZip(out, "license.txt", false);
        this.addFileToZip(out, "dictionary_" + language + ".ortho", true);
        this.addFileToZip(out, "statistics.txt", true);
        this.addFileToZip(out, "IncludedWords.txt", true);
        out.close();
    }

    private final void addFileToZip(ZipOutputStream out, String filename, boolean delete) throws Exception {
        int count;
        File file = new File(filename);
        FileInputStream fin = new FileInputStream(file);
        ZipEntry entry = new ZipEntry(filename);
        entry.setTime(file.lastModified());
        out.putNextEntry(entry);
        byte[] buffer = new byte[16384];
        while ((count = fin.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.closeEntry();
        fin.close();
        if (delete) {
            file.delete();
        }
    }

    protected final int indexOf(String string, char[] chars, int fromIndex) {
        while (fromIndex < string.length()) {
            char c = string.charAt(fromIndex);
            for (int i = 0; i < chars.length; ++i) {
                if (c != chars[i]) continue;
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    protected boolean isValidWord(String word) {
        int last;
        if (word == null) {
            return false;
        }
        int length = word.length();
        if (length <= 1) {
            return false;
        }
        for (int i = last = length - 1; i >= 0; --i) {
            char ch = word.charAt(i);
            if (Character.isLetter(ch)) continue;
            if (ch == '\'') {
                if (i == last && word.charAt(0) == '\'') {
                    return false;
                }
                if (i <= 0 || word.charAt(i - 1) != '\'') continue;
                return false;
            }
            if (ch == '.' && i == last || ch == '-' && i != 0 && i != last) continue;
            return false;
        }
        return true;
    }

    protected final void addWord(String word) {
        this.book.addWord(word);
    }

    Book getBook() {
        return this.book;
    }

    abstract boolean isValidLanguage(String var1, String var2);
}

