/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class ZigzagStroke
implements Stroke {
    private float amplitude = 10.0f;
    private float wavelength = 10.0f;
    private Stroke stroke;
    private static final float FLATNESS = 1.0f;

    public ZigzagStroke(Stroke stroke, float amplitude, float wavelength) {
        this.stroke = stroke;
        this.amplitude = amplitude;
        this.wavelength = wavelength;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        int type = 0;
        boolean first = false;
        float next = 0.0f;
        int phase = 0;
        float factor = 1.0f;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    result.moveTo(moveX, moveY);
                    first = true;
                    next = this.wavelength / 2.0f;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        float angle = (float)Math.atan2(dy, dx);
                        while (distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            float tx = this.amplitude * dy * r;
                            float ty = this.amplitude * dx * r;
                            if (!(phase & true)) {
                                result.lineTo(x + this.amplitude * dy * r, y - this.amplitude * dx * r);
                            } else {
                                result.lineTo(x - this.amplitude * dy * r, y + this.amplitude * dx * r);
                            }
                            next += this.wavelength;
                            ++phase;
                        }
                    }
                    next -= distance;
                    first = false;
                    lastX = thisX;
                    lastY = thisY;
                    if (type != 4) break;
                    result.closePath();
                }
            }
            it.next();
        }
        return this.stroke.createStrokedShape(result);
    }
}

