/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AboutDialog;
import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.Dictionary;
import com.inet.jortho.DictionaryEditDialog;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Suggestion;
import com.inet.jortho.Tokenizer;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class SpellCheckerDialog
extends JDialog
implements ActionListener {
    private JTextComponent jText;
    private Dictionary dictionary;
    private Tokenizer tok;
    private boolean isDictionaryModify;
    private final SpellCheckerOptions options;
    private final JLabel notFound = Utils.getLabel(null);
    private final JTextField word = Utils.getTextField();
    private final JList suggestionsList = Utils.getList();
    private final JButton ignore = Utils.getButton("ignore");
    private final JButton ignoreAll = Utils.getButton("ignoreAll");
    private final JButton addToDic = Utils.getButton("addToDictionary");
    private final JButton editDic = Utils.getButton("editDictionary");
    private final JButton change = Utils.getButton("change");
    private final JButton changeAll = Utils.getButton("changeAll");
    private final JButton about = Utils.getButton("about");
    private final JButton close = Utils.getButton("close");
    private final ArrayList<String> ignoreWords = new ArrayList();
    private final HashMap<String, String> changeWords = new HashMap();

    SpellCheckerDialog(Dialog owner) throws HeadlessException {
        this(owner, false, null);
    }

    SpellCheckerDialog(Dialog owner, boolean modal, SpellCheckerOptions options) {
        super(owner, modal);
        this.options = options == null ? SpellChecker.getOptions() : options;
        this.init();
    }

    SpellCheckerDialog(Frame owner) {
        this(owner, false, null);
    }

    SpellCheckerDialog(Frame owner, boolean modal, SpellCheckerOptions options) {
        super(owner, modal);
        this.options = options == null ? SpellChecker.getOptions() : options;
        this.init();
    }

    private final void init() {
        Utils.setDialogIcon(this);
        this.setDefaultCloseOperation(2);
        Container cont = this.getContentPane();
        cont.setLayout(new GridBagLayout());
        Insets insetL = new Insets(8, 8, 0, 8);
        Insets insetR = new Insets(8, 0, 0, 8);
        cont.add((Component)Utils.getLabel(Utils.getResource("notInDictionary") + ":"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, insetL, 0, 0));
        this.notFound.setForeground(Color.RED);
        this.notFound.setText("xxxxxxxxxx");
        cont.add((Component)this.notFound, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 16, 0, insetL, 0, 0));
        cont.add((Component)this.word, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, insetL, 0, 0));
        cont.add((Component)Utils.getLabel(Utils.getResource("suggestions") + ":"), new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 16, 0, insetL, 0, 0));
        JScrollPane scrollPane = new JScrollPane(this.suggestionsList);
        cont.add((Component)scrollPane, new GridBagConstraints(1, 4, 2, 6, 1.0, 1.0, 18, 1, new Insets(8, 8, 8, 8), 0, 0));
        cont.add((Component)this.ignore, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.ignoreAll, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.addToDic, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.editDic, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.change, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.changeAll, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.about, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)this.close, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 18, 2, insetR, 0, 0));
        cont.add((Component)Utils.getLabel(null), new GridBagConstraints(3, 9, 1, 1, 0.0, 1.0, 18, 2, insetR, 0, 0));
        this.ignore.addActionListener(this);
        this.ignoreAll.addActionListener(this);
        this.addToDic.addActionListener(this);
        this.editDic.addActionListener(this);
        this.change.addActionListener(this);
        this.changeAll.addActionListener(this);
        this.about.addActionListener(this);
        this.close.addActionListener(this);
        this.close.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESCAPE");
        this.close.getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellCheckerDialog.this.dispose();
            }
        });
        this.word.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }
        });
        this.suggestionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting() && SpellCheckerDialog.this.suggestionsList.getSelectedIndex() >= 0) {
                    SpellCheckerDialog.this.word.setText((String)SpellCheckerDialog.this.suggestionsList.getSelectedValue());
                    SpellCheckerDialog.this.addToDic.setEnabled(true);
                }
            }
        });
        this.suggestionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && SpellCheckerDialog.this.suggestionsList.getSelectedIndex() >= 0) {
                    SpellCheckerDialog.this.word.setText((String)SpellCheckerDialog.this.suggestionsList.getSelectedValue());
                    SpellCheckerDialog.this.actionPerformed(new ActionEvent(SpellCheckerDialog.this.suggestionsList, 0, null));
                }
            }
        });
        boolean isUserDictionary = SpellChecker.getUserDictionaryProvider() != null;
        this.addToDic.setEnabled(isUserDictionary);
        this.editDic.setEnabled(isUserDictionary);
        this.pack();
    }

    public void show(JTextComponent jTextComponent, Dictionary dic, Locale loc) {
        this.jText = jTextComponent;
        this.dictionary = dic;
        this.change.requestFocus();
        this.setTitle(Utils.getResource("spelling") + ": " + loc.getDisplayLanguage());
        this.tok = new Tokenizer(jTextComponent, dic, loc, this.options);
        if (this.searchNext()) {
            Container parent;
            for (parent = jTextComponent; parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                if (parent instanceof JComponent) {
                    JComponent jcomp = parent;
                    if (jcomp.getVisibleRect().height == jcomp.getBounds().height) break;
                }
                if (parent.getParent() == null) break;
            }
            this.setLocationRelativeTo(parent);
            this.setVisible(true);
        }
    }

    private boolean searchNext() {
        String wordStr;
        while (true) {
            if ((wordStr = this.tok.nextInvalidWord()) == null) {
                this.dispose();
                String title = SpellChecker.getApplicationName();
                if (title == null) {
                    title = this.getTitle();
                }
                SpellChecker.getMessageHandler().handleInformation(this.getParent(), title, Utils.getResource("msgFinish"));
                return false;
            }
            if (this.ignoreWords.contains(wordStr)) continue;
            String changeTo = this.changeWords.get(wordStr);
            if (changeTo == null) break;
            this.replaceWord(wordStr, changeTo);
        }
        this.word.setText(wordStr);
        this.notFound.setText(wordStr);
        List<Suggestion> list = this.dictionary.searchSuggestions(wordStr);
        boolean needCapitalization = this.tok.isFirstWordInSentence() && Utils.isFirstCapitalized(wordStr);
        Vector<String> suggestionsVector = new Vector<String>();
        for (int i = 0; i < list.size() && i < this.options.getSuggestionsLimitDialog(); ++i) {
            Suggestion sugestion = list.get(i);
            String newWord = sugestion.getWord();
            if (needCapitalization) {
                newWord = Utils.getCapitalized(newWord);
            }
            if (i == 0) {
                this.word.setText(newWord);
            }
            suggestionsVector.add(newWord);
        }
        this.suggestionsList.setListData(suggestionsVector);
        this.addToDic.setEnabled(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.ignore) {
            this.searchNext();
        } else if (source == this.about) {
            new AboutDialog(this).setVisible(true);
        } else if (source == this.close) {
            this.dispose();
        } else {
            String newWord = this.word.getText();
            String oldWord = this.notFound.getText();
            if (source == this.ignoreAll) {
                this.ignoreWords.add(oldWord);
                this.searchNext();
            } else if (source == this.addToDic) {
                UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
                if (provider != null) {
                    provider.addWord(oldWord);
                }
                this.dictionary.add(oldWord);
                this.dictionary.trimToSize();
                this.isDictionaryModify = true;
                this.searchNext();
            } else if (source == this.editDic) {
                new DictionaryEditDialog(this).setVisible(true);
            } else if (source == this.change || source == this.suggestionsList) {
                this.replaceWord(oldWord, newWord);
                this.searchNext();
            } else if (source == this.changeAll) {
                this.changeWords.put(oldWord, newWord);
                this.replaceWord(oldWord, newWord);
                this.searchNext();
            }
        }
    }

    private void replaceWord(String oldWord, String newWord) {
        this.jText.setSelectionStart(this.tok.getWordOffset());
        this.jText.setSelectionEnd(this.tok.getWordOffset() + oldWord.length());
        this.jText.replaceSelection(newWord);
        this.tok.updatePhrase();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isDictionaryModify) {
            AutoSpellChecker.refresh(this.jText);
        }
    }
}

