/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.CheckerMenu;
import com.inet.jortho.CheckerPopup;
import com.inet.jortho.CustomDictionaryProvider;
import com.inet.jortho.CustomUIProvider;
import com.inet.jortho.DefaultMessageHandler;
import com.inet.jortho.Dictionary;
import com.inet.jortho.DictionaryFactory;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.MessageHandler;
import com.inet.jortho.PopupListener;
import com.inet.jortho.SpellCheckerDialog;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SpellChecker {
    private static final ArrayList<LanguageAction> languages = new ArrayList();
    private static Dictionary currentDictionary;
    private static Locale currentLocale;
    private static UserDictionaryProvider userDictionaryProvider;
    private static CustomDictionaryProvider customDictionaryProvider;
    private static final Map<LanguageChangeListener, Object> listeners;
    private static String applicationName;
    private static final SpellCheckerOptions globalOptions;
    private static MessageHandler messageHandler;
    private static CustomUIProvider customUIProvider;
    static final String SELECTED_KEY = "SwingSelectedKey";

    private SpellChecker() {
    }

    public static void setUserDictionaryProvider(UserDictionaryProvider userDictionaryProvider) {
        SpellChecker.userDictionaryProvider = userDictionaryProvider;
    }

    public static UserDictionaryProvider getUserDictionaryProvider() {
        return userDictionaryProvider;
    }

    public static void setCustomDictionaryProvider(CustomDictionaryProvider customDictionaryProvider) {
        SpellChecker.customDictionaryProvider = customDictionaryProvider;
    }

    public static CustomDictionaryProvider getCustomDictionaryProvider() {
        return customDictionaryProvider;
    }

    public static void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw new IllegalArgumentException();
        }
        SpellChecker.messageHandler = messageHandler;
    }

    public static MessageHandler getMessageHandler() {
        return messageHandler;
    }

    public static void setCustomUIProvider(CustomUIProvider customUIProvider) {
        SpellChecker.customUIProvider = customUIProvider;
    }

    public static CustomUIProvider getCustomUIProvider() {
        return customUIProvider;
    }

    public static void registerDictionaries(URL baseURL, String activeLocale) {
        InputStream input;
        if (baseURL == null) {
            try {
                baseURL = SpellChecker.class.getResource("/dictionaries.cnf");
                baseURL = baseURL != null ? new URL(baseURL, ".") : new URL("file", null, "");
            }
            catch (MalformedURLException e) {
                SpellChecker.getMessageHandler().handleException(e);
            }
        }
        try {
            input = new URL(baseURL, "dictionaries.cnf").openStream();
        }
        catch (Exception e1) {
            try {
                input = new URL(baseURL, "dictionaries.properties").openStream();
            }
            catch (Exception e2) {
                try {
                    input = new URL(baseURL, "dictionaries.txt").openStream();
                }
                catch (Exception e3) {
                    System.err.println("JOrtho configuration file not found!");
                    SpellChecker.getMessageHandler().handleException(e1);
                    SpellChecker.getMessageHandler().handleException(e2);
                    SpellChecker.getMessageHandler().handleException(e3);
                    return;
                }
            }
        }
        Properties props = new Properties();
        try {
            props.load(input);
        }
        catch (IOException e) {
            SpellChecker.getMessageHandler().handleException(e);
            return;
        }
        String availableLocales = props.getProperty("languages");
        String extension = props.getProperty("extension", ".ortho");
        SpellChecker.registerDictionaries(baseURL, availableLocales, activeLocale, extension);
    }

    public static void registerDictionaries(URL baseURL, String availableLocales, String activeLocale) {
        SpellChecker.registerDictionaries(baseURL, availableLocales, activeLocale, ".ortho");
    }

    public static void registerDictionaries(URL baseURL, String availableLocales, String activeLocale, String extension) {
        if (baseURL == null) {
            try {
                baseURL = new URL("file", null, "");
            }
            catch (MalformedURLException e) {
                SpellChecker.getMessageHandler().handleException(e);
            }
        }
        for (String locale : availableLocales.split(",")) {
            if ((locale = locale.trim().toLowerCase()).length() <= 0) continue;
            LanguageAction action = new LanguageAction(baseURL, new Locale(locale), extension);
            languages.remove(action);
            languages.add(action);
            if (!locale.equals(activeLocale)) continue;
            action.actionPerformed(null);
        }
        Collections.sort(languages);
    }

    public static void register(JTextComponent text) throws NullPointerException {
        SpellChecker.register(text, true, true, true, true);
    }

    public static void register(JTextComponent text, boolean hasPopup, boolean submenu, boolean hasShortKey, boolean hasAutoSpell) throws NullPointerException {
        if (hasPopup) {
            SpellChecker.enablePopup(text, true, submenu);
        }
        if (hasShortKey) {
            SpellChecker.enableShortKey(text, true);
        }
        if (hasAutoSpell) {
            SpellChecker.enableAutoSpell(text, true);
        }
    }

    public static void unregister(JTextComponent text) {
        SpellChecker.enableShortKey(text, false);
        SpellChecker.enablePopup(text, false, false);
        SpellChecker.enableAutoSpell(text, false);
    }

    public static void enableShortKey(JTextComponent text, boolean enable) {
        SpellChecker.enableShortKey(text, enable, null);
    }

    public static void enableShortKey(final JTextComponent text, boolean enable, final SpellCheckerOptions options) {
        if (enable) {
            text.getInputMap().put(KeyStroke.getKeyStroke(118, 0), "spell-checking");
            text.getActionMap().put("spell-checking", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpellChecker.showSpellCheckerDialog(text, options);
                }
            });
        } else {
            text.getActionMap().remove("spell-checking");
        }
    }

    public static void showSpellCheckerDialog(JTextComponent text, SpellCheckerOptions options) {
        if (!text.isEditable()) {
            return;
        }
        Dictionary dictionary = currentDictionary;
        if (dictionary != null) {
            Window parent = SwingUtilities.getWindowAncestor(text);
            SpellCheckerDialog dialog = parent instanceof Frame ? new SpellCheckerDialog((Frame)parent, true, options) : new SpellCheckerDialog((Dialog)parent, true, options);
            dialog.show(text, dictionary, currentLocale);
        }
    }

    public static void enablePopup(JTextComponent text, boolean enable, boolean submenu) {
        if (enable) {
            JPopupMenu menu;
            if (submenu) {
                menu = new JPopupMenu();
                menu.add(SpellChecker.createCheckerMenu());
                menu.add(SpellChecker.createLanguagesMenu());
            } else {
                menu = SpellChecker.createCheckerPopup();
            }
            text.addMouseListener(new PopupListener(menu));
        } else {
            for (MouseListener listener : text.getMouseListeners()) {
                if (!(listener instanceof PopupListener)) continue;
                text.removeMouseListener(listener);
            }
        }
    }

    public static void enableAutoSpell(JTextComponent text, boolean enable) {
        SpellChecker.enableAutoSpell(text, enable, null);
    }

    public static void enableAutoSpell(JTextComponent text, boolean enable, SpellCheckerOptions options) {
        if (enable) {
            new AutoSpellChecker(text, options);
        } else {
            AutoSpellChecker.disable(text);
        }
    }

    public static void addLanguageChangeLister(LanguageChangeListener listener) {
        listeners.put(listener, null);
    }

    public static void removeLanguageChangeLister(LanguageChangeListener listener) {
        listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(Locale oldLocale) {
        LanguageChangeEvent ev = new LanguageChangeEvent(currentLocale, oldLocale);
        Object[] objectArray = listeners;
        synchronized (listeners) {
            Object[] list = listeners.keySet().toArray();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Object listener : list) {
                ((LanguageChangeListener)listener).languageChanged(ev);
            }
            return;
        }
    }

    public static JMenu createCheckerMenu() {
        return SpellChecker.createCheckerMenu(null);
    }

    public static JMenu createCheckerMenu(SpellCheckerOptions options) {
        return new CheckerMenu(options);
    }

    public static JPopupMenu createCheckerPopup() {
        return SpellChecker.createCheckerPopup(null);
    }

    public static JPopupMenu createCheckerPopup(SpellCheckerOptions options) {
        return new CheckerPopup(options);
    }

    public static JMenu createLanguagesMenu() {
        return SpellChecker.createLanguagesMenu(null);
    }

    public static JMenu createLanguagesMenu(SpellCheckerOptions options) {
        JMenu menu = new JMenu(Utils.getResource("languages"));
        ButtonGroup group = new ButtonGroup();
        menu.setEnabled(languages.size() > 0);
        for (LanguageAction action : languages) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setModel(new ActionToggleButtonModel(action));
            menu.add(item);
            group.add(item);
        }
        if (options == null) {
            options = SpellChecker.getOptions();
        }
        if (languages.size() > 0 && options.isLanguageDisableVisible()) {
            menu.addSeparator();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(DisableLanguageAction.instance);
            item.setModel(new ActionToggleButtonModel(DisableLanguageAction.instance));
            menu.add(item);
            group.add(item);
        }
        return menu;
    }

    static Dictionary getCurrentDictionary() {
        return currentDictionary;
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static void setCurrentLocale(Locale locale) throws IllegalArgumentException {
        if (locale.equals(currentLocale)) {
            return;
        }
        for (LanguageAction language : languages) {
            if (!language.locale.equals(locale)) continue;
            language.actionPerformed(null);
            return;
        }
        throw new IllegalArgumentException("Not registered locale: " + locale);
    }

    public static boolean isDictionaryLoaded() {
        return currentDictionary != null && currentDictionary.getDataSize() > 1;
    }

    public static void setApplicationName(String name) {
        applicationName = name;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static SpellCheckerOptions getOptions() {
        return globalOptions;
    }

    static {
        listeners = Collections.synchronizedMap(new WeakHashMap());
        globalOptions = new SpellCheckerOptions();
        messageHandler = new DefaultMessageHandler(null);
    }

    private static class LanguageAction
    extends AbtsractLanguageAction
    implements Comparable<LanguageAction> {
        private final URL baseURL;
        private final Locale locale;
        private String extension;

        LanguageAction(URL baseURL, Locale locale, String extension) {
            super(locale.getDisplayLanguage());
            this.baseURL = baseURL;
            this.locale = locale;
            this.extension = extension;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DictionaryFactory factory = new DictionaryFactory();
                        try {
                            factory.loadWordList(new URL(baseURL, "dictionary_" + locale + extension));
                        }
                        catch (Exception ex) {
                            SpellChecker.getMessageHandler().handleError(ex.toString(), "Error", ex);
                        }
                        try {
                            Iterator<String> userWords;
                            CustomDictionaryProvider provider = userDictionaryProvider;
                            if (provider != null && (userWords = provider.getWords(locale)) != null) {
                                factory.loadWords(userWords);
                            }
                            if ((provider = customDictionaryProvider) != null && (userWords = provider.getWords(locale)) != null) {
                                factory.loadWords(userWords);
                            }
                        }
                        catch (Exception ex) {
                            SpellChecker.getMessageHandler().handleError(ex.toString(), "Error", ex);
                        }
                        Locale oldLocale = locale;
                        currentDictionary = factory.create();
                        factory = null;
                        currentLocale = locale;
                        SpellChecker.fireLanguageChanged(oldLocale);
                    }
                    finally {
                        this.setEnabled(true);
                    }
                }
            });
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LanguageAction) {
                return this.locale.equals(((LanguageAction)obj).locale);
            }
            return false;
        }

        public int hashCode() {
            return this.locale.hashCode();
        }

        @Override
        public int compareTo(LanguageAction obj) {
            return this.toString().compareTo(obj.toString());
        }
    }

    private static class DisableLanguageAction
    extends AbtsractLanguageAction {
        static DisableLanguageAction instance = new DisableLanguageAction();

        private DisableLanguageAction() {
            super(Utils.getResource("disable"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            try {
                currentDictionary = null;
                Locale oldLocale = currentLocale;
                currentLocale = null;
                SpellChecker.fireLanguageChanged(oldLocale);
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    private static abstract class AbtsractLanguageAction
    extends AbstractAction {
        private static AbtsractLanguageAction currentAction;

        public AbtsractLanguageAction(String name) {
            super(name);
        }

        public void setSelected(boolean b) {
            if (b) {
                if (currentAction != null && currentAction != this) {
                    currentAction.setSelected(false);
                }
                currentAction = this;
            }
            this.putValue(SpellChecker.SELECTED_KEY, b);
        }
    }

    private static class ActionToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        private final AbtsractLanguageAction action;

        ActionToggleButtonModel(AbtsractLanguageAction action) {
            this.action = action;
        }

        @Override
        public boolean isSelected() {
            return Boolean.TRUE.equals(this.action.getValue(SpellChecker.SELECTED_KEY));
        }

        @Override
        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.action.setSelected(b);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }
}

