/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

class LowMemoryArrayList<E> {
    private transient E[] elementData;

    LowMemoryArrayList() {
    }

    public int size() {
        return this.elementData == null ? 0 : this.elementData.length;
    }

    public E get(int index) {
        return this.elementData[index];
    }

    public void add(E o) {
        int size = this.size();
        Object[] tempData = new Object[size + 1];
        if (size > 0) {
            System.arraycopy(this.elementData, 0, tempData, 0, size);
        }
        this.elementData = tempData;
        this.elementData[size] = o;
    }

    public void add(int index, E element) {
        int size = this.size();
        Object[] tempData = new Object[size + 1];
        if (size > 0) {
            System.arraycopy(this.elementData, 0, tempData, 0, index);
            System.arraycopy(this.elementData, index, tempData, index + 1, size - index);
        }
        this.elementData = tempData;
        this.elementData[index] = element;
    }
}

