/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LowMemoryArrayList;
import com.inet.jortho.WordIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

class DictionaryFactory {
    private final Node root = new Node('\u0000');
    private char[] tree;
    private int size;

    public void loadWordList(URL filename) throws IOException {
        this.loadWords(new WordIterator(filename));
    }

    public void loadWords(Iterator<String> words) {
        while (words.hasNext()) {
            String word = words.next();
            if (word == null || word.length() <= 1) continue;
            this.add(word);
        }
    }

    public void add(String word) {
        Node node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            Node entry = node.searchCharOrAdd(c);
            if (i == word.length() - 1) {
                entry.isWord = true;
                return;
            }
            node = entry;
        }
    }

    public Dictionary create() {
        this.tree = new char[10000];
        this.root.save(this);
        char[] temp = new char[this.size];
        System.arraycopy(this.tree, 0, temp, 0, this.size);
        this.tree = temp;
        return new Dictionary(this.tree);
    }

    final void checkSize(int newSize) {
        if (newSize > this.tree.length) {
            char[] puffer = new char[Math.max(newSize, 2 * this.tree.length)];
            System.arraycopy(this.tree, 0, puffer, 0, this.size);
            this.tree = puffer;
        }
    }

    private static final class Node
    extends LowMemoryArrayList<Node> {
        private final char c;
        private boolean isWord;

        Node(char c) {
            this.c = c;
        }

        Node searchCharOrAdd(char c) {
            for (int i = 0; i < this.size(); ++i) {
                Node entry = (Node)this.get(i);
                if (entry.c < c) continue;
                if (entry.c == c) {
                    return entry;
                }
                entry = new Node(c);
                this.add(i, entry);
                return entry;
            }
            Node entry = new Node(c);
            this.add(entry);
            return entry;
        }

        int save(DictionaryFactory factory) {
            int idx;
            int start = idx = factory.size;
            int newSize = factory.size + this.size() * 3 + 1;
            factory.checkSize(newSize);
            factory.size = newSize;
            for (int i = 0; i < this.size(); ++i) {
                Node entry = (Node)this.get(i);
                ((DictionaryFactory)factory).tree[idx++] = entry.c;
                int offset = 0;
                if (entry.size() != 0) {
                    offset = entry.save(factory);
                }
                if (entry.isWord) {
                    offset |= Integer.MIN_VALUE;
                }
                ((DictionaryFactory)factory).tree[idx++] = (char)(offset >> 16);
                ((DictionaryFactory)factory).tree[idx++] = (char)offset;
            }
            ((DictionaryFactory)factory).tree[idx] = 65535;
            return start;
        }
    }
}

