/*
 * Decompiled with CFR 0.152.
 */
package tiger;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;
import tiger.DataType;

class VariablesTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Label", "Variable name", "Type"};
    private final Class[] columnTypes = new Class[]{String.class, String.class, DataType.class};
    private ArrayList<ArrayList> rows = new ArrayList();

    VariablesTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.rows.size()) {
            this.addRow();
        }
        this.rows.get(rowIndex).set(columnIndex, aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public void setColumnName(int columnIndex, String name) {
        this.columnNames[columnIndex] = name;
        this.fireTableStructureChanged();
    }

    public void setColumnNames(String[] names) {
        System.arraycopy(names, 0, this.columnNames, 0, Math.min(names.length, this.columnNames.length));
        this.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    public void addRow() {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add("");
        row.add("");
        row.add((Object)DataType.SINGLE_STRING);
        this.rows.add(row);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void deleteRow(int rowIndex) {
        this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void moveRowUp(int rowIndex) {
        if (rowIndex > 0 && this.rows.size() > 1) {
            Collections.swap(this.rows, rowIndex, rowIndex - 1);
            this.fireTableDataChanged();
        }
    }

    public void moveRowDown(int rowIndex) {
        if (rowIndex < this.rows.size() - 1 && rowIndex >= 0) {
            Collections.swap(this.rows, rowIndex, rowIndex + 1);
            this.fireTableDataChanged();
        }
    }
}

