/*
 * Decompiled with CFR 0.152.
 */
package tiger;

import icons.Lazaicon;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Icons;
import se.datadosen.util.SmartResourceBundle;
import tiger.DataType;
import tiger.VariablesTableModel;

public class JVariablesPanel
extends JPanel {
    private VariablesTableModel model = new VariablesTableModel();
    private JTable table = new JTable(this.model);
    private float opacity = 1.0f;
    private final Action addRowAction = new AbstractAction("Add", JVariablesPanel.svgIcon("plus")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JVariablesPanel.this.model.getRowCount();
            JVariablesPanel.this.model.addRow();
            JVariablesPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
            JVariablesPanel.this.table.editCellAt(row, 0);
            JVariablesPanel.this.table.requestFocusInWindow();
        }
    };
    private final Action deleteRowAction = new AbstractAction("Remove", JVariablesPanel.svgIcon("minus")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JVariablesPanel.this.table.getSelectedRow();
            if (row != -1) {
                JVariablesPanel.this.model.deleteRow(row);
                if (--row < 0) {
                    row = 0;
                }
                JVariablesPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    };
    private final Action moveRowUpAction = new AbstractAction("Move up", JVariablesPanel.svgIcon("arrow-up")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JVariablesPanel.this.table.getSelectedRow();
            if (row > 0) {
                JVariablesPanel.this.model.moveRowUp(row);
                JVariablesPanel.this.table.requestFocusInWindow();
                JVariablesPanel.this.table.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    };
    private final Action moveRowDownAction = new AbstractAction("Move down", JVariablesPanel.svgIcon("arrow-down")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JVariablesPanel.this.table.getSelectedRow();
            if (row >= 0 && row < JVariablesPanel.this.table.getRowCount() - 1) {
                JVariablesPanel.this.model.moveRowDown(row);
                JVariablesPanel.this.table.requestFocusInWindow();
                JVariablesPanel.this.table.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    };

    public static Icon svgIcon(String basename) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)18);
    }

    public JVariablesPanel(SmartResourceBundle texts) {
        super(new BorderLayout());
        JComboBox<DataType> dataType = new JComboBox<DataType>(DataType.values());
        String[] translatedColNames = new String[]{texts.getString("ui.label"), texts.getString("ui.variableName"), texts.getString("ui.type")};
        this.model.setColumnNames(translatedColNames);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(dataType));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 160));
        this.table.getTableHeader().setFont(this.table.getTableHeader().getFont().deriveFont(this.table.getTableHeader().getFont().getSize2D() + 1.0f));
        this.table.setFont(this.table.getFont().deriveFont(this.table.getFont().getSize2D() + 1.0f));
        this.table.setRowHeight(this.table.getRowHeight() + 8);
        this.add(new JScrollPane(this.table));
        JPanel buttonPanel = new JPanel(new FlowLayout(3));
        this.add((Component)buttonPanel, "South");
        buttonPanel.add((Component)new JPlainButton(this.addRowAction));
        buttonPanel.add((Component)new JPlainButton(this.deleteRowAction));
        buttonPanel.add((Component)new JPlainButton(this.moveRowUpAction));
        buttonPanel.add((Component)new JPlainButton(this.moveRowDownAction));
    }

    public JTable getTable() {
        return this.table;
    }

    public void setDimensions(Dimension d) {
        this.table.setPreferredScrollableViewportSize(d);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.opacity));
        super.paintChildren(g2);
        g2.dispose();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.table.getTableHeader().setEnabled(enabled);
        this.opacity = enabled ? 1.0f : 0.5f;
        this.repaint();
    }
}

