/*
 * Decompiled with CFR 0.152.
 */
package pixy.util;

public class IntHashtable<E> {
    private static final int DEFAULT_TABLE_SIZE = 257;
    private HashEntry<E>[] array;
    private int currentSize;

    public IntHashtable() {
        this(257);
    }

    public IntHashtable(int n) {
        this.array = new HashEntry[n];
        this.makeEmpty();
    }

    public void put(int n, E e) {
        int n2 = this.locate(n);
        if (this.isActive(n2)) {
            return;
        }
        this.array[n2] = new HashEntry<E>(n, e, true);
        if (++this.currentSize > this.array.length / 2) {
            this.rehash();
        }
    }

    private void rehash() {
        HashEntry<E>[] hashEntryArray = this.array;
        this.array = new HashEntry[IntHashtable.nextPrime(2 * hashEntryArray.length)];
        this.currentSize = 0;
        for (int i = 0; i < hashEntryArray.length; ++i) {
            if (hashEntryArray[i] == null || !hashEntryArray[i].isActive) continue;
            this.put(hashEntryArray[i].key, hashEntryArray[i].value);
        }
    }

    private int locate(int n) {
        int n2 = 0;
        int n3 = (n & Integer.MAX_VALUE) % this.array.length;
        while (this.array[n3] != null && this.array[n3].key != n) {
            if ((n3 += 2 * ++n2 - 1) < this.array.length) continue;
            n3 -= this.array.length;
        }
        return n3;
    }

    public void remove(int n) {
        int n2 = this.locate(n);
        if (this.isActive(n2)) {
            this.array[n2].isActive = false;
            --this.currentSize;
        }
    }

    public boolean contains(int n) {
        return this.isActive(this.locate(n));
    }

    public E get(int n) {
        int n2 = this.locate(n);
        return this.isActive(n2) ? (E)this.array[n2].value : null;
    }

    private boolean isActive(int n) {
        return this.array[n] != null && this.array[n].isActive;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!IntHashtable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        IntHashtable<Integer> intHashtable = new IntHashtable<Integer>();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            intHashtable.put(n, new Integer(n));
            n = (n + 37) % 4000;
        }
        for (n = 1; n < 4000; n += 2) {
            intHashtable.remove(n);
        }
        for (n = 2; n < 4000; n += 2) {
            if ((Integer)intHashtable.get(n) == n) continue;
            System.out.println("Find fails " + n);
        }
        for (n = 1; n < 4000; n += 2) {
            if (intHashtable.get(n) == null) continue;
            System.out.println("OOPS!!! " + n);
        }
    }

    private static class HashEntry<V> {
        int key;
        V value;
        boolean isActive;

        HashEntry(int n, V v) {
            this(n, v, true);
        }

        HashEntry(int n, V v, boolean bl) {
            this.key = n;
            this.value = v;
            this.isActive = bl;
        }
    }
}

