/*
 * Decompiled with CFR 0.152.
 */
package pixy.test;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.TiffTag;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.adobe.IPTC_NAA;
import pixy.meta.adobe._8BIM;
import pixy.meta.exif.Exif;
import pixy.meta.exif.ExifTag;
import pixy.meta.iptc.IPTCApplicationTag;
import pixy.meta.iptc.IPTCDataSet;
import pixy.meta.jpeg.JPGMeta;
import pixy.meta.jpeg.JpegExif;
import pixy.meta.jpeg.JpegXMP;
import pixy.meta.tiff.TiffExif;
import pixy.meta.xmp.XMP;
import pixy.string.StringUtils;
import pixy.string.XMLUtils;
import pixy.util.MetadataUtils;

public class TestPixyMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPixyMeta.class);

    public static void main(String[] stringArray) throws Exception {
        new TestPixyMeta().test(stringArray);
    }

    public void test(String ... stringArray) throws Exception {
        Metadata metadata;
        Map<MetadataType, Metadata> map = Metadata.readMetadata(stringArray[0]);
        LOGGER.info("Start of metadata information:");
        LOGGER.info("Total number of metadata entries: {}", (Object)map.size());
        int n = 0;
        for (Map.Entry<MetadataType, Metadata> object2 : map.entrySet()) {
            LOGGER.info("Metadata entry {} - {}", (Object)n, (Object)object2.getKey());
            metadata = object2.getValue();
            if (metadata instanceof XMP) {
                XMP.showXMP((XMP)metadata);
            } else {
                for (Object object2 : object2.getValue()) {
                    this.printMetadata((MetadataEntry)object2, "", "     ");
                }
            }
            ++n;
            LOGGER.info("-----------------------------------------");
        }
        LOGGER.info("End of metadata information.");
        Object object4 = null;
        Object var5_6 = null;
        if (map.get((Object)MetadataType.XMP) != null) {
            metadata = (XMP)map.get((Object)MetadataType.XMP);
            object4 = new FileInputStream("images/1.jpg");
            FileOutputStream fileOutputStream = new FileOutputStream("1-xmp-inserted.jpg");
            Object object = null;
            if (!((XMP)metadata).hasExtendedXmp()) {
                object = new JpegXMP(((XMP)metadata).getData());
            } else {
                Object object2;
                object2 = ((XMP)metadata).getXmpDocument();
                Document document = ((XMP)metadata).getExtendedXmpDocument();
                object = new JpegXMP(XMLUtils.serializeToString(object2.getDocumentElement(), "UTF-8"), XMLUtils.serializeToString(document));
            }
            Metadata.insertXMP((InputStream)object4, (OutputStream)fileOutputStream, (XMP)object);
            ((FileInputStream)object4).close();
            fileOutputStream.close();
        }
        Metadata.extractThumbnails("images/iptc-envelope.tif", "iptc-envelope");
        object4 = new FileInputStream("images/iptc-envelope.tif");
        FileOutputStream fileOutputStream = new FileOutputStream("iptc-envelope-iptc-inserted.tif");
        Metadata.insertIPTC((InputStream)object4, fileOutputStream, TestPixyMeta.createIPTCDataSet(), true);
        ((FileInputStream)object4).close();
        fileOutputStream.close();
        object4 = new FileInputStream("images/wizard.jpg");
        FileOutputStream fileOutputStream2 = new FileOutputStream("wizard-iptc-inserted.jpg");
        Metadata.insertIPTC((InputStream)object4, fileOutputStream2, TestPixyMeta.createIPTCDataSet(), true);
        ((FileInputStream)object4).close();
        fileOutputStream2.close();
        object4 = new FileInputStream("images/1.jpg");
        FileOutputStream fileOutputStream3 = new FileOutputStream("1-irbthumbnail-inserted.jpg");
        Metadata.insertIRBThumbnail((InputStream)object4, fileOutputStream3, TestPixyMeta.createThumbnail("images/1.jpg"));
        ((FileInputStream)object4).close();
        fileOutputStream3.close();
        object4 = new FileInputStream("images/f1.tif");
        FileOutputStream fileOutputStream4 = new FileOutputStream("f1-irbthumbnail-inserted.tif");
        Metadata.insertIRBThumbnail((InputStream)object4, fileOutputStream4, TestPixyMeta.createThumbnail("images/f1.tif"));
        ((FileInputStream)object4).close();
        fileOutputStream4.close();
        object4 = new FileInputStream("images/exif.tif");
        FileOutputStream fileOutputStream5 = new FileOutputStream("exif-exif-inserted.tif");
        Metadata.insertExif((InputStream)object4, fileOutputStream5, TestPixyMeta.populateExif(TiffExif.class), true);
        ((FileInputStream)object4).close();
        fileOutputStream5.close();
        object4 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream6 = new FileOutputStream("12-exif-inserted.jpg");
        Metadata.insertExif((InputStream)object4, fileOutputStream6, TestPixyMeta.populateExif(JpegExif.class), true);
        ((FileInputStream)object4).close();
        fileOutputStream6.close();
        object4 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream7 = new FileOutputStream("12-metadata-removed.jpg");
        Metadata.removeMetadata((InputStream)object4, fileOutputStream7, MetadataType.JPG_JFIF, MetadataType.JPG_ADOBE, MetadataType.IPTC, MetadataType.ICC_PROFILE, MetadataType.XMP, MetadataType.EXIF);
        ((FileInputStream)object4).close();
        fileOutputStream7.close();
        object4 = new FileInputStream("images/12.jpg");
        FileOutputStream fileOutputStream8 = new FileOutputStream("12-photoshop-iptc-inserted.jpg");
        Metadata.insertIRB((InputStream)object4, fileOutputStream8, TestPixyMeta.createPhotoshopIPTC(), true);
        ((FileInputStream)object4).close();
        fileOutputStream8.close();
        object4 = new FileInputStream("images/table.jpg");
        JPGMeta.extractDepthMap((InputStream)object4, "table");
        ((FileInputStream)object4).close();
        object4 = new FileInputStream("images/butterfly.png");
        FileOutputStream fileOutputStream9 = new FileOutputStream("comment-inserted.png");
        Metadata.insertComments((InputStream)object4, fileOutputStream9, Arrays.asList("Comment1", "Comment2"));
        ((FileInputStream)object4).close();
        fileOutputStream9.close();
    }

    private static List<IPTCDataSet> createIPTCDataSet() {
        ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.COPYRIGHT_NOTICE, "Copyright 2014-2016, yuwen_66@yahoo.com"));
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.CATEGORY, "ICAFE"));
        arrayList.add(new IPTCDataSet(IPTCApplicationTag.KEY_WORDS, "Welcome 'icafe' user!"));
        return arrayList;
    }

    private static List<_8BIM> createPhotoshopIPTC() {
        IPTC_NAA iPTC_NAA = new IPTC_NAA();
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.COPYRIGHT_NOTICE, "Copyright 2014-2016, yuwen_66@yahoo.com"));
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.KEY_WORDS, "Welcome 'icafe' user!"));
        iPTC_NAA.addDataSet(new IPTCDataSet(IPTCApplicationTag.CATEGORY, "ICAFE"));
        return new ArrayList<_8BIM>(Arrays.asList(iPTC_NAA));
    }

    private static BufferedImage createThumbnail(String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        BufferedImage bufferedImage = MetadataUtils.createThumbnail(fileInputStream);
        fileInputStream.close();
        return bufferedImage;
    }

    private static Exif populateExif(Class<?> clazz) throws IOException {
        Exif exif = clazz == TiffExif.class ? new TiffExif() : new JpegExif();
        exif.addImageField(TiffTag.WINDOWS_XP_AUTHOR, FieldType.WINDOWSXP, "Author");
        exif.addImageField(TiffTag.WINDOWS_XP_KEYWORDS, FieldType.WINDOWSXP, "Copyright;Author");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        exif.addExifField(ExifTag.EXPOSURE_TIME, FieldType.RATIONAL, new int[]{10, 600});
        exif.addExifField(ExifTag.FNUMBER, FieldType.RATIONAL, new int[]{49, 10});
        exif.addExifField(ExifTag.ISO_SPEED_RATINGS, FieldType.SHORT, new short[]{273});
        exif.addExifField(ExifTag.EXIF_VERSION, FieldType.UNDEFINED, "0220".getBytes());
        exif.addExifField(ExifTag.DATE_TIME_ORIGINAL, FieldType.ASCII, simpleDateFormat.format(new Date()));
        exif.addExifField(ExifTag.DATE_TIME_DIGITIZED, FieldType.ASCII, simpleDateFormat.format(new Date()));
        exif.addExifField(ExifTag.FOCAL_LENGTH, FieldType.RATIONAL, new int[]{240, 10});
        exif.setThumbnailRequired(true);
        return exif;
    }

    private void printMetadata(MetadataEntry metadataEntry, String object, String string) {
        LOGGER.info((String)object + metadataEntry.getKey() + (String)(StringUtils.isNullOrEmpty(metadataEntry.getValue()) ? "" : ": " + metadataEntry.getValue()));
        if (metadataEntry.isMetadataEntryGroup()) {
            object = (String)object + string;
            Collection<MetadataEntry> collection = metadataEntry.getMetadataEntries();
            for (MetadataEntry metadataEntry2 : collection) {
                this.printMetadata(metadataEntry2, (String)object, string);
            }
        }
    }
}

