/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.xmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.string.XMLUtils;

public abstract class XMP
extends Metadata {
    private Document xmpDocument;
    private Document extendedXmpDocument;
    private Document mergedXmpDocument;
    private boolean hasExtendedXmp;
    private byte[] extendedXmpData;
    private String xmp;

    public static void showXMP(XMP xMP) {
        XMLUtils.showXML(xMP.getMergedDocument());
    }

    public XMP(byte[] byArray) {
        super(MetadataType.XMP, byArray);
    }

    public XMP(String string) {
        super(MetadataType.XMP);
        this.xmp = string;
    }

    public XMP(String string, String string2) {
        super(MetadataType.XMP);
        if (string == null) {
            throw new IllegalArgumentException("Input XMP string is null");
        }
        this.xmp = string;
        if (string2 != null) {
            try {
                this.setExtendedXMPData(XMLUtils.serializeToByteArray(XMLUtils.createXML(string2)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void addNodeToEntry(Node node, MetadataEntry metadataEntry) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 9: {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.addNodeToEntry(node2, metadataEntry);
                    }
                    break;
                }
                case 10: {
                    DocumentType documentType = (DocumentType)node;
                    metadataEntry.addEntry(new MetadataEntry("!DOCTYPE", documentType.getName()));
                    break;
                }
                case 1: {
                    Node node3;
                    Element element = (Element)node;
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        node3 = namedNodeMap.item(i);
                        stringBuilder.append(node3.getNodeName()).append("=").append("'" + node3.getNodeValue()).append("' ");
                    }
                    MetadataEntry metadataEntry2 = new MetadataEntry(element.getTagName(), stringBuilder.toString().trim(), true);
                    metadataEntry.addEntry(metadataEntry2);
                    for (node3 = element.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        this.addNodeToEntry(node3, metadataEntry2);
                    }
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    String string = text.getData().trim();
                    if (string == null || string.length() <= 0) break;
                    metadataEntry.addEntry(new MetadataEntry(string, ""));
                    break;
                }
                case 7: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    metadataEntry.addEntry(new MetadataEntry("?" + processingInstruction.getTarget(), processingInstruction.getData() + "?"));
                    break;
                }
                case 5: {
                    metadataEntry.addEntry(new MetadataEntry("&" + node.getNodeName() + ";", ""));
                    break;
                }
                case 4: {
                    CDATASection cDATASection = (CDATASection)node;
                    metadataEntry.addEntry(new MetadataEntry("![CDATA[" + cDATASection.getData() + "]]", ""));
                    break;
                }
                case 8: {
                    Comment comment = (Comment)node;
                    metadataEntry.addEntry(new MetadataEntry("!--" + comment.getData() + "--", ""));
                    break;
                }
            }
        }
    }

    @Override
    public byte[] getData() {
        byte[] byArray = super.getData();
        if (byArray != null && !this.hasExtendedXmp) {
            return byArray;
        }
        try {
            return XMLUtils.serializeToByteArray(this.getMergedDocument());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getExtendedXmpData() {
        return this.extendedXmpData;
    }

    public Document getExtendedXmpDocument() {
        if (this.hasExtendedXmp && this.extendedXmpDocument == null) {
            this.extendedXmpDocument = XMLUtils.createXML(this.extendedXmpData);
        }
        return this.extendedXmpDocument;
    }

    public Document getMergedDocument() {
        if (this.mergedXmpDocument != null) {
            return this.mergedXmpDocument;
        }
        if (this.getExtendedXmpDocument() != null) {
            Node node;
            this.mergedXmpDocument = XMLUtils.createDocumentNode();
            Document document = this.getXmpDocument();
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = this.mergedXmpDocument.importNode(nodeList.item(i), true);
                this.mergedXmpDocument.appendChild(node);
            }
            XMLUtils.removeAttribute(this.mergedXmpDocument, "rdf:Description", "xmpNote:HasExtendedXMP");
            NodeList nodeList2 = this.extendedXmpDocument.getElementsByTagName("rdf:RDF").item(0).getChildNodes();
            node = (Element)this.mergedXmpDocument.getElementsByTagName("rdf:RDF").item(0);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                Node node3 = this.mergedXmpDocument.importNode(node2, true);
                node.appendChild(node3);
            }
            return this.mergedXmpDocument;
        }
        return this.getXmpDocument();
    }

    public Document getXmpDocument() {
        this.ensureDataRead();
        return this.xmpDocument;
    }

    public boolean hasExtendedXmp() {
        return this.hasExtendedXmp;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        Document document = this.getMergedDocument();
        MetadataEntry metadataEntry = new MetadataEntry("XMP", " Document", true);
        this.addNodeToEntry(document, metadataEntry);
        return Collections.unmodifiableCollection(metadataEntry.getMetadataEntries()).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            if (this.xmp != null) {
                this.xmpDocument = XMLUtils.createXML(this.xmp);
            } else if (this.data != null) {
                this.xmpDocument = XMLUtils.createXML(this.data);
            }
            this.isDataRead = true;
        }
    }

    public void setExtendedXMPData(byte[] byArray) {
        this.extendedXmpData = byArray;
        this.hasExtendedXmp = true;
    }

    public void showMetadata() {
        this.ensureDataRead();
        XMLUtils.showXML(this.getMergedDocument());
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

