/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import pixy.image.jpeg.Marker;
import pixy.image.tiff.ASCIIField;
import pixy.image.tiff.IFD;
import pixy.image.tiff.LongField;
import pixy.image.tiff.TiffTag;
import pixy.io.IOUtils;
import pixy.io.MemoryCacheRandomAccessOutputStream;
import pixy.io.RandomAccessOutputStream;
import pixy.io.WriteStrategyMM;
import pixy.meta.exif.Exif;

public class JpegExif
extends Exif {
    public JpegExif() {
    }

    public JpegExif(byte[] byArray) {
        super(byArray);
    }

    private void createImageIFD() {
        this.imageIFD = new IFD();
        ASCIIField aSCIIField = new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), "Exif created by JPEGTweaker");
        this.imageIFD.addField(aSCIIField);
        String string = "JPEGTweaker 1.0";
        aSCIIField = new ASCIIField(TiffTag.SOFTWARE.getValue(), string);
        this.imageIFD.addField(aSCIIField);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        aSCIIField = new ASCIIField(TiffTag.DATETIME.getValue(), simpleDateFormat.format(new Date()));
        this.imageIFD.addField(aSCIIField);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.ensureDataRead();
        MemoryCacheRandomAccessOutputStream memoryCacheRandomAccessOutputStream = new MemoryCacheRandomAccessOutputStream(outputStream);
        IOUtils.writeShortMM(outputStream, Marker.APP1.getValue());
        int n = 19789;
        int n2 = 42;
        memoryCacheRandomAccessOutputStream.setWriteStrategy(WriteStrategyMM.getInstance());
        memoryCacheRandomAccessOutputStream.writeShort(n);
        memoryCacheRandomAccessOutputStream.writeShort(n2);
        ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).seek(4L);
        memoryCacheRandomAccessOutputStream.writeInt(8);
        ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).seek(8L);
        if (this.imageIFD == null) {
            this.createImageIFD();
        }
        if (this.exifSubIFD != null) {
            this.imageIFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
            this.imageIFD.addChild(TiffTag.EXIF_SUB_IFD, this.exifSubIFD);
        }
        if (this.gpsSubIFD != null) {
            this.imageIFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
            this.imageIFD.addChild(TiffTag.GPS_SUB_IFD, this.gpsSubIFD);
        }
        int n3 = this.imageIFD.write(memoryCacheRandomAccessOutputStream, 8);
        if (this.thumbnail != null && this.thumbnail.containsImage()) {
            this.imageIFD.setNextIFDOffset(memoryCacheRandomAccessOutputStream, n3);
            ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).seek(n3);
            this.thumbnail.write(memoryCacheRandomAccessOutputStream);
        }
        int n4 = (int)((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).getLength();
        IOUtils.writeShortMM(outputStream, n4 + 8);
        byte[] byArray = new byte[]{69, 120, 105, 102, 0, 0};
        IOUtils.write(outputStream, byArray);
        ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).seek(0L);
        ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).writeToStream(n4);
        ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).shallowClose();
    }
}

