/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import pixy.image.jpeg.COMBuilder;
import pixy.image.jpeg.Component;
import pixy.image.jpeg.DHTReader;
import pixy.image.jpeg.DQTReader;
import pixy.image.jpeg.HTable;
import pixy.image.jpeg.Marker;
import pixy.image.jpeg.QTable;
import pixy.image.jpeg.SOFReader;
import pixy.image.jpeg.SOSReader;
import pixy.image.jpeg.Segment;
import pixy.image.jpeg.UnknownSegment;
import pixy.image.tiff.IFD;
import pixy.image.tiff.TiffTag;
import pixy.io.FileCacheRandomAccessInputStream;
import pixy.io.IOUtils;
import pixy.io.RandomAccessInputStream;
import pixy.meta.Metadata;
import pixy.meta.MetadataType;
import pixy.meta.Thumbnail;
import pixy.meta.adobe.IRB;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe.ThumbnailResource;
import pixy.meta.adobe._8BIM;
import pixy.meta.exif.Exif;
import pixy.meta.exif.ExifThumbnail;
import pixy.meta.icc.ICCProfile;
import pixy.meta.image.Comments;
import pixy.meta.image.ImageMetadata;
import pixy.meta.iptc.IPTC;
import pixy.meta.iptc.IPTCDataSet;
import pixy.meta.iptc.IPTCTag;
import pixy.meta.jpeg.Adobe;
import pixy.meta.jpeg.Ducky;
import pixy.meta.jpeg.JFIF;
import pixy.meta.jpeg.JpegExif;
import pixy.meta.jpeg.JpegXMP;
import pixy.meta.xmp.XMP;
import pixy.string.Base64;
import pixy.string.StringUtils;
import pixy.string.XMLUtils;
import pixy.util.ArrayUtils;
import pixy.util.MetadataUtils;

public class JPGMeta {
    public static final EnumSet<Marker> APPnMarkers = EnumSet.range(Marker.APP0, Marker.APP15);
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGMeta.class);

    private static short copySegment(short s, InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        IOUtils.writeShortMM(outputStream, s);
        IOUtils.writeShortMM(outputStream, (short)n);
        IOUtils.write(outputStream, byArray);
        return IOUtils.readShortMM(inputStream);
    }

    private static short copySOS(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        short s = 0;
        block3: while ((n = IOUtils.read(inputStream)) != -1) {
            if (n == 255) {
                n = IOUtils.read(inputStream);
                if (n == -1) {
                    throw new IOException("Premature end of SOS segment!");
                }
                if (n != 0) {
                    s = (short)(0xFF00 | n);
                    switch (Marker.fromShort(s)) {
                        case RST0: 
                        case RST1: 
                        case RST2: 
                        case RST3: 
                        case RST4: 
                        case RST5: 
                        case RST6: 
                        case RST7: {
                            IOUtils.writeShortMM(outputStream, s);
                            continue block3;
                        }
                    }
                    break;
                }
                IOUtils.write(outputStream, 255);
                IOUtils.write(outputStream, n);
                continue;
            }
            IOUtils.write(outputStream, n);
        }
        if (n == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    private static void copyToEnd(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[10240];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static byte[] extractICCProfile(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        short s = IOUtils.readShortMM(inputStream);
        block6: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case PADDING: {
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                    }
                    s = (short)(0xFF00 | n2);
                    continue block6;
                }
                case SOS: {
                    bl = true;
                    continue block6;
                }
                case APP2: {
                    JPGMeta.readAPP2(inputStream, byteArrayOutputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            s = IOUtils.readShortMM(inputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void extractICCProfile(InputStream inputStream, String string) throws IOException {
        byte[] byArray = JPGMeta.extractICCProfile(inputStream);
        if (byArray != null && byArray.length > 0) {
            Object object = "";
            object = string.endsWith("\\") || string.endsWith("/") ? string + "icc_profile" : string.replaceFirst("[.][^.]+$", "");
            FileOutputStream fileOutputStream = new FileOutputStream((String)object + ".icc");
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void extractDepthMap(InputStream inputStream, String string) throws IOException {
        Map<MetadataType, Metadata> map = JPGMeta.readMetadata(inputStream);
        XMP xMP = (XMP)map.get((Object)MetadataType.XMP);
        if (xMP != null) {
            FileOutputStream fileOutputStream;
            byte[] byArray;
            Object object;
            String string2;
            Document document = xMP.getMergedDocument();
            String string3 = XMLUtils.getAttribute(document, "rdf:Description", "GDepth:Mime");
            String string4 = "GDepth:Data";
            String string5 = XMLUtils.getAttribute(document, "rdf:Description", "GAudio:Mime");
            if (StringUtils.isNullOrEmpty(string3)) {
                string3 = XMLUtils.getAttribute(document, "rdf:Description", "GImage:Mime");
                string4 = "GImage:Data";
            }
            if (!StringUtils.isNullOrEmpty(string3) && !StringUtils.isNullOrEmpty(string2 = XMLUtils.getAttribute(document, "rdf:Description", string4))) {
                object = "";
                object = string.endsWith("\\") || string.endsWith("/") ? string + "google_depthmap" : string.replaceFirst("[.][^.]+$", "") + "_depthmap";
                if (string3.equalsIgnoreCase("image/png")) {
                    object = (String)object + ".png";
                } else if (string3.equalsIgnoreCase("image/jpeg")) {
                    object = (String)object + ".jpg";
                }
                try {
                    byArray = Base64.decodeToByteArray(string2);
                    fileOutputStream = new FileOutputStream(new File((String)object));
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!StringUtils.isNullOrEmpty(string5) && !StringUtils.isNullOrEmpty(string2 = XMLUtils.getAttribute(document, "rdf:Description", "GAudio:Data"))) {
                object = "";
                object = string.endsWith("\\") || string.endsWith("/") ? string + "google_cardboard_audio" : string.replaceFirst("[.][^.]+$", "") + "_cardboard_audio";
                if (string5.equalsIgnoreCase("audio/mp4a-latm")) {
                    object = (String)object + ".mp4";
                }
                try {
                    byArray = Base64.decodeToByteArray(string2);
                    fileOutputStream = new FileOutputStream(new File((String)object));
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void extractMetadataFromAPPn(Collection<Segment> collection, Map<MetadataType, Metadata> map) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        byte[] byArray = null;
        String string = "";
        HashMap<String, Thumbnail> hashMap = new HashMap<String, Thumbnail>();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            byte[] byArray2 = ((Segment)object).getData();
            int n = ((Segment)object).getLength();
            if (((Segment)object).getMarker() == Marker.APP0) {
                if (byArray2.length < "JFIF\u0000".length() || !new String(byArray2, 0, "JFIF\u0000".length()).equals("JFIF\u0000")) continue;
                map.put(MetadataType.JPG_JFIF, new JFIF(ArrayUtils.subArray(byArray2, "JFIF\u0000".length(), n - "JFIF\u0000".length() - 2)));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP1) {
                int n2;
                byte[] byArray3;
                if (byArray2.length >= "Exif\u0000\u0000".length() && new String(byArray2, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                    JpegExif jpegExif = new JpegExif(ArrayUtils.subArray(byArray2, "Exif\u0000\u0000".length(), n - "Exif\u0000\u0000".length() - 2));
                    map.put(MetadataType.EXIF, jpegExif);
                    continue;
                }
                if (byArray2.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray2, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || byArray2.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray2, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000")) {
                    JpegXMP jpegXMP = new JpegXMP(ArrayUtils.subArray(byArray2, "http://ns.adobe.com/xap/1.0/\u0000".length(), n - "http://ns.adobe.com/xap/1.0/\u0000".length() - 2));
                    map.put(MetadataType.XMP, jpegXMP);
                    string = XMLUtils.getAttribute(jpegXMP.getXmpDocument(), "rdf:Description", "xmpNote:HasExtendedXMP");
                    continue;
                }
                if (byArray2.length < "http://ns.adobe.com/xmp/extension/\u0000".length() || !new String(byArray2, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || !Arrays.equals(byArray3 = ArrayUtils.subArray(byArray2, n2 = "http://ns.adobe.com/xmp/extension/\u0000".length(), 32), string.getBytes())) continue;
                long l = IOUtils.readUnsignedIntMM(byArray2, n2 += 32);
                n2 += 4;
                if (byArray == null) {
                    byArray = new byte[(int)l];
                }
                long l2 = IOUtils.readUnsignedIntMM(byArray2, n2);
                byte[] byArray4 = ArrayUtils.subArray(byArray2, n2 += 4, n - "http://ns.adobe.com/xmp/extension/\u0000".length() - 42);
                System.arraycopy(byArray4, 0, byArray, (int)l2, byArray4.length);
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP2) {
                if (byArray2.length < "ICC_PROFILE\u0000".length() || !new String(byArray2, 0, "ICC_PROFILE\u0000".length()).equals("ICC_PROFILE\u0000")) continue;
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                byteArrayOutputStream.write(ArrayUtils.subArray(byArray2, "ICC_PROFILE\u0000".length() + 2, n - "ICC_PROFILE\u0000".length() - 4));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP12) {
                if (byArray2.length < "Ducky".length() || !new String(byArray2, 0, "Ducky".length()).equals("Ducky")) continue;
                map.put(MetadataType.JPG_DUCKY, new Ducky(ArrayUtils.subArray(byArray2, "Ducky".length(), n - "Ducky".length() - 2)));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP13) {
                if (byArray2.length < "Photoshop 3.0\u0000".length() || !new String(byArray2, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) continue;
                if (byteArrayOutputStream2 == null) {
                    byteArrayOutputStream2 = new ByteArrayOutputStream();
                }
                byteArrayOutputStream2.write(ArrayUtils.subArray(byArray2, "Photoshop 3.0\u0000".length(), n - "Photoshop 3.0\u0000".length() - 2));
                continue;
            }
            if (((Segment)object).getMarker() != Marker.APP14 || byArray2.length < "Adobe".length() || !new String(byArray2, 0, "Adobe".length()).equals("Adobe")) continue;
            map.put(MetadataType.JPG_ADOBE, new Adobe(ArrayUtils.subArray(byArray2, "Adobe".length(), n - "Adobe".length() - 2)));
        }
        if (byteArrayOutputStream != null) {
            object2 = new ICCProfile(byteArrayOutputStream.toByteArray());
            map.put(MetadataType.ICC_PROFILE, (Metadata)object2);
        }
        if (byteArrayOutputStream2 != null) {
            object2 = new IRB(byteArrayOutputStream2.toByteArray());
            map.put(MetadataType.PHOTOSHOP_IRB, (Metadata)object2);
            object = ((IRB)object2).get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (object != null) {
                map.put(MetadataType.IPTC, new IPTC(((_8BIM)object).getData()));
            }
        }
        if (byArray != null && (object2 = (XMP)map.get((Object)MetadataType.XMP)) != null) {
            ((XMP)object2).setExtendedXMPData(byArray);
        }
        if ((object2 = map.get((Object)MetadataType.EXIF)) != null) {
            object = (Exif)object2;
            if (!((Metadata)object).isDataRead()) {
                ((Exif)object).read();
            }
            if (((Exif)object).containsThumbnail()) {
                hashMap.put("EXIF", ((Exif)object).getThumbnail());
            }
        }
        if ((object2 = map.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            object = (IRB)object2;
            if (!((Metadata)object).isDataRead()) {
                ((IRB)object).read();
            }
            if (((IRB)object).containsThumbnail()) {
                hashMap.put("PHOTOSHOP_IRB", ((IRB)object).getThumbnail());
            }
        }
        map.put(MetadataType.IMAGE, new ImageMetadata(hashMap));
    }

    public static void extractThumbnails(InputStream inputStream, String string) throws IOException {
        boolean bl = false;
        int n = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        short s = IOUtils.readShortMM(inputStream);
        block8: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(inputStream);
                    continue block8;
                }
                case PADDING: {
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                    }
                    s = (short)(0xFF00 | n2);
                    continue block8;
                }
                case SOS: {
                    bl = true;
                    continue block8;
                }
                case APP0: {
                    Object object;
                    Object object2;
                    n = IOUtils.readUnsignedShortMM(inputStream);
                    byte[] byArray = new byte[n - 2];
                    IOUtils.readFully(inputStream, byArray);
                    if (new String(byArray, 0, "JFIF\u0000".length()).equals("JFIF\u0000") || new String(byArray, 0, "JFXX\u0000".length()).equals("JFXX\u0000")) {
                        int n3 = byArray[12] & 0xFF;
                        int n4 = byArray[13] & 0xFF;
                        Object object3 = "";
                        object3 = string.endsWith("\\") || string.endsWith("/") ? string + "jfif_thumbnail" : string.replaceFirst("[.][^.]+$", "") + "_jfif_t";
                        if (n3 != 0 && n4 != 0) {
                            int n5 = 3 * n3 * n4;
                            object2 = new DataBufferByte(ArrayUtils.subArray(byArray, 14, n5), n5);
                            object = new int[]{0, 1, 2};
                            int n6 = 3;
                            int n7 = 1;
                            WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object2, n3, n4, 3 * n3, n6, (int[])object, null);
                            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, n7, 0);
                            BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
                            FileOutputStream fileOutputStream = new FileOutputStream((String)object3 + ".jpg");
                            MetadataUtils.saveAsJPEG(bufferedImage, fileOutputStream, 100);
                            fileOutputStream.close();
                        }
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block8;
                }
                case APP1: {
                    Object object2;
                    byte[] byArray = new byte["Exif\u0000\u0000".length()];
                    n = IOUtils.readUnsignedShortMM(inputStream);
                    IOUtils.readFully(inputStream, byArray);
                    if (Arrays.equals(byArray, "Exif\u0000\u0000".getBytes())) {
                        byArray = new byte[n - 8];
                        IOUtils.readFully(inputStream, byArray);
                        JpegExif jpegExif = new JpegExif(byArray);
                        if (jpegExif.containsThumbnail()) {
                            Object object = "";
                            object = string.endsWith("\\") || string.endsWith("/") ? string + "exif_thumbnail" : string.replaceFirst("[.][^.]+$", "") + "_exif_t";
                            ExifThumbnail exifThumbnail = jpegExif.getThumbnail();
                            object2 = null;
                            object2 = exifThumbnail.getDataType() == 1 ? new FileOutputStream((String)object + ".jpg") : new FileOutputStream((String)object + ".tif");
                            ((OutputStream)object2).write(exifThumbnail.getCompressedImage());
                            ((OutputStream)object2).close();
                        }
                    } else {
                        IOUtils.skipFully(inputStream, n - 8);
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block8;
                }
                case APP13: {
                    IRB iRB;
                    Object object;
                    Object object2;
                    n = IOUtils.readUnsignedShortMM(inputStream);
                    byte[] byArray = new byte[n - 2];
                    IOUtils.readFully(inputStream, byArray, 0, n - 2);
                    int n8 = 0;
                    while (byArray[n8] != 0) {
                        ++n8;
                    }
                    if (new String(byArray, 0, n8++).equals("Photoshop 3.0") && (iRB = new IRB(ArrayUtils.subArray(byArray, n8, byArray.length - n8))).containsThumbnail()) {
                        object2 = iRB.getThumbnail();
                        object = "";
                        object = string.endsWith("\\") || string.endsWith("/") ? string + "photoshop_thumbnail.jpg" : string.replaceFirst("[.][^.]+$", "") + "_photoshop_t.jpg";
                        FileOutputStream fileOutputStream = new FileOutputStream((String)object);
                        if (((Thumbnail)object2).getDataType() == 1) {
                            fileOutputStream.write(((Thumbnail)object2).getCompressedImage());
                        } else {
                            MetadataUtils.saveAsJPEG(((Thumbnail)object2).getRawImage(), fileOutputStream, 100);
                        }
                        fileOutputStream.close();
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block8;
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static ICCProfile getICCProfile(InputStream inputStream) throws IOException {
        ICCProfile iCCProfile = null;
        byte[] byArray = JPGMeta.extractICCProfile(inputStream);
        if (byArray.length > 0) {
            iCCProfile = new ICCProfile(byArray);
        }
        return iCCProfile;
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        boolean bl = false;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        block4: while (!bl) {
            if (Marker.fromShort(s) == Marker.SOS) {
                for (String string : list) {
                    JPGMeta.writeComment(string, outputStream);
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(outputStream, s);
                    s = IOUtils.readShortMM(inputStream);
                    continue block4;
                }
                case PADDING: {
                    IOUtils.writeShortMM(outputStream, s);
                    int n = 0;
                    while ((n = IOUtils.read(inputStream)) == 255) {
                        IOUtils.write(outputStream, n);
                    }
                    s = (short)(0xFF00 | n);
                    continue block4;
                }
            }
            s = JPGMeta.copySegment(s, inputStream, outputStream);
        }
    }

    public static void insertExif(InputStream inputStream, OutputStream outputStream, Exif exif, boolean bl) throws IOException {
        if (exif.isThumbnailRequired() && !exif.containsThumbnail()) {
            inputStream = new FileCacheRandomAccessInputStream(inputStream);
            exif.setThumbnailImage(MetadataUtils.createThumbnail(inputStream));
        }
        Exif exif2 = null;
        int n = -1;
        boolean bl2 = false;
        int n2 = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block5: while (!bl2) {
            Object object;
            Object object2;
            if (Marker.fromShort(s) == Marker.SOS) {
                for (int i = 0; i <= n; ++i) {
                    ((Segment)arrayList.get(i)).write(outputStream);
                }
                object2 = exif.getExifIFD();
                object = exif.getGPSIFD();
                IFD iFD = exif.getImageIFD();
                ExifThumbnail exifThumbnail = exif.getThumbnail();
                Object object3 = null;
                Object object4 = null;
                IFD iFD2 = null;
                if (bl && exif2 != null) {
                    IFD iFD3 = exif2.getImageIFD();
                    IFD iFD4 = exif2.getExifIFD();
                    IFD iFD5 = exif2.getGPSIFD();
                    ExifThumbnail exifThumbnail2 = exif2.getThumbnail();
                    if (iFD3 != null) {
                        iFD2 = new IFD();
                        iFD2.addFields(iFD3.getFields());
                    }
                    if (exifThumbnail2 != null && exifThumbnail == null) {
                        exifThumbnail = exifThumbnail2;
                    }
                    if (iFD4 != null) {
                        object3 = new IFD();
                        ((IFD)object3).addFields(iFD4.getFields());
                    }
                    if (iFD5 != null) {
                        object4 = new IFD();
                        ((IFD)object4).addFields(iFD5.getFields());
                    }
                }
                if (iFD != null) {
                    if (iFD2 == null) {
                        iFD2 = new IFD();
                    }
                    iFD2.addFields(iFD.getFields());
                }
                if (object3 != null) {
                    if (object2 != null) {
                        ((IFD)object3).addFields(((IFD)object2).getFields());
                    }
                } else {
                    object3 = object2;
                }
                if (object4 != null) {
                    if (object != null) {
                        ((IFD)object4).addFields(((IFD)object).getFields());
                    }
                } else {
                    object4 = object;
                }
                if (iFD2 != null) {
                    if (object3 != null) {
                        iFD2.addChild(TiffTag.EXIF_SUB_IFD, (IFD)object3);
                    }
                    if (object4 != null) {
                        iFD2.addChild(TiffTag.GPS_SUB_IFD, (IFD)object4);
                    }
                    exif.setImageIFD(iFD2);
                } else {
                    exif.setExifIFD((IFD)object3);
                    exif.setGPSIFD((IFD)object4);
                }
                exif.setThumbnail(exifThumbnail);
                exif.write(outputStream);
                for (int i = n + 1; i < arrayList.size(); ++i) {
                    ((Segment)arrayList.get(i)).write(outputStream);
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl2 = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    arrayList.add(new Segment(marker, 0, null));
                    s = IOUtils.readShortMM(inputStream);
                    continue block5;
                }
                case APP1: {
                    n2 = IOUtils.readUnsignedShortMM(inputStream);
                    object2 = new byte[n2 - 2];
                    IOUtils.readFully(inputStream, (byte[])object2);
                    arrayList.add(new Segment(marker, n2, (byte[])object2));
                    if (((Object)object2).length >= "Exif\u0000\u0000".length() && new String((byte[])object2, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                        exif2 = new JpegExif(ArrayUtils.subArray((byte[])object2, "Exif\u0000\u0000".length(), n2 - "Exif\u0000\u0000".length() - 2));
                        arrayList.remove(arrayList.size() - 1);
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block5;
                }
                case APP0: {
                    n = arrayList.size();
                }
            }
            n2 = IOUtils.readUnsignedShortMM(inputStream);
            object = new byte[n2 - 2];
            IOUtils.readFully(inputStream, (byte[])object);
            if (marker == Marker.UNKNOWN) {
                arrayList.add(new UnknownSegment(s, n2, (byte[])object));
            } else {
                arrayList.add(new Segment(marker, n2, (byte[])object));
            }
            s = IOUtils.readShortMM(inputStream);
        }
        if (inputStream instanceof RandomAccessInputStream) {
            ((FileCacheRandomAccessInputStream)inputStream).shallowClose();
        }
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[]{73, 67, 67, 95, 80, 82, 79, 70, 73, 76, 69, 0};
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block6: while (!bl) {
            if (Marker.fromShort(s) == Marker.SOS) {
                int n4;
                int n5 = Math.max(n2, n3);
                for (n4 = 0; n4 <= n5; ++n4) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                }
                JPGMeta.writeICCProfile(outputStream, byArray);
                int n6 = n4 = n5 < 0 ? 0 : n5 + 1;
                while (n4 < arrayList.size()) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                    ++n4;
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    arrayList.add(new Segment(marker, 0, null));
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP2: {
                    byte[] byArray3 = new byte[12];
                    n = IOUtils.readUnsignedShortMM(inputStream);
                    if (n < 14) {
                        byArray3 = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray3);
                        arrayList.add(new Segment(marker, n, byArray3));
                    } else {
                        IOUtils.readFully(inputStream, byArray3);
                        if (Arrays.equals(byArray3, byArray2)) {
                            IOUtils.skipFully(inputStream, n - 14);
                        } else {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray3);
                            byte[] byArray4 = new byte[n - "ICC_PROFILE\u0000".length() - 2];
                            IOUtils.readFully(inputStream, byArray4);
                            arrayList.add(new Segment(marker, n, ArrayUtils.concat(byArray3, new byte[][]{byArray4})));
                        }
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP0: {
                    n2 = arrayList.size();
                }
                case APP1: {
                    n3 = arrayList.size();
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray5 = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray5);
            if (marker == Marker.UNKNOWN) {
                arrayList.add(new UnknownSegment(s, n, byArray5));
            } else {
                arrayList.add(new Segment(marker, n, byArray5));
            }
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, ICC_Profile iCC_Profile) throws IOException {
        JPGMeta.insertICCProfile(inputStream, outputStream, iCC_Profile.getData());
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, ICCProfile iCCProfile) throws Exception {
        JPGMeta.insertICCProfile(inputStream, outputStream, iCCProfile.getData());
    }

    /*
     * WARNING - void declaration
     */
    public static void insertIPTC(InputStream inputStream, OutputStream outputStream, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        boolean bl2 = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        HashMap<Short, _8BIM> hashMap = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            inputStream.close();
            outputStream.close();
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block6: while (!bl2) {
            if (Marker.fromShort(s) == Marker.SOS) {
                void n4;
                int n5;
                Object object;
                IRB iRB;
                Object object2;
                if (byteArrayOutputStream != null && (object2 = (_8BIM)(hashMap = new HashMap<Short, _8BIM>((iRB = new IRB(byteArrayOutputStream.toByteArray())).get8BIM())).remove(ImageResourceID.IPTC_NAA.getValue())) != null && bl) {
                    object = new IPTC(((_8BIM)object2).getData());
                    HashMap<IPTCTag, List<IPTCDataSet>> object3 = new HashMap<IPTCTag, List<IPTCDataSet>>(((IPTC)object).getDataSets());
                    for (IPTCDataSet iPTCDataSet : collection) {
                        if (iPTCDataSet.allowMultiple()) continue;
                        object3.remove(iPTCDataSet.getName());
                    }
                    for (List list : object3.values()) {
                        collection.addAll(list);
                    }
                }
                int n52 = Math.max(n2, n3);
                for (int i = 0; i <= n52; ++i) {
                    ((Segment)arrayList.get(i)).write(outputStream);
                }
                object2 = new ByteArrayOutputStream();
                for (IPTCDataSet iPTCDataSet : collection) {
                    iPTCDataSet.write((OutputStream)object2);
                }
                object = new _8BIM(ImageResourceID.IPTC_NAA.getValue(), "iptc", ((ByteArrayOutputStream)object2).toByteArray());
                if (hashMap != null) {
                    hashMap.put(((_8BIM)object).getID(), (_8BIM)object);
                    JPGMeta.writeIRB(outputStream, hashMap.values());
                } else {
                    JPGMeta.writeIRB(outputStream, new _8BIM[]{object});
                }
                int n6 = n5 = n52 < 0 ? 0 : n52 + 1;
                while (n4 < arrayList.size()) {
                    ((Segment)arrayList.get((int)n4)).write(outputStream);
                    ++n4;
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl2 = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    arrayList.add(new Segment(marker, 0, null));
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP13: {
                    if (byteArrayOutputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    }
                    JPGMeta.readAPP13(inputStream, byteArrayOutputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP0: {
                    n2 = arrayList.size();
                }
                case APP1: {
                    n3 = arrayList.size();
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (marker == Marker.UNKNOWN) {
                arrayList.add(new UnknownSegment(s, n, byArray));
            } else {
                arrayList.add(new Segment(marker, n, byArray));
            }
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static void insertIRB(InputStream inputStream, OutputStream outputStream, Collection<_8BIM> collection, boolean bl) throws IOException {
        boolean bl2 = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            inputStream.close();
            outputStream.close();
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block6: while (!bl2) {
            if (Marker.fromShort(s) == Marker.SOS) {
                int n4;
                if (byteArrayOutputStream != null) {
                    IRB iRB = new IRB(byteArrayOutputStream.toByteArray());
                    HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(iRB.get8BIM());
                    for (_8BIM _8BIM2 : collection) {
                        hashMap.put(_8BIM2.getID(), _8BIM2);
                    }
                    if (hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue()) && hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS5.getValue())) {
                        hashMap.remove(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue());
                    }
                    collection = hashMap.values();
                }
                int n5 = Math.max(n2, n3);
                for (n4 = 0; n4 <= n5; ++n4) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                }
                JPGMeta.writeIRB(outputStream, collection);
                int n6 = n4 = n5 < 0 ? 0 : n5 + 1;
                while (n4 < arrayList.size()) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                    ++n4;
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl2 = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    arrayList.add(new Segment(marker, 0, null));
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP13: {
                    if (bl) {
                        if (byteArrayOutputStream == null) {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                        }
                        JPGMeta.readAPP13(inputStream, byteArrayOutputStream);
                    } else {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        IOUtils.skipFully(inputStream, n - 2);
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block6;
                }
                case APP0: {
                    n2 = arrayList.size();
                }
                case APP1: {
                    n3 = arrayList.size();
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (marker == Marker.UNKNOWN) {
                arrayList.add(new UnknownSegment(s, n, byArray));
            } else {
                arrayList.add(new Segment(marker, n, byArray));
            }
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static void insertIRBThumbnail(InputStream inputStream, OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Input thumbnail is null");
        }
        ThumbnailResource thumbnailResource = new ThumbnailResource(bufferedImage);
        JPGMeta.insertIRB(inputStream, outputStream, Arrays.asList(thumbnailResource), true);
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        block5: while (!bl) {
            if (Marker.fromShort(s) == Marker.SOS) {
                int n4;
                int n5 = Math.max(n2, n3);
                for (n4 = 0; n4 <= n5; ++n4) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                }
                xMP.write(outputStream);
                int n6 = n4 = n5 < 0 ? 0 : n5 + 1;
                while (n4 < arrayList.size()) {
                    ((Segment)arrayList.get(n4)).write(outputStream);
                    ++n4;
                }
                IOUtils.writeShortMM(outputStream, s);
                JPGMeta.copyToEnd(inputStream, outputStream);
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    arrayList.add(new Segment(marker, 0, null));
                    s = IOUtils.readShortMM(inputStream);
                    continue block5;
                }
                case APP1: {
                    n = IOUtils.readUnsignedShortMM(inputStream);
                    byte[] byArray = new byte[n - 2];
                    IOUtils.readFully(inputStream, byArray);
                    if (!(byArray.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(byArray, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || byArray.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000"))) {
                        arrayList.add(new Segment(marker, n, byArray));
                        if (byArray.length >= "Exif\u0000\u0000".length() && new String(byArray, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                            n3 = arrayList.size() - 1;
                        }
                    }
                    s = IOUtils.readShortMM(inputStream);
                    continue block5;
                }
                case APP0: {
                    n2 = arrayList.size();
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (marker == Marker.UNKNOWN) {
                arrayList.add(new UnknownSegment(s, n, byArray));
            } else {
                arrayList.add(new Segment(marker, n, byArray));
            }
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, String string, String string2) throws IOException {
        JPGMeta.insertXMP(inputStream, outputStream, new JpegXMP(string, string2));
    }

    private static String hTablesToString(List<HTable> list) {
        String[] stringArray = new String[]{"DC Component", "AC Component"};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Huffman table information =>:\n");
        for (HTable hTable : list) {
            int n;
            stringBuilder.append("Class: " + hTable.getClazz() + " (" + stringArray[hTable.getClazz()] + ")\n");
            stringBuilder.append("Huffman table #: " + hTable.getID() + "\n");
            byte[] byArray = hTable.getBits();
            byte[] byArray2 = hTable.getValues();
            int n2 = 0;
            for (n = 0; n < byArray.length; ++n) {
                n2 += byArray[n] & 0xFF;
            }
            stringBuilder.append("Number of codes: " + n2 + "\n");
            if (n2 > 256) {
                throw new RuntimeException("Invalid huffman code count: " + n2);
            }
            n = 0;
            for (int i = 0; i < 16; ++i) {
                stringBuilder.append("Codes of length " + (i + 1) + " (" + (byArray[i] & 0xFF) + " total): [ ");
                for (int j = 0; j < (byArray[i] & 0xFF); ++j) {
                    stringBuilder.append((byArray2[n++] & 0xFF) + " ");
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("<<End of Huffman table information>>\n");
        }
        return stringBuilder.toString();
    }

    private static String qTablesToString(List<QTable> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quantization table information =>:\n");
        int n = 0;
        for (QTable qTable : list) {
            int n2;
            int n3 = qTable.getPrecision();
            int[] nArray = qTable.getData();
            stringBuilder.append("precision of QT is " + n3 + "\n");
            stringBuilder.append("Quantization table #" + qTable.getID() + ":\n");
            if (n3 == 0) {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            } else {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            }
            ++n;
            stringBuilder.append("\n");
            stringBuilder.append("***************************\n");
        }
        stringBuilder.append("Total number of Quantation tables: " + n + "\n");
        stringBuilder.append("End of quantization table information\n");
        return stringBuilder.toString();
    }

    private static String sofToString(SOFReader sOFReader) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOF information =>\n");
        stringBuilder.append("Precision: " + sOFReader.getPrecision() + "\n");
        stringBuilder.append("Image height: " + sOFReader.getFrameHeight() + "\n");
        stringBuilder.append("Image width: " + sOFReader.getFrameWidth() + "\n");
        stringBuilder.append("# of Components: " + sOFReader.getNumOfComponents() + "\n");
        stringBuilder.append("(1 = grey scaled, 3 = color YCbCr or YIQ, 4 = color CMYK)\n");
        for (Component component : sOFReader.getComponents()) {
            stringBuilder.append("\n");
            stringBuilder.append("Component ID: " + component.getId() + "\n");
            stringBuilder.append("Herizontal sampling factor: " + component.getHSampleFactor() + "\n");
            stringBuilder.append("Vertical sampling factor: " + component.getVSampleFactor() + "\n");
            stringBuilder.append("Quantization table #: " + component.getQTableNumber() + "\n");
            stringBuilder.append("DC table number: " + component.getDCTableNumber() + "\n");
            stringBuilder.append("AC table number: " + component.getACTableNumber() + "\n");
        }
        stringBuilder.append("<= End of SOF information");
        return stringBuilder.toString();
    }

    private static void readAPP13(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        if (new String(byArray, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) {
            outputStream.write(ArrayUtils.subArray(byArray, "Photoshop 3.0\u0000".length(), byArray.length - "Photoshop 3.0\u0000".length()));
        }
    }

    private static void readAPP2(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte["ICC_PROFILE\u0000".length()];
        int n = IOUtils.readUnsignedShortMM(inputStream);
        IOUtils.readFully(inputStream, byArray);
        if (Arrays.equals(byArray, "ICC_PROFILE\u0000".getBytes())) {
            byArray = new byte[n - "ICC_PROFILE\u0000".length() - 2];
            IOUtils.readFully(inputStream, byArray);
            outputStream.write(byArray, 2, n - "ICC_PROFILE\u0000".length() - 4);
        } else {
            IOUtils.skipFully(inputStream, n - "ICC_PROFILE\u0000".length() - 2);
        }
    }

    private static void readDHT(InputStream inputStream, List<HTable> list, List<HTable> list2) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DHTReader dHTReader = new DHTReader(new Segment(Marker.DHT, n, byArray));
        List<HTable> list3 = dHTReader.getDCTables();
        List<HTable> list4 = dHTReader.getACTables();
        list.addAll(list4);
        list2.addAll(list3);
    }

    private static void readDQT(InputStream inputStream, List<QTable> list) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DQTReader dQTReader = new DQTReader(new Segment(Marker.DQT, n, byArray));
        List<QTable> list2 = dQTReader.getTables();
        list.addAll(list2);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        HashMap<String, Thumbnail> hashMap2 = new HashMap<String, Thumbnail>();
        inputStream = new BufferedInputStream(inputStream);
        ArrayList<QTable> arrayList = new ArrayList<QTable>(4);
        ArrayList<HTable> arrayList2 = new ArrayList<HTable>(4);
        ArrayList<HTable> arrayList3 = new ArrayList<HTable>(4);
        ArrayList<SOFReader> arrayList4 = new ArrayList<SOFReader>();
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        byte[] byArray = null;
        String string = "";
        Comments comments = null;
        ArrayList<Segment> arrayList5 = new ArrayList<Segment>();
        boolean bl = false;
        int n = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        short s = IOUtils.readShortMM(inputStream);
        block10: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case APP2: 
                case APP0: 
                case APP1: 
                case APP13: 
                case APP3: 
                case APP4: 
                case APP5: 
                case APP6: 
                case APP7: 
                case APP8: 
                case APP9: 
                case APP10: 
                case APP11: 
                case APP12: 
                case APP14: 
                case APP15: {
                    object2 = JPGMeta.readSegmentData(inputStream);
                    arrayList5.add(new Segment(marker, ((byte[])object2).length + 2, (byte[])object2));
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case COM: {
                    if (comments == null) {
                        comments = new Comments();
                    }
                    comments.addComment(JPGMeta.readSegmentData(inputStream));
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case DHT: {
                    JPGMeta.readDHT(inputStream, arrayList2, arrayList3);
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case DQT: {
                    JPGMeta.readDQT(inputStream, arrayList);
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case SOF0: 
                case SOF1: 
                case SOF2: 
                case SOF3: 
                case SOF5: 
                case SOF6: 
                case SOF7: 
                case SOF9: 
                case SOF10: 
                case SOF11: 
                case SOF13: 
                case SOF14: 
                case SOF15: {
                    arrayList4.add(JPGMeta.readSOF(inputStream, marker));
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case SOS: {
                    object = (SOFReader)arrayList4.get(arrayList4.size() - 1);
                    s = JPGMeta.readSOS(inputStream, (SOFReader)object);
                    LOGGER.debug("\n{}", (Object)JPGMeta.sofToString((SOFReader)object));
                    continue block10;
                }
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(inputStream);
                    continue block10;
                }
                case PADDING: {
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                    }
                    s = (short)(0xFF00 | n2);
                    continue block10;
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            IOUtils.skipFully(inputStream, n - 2);
            s = IOUtils.readShortMM(inputStream);
        }
        inputStream.close();
        LOGGER.debug("\n{}", (Object)JPGMeta.qTablesToString(arrayList));
        LOGGER.debug("\n{}", (Object)JPGMeta.hTablesToString(arrayList2));
        LOGGER.debug("\n{}", (Object)JPGMeta.hTablesToString(arrayList3));
        object2 = arrayList5.iterator();
        while (object2.hasNext()) {
            object = (Segment)object2.next();
            byte[] byArray2 = ((Segment)object).getData();
            n = ((Segment)object).getLength();
            if (((Segment)object).getMarker() == Marker.APP0) {
                if (!new String(byArray2, 0, "JFIF\u0000".length()).equals("JFIF\u0000")) continue;
                hashMap.put(MetadataType.JPG_JFIF, new JFIF(ArrayUtils.subArray(byArray2, "JFIF\u0000".length(), n - "JFIF\u0000".length() - 2)));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP1) {
                int n3;
                byte[] byArray3;
                if (new String(byArray2, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                    JpegExif jpegExif = new JpegExif(ArrayUtils.subArray(byArray2, "Exif\u0000\u0000".length(), n - "Exif\u0000\u0000".length() - 2));
                    hashMap.put(MetadataType.EXIF, jpegExif);
                    continue;
                }
                if (new String(byArray2, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || new String(byArray2, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000")) {
                    JpegXMP jpegXMP = new JpegXMP(ArrayUtils.subArray(byArray2, "http://ns.adobe.com/xap/1.0/\u0000".length(), n - "http://ns.adobe.com/xap/1.0/\u0000".length() - 2));
                    hashMap.put(MetadataType.XMP, jpegXMP);
                    string = XMLUtils.getAttribute(jpegXMP.getXmpDocument(), "rdf:Description", "xmpNote:HasExtendedXMP");
                    continue;
                }
                if (!new String(byArray2, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || !Arrays.equals(byArray3 = ArrayUtils.subArray(byArray2, n3 = "http://ns.adobe.com/xmp/extension/\u0000".length(), 32), string.getBytes())) continue;
                long l = IOUtils.readUnsignedIntMM(byArray2, n3 += 32);
                n3 += 4;
                if (byArray == null) {
                    byArray = new byte[(int)l];
                }
                long l2 = IOUtils.readUnsignedIntMM(byArray2, n3);
                byte[] byArray4 = ArrayUtils.subArray(byArray2, n3 += 4, n - "http://ns.adobe.com/xmp/extension/\u0000".length() - 42);
                System.arraycopy(byArray4, 0, byArray, (int)l2, byArray4.length);
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP2) {
                if (!new String(byArray2, 0, "ICC_PROFILE\u0000".length()).equals("ICC_PROFILE\u0000")) continue;
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                byteArrayOutputStream.write(ArrayUtils.subArray(byArray2, "ICC_PROFILE\u0000".length() + 2, n - "ICC_PROFILE\u0000".length() - 4));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP12) {
                if (!new String(byArray2, 0, "Ducky".length()).equals("Ducky")) continue;
                hashMap.put(MetadataType.JPG_DUCKY, new Ducky(ArrayUtils.subArray(byArray2, "Ducky".length(), n - "Ducky".length() - 2)));
                continue;
            }
            if (((Segment)object).getMarker() == Marker.APP13) {
                if (!new String(byArray2, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) continue;
                if (byteArrayOutputStream2 == null) {
                    byteArrayOutputStream2 = new ByteArrayOutputStream();
                }
                byteArrayOutputStream2.write(ArrayUtils.subArray(byArray2, "Photoshop 3.0\u0000".length(), n - "Photoshop 3.0\u0000".length() - 2));
                continue;
            }
            if (((Segment)object).getMarker() != Marker.APP14 || !new String(byArray2, 0, "Adobe".length()).equals("Adobe")) continue;
            hashMap.put(MetadataType.JPG_ADOBE, new Adobe(ArrayUtils.subArray(byArray2, "Adobe".length(), n - "Adobe".length() - 2)));
        }
        if (byteArrayOutputStream != null) {
            object2 = new ICCProfile(byteArrayOutputStream.toByteArray());
            hashMap.put(MetadataType.ICC_PROFILE, (Metadata)object2);
        }
        if (byteArrayOutputStream2 != null) {
            object2 = new IRB(byteArrayOutputStream2.toByteArray());
            hashMap.put(MetadataType.PHOTOSHOP_IRB, (Metadata)object2);
            object = ((IRB)object2).get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (object != null) {
                hashMap.put(MetadataType.IPTC, new IPTC(((_8BIM)object).getData()));
            }
        }
        if (byArray != null && (object2 = (XMP)hashMap.get((Object)MetadataType.XMP)) != null) {
            ((XMP)object2).setExtendedXMPData(byArray);
        }
        if (comments != null) {
            hashMap.put(MetadataType.COMMENT, comments);
        }
        if ((object2 = (Metadata)hashMap.get((Object)MetadataType.EXIF)) != null) {
            object = (Exif)object2;
            if (!((Metadata)object).isDataRead()) {
                ((Exif)object).read();
            }
            if (((Exif)object).containsThumbnail()) {
                hashMap2.put("EXIF", ((Exif)object).getThumbnail());
            }
        }
        if ((object2 = (Metadata)hashMap.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            object = (IRB)object2;
            if (!((Metadata)object).isDataRead()) {
                ((IRB)object).read();
            }
            if (((IRB)object).containsThumbnail()) {
                hashMap2.put("PHOTOSHOP_IRB", ((IRB)object).getThumbnail());
            }
        }
        hashMap.put(MetadataType.IMAGE, new ImageMetadata(hashMap2));
        return hashMap;
    }

    private static byte[] readSegmentData(InputStream inputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        return byArray;
    }

    private static SOFReader readSOF(InputStream inputStream, Marker marker) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(marker, n, byArray);
        SOFReader sOFReader = new SOFReader(segment);
        return sOFReader;
    }

    private static short readSOS(InputStream inputStream, SOFReader sOFReader) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(Marker.SOS, n, byArray);
        new SOSReader(segment, sOFReader);
        int n2 = 0;
        short s = 0;
        block3: while ((n2 = IOUtils.read(inputStream)) != -1) {
            if (n2 != 255) continue;
            n2 = IOUtils.read(inputStream);
            if (n2 == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (n2 == 0) continue;
            s = (short)(0xFF00 | n2);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n2 == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    public static void removeAPPn(Marker marker, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (marker.getValue() < -32 || marker.getValue() > -17) {
            throw new IllegalArgumentException("Input marker is not an APPn marker");
        }
        boolean bl = false;
        int n = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        block5: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                IOUtils.writeShortMM(outputStream, Marker.EOI.getValue());
                bl = true;
                continue;
            }
            Marker marker2 = Marker.fromShort(s);
            switch (marker2) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(outputStream, s);
                    s = IOUtils.readShortMM(inputStream);
                    continue block5;
                }
                case PADDING: {
                    IOUtils.writeShortMM(outputStream, s);
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                        IOUtils.write(outputStream, n2);
                    }
                    s = (short)(0xFF00 | n2);
                    continue block5;
                }
                case SOS: {
                    IOUtils.writeShortMM(outputStream, s);
                    JPGMeta.copyToEnd(inputStream, outputStream);
                    bl = true;
                    continue block5;
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            if (marker2 != marker) {
                IOUtils.writeShortMM(outputStream, s);
                IOUtils.writeShortMM(outputStream, (short)n);
                IOUtils.write(outputStream, byArray);
            }
            s = IOUtils.readShortMM(inputStream);
        }
    }

    public static Map<MetadataType, Metadata> removeMetadata(InputStream inputStream, OutputStream outputStream, MetadataType ... metadataTypeArray) throws IOException {
        return JPGMeta.removeMetadata(new HashSet<MetadataType>(Arrays.asList(metadataTypeArray)), inputStream, outputStream);
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> set, InputStream inputStream, OutputStream outputStream) throws IOException {
        Metadata metadata;
        Metadata metadata2;
        Metadata metadata3;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        HashMap<MetadataType, Metadata> hashMap2 = new HashMap<MetadataType, Metadata>();
        Comments comments = null;
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        boolean bl = false;
        int n = 0;
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IOException("Invalid JPEG image, expected SOI marker not found!");
        }
        IOUtils.writeShortMM(outputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(inputStream);
        block12: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                IOUtils.writeShortMM(outputStream, Marker.EOI.getValue());
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    IOUtils.writeShortMM(outputStream, s);
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case PADDING: {
                    IOUtils.writeShortMM(outputStream, s);
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                        IOUtils.write(outputStream, n2);
                    }
                    s = (short)(0xFF00 | n2);
                    continue block12;
                }
                case SOS: {
                    IOUtils.writeShortMM(outputStream, s);
                    JPGMeta.copyToEnd(inputStream, outputStream);
                    bl = true;
                    continue block12;
                }
                case COM: {
                    if (set.contains((Object)MetadataType.COMMENT)) {
                        if (comments == null) {
                            comments = new Comments();
                        }
                        comments.addComment(JPGMeta.readSegmentData(inputStream));
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP0: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.JPG_JFIF)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (byArray.length < "JFIF\u0000".length() || !"JFIF\u0000".equals(new String(byArray, 0, "JFIF\u0000".length()))) {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        } else {
                            arrayList.add(new Segment(marker, n, byArray));
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP1: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.EXIF) || set.contains((Object)MetadataType.XMP)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (set.contains((Object)MetadataType.XMP) && byArray.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(byArray, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") || set.contains((Object)MetadataType.XMP) && byArray.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || set.contains((Object)MetadataType.XMP) && byArray.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(byArray, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000") || set.contains((Object)MetadataType.EXIF) && byArray.length >= "Exif\u0000\u0000".length() && new String(byArray, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                            arrayList.add(new Segment(marker, n, byArray));
                        } else {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP2: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.ICC_PROFILE)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (byArray.length < "ICC_PROFILE\u0000".length() || !"ICC_PROFILE\u0000".equals(new String(byArray, 0, "ICC_PROFILE\u0000".length()))) {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        } else {
                            arrayList.add(new Segment(marker, n, byArray));
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP12: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.JPG_DUCKY)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (byArray.length < "Ducky".length() || !"Ducky".equals(new String(byArray, 0, "Ducky".length()))) {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        } else {
                            arrayList.add(new Segment(marker, n, byArray));
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP13: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.PHOTOSHOP_IRB) || set.contains((Object)MetadataType.IPTC) || set.contains((Object)MetadataType.XMP) || set.contains((Object)MetadataType.EXIF)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (byArray.length >= "Photoshop 3.0\u0000".length() && new String(byArray, 0, "Photoshop 3.0\u0000".length()).equals("Photoshop 3.0\u0000")) {
                            IRB iRB = new IRB(ArrayUtils.subArray(byArray, "Photoshop 3.0\u0000".length(), byArray.length - "Photoshop 3.0\u0000".length()));
                            HashMap<Short, _8BIM> hashMap3 = new HashMap<Short, _8BIM>(iRB.get8BIM());
                            if (!set.contains((Object)MetadataType.PHOTOSHOP_IRB)) {
                                _8BIM _8BIM2;
                                if (set.contains((Object)MetadataType.IPTC) && (_8BIM2 = (_8BIM)hashMap3.remove(ImageResourceID.IPTC_NAA.getValue())) != null) {
                                    hashMap2.put(MetadataType.IPTC, new IPTC(_8BIM2.getData()));
                                }
                                if (set.contains((Object)MetadataType.XMP) && (_8BIM2 = (_8BIM)hashMap3.remove(ImageResourceID.XMP_METADATA.getValue())) != null) {
                                    hashMap2.put(MetadataType.XMP, new JpegXMP(_8BIM2.getData()));
                                }
                                if (set.contains((Object)MetadataType.EXIF)) {
                                    _8BIM2 = (_8BIM)hashMap3.remove(ImageResourceID.EXIF_DATA1.getValue());
                                    if (_8BIM2 != null) {
                                        hashMap2.put(MetadataType.EXIF, new JpegExif(_8BIM2.getData()));
                                    }
                                    hashMap3.remove(ImageResourceID.EXIF_DATA3.getValue());
                                }
                                JPGMeta.writeIRB(outputStream, hashMap3.values());
                            } else {
                                arrayList.add(new Segment(marker, n, byArray));
                            }
                        } else {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
                case APP14: {
                    byte[] byArray;
                    if (set.contains((Object)MetadataType.JPG_ADOBE)) {
                        n = IOUtils.readUnsignedShortMM(inputStream);
                        byArray = new byte[n - 2];
                        IOUtils.readFully(inputStream, byArray);
                        if (byArray.length < "Adobe".length() || !"Adobe".equals(new String(byArray, 0, "Adobe".length()))) {
                            IOUtils.writeShortMM(outputStream, s);
                            IOUtils.writeShortMM(outputStream, (short)n);
                            IOUtils.write(outputStream, byArray);
                        } else {
                            arrayList.add(new Segment(marker, n, byArray));
                        }
                        s = IOUtils.readShortMM(inputStream);
                        continue block12;
                    }
                    s = JPGMeta.copySegment(s, inputStream, outputStream);
                    continue block12;
                }
            }
            s = JPGMeta.copySegment(s, inputStream, outputStream);
        }
        JPGMeta.extractMetadataFromAPPn(arrayList, hashMap);
        if (set.contains((Object)MetadataType.IPTC) && hashMap.get((Object)MetadataType.IPTC) == null && (metadata3 = (Metadata)hashMap2.get((Object)MetadataType.IPTC)) != null) {
            hashMap.put(MetadataType.IPTC, metadata3);
        }
        if (set.contains((Object)MetadataType.XMP) && hashMap.get((Object)MetadataType.XMP) == null && (metadata2 = (Metadata)hashMap2.get((Object)MetadataType.XMP)) != null) {
            hashMap.put(MetadataType.XMP, metadata2);
        }
        if (set.contains((Object)MetadataType.EXIF) && hashMap.get((Object)MetadataType.EXIF) == null && (metadata = (Metadata)hashMap2.get((Object)MetadataType.EXIF)) != null) {
            hashMap.put(MetadataType.EXIF, metadata);
        }
        if (comments != null) {
            hashMap.put(MetadataType.COMMENT, comments);
        }
        return hashMap;
    }

    private static short skipSOS(InputStream inputStream) throws IOException {
        int n = 0;
        short s = 0;
        block3: while ((n = IOUtils.read(inputStream)) != -1) {
            if (n != 255) continue;
            n = IOUtils.read(inputStream);
            if (n == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (n == 0) continue;
            s = (short)(0xFF00 | n);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    private static void writeComment(String string, OutputStream outputStream) throws IOException {
        new COMBuilder().comment(string).build().write(outputStream);
    }

    private static void writeICCProfile(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 65535;
        int n2 = 65519;
        int n3 = byArray.length / n2;
        int n4 = byArray.length % n2;
        int n5 = n3 == 0 ? 1 : (n4 == 0 ? n3 : n3 + 1);
        for (int i = 0; i < n3; ++i) {
            IOUtils.writeShortMM(outputStream, Marker.APP2.getValue());
            IOUtils.writeShortMM(outputStream, n);
            IOUtils.write(outputStream, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(outputStream, n5 | i + 1 << 8);
            IOUtils.write(outputStream, byArray, i * n2, n2);
        }
        if (n4 != 0) {
            IOUtils.writeShortMM(outputStream, Marker.APP2.getValue());
            IOUtils.writeShortMM(outputStream, n4 + 16);
            IOUtils.write(outputStream, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(outputStream, n5 | n5 << 8);
            IOUtils.write(outputStream, byArray, byArray.length - n4, n4);
        }
    }

    private static void writeIRB(OutputStream outputStream, _8BIM ... _8BIMArray) throws IOException {
        if (_8BIMArray != null && _8BIMArray.length > 0) {
            JPGMeta.writeIRB(outputStream, Arrays.asList(_8BIMArray));
        }
    }

    private static void writeIRB(OutputStream outputStream, Collection<_8BIM> collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            IOUtils.writeShortMM(outputStream, Marker.APP13.getValue());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (_8BIM _8BIM2 : collection) {
                _8BIM2.write(byteArrayOutputStream);
            }
            IOUtils.writeShortMM(outputStream, 16 + byteArrayOutputStream.size());
            outputStream.write("Photoshop 3.0\u0000".getBytes());
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    private JPGMeta() {
    }
}

