/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.jpeg.DuckyDataSet;
import pixy.meta.jpeg.DuckyTag;

public class Ducky
extends Metadata {
    private Map<DuckyTag, DuckyDataSet> datasetMap;
    private static final Logger LOGGER = LoggerFactory.getLogger(Ducky.class);

    public Ducky() {
        super(MetadataType.JPG_DUCKY);
        this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
        this.isDataRead = true;
    }

    public Ducky(byte[] byArray) {
        super(MetadataType.JPG_DUCKY, byArray);
    }

    public void addDataSet(DuckyDataSet duckyDataSet) {
        if (this.datasetMap != null) {
            this.datasetMap.put(DuckyTag.fromTag(duckyDataSet.getTag()), duckyDataSet);
        }
    }

    public void addDataSets(Collection<? extends DuckyDataSet> collection) {
        if (this.datasetMap != null) {
            for (DuckyDataSet duckyDataSet : collection) {
                this.datasetMap.put(DuckyTag.fromTag(duckyDataSet.getTag()), duckyDataSet);
            }
        }
    }

    public Map<DuckyTag, DuckyDataSet> getDataSets() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this.datasetMap);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        for (DuckyDataSet duckyDataSet : this.datasetMap.values()) {
            arrayList.add(duckyDataSet.getMetadataEntry());
        }
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
            while (n + 4 <= this.data.length) {
                int n2 = IOUtils.readUnsignedShortMM(this.data, n);
                int n3 = IOUtils.readUnsignedShortMM(this.data, n += 2);
                DuckyTag duckyTag = DuckyTag.fromTag(n2);
                this.datasetMap.put(duckyTag, new DuckyDataSet(n2, n3, this.data, n += 2));
                n += n3;
            }
            this.isDataRead = true;
        }
    }

    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("JPEG Ducky output starts =>");
        for (DuckyDataSet duckyDataSet : this.datasetMap.values()) {
            duckyDataSet.print();
        }
        LOGGER.info("<= JPEG Ducky output ends");
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.ensureDataRead();
        for (DuckyDataSet duckyDataSet : this.getDataSets().values()) {
            duckyDataSet.write(outputStream);
        }
    }
}

