/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.gif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pixy.io.IOUtils;
import pixy.meta.Metadata;
import pixy.meta.MetadataType;
import pixy.meta.gif.GifXMP;
import pixy.meta.image.Comments;
import pixy.meta.xmp.XMP;
import pixy.util.ArrayUtils;

public class GIFMeta {
    public static final byte IMAGE_SEPARATOR = 44;
    public static final byte IMAGE_TRAILER = 59;
    public static final byte EXTENSION_INTRODUCER = 33;
    public static final byte GRAPHIC_CONTROL_LABEL = -7;
    public static final byte APPLICATION_EXTENSION_LABEL = -1;
    public static final byte COMMENT_EXTENSION_LABEL = -2;
    public static final byte TEXT_EXTENSION_LABEL = 1;
    public static final int DISPOSAL_UNSPECIFIED = 0;
    public static final int DISPOSAL_LEAVE_AS_IS = 1;
    public static final int DISPOSAL_RESTORE_TO_BACKGROUND = 2;
    public static final int DISPOSAL_RESTORE_TO_PREVIOUS = 3;

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        int n;
        int n2;
        DataTransferObject dataTransferObject = new DataTransferObject();
        GIFMeta.readHeader(inputStream, dataTransferObject);
        GIFMeta.readLSD(inputStream, dataTransferObject);
        outputStream.write(dataTransferObject.header);
        outputStream.write(dataTransferObject.logicalScreenDescriptor);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            n2 = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            n = 1 << n2;
            GIFMeta.readGlobalPalette(inputStream, n, dataTransferObject);
            outputStream.write(dataTransferObject.globalPalette);
        }
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            outputStream.write(33);
            outputStream.write(-2);
            byte[] byArray = list.get(n).getBytes();
            int n3 = byArray.length / 255;
            int n4 = byArray.length % 255;
            int n5 = 0;
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    outputStream.write(255);
                    outputStream.write(byArray, n5, 255);
                    n5 += 255;
                }
            }
            if (n4 > 0) {
                outputStream.write(n4);
                outputStream.write(byArray, n5, n4);
            }
            outputStream.write(0);
        }
        byte[] byArray = new byte[10240];
        int n6 = inputStream.read(byArray);
        while (n6 != -1) {
            outputStream.write(byArray, 0, n6);
            n6 = inputStream.read(byArray);
        }
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        int n;
        DataTransferObject dataTransferObject = new DataTransferObject();
        GIFMeta.readHeader(inputStream, dataTransferObject);
        GIFMeta.readLSD(inputStream, dataTransferObject);
        outputStream.write(dataTransferObject.header);
        outputStream.write(dataTransferObject.logicalScreenDescriptor);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            int n2 = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            n = 1 << n2;
            GIFMeta.readGlobalPalette(inputStream, n, dataTransferObject);
            outputStream.write(dataTransferObject.globalPalette);
        }
        xMP.write(outputStream);
        byte[] byArray = new byte[10240];
        n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        GIFMeta.insertXMPApplicationBlock(inputStream, outputStream, new GifXMP(byArray));
    }

    public static void insertXMPApplicationBlock(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        GIFMeta.insertXMPApplicationBlock(inputStream, outputStream, new GifXMP(string));
    }

    private static boolean readFrame(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        byte[] byArray;
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        do {
            if ((n4 = inputStream.read()) == -1 || n4 == 59) {
                return false;
            }
            if (n4 != 33) continue;
            n2 = inputStream.read();
            int n5 = inputStream.read();
            if (n2 == 249) {
                n = inputStream.read();
                n3 = (n & 0x1C) >> 2;
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                if ((n & 1) == 1) {
                    IOUtils.skipFully(inputStream, 2);
                    inputStream.read();
                    n5 = inputStream.read();
                } else {
                    IOUtils.skipFully(inputStream, 3);
                    n5 = inputStream.read();
                }
            } else if (n2 == 255) {
                byte[] byArray2 = new byte[]{88, 77, 80, 32, 68, 97, 116, 97, 88, 77, 80};
                byArray = new byte[11];
                IOUtils.readFully(inputStream, byArray);
                if (Arrays.equals(byArray2, byArray)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    n5 = inputStream.read();
                    while (n5 != 0) {
                        byteArrayOutputStream.write(n5);
                        byArray = new byte[n5];
                        IOUtils.readFully(inputStream, byArray);
                        byteArrayOutputStream.write(byArray);
                        n5 = inputStream.read();
                    }
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    n5 = byArray3.length - 257;
                    if (n5 > 0) {
                        dataTransferObject.metadataMap.put(MetadataType.XMP, new GifXMP(ArrayUtils.subArray(byArray3, 0, n5)));
                    }
                    n5 = 0;
                } else {
                    n5 = inputStream.read();
                }
            } else if (n2 == 254) {
                byte[] byArray4 = new byte[n5];
                IOUtils.readFully(inputStream, byArray4);
                if (dataTransferObject.comments == null) {
                    dataTransferObject.comments = new Comments();
                }
                dataTransferObject.comments.addComment(byArray4);
                n5 = inputStream.read();
            }
            while (n5 != 0) {
                IOUtils.skipFully(inputStream, n5);
                n5 = inputStream.read();
            }
        } while (n4 != 44);
        GIFMeta.readImageDescriptor(inputStream, dataTransferObject);
        n2 = 1 << (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
        byte[] byArray5 = null;
        if ((dataTransferObject.imageDescriptor[8] & 0x80) == 128) {
            n = (dataTransferObject.imageDescriptor[8] & 7) + 1;
            n2 = 1 << n;
            byArray5 = new byte[3 * n2];
            inputStream.read(byArray5);
        }
        if (byArray5 == null) {
            byArray5 = dataTransferObject.globalPalette;
        }
        inputStream.read();
        n = 0;
        while ((n = inputStream.read()) > 0) {
            byArray = new byte[n];
            inputStream.read(byArray);
        }
        return true;
    }

    private static void readGlobalPalette(InputStream inputStream, int n, DataTransferObject dataTransferObject) throws IOException {
        dataTransferObject.globalPalette = new byte[n * 3];
        inputStream.read(dataTransferObject.globalPalette);
    }

    private static void readHeader(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        dataTransferObject.header = new byte[6];
        inputStream.read(dataTransferObject.header);
    }

    private static void readImageDescriptor(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        dataTransferObject.imageDescriptor = new byte[9];
        inputStream.read(dataTransferObject.imageDescriptor);
    }

    private static void readLSD(InputStream inputStream, DataTransferObject dataTransferObject) throws IOException {
        dataTransferObject.logicalScreenDescriptor = new byte[7];
        inputStream.read(dataTransferObject.logicalScreenDescriptor);
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        DataTransferObject dataTransferObject = new DataTransferObject();
        dataTransferObject.metadataMap = new HashMap<MetadataType, Metadata>();
        GIFMeta.readHeader(inputStream, dataTransferObject);
        GIFMeta.readLSD(inputStream, dataTransferObject);
        if ((dataTransferObject.logicalScreenDescriptor[4] & 0x80) == 128) {
            int n = (dataTransferObject.logicalScreenDescriptor[4] & 7) + 1;
            int n2 = 1 << n;
            GIFMeta.readGlobalPalette(inputStream, n2, dataTransferObject);
        }
        while (GIFMeta.readFrame(inputStream, dataTransferObject)) {
        }
        if (dataTransferObject.comments != null) {
            dataTransferObject.metadataMap.put(MetadataType.COMMENT, dataTransferObject.comments);
        }
        return dataTransferObject.metadataMap;
    }

    private GIFMeta() {
    }

    private static class DataTransferObject {
        private byte[] header;
        private byte[] logicalScreenDescriptor;
        private byte[] globalPalette;
        private byte[] imageDescriptor;
        private Map<MetadataType, Metadata> metadataMap;
        private Comments comments;

        private DataTransferObject() {
        }
    }
}

