/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe._8BIM;

public class JPGQuality
extends _8BIM {
    private int quality = Quality.QUALITY_5_MEDIUM.getValue();
    private int format = Format.FORMAT_STANDARD.getValue();
    private int progressiveScans = ProgressiveScans.PROGRESSIVE_3_SCANS.getValue();
    private byte trailer = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGQuality.class);

    public JPGQuality() {
        this("JPGQuality");
    }

    public JPGQuality(String string) {
        super(ImageResourceID.JPEG_QUALITY, string, null);
    }

    public JPGQuality(String string, byte[] byArray) {
        super(ImageResourceID.JPEG_QUALITY, string, byArray);
        this.read();
    }

    public JPGQuality(Quality quality, Format format, ProgressiveScans progressiveScans) {
        this("JPGQuality", quality, format, progressiveScans);
    }

    public JPGQuality(String string, Quality quality, Format format, ProgressiveScans progressiveScans) {
        super(ImageResourceID.JPEG_QUALITY, string, null);
        if (quality == null || format == null || progressiveScans == null) {
            throw new IllegalArgumentException("Input parameter(s) is null");
        }
        this.quality = quality.getValue();
        this.format = format.getValue();
        this.progressiveScans = progressiveScans.getValue();
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatAsString() {
        String string = "";
        switch (this.format) {
            case 0: {
                string = "Standard Format";
                break;
            }
            case 1: {
                string = "Optimised Format";
                break;
            }
            case 257: {
                string = "Progressive Format";
                break;
            }
        }
        return string;
    }

    public int getProgressiveScans() {
        return this.progressiveScans;
    }

    public String getProgressiveScansAsString() {
        String string = "";
        switch (this.progressiveScans) {
            case 1: {
                string = "3 Scans";
                break;
            }
            case 2: {
                string = "4 Scans";
                break;
            }
            case 3: {
                string = "5 Scans";
                break;
            }
        }
        return string;
    }

    public int getQuality() {
        return this.quality;
    }

    public String getQualityAsString() {
        String string = "";
        switch (this.quality) {
            case 65533: {
                string = "Quality 1 (Low)";
                break;
            }
            case 65534: {
                string = "Quality 2 (Low)";
                break;
            }
            case 65535: {
                string = "Quality 3 (Low)";
                break;
            }
            case 0: {
                string = "Quality 4 (Low)";
                break;
            }
            case 1: {
                string = "Quality 5 (Medium)";
                break;
            }
            case 2: {
                string = "Quality 6 (Medium)";
                break;
            }
            case 3: {
                string = "Quality 7 (Medium)";
                break;
            }
            case 4: {
                string = "Quality 8 (High)";
                break;
            }
            case 5: {
                string = "Quality 9 (High)";
                break;
            }
            case 6: {
                string = "Quality 10 (Maximum)";
                break;
            }
            case 7: {
                string = "Quality 11 (Maximum)";
                break;
            }
            case 8: {
                string = "Quality 12 (Maximum)";
                break;
            }
        }
        return string;
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("{} : {} : {} - Plus 1 byte unknown trailer value = {}", new Object[]{this.getQualityAsString(), this.getFormatAsString(), this.getProgressiveScansAsString(), this.trailer});
    }

    private void read() {
        this.quality = IOUtils.readUnsignedShortMM(this.data, 0);
        this.format = IOUtils.readUnsignedShortMM(this.data, 2);
        this.progressiveScans = IOUtils.readUnsignedShortMM(this.data, 4);
        this.trailer = this.data[6];
    }

    public void setFormat(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("Input format is null");
        }
        this.format = format.getValue();
    }

    public void setProgressiveScans(ProgressiveScans progressiveScans) {
        if (progressiveScans == null) {
            throw new IllegalArgumentException("Input progressive scans is null");
        }
        this.progressiveScans = progressiveScans.getValue();
    }

    public void setQuality(Quality quality) {
        if (quality == null) {
            throw new IllegalArgumentException("Input quality is null");
        }
        this.quality = quality.getValue();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.data == null) {
            this.data = new byte[7];
            this.data[0] = (byte)(this.quality >> 8 & 0xFF);
            this.data[1] = (byte)(this.quality & 0xFF);
            this.data[2] = (byte)(this.format >> 8 & 0xFF);
            this.data[3] = (byte)(this.format & 0xFF);
            this.data[4] = (byte)(this.progressiveScans >> 8 & 0xFF);
            this.data[5] = (byte)(this.progressiveScans & 0xFF);
            this.data[6] = this.trailer;
            this.size = this.data.length;
        }
        super.write(outputStream);
    }

    public static enum Quality {
        QUALITY_1_LOW(65533),
        QUALITY_2_LOW(65534),
        QUALITY_3_LOW(65535),
        QUALITY_4_LOW(0),
        QUALITY_5_MEDIUM(1),
        QUALITY_6_MEDIUM(2),
        QUALITY_7_MEDIUM(3),
        QUALITY_8_HIGH(4),
        QUALITY_9_HIGH(5),
        QUALITY_10_MAXIMUM(6),
        QUALITY_11_MAXIMUM(7),
        QUALITY_12_MAXIMUM(8);

        private final int value;

        private Quality(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Format {
        FORMAT_STANDARD(0),
        FORMAT_OPTIMISED(1),
        FORMAT_PROGRESSIVE(257);

        private final int value;

        private Format(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ProgressiveScans {
        PROGRESSIVE_3_SCANS(1),
        PROGRESSIVE_4_SCANS(2),
        PROGRESSIVE_5_SCANS(3);

        private final int value;

        private ProgressiveScans(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

