/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.util.HashMap;
import java.util.Map;
import pixy.string.StringUtils;

public enum ImageResourceID {
    CHANNELS_ROWS_COLUMNS_DEPTH_MODE("Obsolete. Photoshop 2.0 only. Contains five 2 byte values: number of channels, rows, columns, depth, and mode.", 1000),
    PRINT_MANAGER_INFO("Optional. Macintosh print manager print info record.", 1001),
    XML("XML data.", 1002),
    INDEXED_COLOR_TABLE("Obsolete. Photoshop 2.0 only. Contains the indexed color table.", 1003),
    RESOLUTION_INFO("ResolutionInfo structure.", 1005),
    ALPHA_CHANNEL_NAMES("Names of the alpha channels as a series of Pascal strings.", 1006),
    DISPLAY_INFO("DisplayInfo structure.", 1007),
    CAPTION("Optional. The caption as a Pascal string.", 1008),
    BORDER_INFO("Border information. Contains a fixed-number for the border width, and 2 bytes for border units (1=inches, 2=cm, 3=points, 4=picas, 5=columns).", 1009),
    BACKGROUND_COLOR("Background color.", 1010),
    PRINT_FLAGS("Print flags. A series of one byte boolean values: labels, crop marks, color bars, registration marks, negative, flip, interpolate, caption.", 1011),
    GRAYSCALE_INFO("Grayscale and multichannel halftoning information.", 1012),
    COLOR_HALFTONING_INFO("Color halftoning information.", 1013),
    DUOTONE_HALFTONING_INFO("Duotone halftoning information.", 1014),
    GRAYSCALE_FUNCTION("Grayscale and multichannel transfer function.", 1015),
    COLOR_FUNCTION("Color transfer functions.", 1016),
    DUOTONE_FUNCTION("Duotone transfer functions.", 1017),
    DUOTONE_IMAGE_INFO("Duotone image information.", 1018),
    EFFECTIVE_BW_VALUES("Two bytes for the effective black and white values for the dot range.", 1019),
    OBSOLETE1("Obsolete.", 1020),
    EPS_OPTIONS("EPS options.", 1021),
    QUICK_MASK_INFO("Quick Mask information. 2 bytes containing Quick Mask channel ID, 1 byte boolean indicating whether the mask was initially empty.", 1022),
    OBSOLETE2("Obsolete.", 1023),
    LAYER_STATE_INFO("Layer state information. 2 bytes containing the index of target layer. 0=bottom layer.", 1024),
    WORKING_PATH("Working path (not saved).", 1025),
    LAYERS_GROUP_INFO("Layers group information. 2 bytes per layer containing a group ID for the dragging groups. Layers in a group have the same group ID.", 1026),
    OBSOLETE3("Obsolete.", 1027),
    IPTC_NAA("IPTC-NAA record.", 1028),
    IMAGE_MODE("Image mode for raw format files.", 1029),
    JPEG_QUALITY("JPEG quality. Private.", 1030),
    GRID_INFO("Grid and guides information.", 1032),
    THUMBNAIL_RESOURCE_PS4("Photoshop 4.0 thumbnail resource.", 1033),
    COPYRIGHT_FLAG("Copyright flag. Boolean indicating whether image is copyrighted. Can be set via Property suite or by user in File Info...", 1034),
    URL("URL. Handle of a text string with uniform resource locator. Can be set via Property suite or by user in File Info...", 1035),
    THUMBNAIL_RESOURCE_PS5("Photoshop 5.0 thumbnail resource.", 1036),
    GLOBLE_ANGLE("Global Angle. 4 bytes that contain an integer between 0..359 which is the global lighting angle for effects layer. If not present assumes 30.", 1037),
    COLOR_SAMPLERS_RESOURCE("Color samplers resource. See color samplers resource format later in this chapter.", 1038),
    ICC_PROFILE("ICC Profile. The raw bytes of an ICC format profile.", 1039),
    WATERMARK("One byte for Watermark.", 1040),
    ICC_UNTAGGED("ICC Untagged. 1 byte that disables any assumed profile handling when opening the file. 1 = intentionally untagged.", 1041),
    EFFECTS_VISIBLE("Effects visible. 1 byte global flag to show/hide all the effects layer. Only present when they are hidden.", 1042),
    SPOT_HALFTONE("Spot Halftone. 4 bytes for version, 4 bytes for length, and the variable length data.", 1043),
    DOC_SPECIFIC_ID("Document specific IDs, layer IDs will be generated starting at this base value or a greater value if we find existing IDs to already exceed it. 4 bytes.", 1044),
    UNICODE_ALPHA_NAMES("Unicode Alpha Names. 4 bytes for length and the string as a unicode string.", 1045),
    INDEXED_COLOR_TABLE_COUNT("Indexed Color Table Count. 2 bytes for the number of colors in table that are actually defined", 1046),
    TRANSPARENT_INDEX("Tansparent Index. 2 bytes for the index of transparent color, if any.", 1047),
    GLOBLE_ALTITUDE("Global Altitude. 4 byte entry for altitude.", 1049),
    SLICES("Slices.", 1050),
    WORKFLOW_URL("Workflow URL. Unicode string, 4 bytes of length followed by unicode string.", 1051),
    JUMP_TO_XPEP("Jump To XPEP. 2 bytes major version, 2 bytes minor version, 4 bytes count.", 1052),
    ALPHA_IDENTIFIERS("Alpha Identifiers. 4 bytes of length, followed by 4 bytes each for every alpha identifier.", 1053),
    URL_LIST("URL List. 4 byte count of URLs, followed by 4 byte long, 4 byte ID, and unicode string for each count.", 1054),
    VERSION_INFO("(Photoshop 6.0) Version Info. 4 byte version, 1 byte HasRealMergedData, unicode string of writer name, unicode string of reader name, 4 bytes of file version.", 1057),
    EXIF_DATA1("(Photoshop 7.0) EXIF data 1.", 1058),
    EXIF_DATA3("(Photoshop 7.0) EXIF data 3.", 1059),
    XMP_METADATA("(Photoshop 7.0) XMP metadata.", 1060),
    CAPTION_DIGEST("(Photoshop 7.0) Caption digest. 16 bytes: RSA Data Security, MD5 message-digest algorithm.", 1061),
    PRINT_SCALE("(Photoshop 7.0) Print scale. 2 bytes style (0 = centered, 1 = size to fit, 2 = user defined). 4 bytes x location (floating point). 4 bytes y location (floating point). 4 bytes scale (floating point).", 1062),
    PIXEL_ASPECT_RATIO("(Photoshop CS) Pixel Aspect Ratio. 4 bytes (version = 1 or 2), 8 bytes double, x / y of a pixel. Version 2, attempting to correct values for NTSC and PAL, previously off by a factor of approx. 5%.", 1064),
    LAYER_COMPS("(Photoshop CS) Layer Comps. 4 bytes (descriptor version = 16).", 1065),
    ALTERNATE_DUOTONE_COLORS("(Photoshop CS) Alternate Duotone Colors.  bytes (version = 1), 2 bytes count, following is repeated for each count: [ Color: 2 bytes for space followed by 4 * 2 byte color component ], following this is another 2 byte count, usually 256, followed by Lab colors one byte each for L, a, b.", 1066),
    ALTERNATE_SPOT_COLORS("(Photoshop CS)Alternate Spot Colors. 2 bytes (version = 1), 2 bytes channel count, following is repeated for each count: 4 bytes channel ID, Color: 2 bytes for space followed by 4 * 2 byte color component", 1067),
    LAYER_SELECTION_IDS("(Photoshop CS2) Layer Selection ID(s). 2 bytes count, following is repeated for each count: 4 bytes layer ID.", 1069),
    HDR_TONING_INFO("(Photoshop CS2) HDR Toning information.", 1070),
    PRINT_INFO("(Photoshop CS2) Print info.", 1071),
    LAYER_GROUP_ENABLED_ID("(Photoshop CS2) Layer Group(s) Enabled ID. 1 byte for each layer in the document, repeated by length of the resource. NOTE: Layer groups have start and end markers.", 1072),
    COLOR_SAMPLERS_RESOURCE_CS3("(Photoshop CS3) Color samplers resource. Also see ID 1038 for old format.", 1073),
    MEASUREMENT_SCALE("(Photoshop CS3) Measurement Scale. 4 bytes (descriptor version = 16), Descriptor.", 1074),
    TIMELINE_INFO("(Photoshop CS3) Timeline Information. 4 bytes (descriptor version = 16).", 1075),
    SHEET_DISCLOSURE("(Photoshop CS3) Sheet Disclosure. 4 bytes (descriptor version = 16).", 1076),
    DISPLAY_INFO_STRUCTURE("(Photoshop CS3) DisplayInfo structure to support floating point clors. Also see ID 1007.", 1077),
    ONION_SKINS("(Photoshop CS3) Onion Skins. 4 bytes (descriptor version = 16).", 1078),
    COUNT_INFO("(Photoshop CS4) Count Information. 4 bytes (descriptor version = 16).", 1080),
    PRINT_INFO_CS5("(Photoshop CS5) Print Information. 4 bytes (descriptor version = 16).", 1082),
    PRINT_STYLE("(Photoshop CS5) Print Style. 4 bytes (descriptor version = 16).", 1083),
    MACINTOSH_NS_PRINT_INFO("(Photoshop CS5) Macintosh NSPrintInfo. Variable OS specific info for Macintosh. NSPrintInfo. It is recommened that you do not interpret or use this data.", 1084),
    WINDOWS_DEVMODE("(Photoshop CS5) Windows DEVMODE. Variable OS specific info for Windows. DEVMODE. It is recommened that you do not interpret or use this data.", 1085),
    AUTO_SAVE_FILE_PATH("(Photoshop CS6) Auto Save File Path. Unicode string. It is recommened that you do not interpret or use this data.", 1086),
    AUTO_SAVE_FORMAT("(Photoshop CS6) Auto Save Format. Unicode string. It is recommened that you do not interpret or use this data.", 1087),
    PATH_INFO0("Path Information (saved paths).", 2000),
    PATH_INFO998("Path Information (saved paths).", 2998),
    CLIPPING_PATH_NAME("Name of clipping path.", 2999),
    ORIGIN_PATH_INFO("Origin path info.", 3000),
    PLUGIN_RESOURCE0("Plug-In resource.", 4000),
    PLUGIN_RESOURCE999("Plug-In resource.", 4999),
    IMAGEREADY_VARIABLES("Image Ready variables. XML representation of variables definition.", 7000),
    IMAGEREADY_DATASETS("Image Ready data sets.", 7001),
    LIGHTROOM_WORKFLOW("(Photoshop CS3) Lightroom workflow, if present the document is in the middle of a Lightroom workflow.", 8000),
    PRINT_FLAGS_INFO("Print flags information. 2 bytes version (=1), 1 byte center crop marks, 1 byte (=0), 4 bytes bleed width value, 2 bytes bleed width scale.", 10000),
    UNKNOWN("Unknown", -1);

    private static final Map<Short, ImageResourceID> idMap;
    private final String description;
    private final short value;

    private ImageResourceID(String string2, short s) {
        this.description = string2;
        this.value = s;
    }

    public String getDescription() {
        return this.description;
    }

    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name();
        }
        return this.name() + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "] - " + this.description;
    }

    public static ImageResourceID fromShort(short s) {
        ImageResourceID imageResourceID = idMap.get(s);
        if (imageResourceID == null) {
            return UNKNOWN;
        }
        return imageResourceID;
    }

    static {
        idMap = new HashMap<Short, ImageResourceID>();
        for (ImageResourceID imageResourceID : ImageResourceID.values()) {
            idMap.put(imageResourceID.getValue(), imageResourceID);
        }
    }
}

