/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.adobe.IPTC_NAA;
import pixy.meta.adobe.IRBThumbnail;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe.JPGQuality;
import pixy.meta.adobe.ThumbnailResource;
import pixy.meta.adobe.VersionInfo;
import pixy.meta.adobe._8BIM;
import pixy.util.ArrayUtils;

public class IRB
extends Metadata {
    private boolean containsThumbnail;
    private ThumbnailResource thumbnail;
    Map<Short, _8BIM> _8bims = new HashMap<Short, _8BIM>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IRB.class);

    public static void showIRB(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            IRB iRB = new IRB(byArray);
            try {
                iRB.read();
                iRB.showMetadata();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showIRB(InputStream inputStream) {
        try {
            IRB.showIRB(IOUtils.inputStreamToByteArray(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IRB(byte[] byArray) {
        super(MetadataType.PHOTOSHOP_IRB, byArray);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        for (_8BIM _8BIM2 : this._8bims.values()) {
            arrayList.add(_8BIM2.getMetadataEntry());
        }
        if (this.containsThumbnail) {
            int n = this.thumbnail.getDataType();
            switch (n) {
                case 1: {
                    arrayList.add(new MetadataEntry("Thumbnail Format: ", "DATA_TYPE_KJpegRGB"));
                    break;
                }
                case 0: {
                    arrayList.add(new MetadataEntry("Thumbnail Format: ", "DATA_TYPE_KRawRGB"));
                }
            }
            arrayList.add(new MetadataEntry("Thumbnail width:", "" + this.thumbnail.getWidth()));
            arrayList.add(new MetadataEntry("Thumbnail height: ", "" + this.thumbnail.getHeight()));
            arrayList.add(new MetadataEntry("Thumbnail Padded row bytes:  ", "" + this.thumbnail.getPaddedRowBytes()));
            arrayList.add(new MetadataEntry("Thumbnail Total size: ", "" + this.thumbnail.getTotalSize()));
            arrayList.add(new MetadataEntry("Thumbnail Size after compression: ", "" + this.thumbnail.getCompressedSize()));
            arrayList.add(new MetadataEntry("Thumbnail Bits per pixel: ", "" + this.thumbnail.getBitsPerPixel()));
            arrayList.add(new MetadataEntry("Thumbnail Number of planes: ", "" + this.thumbnail.getNumOfPlanes()));
        }
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public boolean containsThumbnail() {
        this.ensureDataRead();
        return this.containsThumbnail;
    }

    public Map<Short, _8BIM> get8BIM() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this._8bims);
    }

    public _8BIM get8BIM(short s) {
        this.ensureDataRead();
        return this._8bims.get(s);
    }

    public IRBThumbnail getThumbnail() {
        this.ensureDataRead();
        return this.thumbnail.getThumbnail();
    }

    public ThumbnailResource getThumbnailResource() {
        this.ensureDataRead();
        return this.thumbnail;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            while (n + 4 < this.data.length) {
                int n2;
                String string = new String(this.data, n, 4);
                n += 4;
                if (!string.equals("8BIM")) continue;
                short s = IOUtils.readShortMM(this.data, n);
                n += 2;
                if ((n2 = this.data[n++] & 0xFF) % 2 == 0) {
                    ++n2;
                }
                String string2 = new String(this.data, n, n2).trim();
                int n3 = IOUtils.readIntMM(this.data, n += n2);
                n += 4;
                if (n3 <= 0) continue;
                ImageResourceID imageResourceID = ImageResourceID.fromShort(s);
                switch (imageResourceID) {
                    case JPEG_QUALITY: {
                        this._8bims.put(s, new JPGQuality(string2, ArrayUtils.subArray(this.data, n, n3)));
                        break;
                    }
                    case VERSION_INFO: {
                        this._8bims.put(s, new VersionInfo(string2, ArrayUtils.subArray(this.data, n, n3)));
                        break;
                    }
                    case IPTC_NAA: {
                        byte[] byArray = ArrayUtils.subArray(this.data, n, n3);
                        _8BIM _8BIM2 = this._8bims.get(s);
                        if (_8BIM2 != null) {
                            byte[] byArray2 = _8BIM2.getData();
                            this._8bims.put(s, new IPTC_NAA(string2, ArrayUtils.concat(byArray2, new byte[][]{byArray})));
                            break;
                        }
                        this._8bims.put(s, new IPTC_NAA(string2, byArray));
                        break;
                    }
                    case THUMBNAIL_RESOURCE_PS4: 
                    case THUMBNAIL_RESOURCE_PS5: {
                        this.containsThumbnail = true;
                        this.thumbnail = new ThumbnailResource(imageResourceID, ArrayUtils.subArray(this.data, n, n3));
                        this._8bims.put(s, this.thumbnail);
                        break;
                    }
                    default: {
                        this._8bims.put(s, new _8BIM(s, string2, n3, ArrayUtils.subArray(this.data, n, n3)));
                    }
                }
                n += n3;
                if (n3 % 2 == 0) continue;
                ++n;
            }
            this.isDataRead = true;
        }
    }

    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("<<Adobe IRB information starts>>");
        for (_8BIM _8BIM2 : this._8bims.values()) {
            _8BIM2.print();
        }
        if (this.containsThumbnail) {
            LOGGER.info("{}", (Object)this.thumbnail.getResouceID());
            int n = this.thumbnail.getDataType();
            switch (n) {
                case 1: {
                    LOGGER.info("Thumbnail format: KJpegRGB");
                    break;
                }
                case 0: {
                    LOGGER.info("Thumbnail format: KRawRGB");
                }
            }
            LOGGER.info("Thumbnail width: {}", (Object)this.thumbnail.getWidth());
            LOGGER.info("Thumbnail height: {}", (Object)this.thumbnail.getHeight());
            LOGGER.info("Padded row bytes: {}", (Object)this.thumbnail.getPaddedRowBytes());
            LOGGER.info("Total size: {}", (Object)this.thumbnail.getTotalSize());
            LOGGER.info("Size after compression: {}", (Object)this.thumbnail.getCompressedSize());
            LOGGER.info("Bits per pixel: {}", (Object)this.thumbnail.getBitsPerPixel());
            LOGGER.info("Number of planes: {}", (Object)this.thumbnail.getNumOfPlanes());
        }
        LOGGER.info("<<Adobe IRB information ends>>");
    }
}

