/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pixy.meta.MetadataEntry;
import pixy.meta.adobe.ImageResourceID;
import pixy.meta.adobe._8BIM;
import pixy.meta.iptc.IPTC;
import pixy.meta.iptc.IPTCDataSet;
import pixy.meta.iptc.IPTCTag;
import pixy.string.StringUtils;

public class IPTC_NAA
extends _8BIM {
    private IPTC iptc;

    public IPTC_NAA() {
        this("IPTC_NAA");
    }

    public IPTC_NAA(String string) {
        super(ImageResourceID.IPTC_NAA, string, null);
        this.iptc = new IPTC();
    }

    public IPTC_NAA(String string, byte[] byArray) {
        super(ImageResourceID.IPTC_NAA, string, byArray);
        this.iptc = new IPTC(byArray);
    }

    public void addDataSet(IPTCDataSet iPTCDataSet) {
        this.iptc.addDataSet(iPTCDataSet);
    }

    public void addDataSets(Collection<? extends IPTCDataSet> collection) {
        this.iptc.addDataSets(collection);
    }

    public Map<IPTCTag, List<IPTCDataSet>> getDataSets() {
        return this.iptc.getDataSets();
    }

    public List<IPTCDataSet> getDataSet(IPTCTag iPTCTag) {
        return this.iptc.getDataSet(iPTCTag);
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        ImageResourceID imageResourceID = ImageResourceID.fromShort(this.getID());
        MetadataEntry metadataEntry = new MetadataEntry(imageResourceID.name(), imageResourceID.getDescription(), true);
        Map<IPTCTag, List<IPTCDataSet>> map = this.getDataSets();
        if (map != null) {
            Set<Map.Entry<IPTCTag, List<IPTCDataSet>>> set = map.entrySet();
            for (Map.Entry<IPTCTag, List<IPTCDataSet>> entry : set) {
                StringBuilder stringBuilder = new StringBuilder();
                for (IPTCDataSet iPTCDataSet : entry.getValue()) {
                    stringBuilder.append(iPTCDataSet.getDataAsString()).append(";");
                }
                String string = entry.getKey().getName();
                String object2 = StringUtils.replaceLast(stringBuilder.toString(), ";", "");
                metadataEntry.addEntry(new MetadataEntry(string, object2));
            }
            return metadataEntry;
        }
        return super.getMetadataEntry();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.iptc.write(byteArrayOutputStream);
            this.data = byteArrayOutputStream.toByteArray();
            this.size = this.data.length;
        }
        super.write(outputStream);
    }
}

